/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.model.util;

import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistenceDescriptor;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class NameMapper {
    public static final int USER_DEFINED_KEY_CLASS = 1;
    public static final int PRIMARY_KEY_FIELD = 2;
    public static final int UNKNOWN_KEY_CLASS = 3;
    public static final String GENERATED_KEY_FIELD_NAME = "generatedPKField";
    public static final String GENERATED_VERSION_FIELD_PREFIX = "thisVersionFieldWasGeneratedByTheNameMapper";
    private static final String GENERATED_CMR_FIELD_PREFIX = "thisRelationshipFieldWasGeneratedByTheNameMapper";
    private EjbBundleDescriptor _bundleDescriptor;
    private Map _generatedRelToInverseRelMap;
    private Map _relToInverseGeneratedRelMap;

    protected NameMapper(EjbBundleDescriptor bundleDescriptor) {
        this._bundleDescriptor = bundleDescriptor;
        this.initGeneratedRelationshipMaps();
    }

    private void initGeneratedRelationshipMaps() {
        EjbBundleDescriptor bundleDescriptor = this.getBundleDescriptor();
        Set relationships = bundleDescriptor.getRelationships();
        this._generatedRelToInverseRelMap = new HashMap();
        this._relToInverseGeneratedRelMap = new HashMap();
        if (relationships != null) {
            RelationshipDescriptor relationship;
            Iterator iterator = relationships.iterator();
            ArrayList<RelationshipDescriptor> generatedRels = new ArrayList<RelationshipDescriptor>();
            int counter = 0;
            while (iterator.hasNext()) {
                relationship = (RelationshipDescriptor)iterator.next();
                if (relationship.getSource().getCMRField() == null) {
                    generatedRels.add(relationship);
                }
                if (relationship.getSink().getCMRField() != null) continue;
                generatedRels.add(relationship);
            }
            iterator = generatedRels.iterator();
            while (iterator.hasNext()) {
                relationship = (RelationshipDescriptor)iterator.next();
                RelationRoleDescriptor source = relationship.getSource();
                String sourceEjbName = source.getOwner().getName();
                String sourceCMRField = source.getCMRField();
                boolean sourceIsNull = sourceCMRField == null;
                RelationRoleDescriptor sink = relationship.getSink();
                String sinkEjbName = sink.getOwner().getName();
                String ejbName = sourceIsNull ? sourceEjbName : sinkEjbName;
                String otherEjbName = sourceIsNull ? sinkEjbName : sourceEjbName;
                List<String> ejbField = Arrays.asList(otherEjbName, sourceIsNull ? sink.getCMRField() : sourceCMRField);
                PersistenceDescriptor pDescriptor = ((EjbCMPEntityDescriptor)bundleDescriptor.getEjbByName(ejbName)).getPersistenceDescriptor();
                List<String> generatedField = null;
                String uniqueName = null;
                while (this.hasField(pDescriptor, uniqueName = GENERATED_CMR_FIELD_PREFIX + ++counter)) {
                }
                generatedField = Arrays.asList(ejbName, uniqueName);
                this._generatedRelToInverseRelMap.put(generatedField, ejbField);
                this._relToInverseGeneratedRelMap.put(ejbField, generatedField);
            }
        }
    }

    private Map getGeneratedFieldsMap() {
        return this._generatedRelToInverseRelMap;
    }

    private Map getInverseFieldsMap() {
        return this._relToInverseGeneratedRelMap;
    }

    private boolean hasField(PersistenceDescriptor persistenceDescriptor, String fieldName) {
        Class fieldType = null;
        try {
            fieldType = persistenceDescriptor.getTypeFor(fieldName);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        return fieldType != null;
    }

    public EjbBundleDescriptor getBundleDescriptor() {
        return this._bundleDescriptor;
    }

    public abstract boolean isEjbName(String var1);

    public abstract EjbCMPEntityDescriptor getDescriptorForEjbName(String var1);

    public abstract String getAbstractBeanClassForEjbName(String var1);

    public abstract String getKeyClassForEjbName(String var1);

    public String getKeyClassForPersistenceKeyClass(String className) {
        String ejbName = this.getEjbNameForPersistenceKeyClass(className);
        return ejbName != null ? this.getKeyClassForEjbName(ejbName) : null;
    }

    public String getEjbNameForPersistenceKeyClass(String className) {
        if (className.toUpperCase().endsWith("OID")) {
            return this.getEjbNameForPersistenceClass(className.substring(0, className.length() - 4));
        }
        return null;
    }

    public int getKeyClassTypeForEjbName(String name) {
        String keyClass = this.getKeyClassForEjbName(name);
        if (!"java.lang.Object".equals(keyClass)) {
            EjbCMPEntityDescriptor descriptor = this.getDescriptorForEjbName(name);
            return descriptor.getPrimaryKeyFieldDesc() != null ? 2 : 1;
        }
        return 3;
    }

    public abstract String getEjbNameForAbstractSchema(String var1);

    public abstract String getAbstractSchemaForEjbName(String var1);

    public abstract String getConcreteBeanClassForEjbName(String var1);

    public abstract String getEjbNameForPersistenceClass(String var1);

    public abstract String getPersistenceClassForEjbName(String var1);

    public abstract boolean isLocalInterface(String var1);

    public String getPersistenceClassForLocalInterface(String className, String fieldName, String interfaceName) {
        if (this.isLocalInterface(interfaceName)) {
            String ejbName = this.getEjbNameForPersistenceClass(className);
            String ejbField = this.getEjbFieldForPersistenceField(className, fieldName);
            return this.getPersistenceClassForEjbName(this.getEjbNameForLocalInterface(ejbName, ejbField, interfaceName));
        }
        return null;
    }

    public abstract String getEjbNameForLocalInterface(String var1, String var2, String var3);

    public abstract String getLocalInterfaceForEjbName(String var1);

    public abstract boolean isRemoteInterface(String var1);

    public String getPersistenceClassForRemoteInterface(String className, String fieldName, String interfaceName) {
        if (this.isRemoteInterface(interfaceName)) {
            String ejbName = this.getEjbNameForPersistenceClass(className);
            String ejbField = this.getEjbFieldForPersistenceField(className, fieldName);
            return this.getPersistenceClassForEjbName(this.getEjbNameForRemoteInterface(ejbName, ejbField, interfaceName));
        }
        return null;
    }

    public abstract String getEjbNameForRemoteInterface(String var1, String var2, String var3);

    public abstract String getRemoteInterfaceForEjbName(String var1);

    public abstract String getEjbFieldForPersistenceField(String var1, String var2);

    public abstract String getPersistenceFieldForEjbField(String var1, String var2);

    public boolean isGeneratedField(String name, String fieldName) {
        return this.isGeneratedEjbRelationship(name, fieldName) || fieldName.equals(GENERATED_KEY_FIELD_NAME) || fieldName.startsWith(GENERATED_VERSION_FIELD_PREFIX);
    }

    public boolean isGeneratedEjbRelationship(String name, String fieldName) {
        return this.getGeneratedFieldsMap().keySet().contains(Arrays.asList(name, fieldName));
    }

    public List getGeneratedRelationshipsForEjbName(String name) {
        Map generatedFieldsMap = this.getGeneratedFieldsMap();
        Iterator iterator = generatedFieldsMap.keySet().iterator();
        ArrayList returnList = new ArrayList();
        while (iterator.hasNext()) {
            List nextField = (List)iterator.next();
            if (!nextField.get(0).equals(name)) continue;
            returnList.add(nextField.get(1));
        }
        return returnList;
    }

    public String[] getGeneratedFieldForEjbField(String name, String fieldName) {
        List field = (List)this.getInverseFieldsMap().get(Arrays.asList(name, fieldName));
        return field != null ? field.toArray(new String[2]) : null;
    }

    public String[] getEjbFieldForGeneratedField(String name, String fieldName) {
        List field = (List)this.getGeneratedFieldsMap().get(Arrays.asList(name, fieldName));
        return field != null ? field.toArray(new String[2]) : null;
    }
}

