/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.ejb.codegen.EjbcContext;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.RelationshipDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.ConnectionProvider;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.SchemaElementImpl;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionException;
import com.sun.jdo.api.persistence.mapping.ejb.ConversionHelper;
import com.sun.jdo.api.persistence.mapping.ejb.MappingFile;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmpFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.CmrFieldMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.ColumnPair;
import com.sun.jdo.api.persistence.mapping.ejb.beans.EntityMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMapping;
import com.sun.jdo.api.persistence.mapping.ejb.beans.SunCmpMappings;
import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.spi.persistence.generator.database.DatabaseGenerator;
import com.sun.jdo.spi.persistence.generator.database.MappingPolicy;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.EjbConversionHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGeneratorHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.LogHelperEJBCompiler;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.NameMapper;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.DeploymentHelper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.JavaTypeHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.database.DBVendorTypeHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.schema2beans.Schema2BeansException;
import org.netbeans.modules.schema2beans.ValidateException;

public class MappingGenerator {
    public static final String JAVA_TO_DB_FLAG = "java-to-database";
    private static final String CLASS_SUFFIX = "_JDOState";
    private static final String FAKE_NAME = "fakename";
    private static final String DBSCHEMA_EXTENSION = ".dbschema";
    private static final char DOT = '.';
    private static final char UNDERLINE = '_';
    private static final Logger logger = LogHelperEJBCompiler.getLogger();
    private final EjbBundleDescriptor bundle;
    private final Model model;
    private final NameMapper nameMapper;
    private final ClassLoader loader;
    private final ConversionHelper ddHelper;
    private boolean skipGeneratedFields = false;
    private String dbVendorName = null;
    private boolean isJavaToDatabaseFlag = false;
    private List strongRefs = new ArrayList();
    private static final ResourceBundle messages = I18NHelper.loadBundle(MappingGenerator.class);

    public MappingGenerator(EjbBundleDescriptor bundle, Model model, NameMapper nameMapper, ClassLoader loader) {
        this(bundle, model, nameMapper, loader, false);
    }

    public MappingGenerator(EjbBundleDescriptor bundle, Model model, NameMapper nameMapper, ClassLoader loader, boolean skipGeneratedFields) {
        this.bundle = bundle;
        this.model = model;
        this.loader = loader;
        this.nameMapper = nameMapper;
        this.ddHelper = new EjbConversionHelper(nameMapper);
        this.skipGeneratedFields = skipGeneratedFields;
    }

    public SchemaElement generateMapping(EjbcContext ejbcContext, String inputFilesPath) throws IOException, DBException, ModelException, Schema2BeansException, SQLException, GeneratorException, ConversionException {
        SchemaElement schema = null;
        File cmpMappingFile = MappingGenerator.getSunCmpMappingFile(inputFilesPath);
        boolean mappedBeans = cmpMappingFile.exists();
        ResourceReferenceDescriptor cmpResource = this.checkOrCreateCMPResource(mappedBeans);
        this.isJavaToDatabaseFlag = DeploymentHelper.isJavaToDatabase(cmpResource.getSchemaGeneratorProperties());
        boolean mustHaveDBVendorName = !mappedBeans || mappedBeans && this.isJavaToDatabaseFlag;
        Results deploymentArguments = this.getDeploymentArguments(ejbcContext, cmpResource, mustHaveDBVendorName);
        this.dbVendorName = deploymentArguments.getDatabaseVendorName();
        if (mappedBeans && ejbcContext != null) {
            String warning = null;
            if (this.isJavaToDatabaseFlag) {
                if (deploymentArguments.hasUniqueTableNames()) {
                    warning = I18NHelper.getMessage(messages, "EXC_DisallowJava2DBUniqueTableNames", this.bundle.getApplication().getRegistrationName(), JDOCodeGeneratorHelper.getModuleName(this.bundle));
                    logger.warning(warning);
                }
            } else if (deploymentArguments.hasJavaToDatabaseArgs()) {
                warning = I18NHelper.getMessage(messages, "EXC_DisallowJava2DBCLIOverrides", this.bundle.getApplication().getRegistrationName(), JDOCodeGeneratorHelper.getModuleName(this.bundle));
                logger.warning(warning);
            }
            if (warning != null) {
                DeploymentStatus status = ejbcContext.getDeploymentRequest().getCurrentDeploymentStatus();
                status.setStageStatus(1);
                String msg = status.getStageStatusMessage();
                msg = msg == null ? warning : msg + "\n" + warning;
                status.setStageStatusMessage(msg);
            }
            SunCmpMappings sunCmpMappings = this.getSunCmpMappings(cmpMappingFile);
            this.ensureDBSchemaExistence(cmpResource, sunCmpMappings, inputFilesPath);
            Map mappingClasses = this.loadMappingClasses(sunCmpMappings, this.loader);
            MappingClassElement mc = null;
            Iterator iter = mappingClasses.values().iterator();
            while (iter.hasNext()) {
                mc = (MappingClassElement)iter.next();
                if (mc == null) continue;
                schema = SchemaElement.forName(mc.getDatabaseRoot());
                break;
            }
            if (logger.isLoggable(500)) {
                logger.fine("Loaded mapped beans for " + cmpResource.getJndiName() + ", isJavaToDatabase=" + this.isJavaToDatabaseFlag);
            }
        } else {
            DatabaseGenerator.Results results = this.generateMappingClasses(this.dbVendorName, deploymentArguments.getUseUniqueTableNames(), deploymentArguments.getUserPolicy(), inputFilesPath);
            this.writeSunCmpMappingFile(results.getMappingClasses(), cmpMappingFile);
            schema = results.getSchema();
            MappingGenerator.writeSchemaFile(schema, inputFilesPath);
            this.setJavaToDatabase(cmpResource, true);
        }
        return schema;
    }

    public DatabaseGenerator.Results generateMappingClasses(String dbName, String uniqueTableNames, Properties userPolicy, String inputFilesPath) throws IOException, Schema2BeansException, ModelException, DBException, ConversionException {
        SunCmpMappings sunCmpMappings = null;
        ArrayList pcClasses = new ArrayList();
        sunCmpMappings = this.getPartialSunCmpMappings(pcClasses, Boolean.valueOf(uniqueTableNames));
        this.ddHelper.setEnsureValidation(false);
        SchemaElement fakeSchema = new SchemaElement(new SchemaElementImpl());
        fakeSchema.setName(DBIdentifier.create(FAKE_NAME));
        SchemaElement.addToCache(fakeSchema);
        this.loadMappingClasses(sunCmpMappings, null);
        DatabaseGenerator.Results results = this.generateSchema(pcClasses, dbName, uniqueTableNames, userPolicy);
        SchemaElement schema = results.getSchema();
        Set mappingClasses = results.getMappingClasses();
        SchemaElement.removeFromCache(FAKE_NAME);
        SchemaElement.removeFromCache(schema.getName().getName());
        SchemaElement.addToCache(schema);
        this.updateMappingClasses(mappingClasses);
        if (this.skipGeneratedFields) {
            Iterator iter = mappingClasses.iterator();
            while (iter.hasNext()) {
                PersistenceFieldElement pfe;
                MappingClassElement mapClassElt = (MappingClassElement)iter.next();
                if (mapClassElt == null) continue;
                String className = mapClassElt.getName();
                String ejbName = this.nameMapper.getEjbNameForPersistenceClass(className);
                PersistenceClassElement pce = this.model.getPersistenceClass(className);
                PersistenceFieldElement[] allFields = pce.getFields();
                if (allFields == null) continue;
                ArrayList<PersistenceFieldElement> generatedFieldList = new ArrayList<PersistenceFieldElement>();
                for (int i = 0; i < allFields.length; ++i) {
                    String pFieldName;
                    String ejbFieldName;
                    pfe = allFields[i];
                    if (pfe == null || !this.nameMapper.isGeneratedField(ejbName, ejbFieldName = this.nameMapper.getEjbFieldForPersistenceField(className, pFieldName = pfe.getName()))) continue;
                    generatedFieldList.add(pfe);
                }
                Iterator iterator = generatedFieldList.iterator();
                while (iterator.hasNext()) {
                    pfe = (PersistenceFieldElement)iterator.next();
                    MappingFieldElement mfe = mapClassElt.getField(pfe.getName());
                    if (mfe == null || mfe.isVersion()) continue;
                    this.model.removeFieldElement(pfe);
                    mapClassElt.removeField(mfe);
                }
            }
        }
        return results;
    }

    private Map loadMappingClasses(SunCmpMappings sunMapping, ClassLoader classLoader) throws DBException, ModelException, ConversionException {
        if (logger.isLoggable(500)) {
            logger.fine("begin loadMappingClasses");
        }
        MappingFile mapFile = new MappingFile(classLoader);
        Map allMappings = mapFile.intoMappingClasses(sunMapping, this.ddHelper);
        this.updateMappingClasses(allMappings.values());
        if (logger.isLoggable(500)) {
            logger.fine("end loadMappingClasses");
        }
        return allMappings;
    }

    public void cleanup() {
        this.strongRefs.clear();
    }

    public String getDatabaseVendorName() {
        return this.dbVendorName;
    }

    public boolean isJavaToDatabase() {
        return this.isJavaToDatabaseFlag;
    }

    private void setJavaToDatabase(ResourceReferenceDescriptor cmpResource, boolean value) {
        Properties schemaGeneratorProperties;
        if (logger.isLoggable(500)) {
            logger.fine("set javatodb flag in cmpResource");
        }
        if ((schemaGeneratorProperties = cmpResource.getSchemaGeneratorProperties()) == null) {
            schemaGeneratorProperties = new Properties();
            cmpResource.setSchemaGeneratorProperties(schemaGeneratorProperties);
        }
        schemaGeneratorProperties.setProperty(JAVA_TO_DB_FLAG, String.valueOf(value));
        this.isJavaToDatabaseFlag = value;
    }

    private DatabaseGenerator.Results generateSchema(List pcClasses, String dbName, String useUniqueTableNames, Properties userPolicy) throws IOException, DBException, ModelException {
        MappingPolicy mappingPolicy = MappingPolicy.getMappingPolicy(dbName);
        mappingPolicy.setUserPolicy(userPolicy);
        if (!StringHelper.isEmpty(useUniqueTableNames) && !useUniqueTableNames.equals("undefined")) {
            mappingPolicy.setUniqueTableName(Boolean.valueOf(useUniqueTableNames));
        }
        String schemaName = DeploymentHelper.getDDLNamePrefix(this.bundle).replace('.', '_');
        if (logger.isLoggable(500)) {
            logger.fine("SCHEMA_NAME: " + schemaName);
        }
        return DatabaseGenerator.generate(this.model, pcClasses, mappingPolicy, schemaName, CLASS_SUFFIX, true);
    }

    /*
     * Loose catch block
     */
    private SunCmpMappings getSunCmpMappings(File cmpMappingFile) throws IOException, Schema2BeansException, GeneratorException {
        SunCmpMappings sunCmpMapping;
        block20: {
            Exception ex22;
            BufferedInputStream iasMapping;
            FileInputStream is;
            block17: {
                is = null;
                iasMapping = null;
                sunCmpMapping = null;
                if (cmpMappingFile.length() == 0L) {
                    throw JDOCodeGeneratorHelper.createGeneratorException("CMG.BeansFileSizeIsZero", this.bundle);
                }
                is = new FileInputStream(cmpMappingFile);
                iasMapping = new BufferedInputStream(is);
                sunCmpMapping = SunCmpMappings.createGraph(iasMapping);
                Object var7_5 = null;
                if (is == null) break block17;
                try {
                    ((InputStream)is).close();
                }
                catch (Exception ex22) {
                    if (!logger.isLoggable(500)) break block17;
                    logger.fine(ex22.toString());
                }
            }
            if (iasMapping != null) {
                try {
                    iasMapping.close();
                }
                catch (Exception ex22) {
                    if (logger.isLoggable(500)) {
                        logger.fine(ex22.toString());
                    }
                }
            }
            break block20;
            {
                catch (IOException ex3) {
                    throw ex3;
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Exception ex22;
                    block18: {
                        Object var7_6 = null;
                        if (is != null) {
                            try {
                                ((InputStream)is).close();
                            }
                            catch (Exception ex22) {
                                if (!logger.isLoggable(500)) break block18;
                                logger.fine(ex22.toString());
                            }
                        }
                    }
                    if (iasMapping != null) {
                        try {
                            iasMapping.close();
                        }
                        catch (Exception ex22) {
                            if (!logger.isLoggable(500)) break block19;
                            logger.fine(ex22.toString());
                        }
                    }
                }
                throw throwable;
            }
        }
        try {
            sunCmpMapping.validate();
        }
        catch (ValidateException ex) {
            throw JDOCodeGeneratorHelper.createGeneratorException("CMG.InvalidSunCmpMappingsFile", this.bundle, (Exception)((Object)ex));
        }
        return sunCmpMapping;
    }

    private static File getSunCmpMappingFile(String inputFilesPath) {
        StringBuffer cmpMappingFile = new StringBuffer(inputFilesPath).append(File.separator).append(MappingFile.DEFAULT_LOCATION_IN_EJB_JAR);
        return new File(cmpMappingFile.toString());
    }

    private void writeSunCmpMappingFile(Set mappingClasses, File cmpMappingFile) throws IOException, ConversionException, Schema2BeansException {
        HashMap<String, MappingClassElement> mappingMap = new HashMap<String, MappingClassElement>();
        Iterator iter = mappingClasses.iterator();
        while (iter.hasNext()) {
            MappingClassElement mappingClass = (MappingClassElement)iter.next();
            String ejbName = this.nameMapper.getEjbNameForPersistenceClass(mappingClass.getName());
            mappingMap.put(ejbName, mappingClass);
        }
        MappingFile mf = new MappingFile();
        FileOutputStream sunCmpMapping = new FileOutputStream(cmpMappingFile);
        mf.fromMappingClasses(sunCmpMapping, mappingMap, this.ddHelper);
    }

    private static void writeSchemaFile(SchemaElement schema, String filePath) throws IOException {
        FileOutputStream schemaStream = new FileOutputStream(new File(filePath, NameUtil.getSchemaResourceName(schema.getName().getName())));
        schema.save(schemaStream);
    }

    private void updateMappingClasses(Collection mappingClasses) {
        Iterator iter = mappingClasses.iterator();
        while (iter.hasNext()) {
            MappingClassElement mapClassElt = (MappingClassElement)iter.next();
            this.model.updateKeyForClass(mapClassElt, null);
            this.strongRefs.add(mapClassElt);
        }
    }

    private SunCmpMappings getPartialSunCmpMappings(List pcClasses, boolean useUniqueTableNames) throws Schema2BeansException {
        if (logger.isLoggable(500)) {
            logger.fine("generate partial SunCmpMappings");
        }
        NameMapper nameMapper2 = useUniqueTableNames ? new NameMapper(this.bundle) : this.nameMapper;
        SunCmpMappings mappings = null;
        mappings = new SunCmpMappings();
        SunCmpMapping mapping = new SunCmpMapping();
        mapping.setSchema(FAKE_NAME);
        Map ejbRelMap = this.getCMRFieldsForEjbs();
        Iterator iter = this.bundle.getEjbs().iterator();
        while (iter.hasNext()) {
            Object desc = iter.next();
            if (!(desc instanceof IASEjbCMPEntityDescriptor)) continue;
            IASEjbCMPEntityDescriptor ejbDesc = (IASEjbCMPEntityDescriptor)desc;
            String ejbName = ejbDesc.getName();
            String pcClass = this.ddHelper.getMappedClassName(ejbName);
            String hashClassName = JavaTypeHelper.getShortClassName(pcClass);
            if (useUniqueTableNames & hashClassName.equals(ejbName)) {
                hashClassName = JavaTypeHelper.getShortClassName(nameMapper2.getPersistenceClassForEjbName(ejbName));
                pcClasses.add(new DatabaseGenerator.NameTuple(pcClass, ejbName, hashClassName));
            } else {
                pcClasses.add(new DatabaseGenerator.NameTuple(pcClass, ejbName));
            }
            EntityMapping entity = new EntityMapping();
            entity.setEjbName(ejbName);
            entity.setTableName(FAKE_NAME);
            Collection pFields = ejbDesc.getPersistentFields();
            Iterator fIter = pFields.iterator();
            while (fIter.hasNext()) {
                String fieldName = ((PersistentFieldInfo)fIter.next()).name;
                CmpFieldMapping cmpField = new CmpFieldMapping();
                cmpField.setFieldName(fieldName);
                cmpField.addColumnName(FAKE_NAME);
                entity.addCmpFieldMapping(cmpField);
            }
            List cmrFields = (List)ejbRelMap.get(ejbName);
            if (cmrFields != null) {
                for (int ii = 0; ii < cmrFields.size(); ++ii) {
                    CmrFieldMapping cmrField = new CmrFieldMapping();
                    cmrField.setCmrFieldName((String)cmrFields.get(ii));
                    ColumnPair columnPair = new ColumnPair();
                    columnPair.addColumnName(FAKE_NAME);
                    columnPair.addColumnName(FAKE_NAME);
                    cmrField.addColumnPair(columnPair);
                    entity.addCmrFieldMapping(cmrField);
                }
            }
            mapping.addEntityMapping(entity);
        }
        mappings.addSunCmpMapping(mapping);
        return mappings;
    }

    private Map getCMRFieldsForEjbs() {
        HashMap<String, ArrayList<String>> ejbRelMap = new HashMap<String, ArrayList<String>>();
        Set rels = this.bundle.getRelationships();
        Iterator relIter = rels.iterator();
        while (relIter.hasNext()) {
            RelationshipDescriptor rel = (RelationshipDescriptor)relIter.next();
            RelationRoleDescriptor source = rel.getSource();
            RelationRoleDescriptor sink = rel.getSink();
            String sourceEjbName = source.getOwner().getName();
            String sourceCMRField = source.getCMRField();
            if (sourceCMRField != null) {
                ArrayList<String> sourceRels = (ArrayList<String>)ejbRelMap.get(sourceEjbName);
                if (sourceRels == null) {
                    sourceRels = new ArrayList<String>();
                    ejbRelMap.put(sourceEjbName, sourceRels);
                }
                sourceRels.add(sourceCMRField);
            }
            String sinkEjbName = sink.getOwner().getName();
            String sinkCMRField = sink.getCMRField();
            if (sinkCMRField == null) continue;
            ArrayList<String> sinkRels = (ArrayList<String>)ejbRelMap.get(sinkEjbName);
            if (sinkRels == null) {
                sinkRels = new ArrayList<String>();
                ejbRelMap.put(sinkEjbName, sinkRels);
            }
            sinkRels.add(sinkCMRField);
        }
        return ejbRelMap;
    }

    private Results getDeploymentArguments(EjbcContext ejbcContext, ResourceReferenceDescriptor cmpResource, boolean connectToDatabase) {
        String useUniqueTableNames = null;
        String dbVendorName = null;
        Properties userPolicy = null;
        boolean javaToDatabaseArgs = false;
        if (null == ejbcContext) {
            dbVendorName = cmpResource.getDatabaseVendorName();
        } else {
            String createTables;
            Properties cliOverrides = ejbcContext.getOptionalArguments();
            useUniqueTableNames = cliOverrides.getProperty("CmpInfo.uniqueTableNames");
            javaToDatabaseArgs = !StringHelper.isEmpty(useUniqueTableNames) && !useUniqueTableNames.equals("undefined");
            dbVendorName = cliOverrides.getProperty("CmpInfo.dbVendorName");
            javaToDatabaseArgs |= !StringHelper.isEmpty(dbVendorName) && !dbVendorName.equals("undefined");
            if (null == dbVendorName || dbVendorName.equals("undefined")) {
                dbVendorName = cmpResource.getDatabaseVendorName();
            }
            if (null == dbVendorName && connectToDatabase) {
                try {
                    Connection conn = DeploymentHelper.getConnection(cmpResource.getJndiName());
                    dbVendorName = conn.getMetaData().getDatabaseProductName();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            javaToDatabaseArgs |= !StringHelper.isEmpty(createTables = cliOverrides.getProperty("CmpInfo.CREATE_TABLES")) && !createTables.equals("undefined");
            String dropAndCreateTables = cliOverrides.getProperty("CmpInfo.DROP_AND_CREATE_TABLES");
            javaToDatabaseArgs |= !StringHelper.isEmpty(dropAndCreateTables) && !dropAndCreateTables.equals("undefined");
        }
        dbVendorName = null == dbVendorName ? DBVendorTypeHelper.DEFAULT_DB : DBVendorTypeHelper.getDBType(dbVendorName);
        userPolicy = cmpResource.getSchemaGeneratorProperties();
        return new Results(useUniqueTableNames, dbVendorName, userPolicy, javaToDatabaseArgs);
    }

    private ResourceReferenceDescriptor checkOrCreateCMPResource(boolean mappedBeans) throws GeneratorException {
        ResourceReferenceDescriptor cmpResource = this.bundle.getCMPResourceReference();
        if (mappedBeans) {
            if (cmpResource == null) {
                throw JDOCodeGeneratorHelper.createGeneratorException("EXC_MissingCMPResource", this.bundle);
            }
        } else if (cmpResource == null) {
            cmpResource = new ResourceReferenceDescriptor();
            cmpResource.setJndiName("jdbc/PointBase");
            cmpResource.setDatabaseVendorName(DBVendorTypeHelper.POINTBASE);
            cmpResource.setCreateTablesAtDeploy(true);
            cmpResource.setDropTablesAtUndeploy(true);
            this.bundle.setCMPResourceReference(cmpResource);
        }
        return cmpResource;
    }

    private void ensureDBSchemaExistence(ResourceReferenceDescriptor cmpResource, SunCmpMappings sunCmpMappings, String inputFilesPath) throws DBException, SQLException, GeneratorException {
        String generatedSchemaName = DeploymentHelper.getDDLNamePrefix(this.bundle);
        HashSet tables = new HashSet();
        int size = sunCmpMappings.sizeSunCmpMapping();
        for (int i = 0; i < size; ++i) {
            SunCmpMapping sunCmpMapping = sunCmpMappings.getSunCmpMapping(i);
            String schemaName = sunCmpMapping.getSchema();
            if (StringHelper.isEmpty(schemaName)) {
                this.addAllTables(sunCmpMapping, tables);
                sunCmpMapping.setSchema(generatedSchemaName);
                continue;
            }
            File dbschemaFile = new File(inputFilesPath + File.separator + schemaName + DBSCHEMA_EXTENSION);
            if (dbschemaFile.exists() && dbschemaFile.isFile() && dbschemaFile.canRead()) continue;
            throw new GeneratorException(I18NHelper.getMessage(messages, "CMG.MissingDBSchema", this.bundle.getApplication().getRegistrationName(), JDOCodeGeneratorHelper.getModuleName(this.bundle), schemaName));
        }
        if (tables.size() > 0) {
            String userSchema = null;
            Connection con = DeploymentHelper.getConnection(cmpResource.getJndiName());
            DatabaseMetaData dmd = con.getMetaData();
            if (DBVendorTypeHelper.requireUpperCaseSchema(dmd)) {
                userSchema = dmd.getUserName().trim().toUpperCase();
            }
            ConnectionProvider cp = new ConnectionProvider(con, dmd.getDriverName().trim());
            if (userSchema != null) {
                cp.setSchema(userSchema);
            }
            try {
                SchemaElementImpl outSchemaImpl = new SchemaElementImpl(cp);
                SchemaElement schemaElement = new SchemaElement(outSchemaImpl);
                schemaElement.setName(DBIdentifier.create(generatedSchemaName));
                outSchemaImpl.initTables(cp, new LinkedList(tables), new LinkedList(), false);
                FileOutputStream outstream = new FileOutputStream(inputFilesPath + File.separator + generatedSchemaName + DBSCHEMA_EXTENSION);
                schemaElement.save(outstream);
            }
            catch (IOException ex) {
                throw JDOCodeGeneratorHelper.createGeneratorException("CMG.CannotSaveDBSchema", this.bundle, ex);
            }
            finally {
                cp.closeConnection();
            }
        }
    }

    private void addAllTables(SunCmpMapping sunCmpMapping, Set tables) {
        EntityMapping[] beans = sunCmpMapping.getEntityMapping();
        for (int i = 0; i < beans.length; ++i) {
            this.addTableName(beans[i].getTableName(), tables);
            CmpFieldMapping[] cmpfields = beans[i].getCmpFieldMapping();
            for (int j = 0; j < cmpfields.length; ++j) {
                String[] names = cmpfields[j].getColumnName();
                for (int jj = 0; jj < names.length; ++jj) {
                    this.addRelatedTableName(names[jj], tables);
                }
            }
            CmrFieldMapping[] cmrfields = beans[i].getCmrFieldMapping();
            for (int j = 0; j < cmrfields.length; ++j) {
                ColumnPair[] pairs = cmrfields[j].getColumnPair();
                for (int jj = 0; jj < pairs.length; ++jj) {
                    String[] names = pairs[jj].getColumnName();
                    for (int jjj = 0; jjj < names.length; ++jjj) {
                        this.addRelatedTableName(names[jjj], tables);
                    }
                }
            }
        }
    }

    private void addTableName(String name, Set tables) {
        if (!StringHelper.isEmpty(name)) {
            if (logger.isLoggable(500)) {
                logger.fine("Adding Table to Capture Set: " + name);
            }
            tables.add(name);
        }
    }

    private void addRelatedTableName(String columnName, Set tables) {
        int l;
        if (!StringHelper.isEmpty(columnName) && (l = columnName.indexOf(46)) > 0) {
            this.addTableName(columnName.substring(0, l), tables);
        }
    }

    public static void updateColumn(ColumnElement column, int jdbcType, Integer length, Integer scale, Integer precision) throws DBException {
        column.setType(jdbcType);
        column.setLength(length);
        column.setScale(scale);
        column.setPrecision(precision);
    }

    public static void updateProperties(Properties prop, String className, String fieldName, int jdbcType, Integer length, Integer scale, Integer precision) {
        prop.setProperty(MappingPolicy.getOverrideForType(className, fieldName), MappingPolicy.getJdbcTypeName(jdbcType));
        MappingGenerator.updateProperty(prop, MappingPolicy.getOverrideForLength(className, fieldName), length);
        MappingGenerator.updateProperty(prop, MappingPolicy.getOverrideForScale(className, fieldName), scale);
        MappingGenerator.updateProperty(prop, MappingPolicy.getOverrideForPrecision(className, fieldName), precision);
    }

    private static void updateProperty(Properties prop, String key, Integer value) {
        if (value != null) {
            prop.setProperty(key, value.toString());
        } else {
            prop.remove(key);
        }
    }

    public static class SQLTypeUtil {
        private static final Map characterMap = new HashMap();
        private static final Map numericMap = new HashMap();
        private static final Map blobMap = new HashMap();
        private static final Map timeMap = new HashMap();
        private static final String NONE_ATTRIBUTE = "none";
        private static final String LENGTH_ATTRIBUTE = "length";
        private static final String SCALE_ATTRIBUTE = "scale";
        private static final String SCALE_PRECISION_ATTRIBUTE = "scale-precision";

        public static boolean isNumeric(int jdbcType) {
            return SQLTypeUtil.checkType(jdbcType, numericMap);
        }

        public static boolean isCharacter(int jdbcType) {
            return SQLTypeUtil.checkType(jdbcType, characterMap);
        }

        public static boolean isBlob(int jdbcType) {
            return SQLTypeUtil.checkType(jdbcType, blobMap);
        }

        public static boolean isTime(int jdbcType) {
            return SQLTypeUtil.checkType(jdbcType, timeMap);
        }

        private static boolean checkType(int jdbcType, Map jdbcTypes) {
            return jdbcTypes.containsKey(new Integer(jdbcType));
        }

        public static Collection getCompatibleTypes(int jdbcType) {
            if (SQLTypeUtil.isNumeric(jdbcType)) {
                return numericMap.keySet();
            }
            if (SQLTypeUtil.isCharacter(jdbcType)) {
                return characterMap.keySet();
            }
            if (SQLTypeUtil.isBlob(jdbcType)) {
                return blobMap.keySet();
            }
            if (SQLTypeUtil.isTime(jdbcType)) {
                return timeMap.keySet();
            }
            return null;
        }

        public static boolean hasScale(int jdbcType) {
            return SQLTypeUtil.getAttribute(jdbcType).equals(SCALE_ATTRIBUTE) || SQLTypeUtil.getAttribute(jdbcType).equals(SCALE_PRECISION_ATTRIBUTE);
        }

        public static boolean hasPrecision(int jdbcType) {
            return SQLTypeUtil.getAttribute(jdbcType).equals(SCALE_PRECISION_ATTRIBUTE);
        }

        public static boolean hasLength(int jdbcType) {
            return SQLTypeUtil.getAttribute(jdbcType).equals(LENGTH_ATTRIBUTE);
        }

        private static String getAttribute(int jdbcType) {
            if (SQLTypeUtil.isNumeric(jdbcType)) {
                return (String)numericMap.get(new Integer(jdbcType));
            }
            if (SQLTypeUtil.isCharacter(jdbcType)) {
                return (String)characterMap.get(new Integer(jdbcType));
            }
            if (SQLTypeUtil.isBlob(jdbcType)) {
                return (String)blobMap.get(new Integer(jdbcType));
            }
            if (SQLTypeUtil.isTime(jdbcType)) {
                return (String)timeMap.get(new Integer(jdbcType));
            }
            return NONE_ATTRIBUTE;
        }

        static {
            characterMap.put(new Integer(1), LENGTH_ATTRIBUTE);
            characterMap.put(new Integer(12), LENGTH_ATTRIBUTE);
            characterMap.put(new Integer(2005), LENGTH_ATTRIBUTE);
            numericMap.put(new Integer(-7), NONE_ATTRIBUTE);
            numericMap.put(new Integer(-6), NONE_ATTRIBUTE);
            numericMap.put(new Integer(5), NONE_ATTRIBUTE);
            numericMap.put(new Integer(-5), NONE_ATTRIBUTE);
            numericMap.put(new Integer(4), NONE_ATTRIBUTE);
            numericMap.put(new Integer(8), NONE_ATTRIBUTE);
            numericMap.put(new Integer(3), SCALE_PRECISION_ATTRIBUTE);
            numericMap.put(new Integer(7), NONE_ATTRIBUTE);
            blobMap.put(new Integer(2004), LENGTH_ATTRIBUTE);
            timeMap.put(new Integer(91), NONE_ATTRIBUTE);
            timeMap.put(new Integer(92), NONE_ATTRIBUTE);
            timeMap.put(new Integer(93), NONE_ATTRIBUTE);
        }
    }

    private class Results {
        private final String useUniqueTableNames;
        private final String dbVendorName;
        private final Properties userPolicy;
        private final boolean javaToDatabaseArgs;

        Results(String useUniqueTableNames, String dbVendorName, Properties userPolicy, boolean javaToDatabaseArgs) {
            this.useUniqueTableNames = useUniqueTableNames;
            this.dbVendorName = dbVendorName;
            this.userPolicy = userPolicy;
            this.javaToDatabaseArgs = javaToDatabaseArgs;
        }

        public String getUseUniqueTableNames() {
            return this.useUniqueTableNames;
        }

        public boolean hasUniqueTableNames() {
            return !StringHelper.isEmpty(this.useUniqueTableNames) && !this.useUniqueTableNames.equals("undefined");
        }

        public boolean hasJavaToDatabaseArgs() {
            return this.javaToDatabaseArgs;
        }

        public String getDatabaseVendorName() {
            return this.dbVendorName;
        }

        public Properties getUserPolicy() {
            return this.userPolicy;
        }
    }
}

