/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.ejbc;

import com.sun.jdo.api.persistence.model.Model;
import com.sun.jdo.api.persistence.model.jdo.PersistenceClassElement;
import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import com.sun.jdo.api.persistence.model.mapping.MappingFieldElement;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.AbstractMethodHelper;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.CMPROTemplateFormatter;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.CMPTemplateFormatter;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.LogHelperEJBCompiler;
import com.sun.jdo.spi.persistence.support.ejb.ejbqlc.JDOQLElements;
import com.sun.jdo.spi.persistence.support.ejb.model.util.NameMapper;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.JavaClassWriterHelper;
import com.sun.jdo.spi.persistence.utility.generator.JavaFileWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.IOJavaClassWriter;
import com.sun.jdo.spi.persistence.utility.generator.io.IOJavaFileWriter;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

abstract class JDOConcreteBeanGenerator {
    static final Logger logger = LogHelperEJBCompiler.getLogger();
    NameMapper nameMapper = null;
    Model model = null;
    String beanName = null;
    String helperName = null;
    String concreteImplName = null;
    String abstractBean = null;
    String pkClass = null;
    String pcname = null;
    boolean hasLocalInterface;
    boolean hasRemoteInterface;
    boolean isUpdateable;
    String setPKField = null;
    String[] pcnameParam = new String[1];
    String[] pkClassParam = new String[1];
    static String[] objectType = new String[]{"Object"};
    static String[] param0 = new String[]{"param0"};
    static String[] param0PM = new String[]{"param0", "_jdoPersistenceManager"};
    String[] oneParam = new String[1];
    String[] twoParams = new String[2];
    String[] threeParams = new String[3];
    String[] fourParams = new String[4];
    String[] fiveParams = new String[5];
    String[] sixParams = new String[6];
    String[] queryParams = new String[10];
    StringBuffer loadNonDFGBody = null;
    ClassLoader loader;
    JavaClassWriter concreteImplWriter;
    JavaClassWriter jdoHelperWriter;
    static final ResourceBundle messages = I18NHelper.loadBundle(JDOConcreteBeanGenerator.class);
    String inputFilesSignature;
    String generatorClassesSignature;
    static final String SIGNATURE = "$RCSfile: JDOConcreteBeanGenerator.java,v $ $Revision: 1.39 $";

    JDOConcreteBeanGenerator(ClassLoader loader, Model model, NameMapper nameMapper) throws IOException {
        this.loader = loader;
        this.model = model;
        this.nameMapper = nameMapper;
        CMPTemplateFormatter.initHelpers();
        CMPROTemplateFormatter.initHelpers();
    }

    void setUpdateable(boolean updateable) {
        this.isUpdateable = updateable;
    }

    Collection validate(AbstractMethodHelper methodHelper, String beanName) {
        return new ArrayList();
    }

    Collection generate(AbstractMethodHelper methodHelper, String beanName, File srcout, File classout) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        this.beanName = beanName;
        this.abstractBean = this.nameMapper.getAbstractBeanClassForEjbName(beanName);
        String pkgName = CMPTemplateFormatter.getPackageName(this.abstractBean);
        this.concreteImplName = this.nameMapper.getConcreteBeanClassForEjbName(beanName);
        String shortCmpName = CMPTemplateFormatter.getShortClassName(this.concreteImplName);
        this.pcnameParam[0] = this.pcname = this.nameMapper.getPersistenceClassForEjbName(beanName);
        PersistenceClassElement pcClassElement = this.model.getPersistenceClass(this.pcname);
        this.pkClassParam[0] = this.pkClass = this.nameMapper.getKeyClassForEjbName(beanName).replace('$', '.');
        PersistenceFieldElement[] allFields = pcClassElement.getFields();
        String prefix = srcout.getPath() + File.separator + this.concreteImplName.replace('.', File.separatorChar);
        String cmp_file_name = prefix + ".java";
        String hlp_file_name = prefix + "_JDOHelper" + ".java";
        this.hasLocalInterface = this.nameMapper.getLocalInterfaceForEjbName(beanName) != null;
        boolean bl = this.hasRemoteInterface = this.nameMapper.getRemoteInterfaceForEjbName(beanName) != null;
        if (logger.isLoggable(500)) {
            logger.fine("allFields: " + (allFields != null ? allFields.length : 0));
            logger.fine("cmp_file_name: " + cmp_file_name);
            logger.fine("hlp_file_name: " + hlp_file_name);
            logger.fine("cmp_name: " + this.concreteImplName);
            logger.fine("pkClass: " + this.pkClass);
            logger.fine("PCname: " + this.pcname);
        }
        File cmp_file = new File(cmp_file_name);
        IOJavaFileWriter concreteImplFileWriter = new IOJavaFileWriter(cmp_file);
        this.concreteImplWriter = new IOJavaClassWriter();
        File hlp_file = new File(hlp_file_name);
        IOJavaFileWriter helperFileWriter = new IOJavaFileWriter(hlp_file);
        this.jdoHelperWriter = new IOJavaClassWriter();
        if (pkgName != null && pkgName.length() > 0) {
            concreteImplFileWriter.setPackage(pkgName, null);
            helperFileWriter.setPackage(pkgName, null);
        }
        this.addImportStatements(concreteImplFileWriter, helperFileWriter);
        this.oneParam[0] = CMPTemplateFormatter.cmpImplCommentsTemplate;
        this.concreteImplWriter.setClassDeclaration(1, shortCmpName, this.oneParam);
        this.addInterfaces();
        this.concreteImplWriter.setSuperclass(this.abstractBean);
        this.concreteImplWriter.addConstructor(shortCmpName, 1, null, null, null, CMPTemplateFormatter.super_, null);
        this.helperName = shortCmpName + "_JDOHelper";
        this.oneParam[0] = shortCmpName;
        this.jdoHelperWriter.setClassDeclaration(1, this.helperName, CMPTemplateFormatter.getBodyAsStrings(CMPTemplateFormatter.hcomformatter.format(this.oneParam)));
        this.setHelperSuperclass();
        this.generateFields();
        this.generateTypeSpecificMethods(allFields, methodHelper);
        this.generateFinders(methodHelper);
        this.generateCreateMethods(methodHelper.getCreateMethods());
        this.generateKnownMethods(methodHelper);
        this.generateHelperClassMethods();
        this.generateConversions();
        this.generatePKObjectIdConversion(this.getKeyFields(allFields));
        concreteImplFileWriter.addClass(this.concreteImplWriter);
        concreteImplFileWriter.save();
        helperFileWriter.addClass(this.jdoHelperWriter);
        helperFileWriter.save();
        files.add(cmp_file);
        files.add(hlp_file);
        return files;
    }

    void addImportStatements(JavaFileWriter concreteImplFileWriter, JavaFileWriter helperFileWriter) throws IOException {
        int i;
        String[] st = CMPTemplateFormatter.importsArray;
        for (i = 0; i < st.length; ++i) {
            concreteImplFileWriter.addImport(st[i], null);
        }
        st = CMPTemplateFormatter.helperImportsArray;
        for (i = 0; i < st.length; ++i) {
            helperFileWriter.addImport(st[i], null);
        }
    }

    void addInterfaces() throws IOException {
        String[] st = CMPTemplateFormatter.interfacesArray;
        for (int i = 0; i < st.length; ++i) {
            this.concreteImplWriter.addInterface(st[i]);
        }
    }

    abstract void setHelperSuperclass() throws IOException;

    void generateTypeSpecificMethods(PersistenceFieldElement[] allFields, AbstractMethodHelper methodHelper) throws IOException {
        this.loadNonDFGBody = this.isUpdateable ? null : new StringBuffer();
    }

    void addCodeGenInputFilesSignature(String newSignature) {
        this.inputFilesSignature = this.inputFilesSignature == null || this.inputFilesSignature.length() == 0 ? newSignature : this.inputFilesSignature + " ## " + newSignature;
    }

    void addCodeGeneratorClassSignature(String newSignature) {
        this.generatorClassesSignature = this.generatorClassesSignature == null || this.generatorClassesSignature.length() == 0 ? newSignature : this.generatorClassesSignature + " ## " + newSignature;
    }

    void generateFields() throws IOException {
        CMPTemplateFormatter.addPrivateField(CMPTemplateFormatter.privatetransientvformatter.format(this.pcnameParam), 128, this.concreteImplWriter);
        CMPTemplateFormatter.addPrivateField(CMPTemplateFormatter.privateStaticVariablesTemplate, 8, this.concreteImplWriter);
        this.twoParams[0] = this.pcname;
        this.twoParams[1] = this.beanName;
        CMPTemplateFormatter.addPrivateField(CMPTemplateFormatter.privatestaticfinalvformatter.format(this.twoParams), 24, this.concreteImplWriter);
        this.twoParams[0] = this.generatorClassesSignature;
        this.twoParams[1] = this.inputFilesSignature;
        CMPTemplateFormatter.addFields(CMPTemplateFormatter.publicstaticfinalvformatter.format(this.twoParams), 25, this.concreteImplWriter);
        CMPTemplateFormatter.addPrivateField(CMPTemplateFormatter.otherVariablesTemplate, 0, this.concreteImplWriter);
        this.twoParams[0] = this.concreteImplName;
        this.twoParams[1] = this.beanName;
        CMPTemplateFormatter.addPrivateField(CMPTemplateFormatter.hvformatter.format(this.twoParams), 136, this.jdoHelperWriter);
        if (!this.isUpdateable) {
            CMPTemplateFormatter.addPrivateField(CMPROTemplateFormatter.privatetransientvformatter.format(this.pcnameParam), 128, this.concreteImplWriter);
            CMPTemplateFormatter.addPrivateField(CMPROTemplateFormatter.privateStaticVariablesTemplate, 8, this.concreteImplWriter);
        }
    }

    void generateFinders(AbstractMethodHelper methodHelper) throws IOException {
        boolean debug = logger.isLoggable(500);
        List finders = methodHelper.getFinders();
        for (int i = 0; i < finders.size(); ++i) {
            Method m = (Method)finders.get(i);
            String mname = "ejb" + StringHelper.getCapitalizedString(m.getName());
            if (debug) {
                logger.fine("Finder: " + mname);
            }
            if (mname.equals("ejbFindByPrimaryKey")) {
                String[] exceptionTypes = CMPTemplateFormatter.getExceptionNames(m);
                this.oneParam[0] = "key";
                this.concreteImplWriter.addMethod("ejbFindByPrimaryKey", 1, this.pkClass, this.oneParam, this.pkClassParam, exceptionTypes, CMPTemplateFormatter.ejbFindByPrimaryKeyBody, null);
                continue;
            }
            JDOQLElements rs = this.getJDOQLElements(m, methodHelper);
            String returnType = this.isSingleObjectFinder(m) ? this.pkClass : m.getReturnType().getName();
            CMPTemplateFormatter.addGenericMethod(m, mname, returnType, this.generateFinderMethodBody(methodHelper, rs, mname, m, returnType, i), this.concreteImplWriter);
        }
    }

    abstract JDOQLElements getJDOQLElements(Method var1, AbstractMethodHelper var2) throws IOException;

    private void generateCreateMethods(List createMethods) throws IOException {
        Class<?> beanClass = null;
        try {
            beanClass = Class.forName(this.abstractBean, true, this.loader);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
        HashSet<Method> generated = new HashSet<Method>();
        for (int i = 0; i < createMethods.size(); ++i) {
            boolean debug;
            Method m;
            Method m1 = m = (Method)createMethods.get(i);
            String createName = "ejbCreate";
            String postCreateName = "ejbPostCreate";
            if (m.getName().length() > 6) {
                String suffix = m.getName().substring(6);
                createName = createName + suffix;
                postCreateName = postCreateName + suffix;
            }
            if (debug = logger.isLoggable(500)) {
                logger.fine("CreateMethod: " + this.abstractBean + "" + m.getName());
                logger.fine("ejbCreateMethod: " + createName);
                logger.fine("ejbPostCreateMethod: " + postCreateName);
            }
            try {
                Class<?>[] params = m.getParameterTypes();
                for (int j = 0; j < params.length; ++j) {
                    if (params[j].isPrimitive() || params[j].getClassLoader() == null || params[j].getClassLoader().equals(this.loader)) continue;
                    String pname = params[j].getName();
                    if (debug) {
                        logger.fine("Replacing parameter class for: " + pname);
                        logger.fine("Param ClassLoader: " + params[j].getClassLoader());
                        logger.fine("Need ClassLoader: " + this.loader);
                    }
                    params[j] = Class.forName(pname, true, this.loader);
                }
                m = beanClass.getMethod(createName, params);
                m1 = beanClass.getMethod(postCreateName, params);
                if (generated.contains(m)) {
                    if (!debug) continue;
                    logger.fine("...generated...");
                    continue;
                }
                generated.add(m);
            }
            catch (Exception e) {
                continue;
            }
            String[] exc = CMPTemplateFormatter.getExceptionNames(m);
            String parametersList = CMPTemplateFormatter.getParametersList(m);
            String parametersListWithSeparator = this.makeLiteral(CMPTemplateFormatter.getParametersListWithSeparator(m, " + \", \" + "));
            String body = this.getEJBCreateMethodBody(createName, exc, parametersList, parametersListWithSeparator);
            CMPTemplateFormatter.addGenericMethod(m, createName, this.pkClass, body, this.concreteImplWriter);
            body = this.getEJBPostCreateMethodBody(postCreateName, parametersList, parametersListWithSeparator);
            CMPTemplateFormatter.addGenericMethod(m1, postCreateName, "void", body, this.concreteImplWriter);
        }
    }

    abstract String getEJBCreateMethodBody(String var1, String[] var2, String var3, String var4);

    abstract String getEJBPostCreateMethodBody(String var1, String var2, String var3);

    abstract String getEJBRemoveMethodBody();

    void generateKnownMethods(AbstractMethodHelper methodHelper) throws IOException {
        String[] exc = null;
        String[] st = CMPTemplateFormatter.commonPublicMethodsArray;
        for (int i = 0; i < st.length; ++i) {
            String mname = st[i];
            exc = this.getExceptionList(methodHelper, mname);
            String body = null;
            if (mname.equals("ejbRemove")) {
                body = this.getEJBRemoveMethodBody();
            } else if (mname.equals("ejb__flush")) {
                this.oneParam[0] = "javax.ejb.DuplicateKeyException";
                exc = this.oneParam;
                body = CMPTemplateFormatter.helpers.getProperty(mname);
            } else {
                body = CMPTemplateFormatter.helpers.getProperty(mname);
            }
            this.concreteImplWriter.addMethod(mname, 1, "void", null, null, exc, CMPTemplateFormatter.getBodyAsStrings(body), null);
        }
        this.oneParam[0] = "int";
        this.concreteImplWriter.addMethod("afterCompletion", 1, "void", param0, this.oneParam, null, CMPTemplateFormatter.afterCompletionBody, null);
        this.concreteImplWriter.addMethod("ejb__remove", 1, "void", param0, objectType, null, null, null);
        st = CMPTemplateFormatter.commonPrivateMethodsArray;
        for (int i = 0; i < st.length; ++i) {
            String mname = st[i];
            String body = CMPTemplateFormatter.helpers.getProperty(mname);
            CMPTemplateFormatter.addGenericMethod(mname, CMPTemplateFormatter.getBodyAsStrings(body), this.concreteImplWriter);
        }
        this.oneParam[0] = "byte";
        String body = CMPTemplateFormatter.jdoarraycopyformatter.format(this.oneParam);
        this.oneParam[0] = "byte[]";
        this.concreteImplWriter.addMethod("jdoArrayCopy", 2, "byte[]", param0, this.oneParam, null, CMPTemplateFormatter.getBodyAsStrings(body), null);
        this.oneParam[0] = "javax.ejb.EntityContext";
        this.concreteImplWriter.addMethod("setEntityContext", 1, "void", param0, this.oneParam, this.getExceptionList(methodHelper, "setEntityContext", this.oneParam), CMPTemplateFormatter.setEntityContextBody, null);
        this.oneParam[0] = "key";
        String[] param = new String[]{this.concreteImplName};
        this.concreteImplWriter.addMethod("jdoGetObjectId", 2, "Object", this.oneParam, this.pkClassParam, null, CMPTemplateFormatter.getBodyAsStrings(CMPTemplateFormatter.goidformatter.format(param)), null);
        this.oneParam[0] = CMPTemplateFormatter.jdoGetJdoInstanceClassTemplate;
        CMPTemplateFormatter.addGenericMethod("jdoGetJdoInstanceClass", 9, "java.lang.Class", this.oneParam, this.concreteImplWriter);
        this.generateSpecialKnownMethods();
    }

    void generateSpecialKnownMethods() throws IOException {
        Object body = null;
        if (this.isUpdateable) {
            body = CMPTemplateFormatter.jdoClosePersistenceManagerBody;
        }
        CMPTemplateFormatter.addGenericMethod("jdoClosePersistenceManager", body, this.concreteImplWriter);
        if (this.isUpdateable) {
            body = CMPTemplateFormatter.assertPersistenceManagerIsNullBody;
        }
        CMPTemplateFormatter.addGenericMethod("assertPersistenceManagerIsNull", body, this.concreteImplWriter);
        if (this.isUpdateable) {
            this.oneParam[0] = I18NHelper.getMessage(messages, "EXC_TransactionNotActive");
            body = CMPTemplateFormatter.getBodyAsStrings(CMPTemplateFormatter.intxformatter.format(this.oneParam));
        }
        CMPTemplateFormatter.addGenericMethod("assertInTransaction", body, this.concreteImplWriter);
        body = this.isUpdateable ? CMPTemplateFormatter.jdoGetPersistenceManagerBody : CMPROTemplateFormatter.jdoGetPersistenceManagerBody;
        CMPTemplateFormatter.addGenericMethod("jdoGetPersistenceManager", "com.sun.jdo.api.persistence.support.PersistenceManager", body, this.concreteImplWriter);
        this.oneParam[0] = this.concreteImplName;
        MessageFormat mformat = null;
        mformat = this.isUpdateable ? CMPTemplateFormatter.jdolookuppmfformatter : CMPROTemplateFormatter.jdolookuppmfformatter;
        CMPTemplateFormatter.addGenericMethod("jdoLookupPersistenceManagerFactory", 42, CMPTemplateFormatter.getBodyAsStrings(mformat.format(this.oneParam)), this.concreteImplWriter);
        this.threeParams[0] = this.pkClass;
        this.threeParams[1] = this.pcname;
        this.threeParams[2] = "";
        if (this.isUpdateable) {
            mformat = CMPTemplateFormatter.giformatter;
        } else {
            if (this.loadNonDFGBody != null) {
                this.threeParams[2] = this.loadNonDFGBody.toString();
            }
            mformat = CMPROTemplateFormatter.giformatter;
        }
        CMPTemplateFormatter.addGenericMethod("jdoGetInstance", CMPTemplateFormatter.getBodyAsStrings(mformat.format(this.threeParams)), this.concreteImplWriter);
        body = this.isUpdateable ? null : CMPTemplateFormatter.getBodyAsStrings(CMPROTemplateFormatter.ejb__refreshformatter.format(this.threeParams));
        this.concreteImplWriter.addMethod("ejb__refresh", 1, "void", param0, objectType, null, (String[])body, null);
        this.oneParam[0] = "com.sun.jdo.api.persistence.support.PersistenceManager";
        body = this.isUpdateable ? CMPTemplateFormatter.jdoReleasePersistenceManagerBody : CMPROTemplateFormatter.jdoReleasePersistenceManagerBody;
        this.concreteImplWriter.addMethod("jdoReleasePersistenceManager", 2, "void", param0, this.oneParam, null, (String[])body, null);
    }

    void generateHelperClassMethods() throws IOException {
        this.oneParam[0] = CMPTemplateFormatter.assertInstanceOfRemoteInterfaceImplTemplate;
        this.jdoHelperWriter.addMethod("assertInstanceOfRemoteInterfaceImpl", 1, "void", param0, objectType, null, this.oneParam, null);
        this.oneParam[0] = CMPTemplateFormatter.getHelperInstanceTemplate;
        CMPTemplateFormatter.addGenericMethod("getHelperInstance", 9, this.helperName, this.oneParam, this.jdoHelperWriter);
        CMPTemplateFormatter.addGenericMethod("getContainer", 1, "Object", CMPTemplateFormatter.getContainerBody, this.jdoHelperWriter);
        this.oneParam[0] = this.concreteImplName;
        CMPTemplateFormatter.addGenericMethod("getPCClass", 1, "java.lang.Class", CMPTemplateFormatter.getBodyAsStrings(CMPTemplateFormatter.pcclassgetterformatter.format(this.oneParam)), this.jdoHelperWriter);
    }

    private String[] getKeyFields(PersistenceFieldElement[] fields) {
        ArrayList<String> returnList = new ArrayList<String>();
        int count = fields != null ? fields.length : 0;
        for (int i = 0; i < count; ++i) {
            PersistenceFieldElement pfe = fields[i];
            if (!pfe.isKey()) continue;
            returnList.add(pfe.getName());
        }
        return returnList.toArray(new String[returnList.size()]);
    }

    private void generatePKObjectIdConversion(String[] keyFields) throws IOException {
        int length = keyFields.length;
        StringBuffer getOid = new StringBuffer();
        StringBuffer getPK = new StringBuffer();
        String[] pkfieldParam = new String[1];
        getOid.append(CMPTemplateFormatter.assertPKNotNullTemplate).append(CMPTemplateFormatter.noidformatter.format(this.pcnameParam));
        getPK.append(CMPTemplateFormatter.assertOidNotNullTemplate).append(CMPTemplateFormatter.oidcformatter.format(this.pcnameParam));
        boolean debug = logger.isLoggable(500);
        if (length == 1) {
            String pkfield = keyFields[0];
            String pkfieldType = this.model.getFieldType(this.pcname, pkfield);
            pkfieldParam[0] = pkfield;
            if (debug) {
                logger.fine("pkfield: " + pkfield);
            }
            if (this.model.isPrimitive(this.pcname, pkfield) || !this.pkClass.equals(pkfieldType) && !this.pkClass.equals(Object.class.getName())) {
                getPK.append(CMPTemplateFormatter.npkformatter.format(this.pkClassParam));
                getOid.append(CMPTemplateFormatter.pkcformatter.format(this.pkClassParam));
                pkfieldParam[0] = pkfield;
                getOid.append(CMPTemplateFormatter.oidformatter.format(pkfieldParam));
                getPK.append(CMPTemplateFormatter.pkformatter.format(pkfieldParam));
                getPK.append("return key;");
            } else {
                this.oneParam[0] = pkfieldType;
                getOid.append(CMPTemplateFormatter.pkcformatter.format(this.oneParam));
                this.twoParams[0] = pkfield;
                this.twoParams[1] = pkfieldType;
                getOid.append(this.requireCloneOnGetAndSet(pkfieldType) ? CMPTemplateFormatter.oid1cloneformatter.format(this.twoParams) : (this.requireTrimOnSet(pkfieldType) ? CMPTemplateFormatter.oid1stringformatter.format(pkfieldParam) : CMPTemplateFormatter.oid1formatter.format(pkfieldParam)));
                getPK.append(this.requireCloneOnGetAndSet(pkfieldType) ? CMPTemplateFormatter.pk1cloneformatter.format(pkfieldParam) : CMPTemplateFormatter.pk1formatter.format(pkfieldParam));
            }
        } else {
            getPK.append(CMPTemplateFormatter.npkformatter.format(this.pkClassParam));
            getOid.append(CMPTemplateFormatter.pkcformatter.format(this.pkClassParam));
            for (int i = 0; i < length; ++i) {
                String pkfield;
                pkfieldParam[0] = pkfield = keyFields[i];
                if (debug) {
                    logger.fine("pkfield: " + pkfield);
                }
                if (!this.model.isPrimitive(this.pcname, pkfield)) {
                    getOid.append(CMPTemplateFormatter.assertpkfieldformatter.format(pkfieldParam));
                }
                String pkfieldType = this.model.getFieldType(this.pcname, pkfield);
                this.twoParams[0] = pkfield;
                this.twoParams[1] = pkfieldType;
                getOid.append(this.requireCloneOnGetAndSet(pkfieldType) ? CMPTemplateFormatter.oidcloneformatter.format(this.twoParams) : (this.requireTrimOnSet(pkfieldType) ? CMPTemplateFormatter.oidstringformatter.format(pkfieldParam) : CMPTemplateFormatter.oidformatter.format(pkfieldParam)));
                getPK.append(this.requireCloneOnGetAndSet(pkfieldType) ? CMPTemplateFormatter.pkcloneformatter.format(this.twoParams) : CMPTemplateFormatter.pkformatter.format(pkfieldParam));
            }
            getPK.append("return key;");
        }
        getOid.append("return jdoObjectId;");
        this.jdoHelperWriter.addMethod("convertPrimaryKeyToObjectId", 1, "Object", param0, objectType, null, CMPTemplateFormatter.getBodyAsStrings(getOid.toString()), null);
        this.jdoHelperWriter.addMethod("convertObjectIdToPrimaryKey", 1, "Object", param0, objectType, null, CMPTemplateFormatter.getBodyAsStrings(getPK.toString()), null);
    }

    String getConcreteBeanForPCClass(String pcClass) {
        return this.nameMapper.getConcreteBeanClassForEjbName(this.nameMapper.getEjbNameForPersistenceClass(pcClass));
    }

    void generateConversions() throws IOException {
        String[] pcParams = new String[]{"pc", "_jdoPersistenceManager"};
        String[] pcParamTypes = new String[]{"Object", "com.sun.jdo.api.persistence.support.PersistenceManager"};
        String[] collParamTypes = new String[]{"java.util.Collection", "com.sun.jdo.api.persistence.support.PersistenceManager"};
        String[] body = null;
        if (!this.hasRemoteInterface) {
            body = CMPTemplateFormatter.getBodyAsStrings("return null;");
            this.jdoHelperWriter.addMethod("convertPCToEJBObject", 1, "EJBObject", pcParams, pcParamTypes, null, body, null);
            this.twoParams[0] = "EJBObject";
            this.twoParams[1] = "com.sun.jdo.api.persistence.support.PersistenceManager";
            this.jdoHelperWriter.addMethod("convertEJBObjectToPC", 1, "Object", param0PM, this.twoParams, null, body, null);
        }
    }

    boolean containsException(String[] exc, String checkExc) {
        boolean rc = false;
        if (exc != null) {
            for (int i = 0; i < exc.length; ++i) {
                if (!exc[i].equals(checkExc)) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    String getException(String[] exc, String checkExc) {
        return this.containsException(exc, checkExc) ? checkExc : "EJBException";
    }

    String getException(String[] exc, String checkExc, String superExc) {
        String rc = "EJBException";
        if (exc != null) {
            for (int i = 0; i < exc.length; ++i) {
                if (!exc[i].equals(checkExc) && !exc[i].equals(superExc)) continue;
                rc = checkExc;
                break;
            }
        }
        return rc;
    }

    private boolean isSingleObjectFinder(Method finder) {
        return !finder.getReturnType().equals(Collection.class) && !finder.getReturnType().equals(Enumeration.class);
    }

    private String generateFinderMethodBody(AbstractMethodHelper methodHelper, JDOQLElements jdoqlElements, String mname, Method m, String returnType, int index) throws IOException {
        StringBuffer body = new StringBuffer();
        body.append(CMPTemplateFormatter.assertPersistenceManagerIsNullTemplate);
        body.append("\n");
        body.append(this.generateFinderSelectorCommonBody(methodHelper, jdoqlElements, mname, m, returnType, index));
        this.oneParam[0] = mname;
        if (this.isSingleObjectFinder(m)) {
            this.fourParams[0] = mname;
            this.fourParams[1] = this.pkClass;
            this.fourParams[2] = this.concreteImplName;
            this.fourParams[3] = CMPTemplateFormatter.catchClauseTemplate;
            body.append(CMPTemplateFormatter.singlefinderformatter.format(this.fourParams));
        } else {
            this.twoParams[0] = this.concreteImplName;
            this.twoParams[1] = CMPTemplateFormatter.catchClauseTemplate;
            if (this.isFinderReturningEnumeration(m)) {
                body.append(CMPTemplateFormatter.multifinderenumerationformatter.format(this.twoParams));
            } else {
                body.append(CMPTemplateFormatter.multifinderformatter.format(this.twoParams));
            }
        }
        return body.toString();
    }

    String generateFinderSelectorCommonBody(AbstractMethodHelper methodHelper, JDOQLElements jdoqlElements, String methodName, Method m, String returnType, int index) throws IOException {
        String queryVariableQualifier;
        this.oneParam[0] = queryVariableQualifier = m.getName() + '_' + index;
        CMPTemplateFormatter.addPrivateField(CMPTemplateFormatter.finderselectorstaticvformatter.format(this.oneParam), 8, this.concreteImplWriter);
        CMPTemplateFormatter.addPrivateField(CMPTemplateFormatter.finderselectorstaticfinalvformatter.format(this.oneParam), 24, this.concreteImplWriter);
        StringBuffer body = new StringBuffer();
        String[] parameterEjbNames = jdoqlElements.getParameterEjbNames();
        body.append(this.generateFinderSelectorParamCheck(m, parameterEjbNames));
        String pcClassName = jdoqlElements.getCandidateClassName();
        String concreteBeanClassName = this.getConcreteBeanForPCClass(pcClassName);
        this.queryParams[0] = returnType;
        this.queryParams[1] = queryVariableQualifier;
        this.queryParams[2] = concreteBeanClassName;
        this.queryParams[3] = StringHelper.escape(jdoqlElements.getFilter());
        this.queryParams[4] = StringHelper.escape(jdoqlElements.getParameters());
        this.queryParams[5] = StringHelper.escape(jdoqlElements.getVariables());
        this.queryParams[6] = StringHelper.escape(jdoqlElements.getResult());
        this.queryParams[7] = StringHelper.escape(jdoqlElements.getOrdering());
        this.queryParams[8] = Boolean.toString(methodHelper.isQueryPrefetchEnabled(m));
        this.queryParams[9] = StringHelper.escape(this.generateQueryIgnoreCache());
        body.append(CMPTemplateFormatter.finderselectorformatter.format(this.queryParams));
        String queryParam = this.generateParamConvBody(m, parameterEjbNames);
        if (jdoqlElements.isAggregate()) {
            if (queryParam == null) {
                this.oneParam[0] = "";
                body.append(CMPTemplateFormatter.aggqueryexecformatter.format(this.oneParam));
            } else {
                this.oneParam[0] = queryParam;
                body.append(CMPTemplateFormatter.aggqueryexecparamconvformatter.format(this.oneParam));
            }
        } else if (queryParam == null) {
            this.oneParam[0] = "";
            body.append(CMPTemplateFormatter.queryexecformatter.format(this.oneParam));
        } else {
            this.oneParam[0] = queryParam;
            body.append(CMPTemplateFormatter.queryexecparamconvformatter.format(this.oneParam));
        }
        return body.toString();
    }

    String generateFinderSelectorParamCheck(Method m, String[] parameterEjbNames) {
        StringBuffer checkBody = new StringBuffer();
        return checkBody.toString();
    }

    String generateQueryIgnoreCache() {
        return "";
    }

    abstract boolean isFinderReturningEnumeration(Method var1);

    private String generateParamConvBody(Method m, String[] parameterEjbNames) {
        StringBuffer paramString = new StringBuffer();
        Class<?>[] paramTypes = m.getParameterTypes();
        int paramLength = paramTypes.length;
        MessageFormat mformat = null;
        String paramClassName = null;
        if (paramLength > 0) {
            for (int i = 0; i < paramLength; ++i) {
                paramClassName = paramTypes[i].getName();
                if (this.nameMapper.isLocalInterface(paramClassName) || this.nameMapper.isRemoteInterface(paramClassName)) {
                    if (parameterEjbNames[i] != null) {
                        String concreteImplName;
                        mformat = CMPTemplateFormatter.queryexecparamconvargumentformatter;
                        this.threeParams[0] = concreteImplName = this.nameMapper.getConcreteBeanClassForEjbName(parameterEjbNames[i]);
                        this.threeParams[1] = String.valueOf(i);
                        this.threeParams[2] = this.nameMapper.isLocalInterface(paramClassName) ? "convertEJBLocalObjectToPC" : "convertEJBObjectToPC";
                        paramString.append(mformat.format(this.threeParams));
                    } else {
                        paramString.append("param" + i);
                    }
                } else if (paramTypes[i].isPrimitive()) {
                    paramString.append(JavaClassWriterHelper.getWrapperExpr(paramTypes[i], "param" + i));
                } else {
                    paramString.append("param" + i);
                }
                if (i >= paramLength - 1) continue;
                paramString.append(", ");
            }
        } else {
            return null;
        }
        return paramString.toString();
    }

    String[] getExceptionList(AbstractMethodHelper methodHelper, String mname, String[] paramTypeNames) {
        String[] rc = null;
        Class[] paramTypes = null;
        Map methodNames = methodHelper.getMethodNames();
        Method m = (Method)methodNames.get(mname);
        boolean debug = logger.isLoggable(500);
        if (debug) {
            logger.fine("Processing method: " + mname);
            logger.fine("Known method: " + m);
        }
        if (m == null) {
            if (paramTypeNames != null) {
                paramTypes = new Class[paramTypeNames.length];
                try {
                    for (int i = paramTypeNames.length - 1; i >= 0; --i) {
                        paramTypes[i] = Class.forName(paramTypeNames[i], true, this.loader);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                Class<?> beanClass = Class.forName(this.abstractBean, true, this.loader);
                m = beanClass.getMethod(mname, paramTypes);
                if (debug) {
                    logger.fine("Found method: " + m);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (m != null) {
            rc = CMPTemplateFormatter.getExceptionNames(m);
        }
        return rc;
    }

    String[] getExceptionList(AbstractMethodHelper methodHelper, String mname) {
        return this.getExceptionList(methodHelper, mname, null);
    }

    private String makeLiteral(String st) {
        return StringHelper.isEmpty(st) ? "\"\"" : "\"\" + " + st;
    }

    String getSignaturesOfGeneratorClasses() {
        StringBuffer signatures = new StringBuffer().append(SIGNATURE).append(" ## ").append(CMPTemplateFormatter.signatureTemplate).append(" ## ").append("$RCSfile: DeploymentDescriptorModel.java,v $ $Revision: 1.9 $");
        return signatures.toString();
    }

    boolean requireCloneOnGetAndSet(String fieldType) {
        return "java.util.Date".equals(fieldType) || "java.sql.Date".equals(fieldType) || "java.sql.Time".equals(fieldType) || "java.sql.Timestamp".equals(fieldType);
    }

    boolean requireTrimOnSet(String fieldType) {
        return "java.lang.String".equals(fieldType);
    }

    void loadNonDFGField(FieldInfo fieldInfo) {
        if (!this.isUpdateable && !fieldInfo.isDFG) {
            this.oneParam[0] = fieldInfo.getter;
            this.loadNonDFGBody.append(CMPROTemplateFormatter.loadNonDFGformatter.format(this.oneParam));
        }
    }

    class FieldInfo {
        final PersistenceFieldElement pfe;
        final String name;
        final String type;
        final String getter;
        final String setter;
        final boolean isKey;
        final boolean isPrimitive;
        final boolean isByteArray;
        final boolean isSerializable;
        final boolean requireCloneOnGetAndSet;
        final boolean isGeneratedField;
        final boolean isDFG;

        FieldInfo(Model model, NameMapper nameMapper, PersistenceFieldElement pfe, String beanName, String pcname) {
            this.pfe = pfe;
            String pfn = pfe.getName();
            this.name = nameMapper.getEjbFieldForPersistenceField(pcname, pfn);
            String fname = StringHelper.getCapitalizedString(this.name);
            this.getter = "get" + fname;
            this.setter = "set" + fname;
            boolean debug = logger.isLoggable(500);
            if (debug) {
                logger.fine("-Methods: " + this.getter + " " + this.setter);
            }
            this.isKey = pfe.isKey();
            this.isPrimitive = model.isPrimitive(pcname, pfn);
            this.isByteArray = model.isByteArray(beanName, this.name);
            this.isSerializable = model.isByteArray(pcname, pfn);
            this.type = this.isSerializable ? model.getFieldType(beanName, this.name).replace('$', '.') : model.getFieldType(beanName, this.name);
            if (debug) {
                logger.fine("Field: " + this.name + " " + this.type);
            }
            this.requireCloneOnGetAndSet = JDOConcreteBeanGenerator.this.requireCloneOnGetAndSet(this.type);
            this.isGeneratedField = nameMapper.isGeneratedField(beanName, this.name);
            MappingClassElement mce = model.getMappingClass(pcname);
            MappingFieldElement mfe = mce.getField(this.name);
            this.isDFG = mfe.getFetchGroup() == 1;
        }
    }
}

