/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.generator.database;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.DBException;
import com.sun.forte4j.modules.dbmodel.DBIdentifier;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.IndexElement;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.UniqueKeyElement;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.ColumnElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.ColumnPairElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.ForeignKeyElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.IndexElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.SchemaElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.TableElementImpl;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.UniqueKeyElementImpl;
import com.sun.forte4j.modules.dbmodel.util.NameUtil;
import com.sun.jdo.spi.persistence.generator.database.JDBCInfo;
import com.sun.jdo.spi.persistence.generator.database.MappingPolicy;

class DBElementFactory {
    private static final String TAGLINE = "generated schema version ";
    private static final String SIGNATURE = "$RCSfile: DBElementFactory.java,v $ $Revision: 1.8 $";
    private static final String UNKNOWN_FIELD_TYPE = "java.lang.Long";
    private static final String DEFAULT_FIELD_TYPE = "java.lang.Object";

    private DBElementFactory() {
    }

    static SchemaElement createSchema(String schemaName) throws DBException {
        SchemaElementImpl schemaImpl = new SchemaElementImpl();
        SchemaElement schema = new SchemaElement(schemaImpl);
        schema.setName(DBIdentifier.create(schemaName));
        schema.setDatabaseProductVersion("generated schema version $RCSfile: DBElementFactory.java,v $ $Revision: 1.8 $");
        return schema;
    }

    static TableElement createAndAttachTable(SchemaElement schema, String tableName) throws DBException {
        String fullName = NameUtil.getAbsoluteTableName(schema.getName().getName(), tableName);
        TableElementImpl tableImpl = new TableElementImpl(tableName);
        TableElement table = new TableElement(tableImpl, schema);
        table.setName(DBIdentifier.create(fullName));
        table.setTableOrView(true);
        schema.addTable(table);
        return table;
    }

    static ColumnElement createAndAttachColumn(String columnName, TableElement table, JDBCInfo ji) throws DBException {
        String fullName = NameUtil.getAbsoluteMemberName(table.getName().getName(), columnName);
        DBIdentifier columnId = DBIdentifier.create(columnName);
        ColumnElementImpl columnImpl = new ColumnElementImpl();
        ColumnElement column = new ColumnElement(columnImpl, table);
        column.setName(columnId);
        column.setType(ji.getJdbcType());
        column.setNullable(ji.getNullable());
        column.setPrecision(ji.getPrecision());
        column.setScale(ji.getScale());
        column.setLength(ji.getLength());
        table.addColumn(column);
        return column;
    }

    static ColumnPairElement createColumnPair(ColumnElement column, ColumnElement refColumn, TableElement declaringTbl) throws DBException {
        ColumnPairElementImpl pairImpl = new ColumnPairElementImpl();
        ColumnPairElement pair = new ColumnPairElement(pairImpl, column, refColumn, declaringTbl);
        return pair;
    }

    static UniqueKeyElement createAndAttachPrimaryKey(TableElement table, String pKeyName) throws DBException {
        String tableName = table.getName().getName();
        String fullName = NameUtil.getAbsoluteMemberName(tableName, pKeyName);
        TableElementImpl tableImpl = (TableElementImpl)table.getElementImpl();
        IndexElementImpl indexImpl = new IndexElementImpl(tableImpl, fullName, true);
        IndexElement index = new IndexElement(indexImpl, table);
        index.setUnique(true);
        UniqueKeyElementImpl pKeyImpl = new UniqueKeyElementImpl();
        UniqueKeyElement pKey = new UniqueKeyElement(pKeyImpl, table, index);
        pKey.setName(DBIdentifier.create(fullName));
        pKey.setPrimaryKey(true);
        table.addKey(pKey);
        table.addIndex(pKey.getAssociatedIndex());
        return pKey;
    }

    static ForeignKeyElement createAndAttachForeignKey(TableElement declaringTbl, TableElement refTbl, String keyName, MappingPolicy mappingPolicy, String uniqueId) throws DBException {
        String fkeyName = mappingPolicy.getConstraintName(keyName, uniqueId);
        TableElementImpl tableImpl = (TableElementImpl)declaringTbl.getElementImpl();
        ForeignKeyElementImpl fkeyImpl = new ForeignKeyElementImpl(tableImpl, fkeyName);
        ForeignKeyElement fkey = new ForeignKeyElement(fkeyImpl, declaringTbl);
        UniqueKeyElement pk = refTbl.getPrimaryKey();
        ColumnElement[] pkColumns = pk.getColumns();
        String refTblName = refTbl.getName().getName();
        if (pkColumns != null) {
            for (int i = 0; i < pkColumns.length; ++i) {
                ColumnElement refColumn = pkColumns[i];
                String columnName = mappingPolicy.getConstraintColumnName(refTblName, refColumn.getName().getName());
                JDBCInfo ji = new JDBCInfo(refColumn.getType(), refColumn.getPrecision(), refColumn.getScale(), refColumn.getLength(), true);
                ColumnElement column = DBElementFactory.createAndAttachColumn(columnName, declaringTbl, ji);
                ColumnPairElement pair = DBElementFactory.createColumnPair(column, refColumn, declaringTbl);
                fkey.addColumnPair(pair);
            }
        }
        declaringTbl.addKey(fkey);
        return fkey;
    }

    static JDBCInfo getColumnType(String fieldName, String fieldType, MappingPolicy mappingPolicy) {
        JDBCInfo rc;
        if (fieldType == null) {
            fieldType = UNKNOWN_FIELD_TYPE;
        }
        if (null == (rc = mappingPolicy.getJDBCInfo(fieldName, fieldType))) {
            rc = mappingPolicy.getJDBCInfo(null, DEFAULT_FIELD_TYPE);
        }
        return rc;
    }
}

