/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.model.jdo;

import com.sun.jdo.api.persistence.model.ModelException;
import com.sun.jdo.api.persistence.model.jdo.PersistenceElementProperties;
import com.sun.jdo.spi.persistence.utility.I18NHelper;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.text.Collator;
import java.util.ResourceBundle;

public abstract class PersistenceElement
implements PersistenceElementProperties,
Comparable {
    private static final ResourceBundle _messages = I18NHelper.loadBundle("com.sun.jdo.api.persistence.model.Bundle", PersistenceElement.class.getClassLoader());
    Impl _impl;

    public PersistenceElement() {
        this(null);
    }

    protected PersistenceElement(Impl impl) {
        this.setImpl(impl);
    }

    public final Impl getImpl() {
        return this._impl;
    }

    protected static final ResourceBundle getMessages() {
        return _messages;
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.getImpl().addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.getImpl().removePropertyChangeListener(l);
    }

    public final void addVetoableChangeListener(VetoableChangeListener l) {
        this.getImpl().addVetoableChangeListener(l);
    }

    public final void removeVetoableChangeListener(VetoableChangeListener l) {
        this.getImpl().removeVetoableChangeListener(l);
    }

    public String getName() {
        return this.getImpl().getName();
    }

    public void setName(String name) throws ModelException {
        this.getImpl().setName(name);
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getClass() == obj.getClass() && this.compareTo(obj) == 0;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new ClassCastException();
        }
        if (o == this) {
            return 0;
        }
        String thisName = this.getName();
        String otherName = ((PersistenceElement)o).getName();
        if (thisName == null) {
            return otherName == null ? 0 : -1;
        }
        if (otherName == null) {
            return 1;
        }
        int ret = Collator.getInstance().compare(thisName, otherName);
        if (ret == 0 && this.getClass() != o.getClass()) {
            ret = this.getClass().getName().compareTo(o.getClass().getName());
        }
        return ret;
    }

    public void setImpl(Impl impl) {
        this._impl = impl;
        if (this._impl != null) {
            this.getImpl().attachToElement(this);
        }
    }

    public static interface Impl {
        public static final int ADD = 1;
        public static final int REMOVE = -1;
        public static final int SET = 0;

        public void attachToElement(PersistenceElement var1);

        public void addPropertyChangeListener(PropertyChangeListener var1);

        public void removePropertyChangeListener(PropertyChangeListener var1);

        public void addVetoableChangeListener(VetoableChangeListener var1);

        public void removeVetoableChangeListener(VetoableChangeListener var1);

        public String getName();

        public void setName(String var1) throws ModelException;
    }
}

