/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.meta;

import com.sun.jdo.api.persistence.enhancer.meta.ExtendedJDOMetaData;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataFatalError;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataProperties;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaDataUserException;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

public class JDOMetaDataPropertyImpl
extends Support
implements ExtendedJDOMetaData {
    private static final HashSet transientTypePrefixes = new HashSet();
    private static final HashSet secondClassObjectTypes = new HashSet();
    private static final HashSet mutableSecondClassObjectTypes = new HashSet();
    private final JDOMetaDataProperties properties;

    public JDOMetaDataPropertyImpl(Properties properties, PrintWriter out) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (properties == null) {
            String msg = "Initializing meta data: properties == null";
            throw new JDOMetaDataFatalError("Initializing meta data: properties == null");
        }
        this.properties = new JDOMetaDataProperties(properties);
        this.readProperties();
    }

    public JDOMetaDataPropertyImpl(Properties properties) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        this(properties, null);
    }

    public boolean isPersistenceCapableClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        Iterator i = transientTypePrefixes.iterator();
        while (i.hasNext()) {
            String typePrefix = (String)i.next();
            if (!classPath.startsWith(typePrefix)) continue;
            return false;
        }
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classPath);
        return clazz != null ? clazz.isPersistent() : false;
    }

    public boolean isTransientClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return !this.isPersistenceCapableClass(classPath);
    }

    public boolean isPersistenceCapableRootClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (!this.isPersistenceCapableClass(classPath)) {
            return false;
        }
        String superclass = this.getSuperClass(classPath);
        return superclass != null ? !this.isPersistenceCapableClass(superclass) : true;
    }

    public String getPersistenceCapableRootClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return this.isPersistenceCapableClass(classPath) ? classPath : null;
    }

    public final String getSuperClass(String classname) {
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getSuperClassName() : null;
    }

    public boolean isSecondClassObjectType(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return secondClassObjectTypes.contains(classPath);
    }

    public boolean isMutableSecondClassObjectType(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return mutableSecondClassObjectTypes.contains(classPath);
    }

    public boolean isPersistentField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isPersistent() : false;
    }

    public boolean isTransactionalField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isTransactional() : false;
    }

    public boolean isPrimaryKeyField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isPk() : false;
    }

    public boolean isDefaultFetchGroupField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isInDefaultFetchGroup() : false;
    }

    public int getFieldNo(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classPath);
        return clazz != null ? clazz.getIndexOfField(fieldName) : -1;
    }

    public String[] getManagedFields(String classname) {
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getManagedFieldNames() : new String[]{};
    }

    public final String[] getKnownClasses() {
        return this.properties.getKnownClassNames();
    }

    public final String[] getKnownFields(String classname) {
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getFields() : new String[]{};
    }

    public final int getClassModifiers(String classname) {
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getModifiers() : 0;
    }

    public final int getFieldModifiers(String classname, String fieldname) {
        JDOMetaDataProperties.JDOField field = this.getJDOField(classname, fieldname);
        return field != null ? field.getModifiers() : 0;
    }

    public final String getFieldType(String classname, String fieldname) {
        JDOMetaDataProperties.JDOField field = this.getJDOField(classname, fieldname);
        return field != null ? field.getType() : null;
    }

    private final JDOMetaDataProperties.JDOClass getJDOClass(String classname) throws JDOMetaDataUserException {
        return this.properties.getJDOClass(classname);
    }

    private final void readProperties() {
        String[] classnames = this.properties.getKnownClassNames();
        for (int i = classnames.length - 1; i >= 0; --i) {
            JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classnames[i]);
            if (!clazz.isPersistent() || !secondClassObjectTypes.contains(clazz.getName())) continue;
            throw new JDOMetaDataUserException("ERROR: Parsing meta data properties: The persistent-capable class '" + clazz.getName() + "' is second class object type.");
        }
    }

    private final JDOMetaDataProperties.JDOField getJDOField(String classname, String fieldname) {
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classname);
        return clazz != null ? clazz.getField(fieldname) : null;
    }

    public String getKeyClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classPath);
        return clazz != null ? clazz.getOidClassName() : null;
    }

    public boolean isKeyField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        JDOMetaDataProperties.JDOField field = this.getJDOField(classPath, fieldName);
        return field != null ? field.isPk() : false;
    }

    public boolean isKnownNonManagedField(String classPath, String fieldName, String fieldSig) {
        JDOMetaDataProperties.JDOClass clazz = this.getJDOClass(classPath);
        if (clazz == null) {
            return true;
        }
        JDOMetaDataProperties.JDOField field = clazz.getField(fieldName);
        return field != null ? field.isKnownTransient() : false;
    }

    public boolean isManagedField(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        return this.isPersistentField(classPath, fieldName) || this.isTransactionalField(classPath, fieldName);
    }

    public int getFieldFlags(String classPath, String fieldName) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        if (!this.isManagedField(classPath, fieldName)) {
            JDOMetaDataPropertyImpl.affirm(!this.isTransactionalField(classPath, fieldName));
            JDOMetaDataPropertyImpl.affirm(!this.isPersistentField(classPath, fieldName));
            JDOMetaDataPropertyImpl.affirm(!this.isKeyField(classPath, fieldName));
            JDOMetaDataPropertyImpl.affirm(!this.isDefaultFetchGroupField(classPath, fieldName));
            return 0;
        }
        if (this.isTransactionalField(classPath, fieldName)) {
            JDOMetaDataPropertyImpl.affirm(!this.isPersistentField(classPath, fieldName));
            JDOMetaDataPropertyImpl.affirm(!this.isKeyField(classPath, fieldName));
            return 4;
        }
        JDOMetaDataPropertyImpl.affirm(this.isPersistentField(classPath, fieldName));
        if (this.isKeyField(classPath, fieldName)) {
            return 8;
        }
        if (this.isDefaultFetchGroupField(classPath, fieldName)) {
            return 5;
        }
        return 10;
    }

    public int[] getFieldFlags(String classPath, String[] fieldNames) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        int n = fieldNames != null ? fieldNames.length : 0;
        int[] flags = new int[n];
        for (int i = 0; i < n; ++i) {
            flags[i] = this.getFieldFlags(classPath, fieldNames[i]);
        }
        return flags;
    }

    public final String[] getFieldType(String classname, String[] fieldnames) {
        int n = fieldnames != null ? fieldnames.length : 0;
        String[] types = new String[n];
        for (int i = 0; i < n; ++i) {
            types[i] = this.getFieldType(classname, fieldnames[i]);
        }
        return types;
    }

    public int[] getFieldNo(String classPath, String[] fieldNames) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        int n = fieldNames != null ? fieldNames.length : 0;
        int[] flags = new int[n];
        for (int i = 0; i < n; ++i) {
            flags[i] = this.getFieldNo(classPath, fieldNames[i]);
        }
        return flags;
    }

    public String[] getKeyFields(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        ArrayList<String> keys = new ArrayList<String>();
        String[] fieldNames = this.getManagedFields(classPath);
        int n = fieldNames.length;
        for (int i = 0; i < n; ++i) {
            if (!this.isKeyField(classPath, fieldNames[i])) continue;
            keys.add(fieldNames[i]);
        }
        return keys.toArray(new String[keys.size()]);
    }

    public String getPersistenceCapableSuperClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String clazz = this.getSuperClass(classPath);
        while (clazz != null) {
            if (this.isPersistenceCapableClass(clazz)) {
                return clazz;
            }
            clazz = this.getSuperClass(clazz);
        }
        return null;
    }

    public String getSuperKeyClass(String classPath) throws JDOMetaDataUserException, JDOMetaDataFatalError {
        String superClass = this.getPersistenceCapableSuperClass(classPath);
        while (superClass != null) {
            String superKeyClass = this.getKeyClass(superClass);
            if (superKeyClass != null) {
                return superKeyClass;
            }
            superClass = this.getPersistenceCapableSuperClass(superClass);
        }
        return null;
    }

    static {
        transientTypePrefixes.add("java/");
        transientTypePrefixes.add("javax/");
        transientTypePrefixes.add("com/sun/jdo/");
        mutableSecondClassObjectTypes.add("java/util/Date");
        mutableSecondClassObjectTypes.add("com/sun/jdo/spi/persistence/support/sqlstore/sco/Date");
        mutableSecondClassObjectTypes.add("java/sql/Date");
        mutableSecondClassObjectTypes.add("com/sun/jdo/spi/persistence/support/sqlstore/sco/SqlTime");
        mutableSecondClassObjectTypes.add("java/sql/Time");
        mutableSecondClassObjectTypes.add("com/sun/jdo/spi/persistence/support/sqlstore/sco/SqlDate");
        mutableSecondClassObjectTypes.add("java/sql/Timestamp");
        mutableSecondClassObjectTypes.add("com/sun/jdo/spi/persistence/support/sqlstore/sco/SqlTimestamp");
        mutableSecondClassObjectTypes.add("java/util/Collection");
        mutableSecondClassObjectTypes.add("java/util/Set");
        mutableSecondClassObjectTypes.add("java/util/List");
        mutableSecondClassObjectTypes.add("java/util/HashSet");
        mutableSecondClassObjectTypes.add("java/util/Vector");
        mutableSecondClassObjectTypes.add("java/util/ArrayList");
        secondClassObjectTypes.add("java/lang/Boolean");
        secondClassObjectTypes.add("java/lang/Byte");
        secondClassObjectTypes.add("java/lang/Short");
        secondClassObjectTypes.add("java/lang/Integer");
        secondClassObjectTypes.add("java/lang/Long");
        secondClassObjectTypes.add("java/lang/Float");
        secondClassObjectTypes.add("java/lang/Double");
        secondClassObjectTypes.add("java/lang/Number");
        secondClassObjectTypes.add("java/lang/Character");
        secondClassObjectTypes.add("java/lang/String");
        secondClassObjectTypes.add("java/math/BigInteger");
        secondClassObjectTypes.add("java/math/BigDecimal");
        secondClassObjectTypes.addAll(mutableSecondClassObjectTypes);
    }
}

