/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.impl;

import com.sun.jdo.api.persistence.enhancer.classfile.AttributeVector;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassField;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassFile;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassMethod;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstantPool;
import com.sun.jdo.api.persistence.enhancer.classfile.GenericAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.SyntheticAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.VMConstants;
import com.sun.jdo.api.persistence.enhancer.impl.ClassControl;
import com.sun.jdo.api.persistence.enhancer.impl.Environment;
import com.sun.jdo.api.persistence.enhancer.impl.FieldAction;
import com.sun.jdo.api.persistence.enhancer.impl.MethodAction;
import com.sun.jdo.api.persistence.enhancer.impl.MethodBuilder;
import com.sun.jdo.api.persistence.enhancer.meta.JDOMetaData;
import com.sun.jdo.api.persistence.enhancer.util.Support;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class ClassAction
extends Support
implements VMConstants {
    private static final String AnnotatedAttribute = "com.sun.jdo.api.persistence.enhancer.annotated";
    private static final short AnnotatedVersion = 1;
    private static final String jdoGetStateManagerName = "jdoGetStateManager";
    private static final String jdoSetStateManagerName = "jdoSetStateManager";
    private static final String jdoGetFlagsName = "jdoGetFlags";
    private static final String jdoSetFlagsName = "jdoSetFlags";
    private static final String jdoMakeDirtyName = "jdoMakeDirty";
    private static final String jdoIsDirtyName = "jdoIsDirty";
    private static final String jdoIsTransactionalName = "jdoIsTransactional";
    private static final String jdoIsPersistentName = "jdoIsPersistent";
    private static final String jdoIsNewName = "jdoIsNew";
    private static final String jdoIsDeletedName = "jdoIsDeleted";
    private static final String jdoGetPersistenceManagerName = "jdoGetPersistenceManager";
    private static final String jdoGetObjectIdName = "jdoGetObjectId";
    private static final String jdoConstructorName = "<init>";
    private static final String jdoNewInstanceName = "jdoNewInstance";
    private static final String jdoClearName = "jdoClear";
    private static final String jdoCopyName = "jdoCopy";
    private static final String jdoGetFieldName = "jdoGetField";
    private static final String jdoSetFieldName = "jdoSetField";
    private static final String jdoCloneName = "clone";
    private final ClassControl control;
    private final Environment env;
    private final MethodBuilder methodBuilder;
    private final Map methodActionTable = new HashMap(11);
    private final List fieldActionTable = new ArrayList();
    private boolean previouslyAnnotated = false;
    private boolean implementsPersistence = false;
    private boolean sawImplementsPersistenceCapable = false;
    private boolean sawImplementsCloneable = false;
    private boolean sawFieldJDOStateManager = false;
    private boolean sawFieldJDOFlags = false;
    private boolean sawMethodJDOGetStateManager = false;
    private boolean sawMethodJDOSetStateManager = false;
    private boolean sawMethodJDOGetFlags = false;
    private boolean sawMethodJDOSetFlags = false;
    private boolean sawMethodJDOMakeDirty = false;
    private boolean sawMethodJDOIsDirty = false;
    private boolean sawMethodJDOIsTransactional = false;
    private boolean sawMethodJDOIsPersistent = false;
    private boolean sawMethodJDOIsNew = false;
    private boolean sawMethodJDOIsDeleted = false;
    private boolean sawMethodJDOGetPersistenceManager = false;
    private boolean sawMethodJDOGetObjectId = false;
    private boolean sawMethodJDOConstructor = false;
    private boolean sawMethodJDONewInstance = false;
    private boolean sawMethodJDOGetField = false;
    private boolean sawMethodJDOSetField = false;
    private boolean sawMethodJDOClear = false;
    private boolean sawMethodJDOCopy = false;
    private boolean sawMethodJDOClone = false;

    public ClassAction(ClassControl control, Environment env) {
        this.control = control;
        this.env = env;
        this.methodBuilder = new MethodBuilder(env);
    }

    public void scan1() {
        boolean isPersistent;
        this.env.message("scanning class " + this.control.userClassName());
        ClassAction.affirm(!this.classFile().isInterface());
        ClassAction.affirm(this.control.persistType() > -1);
        this.scanAttributes();
        if (this.previouslyAnnotated) {
            return;
        }
        String name = this.className();
        this.implementsPersistence = this.env.getJDOMetaData().isPersistenceCapableRootClass(name);
        boolean bl = isPersistent = this.control.persistType() == 2;
        if (isPersistent) {
            this.scanForImplementsInterfaces();
            this.scanFields();
        }
        this.scanMethods();
    }

    public void augment() {
        if (this.previouslyAnnotated) {
            return;
        }
        if (this.implementsPersistence) {
            this.env.message("augmenting class " + this.control.userClassName());
            if (!this.sawImplementsPersistenceCapable) {
                this.augmentClassInterface("com/sun/jdo/spi/persistence/support/sqlstore/PersistenceCapable");
            }
            if (!this.sawImplementsCloneable) {
                this.augmentClassInterface("java/lang/Cloneable");
            }
            this.insertPersistenceCapableFields("jdoStateManager", "Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;", JDOMetaData.JDOStateManagerFieldType, 129);
            this.insertPersistenceCapableFields("jdoFlags", "B", "byte", 129);
            this.insertPersistenceCapableMethods();
        }
    }

    public void annotate() {
        if (this.previouslyAnnotated) {
            return;
        }
        this.env.message("annotating class " + this.control.userClassName());
        boolean updates = false;
        Iterator e = this.methodActions();
        while (e.hasNext()) {
            MethodAction methodAction = (MethodAction)e.next();
            if (!methodAction.needsAnnotation()) continue;
            methodAction.annotate();
            updates = true;
        }
        if (updates || this.env.updateInPlace()) {
            this.control.noteUpdate();
            byte[] data = new byte[]{0, 1};
            GenericAttribute annotatedAttr = new GenericAttribute(this.classFile().pool().addUtf8(AnnotatedAttribute), data);
            this.classFile().attributes().addElement(annotatedAttr);
        }
    }

    ClassControl classControl() {
        return this.control;
    }

    ClassFile classFile() {
        return this.control.classFile();
    }

    Iterator fieldActions() {
        return this.fieldActionTable.iterator();
    }

    Iterator methodActions() {
        return this.methodActionTable.values().iterator();
    }

    public String className() {
        return this.control.className();
    }

    public String userClassName() {
        return this.control.userClassName();
    }

    public boolean getImplementsPersistence() {
        return this.implementsPersistence;
    }

    public boolean hasCloneMethod() {
        return this.sawMethodJDOClone;
    }

    public boolean hasAnnotatedAttribute() {
        if (this.previouslyAnnotated) {
            return true;
        }
        Enumeration e = this.classFile().attributes().elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!attr.attrName().asString().equals(AnnotatedAttribute)) continue;
            return true;
        }
        return false;
    }

    private void scanAttributes() {
        Enumeration e = this.classFile().attributes().elements();
        while (e.hasMoreElements()) {
            ClassAttribute attr = (ClassAttribute)e.nextElement();
            if (!attr.attrName().asString().equals(AnnotatedAttribute)) continue;
            this.previouslyAnnotated = true;
            this.env.message("ignoring previously enhanced class " + this.control.userClassName());
            break;
        }
    }

    private void scanForImplementsInterfaces() {
        Iterator ifc = this.classFile().interfaces().iterator();
        while (ifc.hasNext()) {
            ConstClass i = (ConstClass)ifc.next();
            String interfaceNamePath = i.asString();
            if (interfaceNamePath.equals("com/sun/jdo/spi/persistence/support/sqlstore/PersistenceCapable")) {
                this.sawImplementsPersistenceCapable = true;
                this.env.warning(ClassAction.getI18N("enhancer.class_implements_jdo_pc", new Object[]{this.userClassName(), JDOMetaData.JDOPersistenceCapableType}));
            }
            if (!"java/lang/Cloneable".equals(interfaceNamePath)) continue;
            this.sawImplementsCloneable = true;
        }
    }

    private void scanFields() {
        Enumeration e = this.classFile().fields().elements();
        while (e.hasMoreElements()) {
            ClassField f = (ClassField)e.nextElement();
            String fieldName = f.name().asString();
            String fieldSig = f.signature().asString();
            this.scanForJDOFields(fieldName, fieldSig);
            FieldAction action = new FieldAction(this, f, this.env);
            action.check();
            this.fieldActionTable.add(action);
        }
    }

    private void scanForJDOFields(String fieldName, String fieldSig) {
        if (fieldName.equals("jdoStateManager")) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_field", this.userClassName(), "jdoStateManager"));
            this.sawFieldJDOStateManager = true;
            return;
        }
        if (fieldName.equals("jdoFlags")) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_field", this.userClassName(), "jdoFlags"));
            this.sawFieldJDOFlags = true;
            return;
        }
        if (fieldName.startsWith("jdo")) {
            this.env.warning(ClassAction.getI18N("enhancer.class_has_jdo_like_member", this.userClassName(), fieldName));
            return;
        }
    }

    private void scanMethods() {
        boolean isPersistent = this.control.persistType() == 2;
        Enumeration e = this.classFile().methods().elements();
        while (e.hasMoreElements()) {
            ClassMethod m = (ClassMethod)e.nextElement();
            String methodName = m.name().asString();
            String methodSig = m.signature().asString();
            if (isPersistent) {
                this.scanForJDOMethods(methodName, methodSig);
            }
            MethodAction action = new MethodAction(this, m, this.env);
            action.check();
            this.methodActionTable.put(m, action);
        }
    }

    private void scanForJDOMethods(String methodName, String methodSig) {
        if (methodName.equals(jdoGetStateManagerName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOGetStateManager = true;
            return;
        }
        if (methodName.equals(jdoSetStateManagerName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOSetStateManager = true;
            return;
        }
        if (methodName.equals(jdoGetFlagsName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOGetFlags = true;
            return;
        }
        if (methodName.equals(jdoSetFlagsName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOSetFlags = true;
            return;
        }
        if (methodName.equals(jdoMakeDirtyName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOMakeDirty = true;
            return;
        }
        if (methodName.equals(jdoIsDirtyName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOIsDirty = true;
            return;
        }
        if (methodName.equals(jdoIsTransactionalName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOIsTransactional = true;
            return;
        }
        if (methodName.equals(jdoIsPersistentName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOIsPersistent = true;
            return;
        }
        if (methodName.equals(jdoIsNewName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOIsNew = true;
            return;
        }
        if (methodName.equals(jdoIsDeletedName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOIsDeleted = true;
            return;
        }
        if (methodName.equals(jdoGetPersistenceManagerName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOGetPersistenceManager = true;
            return;
        }
        if (methodName.equals(jdoGetObjectIdName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOGetObjectId = true;
            return;
        }
        if (methodName.equals(jdoConstructorName) && methodSig.equals("(Lcom/sun/jdo/spi/persistence/support/sqlstore/StateManager;)V")) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOConstructor = true;
            return;
        }
        if (methodName.equals(jdoNewInstanceName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDONewInstance = true;
            return;
        }
        if (methodName.equals(jdoClearName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOClear = true;
            return;
        }
        if (methodName.equals(jdoCopyName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOCopy = true;
            return;
        }
        if (methodName.equals(jdoGetFieldName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOGetField = true;
            return;
        }
        if (methodName.equals(jdoSetFieldName)) {
            this.env.error(ClassAction.getI18N("enhancer.class_defines_jdo_method", this.userClassName(), methodName));
            this.sawMethodJDOSetField = true;
            return;
        }
        if (methodName.equals(jdoCloneName) && methodSig.equals("()Ljava/lang/Object;")) {
            this.sawMethodJDOClone = true;
            return;
        }
        if (methodName.startsWith("jdo")) {
            this.env.warning(ClassAction.getI18N("enhancer.class_has_jdo_like_member", this.userClassName(), methodName));
            return;
        }
    }

    private void insertPersistenceCapableFields(String fieldName, String fieldSig, String printableFieldSig, int accessFlags) {
        ClassAction.affirm(this.implementsPersistence);
        this.control.noteUpdate();
        this.env.message("adding " + this.control.userClassName() + "." + fieldName + " " + printableFieldSig);
        ClassFile cfile = this.classFile();
        ConstantPool pool = cfile.pool();
        AttributeVector fieldAttrs = new AttributeVector();
        fieldAttrs.addElement(new SyntheticAttribute(pool.addUtf8("Synthetic")));
        ClassField theField = new ClassField(accessFlags, pool.addUtf8(fieldName), pool.addUtf8(fieldSig), fieldAttrs);
        cfile.addField(theField);
    }

    private void insertPersistenceCapableMethods() {
        ClassAction.affirm(this.implementsPersistence);
        this.control.noteUpdate();
        ClassAction.affirm(!this.sawMethodJDOGetStateManager);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetStateManager(this, jdoGetStateManagerName));
        ClassAction.affirm(!this.sawMethodJDOSetStateManager);
        this.classFile().addMethod(this.methodBuilder.makeJDOSetStateManager(this, jdoSetStateManagerName));
        ClassAction.affirm(!this.sawMethodJDOGetFlags);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetFlags(this, jdoGetFlagsName));
        ClassAction.affirm(!this.sawMethodJDOSetFlags);
        this.classFile().addMethod(this.methodBuilder.makeJDOSetFlags(this, jdoSetFlagsName));
        ClassAction.affirm(!this.sawMethodJDOMakeDirty);
        this.classFile().addMethod(this.methodBuilder.makeJDOMakeDirtyMethod(this, jdoMakeDirtyName));
        ClassAction.affirm(!this.sawMethodJDOIsDirty);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsDirtyName));
        ClassAction.affirm(!this.sawMethodJDOIsTransactional);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsTransactionalName));
        ClassAction.affirm(!this.sawMethodJDOIsPersistent);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsPersistentName));
        ClassAction.affirm(!this.sawMethodJDOIsNew);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsNewName));
        ClassAction.affirm(!this.sawMethodJDOIsDeleted);
        this.classFile().addMethod(this.methodBuilder.makeJDOInterrogativeMethod(this, jdoIsDeletedName));
        ClassAction.affirm(!this.sawMethodJDOGetPersistenceManager);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetPersistenceManagerMethod(this, jdoGetPersistenceManagerName));
        ClassAction.affirm(!this.sawMethodJDOGetObjectId);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetObjectIdMethod(this, jdoGetObjectIdName));
        ClassAction.affirm(!this.sawMethodJDOConstructor);
        this.classFile().addMethod(this.methodBuilder.makeJDOConstructor(this, jdoConstructorName));
        ClassAction.affirm(!this.sawMethodJDONewInstance);
        this.classFile().addMethod(this.methodBuilder.makeJDONewInstanceMethod(this, jdoNewInstanceName));
        ClassAction.affirm(!this.sawMethodJDOGetField);
        this.classFile().addMethod(this.methodBuilder.makeJDOGetFieldMethod(this, jdoGetFieldName));
        ClassAction.affirm(!this.sawMethodJDOSetField);
        this.classFile().addMethod(this.methodBuilder.makeJDOSetFieldMethod(this, jdoSetFieldName));
        ClassAction.affirm(!this.sawMethodJDOClear);
        this.classFile().addMethod(this.methodBuilder.makeJDOClearMethod(this, jdoClearName));
        if (!this.sawMethodJDOClone) {
            this.classFile().addMethod(this.methodBuilder.makeJDOClone(this, jdoCloneName));
        }
    }

    private void augmentClassInterface(String interfaceName) {
        this.control.noteUpdate();
        ClassFile cfile = this.classFile();
        ConstClass iface = cfile.pool().addClass(interfaceName);
        this.env.message("adding implements " + ClassControl.userClassFromVMClass(interfaceName));
        cfile.addInterface(iface);
    }
}

