/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassAttribute;
import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.CodeEnv;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstUtf8;
import com.sun.jdo.api.persistence.enhancer.classfile.LocalVariable;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;

public class LocalVariableTableAttribute
extends ClassAttribute {
    public static final String expectedAttrName = "LocalVariableTable";
    private Vector localTable;

    Enumeration variables() {
        return this.localTable.elements();
    }

    public LocalVariableTableAttribute(ConstUtf8 nameAttr, Vector lvarTable) {
        super(nameAttr);
        this.localTable = lvarTable;
    }

    static LocalVariableTableAttribute read(ConstUtf8 attrName, DataInputStream data, CodeEnv env) throws IOException {
        int nVars = data.readUnsignedShort();
        Vector<LocalVariable> lvarTable = new Vector<LocalVariable>();
        while (nVars-- > 0) {
            lvarTable.addElement(LocalVariable.read(data, env));
        }
        return new LocalVariableTableAttribute(attrName, lvarTable);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.attrName().getIndex());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream tmp_out = new DataOutputStream(baos);
        tmp_out.writeShort(this.localTable.size());
        for (int i = 0; i < this.localTable.size(); ++i) {
            ((LocalVariable)this.localTable.elementAt(i)).write(tmp_out);
        }
        tmp_out.flush();
        byte[] tmp_bytes = baos.toByteArray();
        out.writeInt(tmp_bytes.length);
        out.write(tmp_bytes, 0, tmp_bytes.length);
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println("LocalVariables: ");
        for (int i = 0; i < this.localTable.size(); ++i) {
            ((LocalVariable)this.localTable.elementAt(i)).print(out, indent + 2);
        }
    }
}

