/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.api.persistence.enhancer.classfile;

import com.sun.jdo.api.persistence.enhancer.classfile.ClassPrint;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasic;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstBasicMemberRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstClass;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstFieldRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstInterfaceMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstMethodRef;
import com.sun.jdo.api.persistence.enhancer.classfile.ConstValue;
import com.sun.jdo.api.persistence.enhancer.classfile.Descriptor;
import com.sun.jdo.api.persistence.enhancer.classfile.Insn;
import com.sun.jdo.api.persistence.enhancer.classfile.InsnError;
import com.sun.jdo.api.persistence.enhancer.classfile.VMOp;
import java.io.PrintStream;

public class InsnConstOp
extends Insn {
    private ConstBasic constValue;

    public int nStackArgs() {
        int n = VMOp.ops[this.opcode()].nStackArgs();
        if (n >= 0) {
            return n;
        }
        switch (this.opcode()) {
            case 179: 
            case 181: {
                ConstFieldRef fld = (ConstFieldRef)this.constValue;
                String sig = fld.nameAndType().signature().asString();
                if (sig.equals("J") || sig.equals("D")) {
                    return this.opcode() == 181 ? 3 : 2;
                }
                return this.opcode() == 181 ? 2 : 1;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ConstBasicMemberRef meth = (ConstBasicMemberRef)this.constValue;
                String sig = meth.nameAndType().signature().asString();
                int nMethodArgWords = Descriptor.countMethodArgWords(sig);
                return nMethodArgWords + (this.opcode() == 184 ? 0 : 1);
            }
        }
        throw new InsnError("unexpected variable opcode");
    }

    public int nStackResults() {
        int n = VMOp.ops[this.opcode()].nStackResults();
        if (n >= 0) {
            return n;
        }
        switch (this.opcode()) {
            case 178: 
            case 180: {
                ConstFieldRef fld = (ConstFieldRef)this.constValue;
                String sig = fld.nameAndType().signature().asString();
                if (sig.equals("J") || sig.equals("D")) {
                    return 2;
                }
                return 1;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ConstBasicMemberRef meth = (ConstBasicMemberRef)this.constValue;
                return Descriptor.countMethodReturnWords(meth.nameAndType().signature().asString());
            }
        }
        throw new InsnError("unexpected variable opcode");
    }

    public String argTypes() {
        switch (this.opcode()) {
            case 179: 
            case 181: {
                ConstFieldRef fld = (ConstFieldRef)this.constValue;
                String sig = fld.nameAndType().signature().asString();
                if (this.opcode() == 179) {
                    return sig;
                }
                return this.descriptorTypeOfObject(fld) + sig;
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ConstBasicMemberRef meth = (ConstBasicMemberRef)this.constValue;
                String argSig = Descriptor.extractArgSig(meth.nameAndType().signature().asString());
                if (this.opcode() == 184) {
                    return argSig;
                }
                return this.descriptorTypeOfObject(meth) + argSig;
            }
        }
        return VMOp.ops[this.opcode()].argTypes();
    }

    public String resultTypes() {
        switch (this.opcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ConstBasicMemberRef meth = (ConstBasicMemberRef)this.constValue;
                String resultSig = Descriptor.extractResultSig(meth.nameAndType().signature().asString());
                if (resultSig.equals("V")) {
                    return "";
                }
                return resultSig;
            }
            case 178: 
            case 180: {
                ConstFieldRef fld = (ConstFieldRef)this.constValue;
                return fld.nameAndType().signature().asString();
            }
            case 18: 
            case 19: 
            case 20: {
                ConstValue constVal = (ConstValue)this.constValue;
                return constVal.descriptor();
            }
        }
        return VMOp.ops[this.opcode()].resultTypes();
    }

    public boolean branches() {
        return false;
    }

    public ConstBasic value() {
        return this.constValue;
    }

    public void setValue(ConstBasic newValue) {
        this.checkConstant(newValue);
        this.constValue = newValue;
    }

    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  " + InsnConstOp.opName(this.opcode()) + "  pool(" + this.constValue.getIndex() + ")");
    }

    int store(byte[] buf, int index) {
        buf[index++] = this.opcode() == 18 && !this.isNarrowldc() ? 19 : (byte)this.opcode();
        int constIndex = this.constValue.getIndex();
        if (this.size() == 3) {
            buf[index++] = (byte)(constIndex >> 8);
        }
        buf[index++] = (byte)(constIndex & 0xFF);
        return index;
    }

    int size() {
        return this.isNarrowldc() ? 2 : 3;
    }

    private boolean isNarrowldc() {
        return this.opcode() == 18 && this.constValue.getIndex() < 256;
    }

    InsnConstOp(int theOpcode, ConstBasic theOperand) {
        this(theOpcode, theOperand, -1);
    }

    InsnConstOp(int theOpcode, ConstBasic theOperand, int pc) {
        super(theOpcode, pc);
        this.constValue = theOperand;
        this.checkConstant(theOperand);
        if (theOpcode == 185) {
            throw new InsnError("attempt to create an " + InsnConstOp.opName(theOpcode) + " as an InsnConstOp instead of InsnInterfaceInvoke");
        }
    }

    InsnConstOp(int theOpcode, ConstInterfaceMethodRef theOperand, int pc) {
        super(theOpcode, pc);
        this.constValue = theOperand;
        this.checkConstant(theOperand);
    }

    private void checkConstant(ConstBasic operand) {
        switch (this.opcode()) {
            case 18: 
            case 19: 
            case 20: {
                if (operand != null && operand instanceof ConstValue) break;
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstValue operand");
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: {
                if (operand != null && operand instanceof ConstFieldRef) break;
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstFieldRef operand");
            }
            case 182: 
            case 183: 
            case 184: {
                if (operand != null && operand instanceof ConstMethodRef) break;
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstMethodRef operand");
            }
            case 185: {
                if (operand != null && operand instanceof ConstInterfaceMethodRef) break;
                throw new InsnError("Attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstInterfaceMethodRef operand");
            }
            case 187: 
            case 189: 
            case 192: 
            case 193: {
                if (operand != null && operand instanceof ConstClass) break;
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " without a ConstClass operand");
            }
            default: {
                throw new InsnError("attempt to create an " + InsnConstOp.opName(this.opcode()) + " with a constant operand");
            }
        }
    }

    private final String descriptorTypeOfObject(ConstBasicMemberRef memRef) {
        String cname = memRef.className().className().asString();
        return "L" + cname + ";";
    }
}

