/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.util;

public class NameUtil {
    private static char columnPairSeparator = (char)59;
    private static char dbElementSeparator = (char)46;

    public static String getSchemaResourceName(String schemaName) {
        return schemaName + ".dbschema";
    }

    public static String getTableName(String memberName) {
        int index = memberName.indexOf(columnPairSeparator);
        String tempString = index != -1 ? memberName.substring(0, index) : memberName;
        return tempString.substring(0, tempString.lastIndexOf(dbElementSeparator));
    }

    public static String getSchemaName(String memberName) {
        if (memberName == null) {
            return null;
        }
        int index = memberName.indexOf(columnPairSeparator);
        String tempString = index != -1 ? memberName.substring(0, index) : memberName;
        return tempString.substring(0, tempString.indexOf(dbElementSeparator));
    }

    public static String getRelativeTableName(String tableName) {
        if (tableName == null) {
            return null;
        }
        if (NameUtil.isRelativeTableName(tableName)) {
            return tableName;
        }
        return tableName.substring(tableName.indexOf(dbElementSeparator) + 1);
    }

    public static String getRelativeMemberName(String memberName) {
        if (memberName == null) {
            return null;
        }
        int semicolonIndex = memberName.indexOf(columnPairSeparator);
        if (semicolonIndex != -1) {
            String firstColumn = memberName.substring(0, semicolonIndex);
            String secondColumn = memberName.substring(semicolonIndex + 1);
            return NameUtil.getRelativeMemberNameInternal(firstColumn) + columnPairSeparator + NameUtil.getRelativeMemberNameInternal(secondColumn);
        }
        return NameUtil.getRelativeMemberNameInternal(memberName);
    }

    private static String getRelativeMemberNameInternal(String memberName) {
        if (memberName == null) {
            return null;
        }
        if (NameUtil.isRelativeMemberName(memberName)) {
            return memberName;
        }
        return memberName.substring(memberName.indexOf(dbElementSeparator) + 1);
    }

    public static String getAbsoluteTableName(String schemaName, String tableName) {
        if (tableName == null) {
            return null;
        }
        if (!NameUtil.isRelativeTableName(tableName)) {
            return tableName;
        }
        return schemaName + dbElementSeparator + tableName;
    }

    public static String getAbsoluteMemberName(String schemaName, String memberName) {
        if (memberName == null) {
            return null;
        }
        int semicolonIndex = memberName.indexOf(columnPairSeparator);
        if (semicolonIndex != -1) {
            String firstColumn = memberName.substring(0, semicolonIndex);
            String secondColumn = memberName.substring(semicolonIndex + 1);
            return NameUtil.getAbsoluteMemberNameInternal(schemaName, firstColumn) + columnPairSeparator + NameUtil.getAbsoluteMemberNameInternal(schemaName, secondColumn);
        }
        return NameUtil.getAbsoluteMemberNameInternal(schemaName, memberName);
    }

    private static String getAbsoluteMemberNameInternal(String schemaName, String memberName) {
        if (memberName == null) {
            return null;
        }
        if (!NameUtil.isRelativeMemberName(memberName)) {
            return memberName;
        }
        return schemaName + dbElementSeparator + memberName;
    }

    private static boolean isRelativeTableName(String tableName) {
        return tableName.indexOf(dbElementSeparator) == -1;
    }

    private static boolean isRelativeMemberName(String columnName) {
        int first = columnName.indexOf(dbElementSeparator);
        return columnName.indexOf(dbElementSeparator, first + 1) == -1;
    }
}

