/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.nodes;

import com.sun.forte4j.modules.dbmodel.ColumnElement;
import com.sun.forte4j.modules.dbmodel.ColumnPairElement;
import com.sun.forte4j.modules.dbmodel.DBElement;
import com.sun.forte4j.modules.dbmodel.ForeignKeyElement;
import com.sun.forte4j.modules.dbmodel.IndexElement;
import com.sun.forte4j.modules.dbmodel.SchemaElement;
import com.sun.forte4j.modules.dbmodel.TableElement;
import com.sun.forte4j.modules.dbmodel.nodes.ColumnElementNode;
import com.sun.forte4j.modules.dbmodel.nodes.ColumnPairElementNode;
import com.sun.forte4j.modules.dbmodel.nodes.DBElementNodeFactory;
import com.sun.forte4j.modules.dbmodel.nodes.ForeignKeyElementNode;
import com.sun.forte4j.modules.dbmodel.nodes.IconStrings;
import com.sun.forte4j.modules.dbmodel.nodes.IndexElementNode;
import com.sun.forte4j.modules.dbmodel.nodes.SchemaChildren;
import com.sun.forte4j.modules.dbmodel.nodes.SchemaElementNode;
import com.sun.forte4j.modules.dbmodel.nodes.TableChildren;
import com.sun.forte4j.modules.dbmodel.nodes.TableElementFilter;
import com.sun.forte4j.modules.dbmodel.nodes.TableElementNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.src.nodes.DefaultFactory;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DefaultDBFactory
implements DBElementNodeFactory,
IconStrings {
    public static final DefaultDBFactory READ_WRITE = new DefaultDBFactory(true);
    public static final DefaultDBFactory READ_ONLY = new DefaultDBFactory(false);
    private boolean _writeable;
    private static final SystemAction[] CATEGORY_ACTIONS = new SystemAction[]{SystemAction.get((Class)(class$org$openide$actions$ToolsAction == null ? (class$org$openide$actions$ToolsAction = DefaultDBFactory.class$("org.openide.actions.ToolsAction")) : class$org$openide$actions$ToolsAction))};
    static final String[] NAMES = new String[]{NbBundle.getMessage((Class)(class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory == null ? (class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory = DefaultDBFactory.class$("com.sun.forte4j.modules.dbmodel.nodes.DefaultDBFactory")) : class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory), (String)"Columns"), NbBundle.getMessage((Class)(class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory == null ? (class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory = DefaultDBFactory.class$("com.sun.forte4j.modules.dbmodel.nodes.DefaultDBFactory")) : class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory), (String)"Indexes"), NbBundle.getMessage((Class)(class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory == null ? (class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory = DefaultDBFactory.class$("com.sun.forte4j.modules.dbmodel.nodes.DefaultDBFactory")) : class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory), (String)"FKs"), NbBundle.getMessage((Class)(class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory == null ? (class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory = DefaultDBFactory.class$("com.sun.forte4j.modules.dbmodel.nodes.DefaultDBFactory")) : class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory), (String)"Tables")};
    static final int[][] FILTERS = new int[][]{{4}, {8}, {16}, {1}};
    static final String[] CATEGORY_ICONS = new String[]{"com/sun/forte4j/modules/dbmodel/resources/columns", "com/sun/forte4j/modules/dbmodel/resources/indexes", "com/sun/forte4j/modules/dbmodel/resources/foreignKeys", "com/sun/forte4j/modules/dbmodel/resources/table"};
    static /* synthetic */ Class class$org$openide$actions$ToolsAction;
    static /* synthetic */ Class class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory;

    public DefaultDBFactory(boolean writeable) {
        this._writeable = writeable;
    }

    public boolean isWriteable() {
        return this._writeable;
    }

    public Node createSchemaNode(SchemaElement element) {
        return new SchemaElementNode(element, this.createSchemaChildren(element), this.isWriteable());
    }

    protected Children createSchemaChildren(SchemaElement element) {
        return this.createSchemaChildren(element, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createSchemaChildren(SchemaElement element, DBElementNodeFactory factory) {
        SchemaChildren children = new SchemaChildren(factory, element);
        boolean writeable = this.isWriteable();
        return children;
    }

    public Node createColumnNode(ColumnElement element) {
        return new ColumnElementNode(element, this.isWriteable());
    }

    public Node createColumnPairNode(ColumnPairElement element) {
        return new ColumnPairElementNode(element, this.isWriteable());
    }

    public Node createIndexNode(IndexElement element) {
        return new IndexElementNode(element, (TableChildren)this.createIndexChildren(element), this.isWriteable());
    }

    protected Children createIndexChildren(IndexElement element) {
        return this.createIndexChildren(element, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createIndexChildren(IndexElement element, DBElementNodeFactory factory) {
        TableChildren children = new TableChildren(factory, element);
        boolean writeable = this.isWriteable();
        return children;
    }

    public Node createForeignKeyNode(ForeignKeyElement element) {
        return new ForeignKeyElementNode(element, (TableChildren)this.createForeignKeyChildren(element), this.isWriteable());
    }

    protected Children createForeignKeyChildren(ForeignKeyElement element) {
        return this.createForeignKeyChildren(element, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createForeignKeyChildren(ForeignKeyElement element, DBElementNodeFactory factory) {
        TableChildren children = new TableChildren(factory, element);
        boolean writeable = this.isWriteable();
        return children;
    }

    public Node createTableNode(TableElement element) {
        return new TableElementNode(element, this.createTableChildren(element), this.isWriteable());
    }

    protected Children createTableChildren(TableElement element) {
        return this.createTableChildren(element, this.isWriteable() ? READ_WRITE : READ_ONLY);
    }

    protected final Children createTableChildren(TableElement element, DBElementNodeFactory factory) {
        boolean viewSupport;
        TableChildren children = new TableChildren(factory, element);
        TableElementFilter filter = new TableElementFilter();
        boolean writeable = this.isWriteable();
        filter.setOrder(new int[]{1, 2});
        children.setFilter(filter);
        String db = element.getDeclaringSchema().getDatabaseProductName().toLowerCase();
        boolean bl = viewSupport = db.indexOf("oracle") != -1 || db.indexOf("microsoft sql server") != -1;
        if (element.isTableOrView() || viewSupport) {
            children.add(new Node[]{new ElementCategoryNode(0, factory, element, writeable), new ElementCategoryNode(1, factory, element, writeable), new ElementCategoryNode(2, factory, element, writeable)});
        } else {
            children.add(new Node[]{new ElementCategoryNode(0, factory, element, writeable)});
        }
        return children;
    }

    public Node createWaitNode() {
        return this.isWriteable() ? DefaultFactory.READ_WRITE.createWaitNode() : DefaultFactory.READ_ONLY.createWaitNode();
    }

    public Node createErrorNode() {
        return this.isWriteable() ? DefaultFactory.READ_WRITE.createErrorNode() : DefaultFactory.READ_ONLY.createErrorNode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ElementCategoryNode
    extends AbstractNode {
        DBElement element;
        int newTypeIndex;

        ElementCategoryNode(int index, DBElementNodeFactory factory, TableElement element, boolean writeable) {
            this(index, new TableChildren(factory, element));
            this.element = element;
            this.newTypeIndex = writeable ? index : -1;
            switch (index) {
                case 0: {
                    this.setName(NbBundle.getMessage((Class)(class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory == null ? (class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory = DefaultDBFactory.class$("com.sun.forte4j.modules.dbmodel.nodes.DefaultDBFactory")) : class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory), (String)"Columns"));
                    break;
                }
                case 1: {
                    this.setName(NbBundle.getMessage((Class)(class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory == null ? (class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory = DefaultDBFactory.class$("com.sun.forte4j.modules.dbmodel.nodes.DefaultDBFactory")) : class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory), (String)"Indexes"));
                    break;
                }
                case 2: {
                    this.setName(NbBundle.getMessage((Class)(class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory == null ? (class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory = DefaultDBFactory.class$("com.sun.forte4j.modules.dbmodel.nodes.DefaultDBFactory")) : class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory), (String)"FKs"));
                }
            }
        }

        ElementCategoryNode(int index, DBElementNodeFactory factory, SchemaElement element, boolean writeable) {
            this(index, new SchemaChildren(factory, element));
            this.element = element;
            this.newTypeIndex = writeable ? index : -1;
            this.setName(NbBundle.getMessage((Class)(class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory == null ? (class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory = DefaultDBFactory.class$("com.sun.forte4j.modules.dbmodel.nodes.DefaultDBFactory")) : class$com$sun$forte4j$modules$dbmodel$nodes$DefaultDBFactory), (String)"Tables"));
        }

        private ElementCategoryNode(int index, TableChildren children) {
            super((Children)children);
            this.setDisplayName(NAMES[index]);
            this.systemActions = CATEGORY_ACTIONS;
            TableElementFilter filter = new TableElementFilter();
            filter.setOrder(FILTERS[index]);
            children.setFilter(filter);
            this.setIconBase(CATEGORY_ICONS[index]);
        }

        private ElementCategoryNode(int index, SchemaChildren children) {
            super((Children)children);
            this.setDisplayName(NAMES[index]);
            this.systemActions = CATEGORY_ACTIONS;
            this.setIconBase(CATEGORY_ICONS[index]);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("dbschema_ctxhelp_wizard");
        }
    }
}

