/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard;

import com.sun.forte4j.modules.dbmodel.jdbcimpl.ConnectionProvider;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.DDLBridge;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard.DBSchemaWizardData;
import com.sun.forte4j.modules.dbmodel.jdbcimpl.wizard.SortedListModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.DatabaseException;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.dlg.ConnectPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class DBSchemaTablesPanel
extends JPanel
implements ListDataListener {
    private final ResourceBundle bundle = NbBundle.getBundle((String)"com.sun.forte4j.modules.dbmodel.jdbcimpl.resources.Bundle");
    private final ResourceBundle bundleDB = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
    private LinkedList tables;
    private LinkedList views;
    private ConnectionProvider cp;
    private String schema;
    private ConnectionNodeInfo cniOld;
    private ConnectionDialog dlg = null;
    private DBSchemaWizardData data;
    private int tablesCount;
    private ArrayList list;
    private JScrollPane jScrollPaneSelectedTables;
    private JLabel jLabelNote;
    private JButton jButtonAddAll;
    private JList jListSelectedTables;
    private JButton jButtonAdd;
    private JPanel jPanelButtons;
    private JButton jButtonRemoveAll;
    private JLabel jLabelSelectedTables;
    private JList jListAvailableTables;
    private JButton jButtonRemove;
    private JScrollPane jScrollPaneAvailableTables;
    private JLabel jLabelAvailableTables;

    public DBSchemaTablesPanel(DBSchemaWizardData data, ArrayList list) {
        this.list = list;
        this.data = data;
        this.tables = new LinkedList();
        this.views = new LinkedList();
        this.cp = null;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
        this.setName(this.bundle.getString("TablesChooser"));
        this.initComponents();
        this.initAccessibility();
        this.jLabelAvailableTables.setDisplayedMnemonic(this.bundle.getString("AvailableTables_Mnemonic").charAt(0));
        this.jLabelSelectedTables.setDisplayedMnemonic(this.bundle.getString("SelectedTables_Mnemonic").charAt(0));
        this.jButtonAdd.setMnemonic(this.bundle.getString("AddButton_Mnemonic").charAt(0));
        this.jButtonRemove.setMnemonic(this.bundle.getString("RemoveButton_Mnemonic").charAt(0));
        this.jButtonAddAll.setMnemonic(this.bundle.getString("AddAllButton_Mnemonic").charAt(0));
        this.jButtonRemoveAll.setMnemonic(this.bundle.getString("RemoveAllButton_Mnemonic").charAt(0));
        this.jListAvailableTables.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBSchemaTablesPanel.this.jListAvailableTables.requestFocus();
            }
        }, KeyStroke.getKeyStroke(84, 8), 2);
        this.jListSelectedTables.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBSchemaTablesPanel.this.jListSelectedTables.requestFocus();
            }
        }, KeyStroke.getKeyStroke(83, 8), 2);
        this.jListSelectedTables.getModel().addListDataListener(this);
        this.jListAvailableTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DBSchemaTablesPanel.this.jButtonAdd.setEnabled(DBSchemaTablesPanel.this.jListAvailableTables.getSelectedIndex() != -1);
            }
        });
        this.jListSelectedTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DBSchemaTablesPanel.this.jButtonRemove.setEnabled(DBSchemaTablesPanel.this.jListSelectedTables.getSelectedIndex() != -1);
            }
        });
    }

    protected boolean init() {
        String driver = null;
        Connection conn = null;
        boolean init = true;
        if (this.data.getConnectionProvider() != null) {
            if (this.data.getConnectionNodeInfo() == this.cniOld) {
                init = false;
            }
            if (init) {
                this.cp = this.data.getConnectionProvider();
                this.uninit();
            }
        }
        if (init) {
            int i;
            this.data.setConnected(false);
            if (this.data.isExistingConn()) {
                final ConnectionNodeInfo cni = this.data.getConnectionNodeInfo();
                conn = cni.getConnection();
                if (conn != null) {
                    try {
                        conn.getCatalog();
                    }
                    catch (SQLException exc) {
                        conn = null;
                    }
                }
                if (conn == null) {
                    boolean remember;
                    String username = cni.getUser();
                    String password = cni.getPassword();
                    Boolean rpwd = (Boolean)cni.get((Object)"rememberpwd");
                    boolean bl = remember = rpwd != null ? rpwd : false;
                    if (username == null || password == null || !remember) {
                        final ConnectPanel basePanel = new ConnectPanel((DatabaseConnection)cni.getDatabaseConnection());
                        final SchemaPanel schemaPanel = new SchemaPanel((DatabaseConnection)cni.getDatabaseConnection());
                        ActionListener actionListener = new ActionListener(){

                            public void actionPerformed(ActionEvent event) {
                                if (event.getSource() == DialogDescriptor.OK_OPTION) {
                                    DBSchemaTablesPanel.this.dlg.setException(null);
                                    cni.setUser(basePanel.getUser());
                                    cni.setPassword(basePanel.getPassword());
                                    if (basePanel.rememberPassword()) {
                                        cni.put((Object)"rememberpwd", (Object)new Boolean(true));
                                    }
                                    try {
                                        if (schemaPanel.getSchema() == null) {
                                            DBSchemaTablesPanel.this.dlg.setSelectedComponent((JPanel)schemaPanel);
                                        }
                                        if (DBSchemaTablesPanel.this.dlg.isException()) {
                                            return;
                                        }
                                        cni.setSchema(schemaPanel.getSchema());
                                        cni.connect();
                                        if (DBSchemaTablesPanel.this.dlg != null) {
                                            DBSchemaTablesPanel.this.dlg.close();
                                        }
                                    }
                                    catch (DatabaseException exc) {
                                        String msg = exc.getMessage();
                                        String message = DBSchemaTablesPanel.this.bundleDB.getString("EXC_PointbaseServerRejected");
                                        message = msg.substring(msg.length() - 30).equalsIgnoreCase(message.substring(message.length() - 30)) ? MessageFormat.format(DBSchemaTablesPanel.this.bundleDB.getString("ERR_UnableToConnect"), msg) : (msg == null ? DBSchemaTablesPanel.this.bundleDB.getString("EXC_UnableToConnectNoReason") : MessageFormat.format(DBSchemaTablesPanel.this.bundleDB.getString("EXC_UnableToConnectReason"), msg));
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                                        StatusDisplayer.getDefault().setStatusText("");
                                    }
                                }
                            }
                        };
                        ChangeListener changeTabListener = new ChangeListener(){

                            public void stateChanged(ChangeEvent e) {
                                block8: {
                                    if (((JTabbedPane)e.getSource()).getSelectedComponent().equals(schemaPanel)) {
                                        cni.setUser(basePanel.getUser());
                                        cni.setPassword(basePanel.getPassword());
                                        DBConnection con = cni.getDatabaseConnection();
                                        try {
                                            Connection connection = con.createJDBCConnection();
                                            if (connection == null) break block8;
                                            Vector<String> items = new Vector<String>();
                                            try {
                                                ResultSet rs = connection.getMetaData().getSchemas();
                                                while (rs.next()) {
                                                    items.add(rs.getString(1).trim());
                                                }
                                                rs.close();
                                                connection.close();
                                            }
                                            catch (SQLException exc) {
                                                // empty catch block
                                            }
                                            schemaPanel.setSchemas(items, cni.getSchema());
                                        }
                                        catch (DDLException exc) {
                                            String message = MessageFormat.format(DBSchemaTablesPanel.this.bundleDB.getString("ERR_UnableObtainSchemas"), exc.getMessage());
                                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                                            DBSchemaTablesPanel.this.dlg.setSelectedComponent((JPanel)basePanel);
                                            DBSchemaTablesPanel.this.dlg.setException((Exception)((Object)new DatabaseException("Unable to obtain schema. " + exc.getMessage())));
                                        }
                                    } else if (schemaPanel.getSchema() != null) {
                                        cni.setSchema(schemaPanel.getSchema());
                                    }
                                }
                            }
                        };
                        this.dlg = new ConnectionDialog((JPanel)basePanel, (JPanel)schemaPanel, basePanel.getTitle(), actionListener, changeTabListener);
                        this.dlg.setVisible(true);
                    } else {
                        StatusDisplayer.getDefault().setStatusText(this.bundle.getString("ConnectingToDatabase"));
                        try {
                            cni.connect();
                        }
                        catch (DatabaseException exc) {
                            String msg = exc.getMessage();
                            String message = this.bundleDB.getString("EXC_PointbaseServerRejected");
                            message = msg.substring(msg.length() - 30).equalsIgnoreCase(message.substring(message.length() - 30)) ? MessageFormat.format(this.bundleDB.getString("ERR_UnableToConnect"), msg) : (msg == null ? this.bundleDB.getString("EXC_UnableToConnectNoReason") : MessageFormat.format(this.bundleDB.getString("EXC_UnableToConnectReason"), msg));
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                            StatusDisplayer.getDefault().setStatusText("");
                            return false;
                        }
                    }
                    conn = cni.getConnection();
                    if (conn != null) {
                        try {
                            conn.getCatalog();
                        }
                        catch (SQLException exc) {
                            ErrorManager.getDefault().notify(1, (Throwable)exc);
                            try {
                                conn.close();
                            }
                            catch (SQLException ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                            conn = null;
                            this.data.setConnected(false);
                            return false;
                        }
                    }
                    this.data.setConnected(true);
                }
                this.schema = cni.getSchema();
                driver = cni.getDriver();
                this.cniOld = cni;
            }
            if (conn == null) {
                return false;
            }
            try {
                this.cp = new ConnectionProvider(conn, driver);
                this.cp.setSchema(this.schema);
                conn.getCatalog();
            }
            catch (SQLException exc) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                conn = null;
                ErrorManager.getDefault().notify(1, (Throwable)exc);
                return false;
            }
            this.data.setConnectionProvider(this.cp);
            this.tables.clear();
            this.views.clear();
            try {
                DDLBridge bridge = new DDLBridge(this.cp.getConnection(), this.cp.getSchema(), this.cp.getDatabaseMetaData());
                bridge.getDriverSpecification().getTables("%", new String[]{"TABLE"});
                ResultSet rs = bridge.getDriverSpecification().getResultSet();
                if (rs != null) {
                    while (rs.next()) {
                        this.tables.add(rs.getString("TABLE_NAME").trim());
                    }
                    rs.close();
                }
                rs = null;
                if (bridge.getDriverSpecification().areViewsSupported()) {
                    bridge.getDriverSpecification().getTables("%", new String[]{"VIEW"});
                    rs = bridge.getDriverSpecification().getResultSet();
                }
                if (rs != null) {
                    while (rs.next()) {
                        this.views.add(rs.getString("TABLE_NAME").trim());
                    }
                    rs.close();
                }
            }
            catch (SQLException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            ((SortedListModel)this.jListAvailableTables.getModel()).clear();
            ((SortedListModel)this.jListSelectedTables.getModel()).clear();
            this.tablesCount = this.tables.size();
            for (i = 0; i < this.tables.size(); ++i) {
                ((SortedListModel)this.jListAvailableTables.getModel()).add(this.bundle.getString("TablePrefix") + " " + this.tables.get(i).toString());
            }
            for (i = 0; i < this.views.size(); ++i) {
                ((SortedListModel)this.jListAvailableTables.getModel()).add(this.bundle.getString("ViewPrefix") + " " + this.views.get(i).toString());
            }
            if (this.jListAvailableTables.getModel().getSize() > 0) {
                this.jListAvailableTables.setSelectedIndex(0);
            }
            this.tables.clear();
            this.views.clear();
        }
        this.updateButtons();
        return true;
    }

    public void uninit() {
        try {
            if (this.cp != null && this.data.isConnected()) {
                if (this.data.isExistingConn()) {
                    this.cniOld.disconnect();
                } else if (this.cniOld.getConnection() != null) {
                    this.cniOld.disconnect();
                } else {
                    this.cp.closeConnection();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_TablesPanelA11yDesc"));
        this.jLabelAvailableTables.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_AvailableTablesA11yDesc"));
        this.jListAvailableTables.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_AvailableTablesListA11yName"));
        this.jLabelSelectedTables.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_SelectedTablesA11yDesc"));
        this.jListSelectedTables.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_SelectedTablesListA11yName"));
        this.jLabelNote.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_FKReferenceNoteA11yDesc"));
    }

    private void initComponents() {
        this.jLabelAvailableTables = new JLabel();
        this.jScrollPaneAvailableTables = new JScrollPane();
        this.jListAvailableTables = new JList();
        this.jPanelButtons = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonRemoveAll = new JButton();
        this.jLabelSelectedTables = new JLabel();
        this.jScrollPaneSelectedTables = new JScrollPane();
        this.jListSelectedTables = new JList();
        this.jLabelNote = new JLabel();
        this.setLayout(new GridBagLayout());
        this.jLabelAvailableTables.setText(this.bundle.getString("AvailableTables"));
        this.jLabelAvailableTables.setLabelFor(this.jListAvailableTables);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabelAvailableTables, gridBagConstraints);
        this.jListAvailableTables.setToolTipText(this.bundle.getString("ACS_AvailableTablesListA11yDesc"));
        this.jListAvailableTables.setModel(new SortedListModel());
        this.jScrollPaneAvailableTables.setViewportView(this.jListAvailableTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.jScrollPaneAvailableTables, gridBagConstraints);
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jButtonAdd.setToolTipText(this.bundle.getString("ACS_AddButtonA11yDesc"));
        this.jButtonAdd.setText(this.bundle.getString("AddButton"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DBSchemaTablesPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanelButtons.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonRemove.setToolTipText(this.bundle.getString("ACS_RemoveButtonA11yDesc"));
        this.jButtonRemove.setText(this.bundle.getString("RemoveButton"));
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DBSchemaTablesPanel.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonRemove, gridBagConstraints);
        this.jButtonAddAll.setToolTipText(this.bundle.getString("ACS_AddAllButtonA11yDesc"));
        this.jButtonAddAll.setText(this.bundle.getString("AddAllButton"));
        this.jButtonAddAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DBSchemaTablesPanel.this.jButtonAddAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonAddAll, gridBagConstraints);
        this.jButtonRemoveAll.setToolTipText(this.bundle.getString("ACS_RemoveAllButtonA11yDesc"));
        this.jButtonRemoveAll.setText(this.bundle.getString("RemoveAllButton"));
        this.jButtonRemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DBSchemaTablesPanel.this.jButtonRemoveAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonRemoveAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(12, 11, 0, 11);
        this.add((Component)this.jPanelButtons, gridBagConstraints);
        this.jLabelSelectedTables.setText(this.bundle.getString("SelectedTables"));
        this.jLabelSelectedTables.setLabelFor(this.jListSelectedTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.add((Component)this.jLabelSelectedTables, gridBagConstraints);
        this.jListSelectedTables.setToolTipText(this.bundle.getString("ACS_SelectedTablesListA11yDesc"));
        this.jListSelectedTables.setModel(new SortedListModel());
        this.jScrollPaneSelectedTables.setViewportView(this.jListSelectedTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.jScrollPaneSelectedTables, gridBagConstraints);
        this.jLabelNote.setText(this.bundle.getString("FKReferenceNote"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.jLabelNote, gridBagConstraints);
    }

    private void jButtonRemoveAllActionPerformed(ActionEvent evt) {
        SortedListModel ulm = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel slm = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] values = slm.toArray();
        for (int i = 0; i < values.length; ++i) {
            ulm.add(values[i]);
            slm.remove(values[i]);
        }
        this.tables.clear();
        this.views.clear();
        int[] sel = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            sel[i] = ulm.indexOf(values[i]);
        }
        this.jListAvailableTables.setSelectedIndices(sel);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonAddAllActionPerformed(ActionEvent evt) {
        SortedListModel ulm = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel slm = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] values = ulm.toArray();
        for (int i = 0; i < values.length; ++i) {
            slm.add(values[i]);
            ulm.remove(values[i]);
            String name = values[i].toString();
            if (name.startsWith(this.bundle.getString("TablePrefix"))) {
                this.tables.add(name.substring(name.indexOf(" ") + 1));
                continue;
            }
            this.views.add(name.substring(name.indexOf(" ") + 1));
        }
        int[] sel = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            sel[i] = slm.indexOf(values[i]);
        }
        this.jListSelectedTables.setSelectedIndices(sel);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        SortedListModel ulm = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel slm = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] values = this.jListSelectedTables.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            ulm.add(values[i]);
            slm.remove(values[i]);
            String name = values[i].toString();
            name = name.substring(name.indexOf(" ")).trim();
            if (this.tables.contains(name)) {
                this.tables.remove(name);
                continue;
            }
            this.views.remove(name);
        }
        int[] sel = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            sel[i] = ulm.indexOf(values[i]);
        }
        this.jListAvailableTables.setSelectedIndices(sel);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        SortedListModel ulm = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel slm = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] values = this.jListAvailableTables.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            slm.add(values[i]);
            ulm.remove(values[i]);
            String name = values[i].toString();
            if (name.startsWith(this.bundle.getString("TablePrefix"))) {
                this.tables.add(name.substring(name.indexOf(" ") + 1));
                continue;
            }
            this.views.add(name.substring(name.indexOf(" ") + 1));
        }
        int[] sel = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            sel[i] = slm.indexOf(values[i]);
        }
        this.jListSelectedTables.setSelectedIndices(sel);
        this.setSelection();
        this.updateButtons();
    }

    private void setSelection() {
        this.data.setTables(this.tables);
        this.data.setViews(this.views);
        if (this.tablesCount == this.tables.size()) {
            this.data.setAllTables(true);
        } else {
            this.data.setAllTables(false);
        }
    }

    private void updateButtons() {
        this.jButtonAdd.setEnabled(this.jListAvailableTables.getSelectedIndex() != -1);
        this.jButtonAddAll.setEnabled(!((SortedListModel)this.jListAvailableTables.getModel()).isEmpty());
        this.jButtonRemove.setEnabled(this.jListSelectedTables.getSelectedIndex() != -1);
        this.jButtonRemoveAll.setEnabled(!((SortedListModel)this.jListSelectedTables.getModel()).isEmpty());
    }

    public boolean isValid() {
        return this.jListSelectedTables.getModel().getSize() > 0;
    }

    public void intervalAdded(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void intervalRemoved(ListDataEvent p1) {
        this.fireChange(this);
    }

    public void contentsChanged(ListDataEvent p1) {
        this.fireChange(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(Object source) {
        ArrayList lst;
        DBSchemaTablesPanel dBSchemaTablesPanel = this;
        synchronized (dBSchemaTablesPanel) {
            lst = (ArrayList)this.list.clone();
        }
        ChangeEvent event = new ChangeEvent(source);
        for (int i = 0; i < lst.size(); ++i) {
            ChangeListener listener = (ChangeListener)lst.get(i);
            listener.stateChanged(event);
        }
    }
}

