/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.guiframework.view.ViewXMLEntityResolver;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TreeReader {
    private static final String OUTPUT_ENCODING = "UTF-8";
    private Document doc;
    private static HashMap nodeClasses = new HashMap();

    public TreeReader(InputStream is, String dtdURLBase) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        dbf.setIgnoringComments(false);
        dbf.setIgnoringElementContentWhitespace(false);
        dbf.setCoalescing(false);
        dbf.setExpandEntityReferences(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver((EntityResolver)new ViewXMLEntityResolver());
        OutputStreamWriter errorWriter = new OutputStreamWriter((OutputStream)System.err, OUTPUT_ENCODING);
        db.setErrorHandler(new MyErrorHandler(new PrintWriter((Writer)errorWriter, true)));
        this.doc = db.parse(is, dtdURLBase);
    }

    public static boolean process(Node n, IndexTreeModel treeModel, IndexTreeNode parent) {
        boolean hasChildren = false;
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName = child.getNodeName();
            if (nodeName.equalsIgnoreCase("Node")) {
                IndexTreeNode treeNode = TreeReader.addToTree((Element)child, treeModel, parent);
                TreeReader.process(child, treeModel, treeNode);
                hasChildren = true;
                continue;
            }
            if (nodeName.equalsIgnoreCase("DynamicNode")) {
                parent.setDynamicChild((Element)child);
                hasChildren = true;
                continue;
            }
            if (!nodeName.equalsIgnoreCase("TreeNodeType")) continue;
            TreeReader.process((Element)child);
        }
        return hasChildren;
    }

    private static void process(Element treeNodeType) {
        String name = treeNodeType.getAttribute("name");
        String clazz = treeNodeType.getAttribute("treeNodeClass");
        nodeClasses.put(name, clazz);
    }

    public static String getClass(String nodeClassType) {
        return (String)nodeClasses.get(nodeClassType);
    }

    private static IndexTreeNode addToTree(Element node, IndexTreeModel treeModel, IndexTreeNode parent) {
        String nodeType;
        String name;
        block7: {
            block6: {
                block5: {
                    int i;
                    name = node.getAttribute("name");
                    if (name.startsWith("$") && (i = name.indexOf(35)) > 0) {
                        String mbeanName = name.substring(1, i);
                        String attrName = name.substring(i + 1, name.length());
                        name = (String)MBeanUtil.getAttribute(mbeanName, attrName);
                    }
                    if ((nodeType = node.getAttribute("type")) == null) {
                        nodeType = "container";
                    }
                    if (parent != null) break block5;
                    if (!nodeType.equalsIgnoreCase("root")) break block6;
                }
                if (parent == null) break block7;
                if (!nodeType.equalsIgnoreCase("root")) break block7;
            }
            throw new RuntimeException("The first node declared must be of type \"root\" and\nthere can be only one root node.");
        }
        IndexTreeNode treeNode = IndexTreeNode.createNode(node, parent, nodeType, name, treeModel);
        return treeNode;
    }

    public void populate(IndexTreeModel treeModel) throws Exception {
        for (Node child = this.doc.getFirstChild(); child != null; child = child.getNextSibling()) {
            String nodeName = child.getNodeName();
            if (!nodeName.equalsIgnoreCase("Tree")) continue;
            TreeReader.process(child, treeModel, null);
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintWriter out;

        MyErrorHandler(PrintWriter out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
            return info;
        }

        public void warning(SAXParseException spe) throws SAXException {
            this.out.println("Warning: " + this.getParseExceptionInfo(spe));
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

