/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.iplanet.jato.RequestContext;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.view.descriptors.BasicTree;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import java.util.ArrayList;
import javax.naming.NameClassPair;

public class MBeanTreeImpl
implements BasicTree {
    private static final String CLASS_WITH_CHILDREN = "com.sun.enterprise.naming.TransientContext";
    private String hrefURL = "";
    private String objectName = "";
    private String methodName = "";
    private String instanceName = "";

    public void init(ViewDescriptor viewDescriptor, RequestContext ctx) {
        this.objectName = (String)viewDescriptor.getParameter("objectName");
        this.methodName = (String)viewDescriptor.getParameter("methodName");
        this.hrefURL = (String)viewDescriptor.getParameter("hrefURL");
        this.instanceName = (String)viewDescriptor.getParameter("instanceName");
        if (this.instanceName == null || "".equals(this.instanceName)) {
            this.instanceName = (String)ctx.getRequest().getSession().getAttribute("INSTANCE_NAME");
            this.objectName = this.objectName + this.instanceName;
            this.hrefURL = this.hrefURL + this.instanceName;
        } else {
            ctx.getRequest().getSession().setAttribute("INSTANCE_NAME", (Object)this.instanceName);
        }
    }

    public ArrayList getChildren(Object parent) {
        ArrayList<NameClassPair> transformed;
        block4: {
            if (!this.hasChildren(parent)) {
                return new ArrayList();
            }
            NameClassPair ncp = (NameClassPair)parent;
            String context = ncp.getName();
            transformed = new ArrayList<NameClassPair>();
            try {
                ArrayList result = (ArrayList)MBeanUtil.invoke(this.objectName, this.methodName, (Object[])new String[]{context}, new String[]{"java.lang.String"});
                for (int i = 0; i < result.size(); ++i) {
                    NameClassPair pair = (NameClassPair)result.get(i);
                    String nm = pair.getName();
                    String prepend = context.equals("") ? "" : context + "/";
                    pair.setName(prepend + pair.getName());
                    transformed.add(pair);
                }
            }
            catch (Exception ex) {
                if (!Util.isLoggableINFO()) break block4;
                Util.logINFO("ERROR in MBeanTreeImpl.getChildren()", ex);
            }
        }
        return transformed;
    }

    public Object getRoot() {
        return new NameClassPair("", "");
    }

    public boolean hasChildren(Object node) {
        NameClassPair ncp = (NameClassPair)node;
        String nm = ncp.getName();
        if (nm.equals("")) {
            return true;
        }
        return ncp.getClassName().equals(CLASS_WITH_CHILDREN);
    }

    public String getDisplayName(Object node) {
        String fullName = ((NameClassPair)node).getName();
        String ret = "Jndi Entries Root ( " + this.instanceName + " )";
        if (!fullName.equals("")) {
            int lastIndex = fullName.lastIndexOf(47) + 1;
            ret = fullName.substring(lastIndex);
        }
        return ret;
    }

    public String getKey(Object node) {
        if (node == null) {
            return "&nodeName=&nodeClass=";
        }
        NameClassPair ncp = (NameClassPair)node;
        return "&nodeName=" + ncp.getName() + "&nodeClass=" + ncp.getClassName();
    }

    public String getURL() {
        return this.hrefURL;
    }
}

