/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.servlet;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.tools.admingui.servlet.MultipartHandler;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UploadServlet
extends HttpServlet {
    private static final String CFG_MAX_UPLOAD_SIZE = "maxUploadSize";
    private static final int MAX_UPLOAD_SIZE = 0xA00000;
    int maxUploadSize = 0xA00000;
    ServletContext ctxt = null;
    String mesg = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.ctxt = this.getServletContext();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html; charset=UTF-8");
        PrintWriter out = res.getWriter();
        String contentType = req.getContentType();
        String dispatchRequest = "../admingui/upload";
        String tempDir = AdminService.getAdminService().getGUITempDirPath();
        String cancelPage = req.getParameter("cancelPage");
        if (contentType.toLowerCase().startsWith("multipart/form-data")) {
            if (tempDir == null && Util.isLoggableCONFIG()) {
                Util.logCONFIG("UploadServlet.doPost: tempDir is null");
            }
            MultipartHandler multiReq = null;
            if (tempDir == null) {
                if (Util.isLoggableWARNING()) {
                    Util.logWARNING("Error uploading file for deployment. Temporary directory is null. ");
                }
                req.setAttribute("ALERT_TYPE", (Object)"error");
                req.setAttribute("ALERT_SUMMARY", (Object)Util.getMessage("upload.nullTempDir"));
                req.setAttribute("MBEAN_MESSAGE", (Object)"");
                req.setAttribute("HAS_MBEAN_MESSAGE", (Object)"true");
                req.setAttribute("HAS_ERROR_MESSAGE", (Object)"true");
                if (cancelPage != null && !cancelPage.equals("")) {
                    req.setAttribute("cancelPage", (Object)cancelPage);
                }
            } else {
                multiReq = new MultipartHandler(req, tempDir, this.maxUploadSize);
                multiReq.parseMultipartUpload();
                Enumeration fileEnum = multiReq.getFileNames();
                String name = (String)fileEnum.nextElement();
                File appFile = multiReq.getFile(name);
                String listPage = multiReq.getParameter("upload.listPage");
                String filePath = appFile.getAbsolutePath();
                String fileName = this.getFileName(filePath);
                req.setAttribute("filePath", (Object)filePath);
                req.setAttribute("fileName", (Object)this.getFileName(filePath));
                req.setAttribute("uploadedFileName", (Object)appFile.getName());
                req.setAttribute("ctxtRoot", (Object)("/" + fileName));
                if (cancelPage != null && !cancelPage.equals("")) {
                    req.setAttribute("cancelPage", (Object)cancelPage);
                }
                if (listPage != null && !listPage.equals("")) {
                    req.setAttribute("listPage", (Object)listPage);
                }
                if (FileUtil.isWARFile((File)appFile)) {
                    dispatchRequest = "../admingui/deployWebModule";
                } else if (FileUtil.isEARFile((File)appFile)) {
                    dispatchRequest = "../admingui/deployJ2EEApplication";
                } else if (FileUtil.isEJBJar((File)appFile)) {
                    dispatchRequest = "../admingui/deployEJBJarModule";
                } else if (FileUtil.isRARFile((File)appFile)) {
                    dispatchRequest = "../admingui/deployConnectorModule";
                } else if (FileUtil.isAppClientJar((File)appFile)) {
                    dispatchRequest = "../admingui/deployAppclientModule";
                } else if (fileName != null) {
                    String fileType = null;
                    String mesg = "";
                    int extensionIndex = filePath.lastIndexOf(46);
                    if (extensionIndex >= 0 && extensionIndex < filePath.length()) {
                        fileType = filePath.substring(extensionIndex + 1, filePath.length());
                        mesg = this.getLocalizedMessage(fileType, req);
                    }
                    req.setAttribute("AppType", fileType);
                    req.setAttribute("ALERT_TYPE", (Object)"error");
                    req.setAttribute("ALERT_SUMMARY", (Object)mesg);
                    req.setAttribute("MBEAN_MESSAGE", (Object)"");
                    req.setAttribute("HAS_MBEAN_MESSAGE", (Object)"true");
                    req.setAttribute("HAS_ERROR_MESSAGE", (Object)"true");
                }
            }
        }
        try {
            req.getRequestDispatcher(dispatchRequest).forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (Exception e) {
            this.ctxt.log(e.getMessage() + " " + e.getClass());
        }
    }

    private String getFileName(String filePath) {
        String name = new File(filePath).getName();
        int index = name.indexOf(".");
        if (index > 0) {
            return name.substring(0, index);
        }
        return filePath;
    }

    private String getLocalizedMessage(String fileType, HttpServletRequest req) {
        Object[] args = new Object[2];
        String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
        String key = "upload.ErrorMessage";
        args[0] = fileType;
        args[1] = fileType.equals("war") ? "web.xml" : (fileType.equals("ear") ? "application.xml" : (fileType.equals("jar") ? "ejb-jar.xml" : "ra.xml"));
        String mesg = Util.getMessage(bundle, key, args, req.getLocale());
        return mesg;
    }
}

