/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.sun.enterprise.admin.servermgmt.RuntimeStatus;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.tools.admingui.ConfigProperties;
import com.sun.enterprise.tools.admingui.handlers.TargetHandlers;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;
import com.sun.web.ui.view.html.CCButton;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.servlet.http.HttpServletRequest;

public class TableHandlers {
    public static final String MODEL = "model";

    public void executeMethod(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        String childName = (String)handlerCtx.getInputValue("tableChildName");
        if (childName == null) {
            throw new FrameworkException("executeMethod: childName not specified", vd, view);
        }
        ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
        if (tableDescriptor == null) {
            throw new FrameworkException("executeMethod: tableDescriptor is null", vd, view);
        }
        if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("executeMethod: tableDescriptor is of wrong type", tableDescriptor, view);
        }
        CCActionTableModelInterface model = ((CCActionTableDescriptor)tableDescriptor).getModel();
        String method = (String)handlerCtx.getInputValue("method");
        if (method == null) {
            throw new FrameworkException("executeMethod: method name is null", vd, view);
        }
        model.setRowSelectionType("multiple");
        String objectName = null;
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected() || (objectName = (String)model.getValue("objectName")) == null) continue;
                MBeanUtil.invoke(objectName, method, null, null);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while invoking '" + method + "' on " + objectName, (Throwable)ex, tableDescriptor, view);
        }
        ContainerViewBase containerView = (ContainerViewBase)tableDescriptor.getView(ctx).getParent();
        containerView.removeChild(tableDescriptor.getName());
        ((DefaultModel)model).clear();
    }

    public void deleteHandler(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        String childName = (String)handlerCtx.getInputValue("tableChildName");
        if (childName == null) {
            throw new FrameworkException("deleteHandler: childName not specified", vd, view);
        }
        ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
        if (tableDescriptor == null) {
            throw new FrameworkException("deleteHandler: tableDescriptor is null", vd, view);
        }
        if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("deleteHandler: tableDescriptor is of wrong type", tableDescriptor, view);
        }
        CCActionTableModelInterface model = ((CCActionTableDescriptor)tableDescriptor).getModel();
        String deleteKey = (String)handlerCtx.getInputValue("deleteKey");
        String deleteMethodName = (String)handlerCtx.getInputValue("deleteMethodName");
        String objectName = (String)handlerCtx.getInputValue("rowObjectName");
        String cascade = (String)handlerCtx.getInputValue("deleteWithCascade");
        String deleteTarget = (String)handlerCtx.getInputValue("deleteTarget");
        Boolean isResource = (Boolean)handlerCtx.getInputValue("isResource");
        Boolean isLifecycleModule = (Boolean)handlerCtx.getInputValue("isLifecycleModule");
        String getObjectMethodName = null;
        if (objectName == null) {
            throw new FrameworkException("No ObjectName  specified", tableDescriptor, view);
        }
        if (deleteKey == null) {
            throw new FrameworkException("No delete key specified", tableDescriptor, view);
        }
        if (deleteMethodName == null && (getObjectMethodName = (String)handlerCtx.getInputValue("getObjectMethodName")) == null) {
            throw new FrameworkException("deleteMethodName or getObjectMethodName must be specified", tableDescriptor, view);
        }
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                if (deleteMethodName != null) {
                    this.deleteTableRow(model.getValue(deleteKey), objectName, deleteMethodName, cascade, deleteTarget, isResource, isLifecycleModule);
                } else {
                    this.deleteTableRowUsingDestroy(model.getValue(deleteKey), objectName, getObjectMethodName);
                }
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while deleting from: '" + tableDescriptor.getName() + "'", (Throwable)ex, tableDescriptor, view);
        }
        ContainerViewBase containerView = (ContainerViewBase)tableDescriptor.getView(ctx).getParent();
        containerView.removeChild(tableDescriptor.getName());
        ((DefaultModel)model).clear();
    }

    private void deleteTableRow(Object key, String objectName, String methodName, String cascade, String target, Boolean isResource, Boolean isLifecycleModule) throws Exception {
        Object[] params = null;
        String[] types = null;
        String defaultTarget = target;
        if (isResource != null && isResource.booleanValue()) {
            this.deleteResourceReferences(key.toString());
            defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
        }
        if (isLifecycleModule != null && isLifecycleModule.booleanValue()) {
            this.deleteLifecycleReferences(key.toString());
            defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
        }
        if (cascade != null && cascade.equals("true")) {
            if (defaultTarget == null) {
                params = new Object[]{key, new Boolean(true)};
                types = new String[]{"java.lang.String", "java.lang.Boolean"};
            } else {
                params = new Object[]{key, new Boolean(true), defaultTarget};
                types = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String"};
            }
        } else if (defaultTarget == null) {
            params = new Object[]{key};
            types = new String[]{"java.lang.String"};
        } else {
            params = new Object[]{key, defaultTarget};
            types = new String[]{"java.lang.String", "java.lang.String"};
        }
        MBeanUtil.invoke(objectName, methodName, params, types);
    }

    private void deleteResourceReferences(String resourceName) throws Exception {
        if (!ConfigProperties.getInstance().getTargetSupported().booleanValue()) {
            return;
        }
        Object[] param = new Object[]{resourceName};
        String[] type = new String[]{"java.lang.String"};
        ObjectName[] references = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", "listReferencees", param, type);
        for (int i = 0; i < references.length; ++i) {
            String targetName = (String)MBeanUtil.getAttribute(references[i], "name");
            MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", "deleteResourceReference", new Object[]{targetName, resourceName}, new String[]{"java.lang.String", "java.lang.String"});
        }
    }

    private void deleteLifecycleReferences(String lifecycleName) throws Exception {
        if (!ConfigProperties.getInstance().getTargetSupported().booleanValue()) {
            return;
        }
        Object[] param = new Object[]{lifecycleName};
        String[] type = new String[]{"java.lang.String"};
        ObjectName[] references = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "listReferencees", param, type);
        for (int i = 0; i < references.length; ++i) {
            String targetName = (String)MBeanUtil.getAttribute(references[i], "name");
            MBeanUtil.invoke("com.sun.appserv:type=applications,category=config", "removeLifecycleModuleReference", new Object[]{lifecycleName, targetName}, new String[]{"java.lang.String", "java.lang.String"});
        }
    }

    public void deletePersistenceManager(RequestContext ctx, HandlerContext handlerCtx) {
        String childName;
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName = (String)handlerCtx.getInputValue("tableChildName"));
        if (tableDescriptor == null) {
            throw new FrameworkException("deletePersistenceManger: tableDescriptor is null", vd, view);
        }
        if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("deletePersistenceManger: tableDescriptor is of wrong type", tableDescriptor, view);
        }
        CCActionTableModelInterface model = ((CCActionTableDescriptor)tableDescriptor).getModel();
        String deleteKey = (String)handlerCtx.getInputValue("deleteKey");
        if (deleteKey == null) {
            throw new FrameworkException("No delete key specified", tableDescriptor, view);
        }
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!model.isRowSelected()) continue;
                String resourceName = model.getValue(deleteKey).toString();
                this.checkDependency(resourceName);
                this.deleteResourceReferences(resourceName);
                String defaultTarget = ConfigProperties.getInstance().getDefaultTarget();
                Object[] params = new Object[]{resourceName, defaultTarget};
                String[] types = new String[]{"java.lang.String", "java.lang.String"};
                MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", "deletePersistenceManagerFactoryResource", params, types);
                model.setRowSelected(false);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("Error while deleting from: '" + tableDescriptor.getName() + "'", (Throwable)ex, tableDescriptor, view);
        }
        ContainerViewBase containerView = (ContainerViewBase)tableDescriptor.getView(ctx).getParent();
        containerView.removeChild(tableDescriptor.getName());
        ((DefaultModel)model).clear();
    }

    private void checkDependency(String key) {
        ObjectName obj = (ObjectName)MBeanUtil.invoke("com.sun.appserv:type=resources,category=config", "getPersistenceManagerFactoryResourceByJndiName", new Object[]{key}, new String[]{"java.lang.String"});
        String jdbc = (String)MBeanUtil.getAttribute(obj, "jdbc-resource-jndi-name");
        if (!Util.isEmpty(jdbc) && MBeanUtil.isValidMBean("com.sun.appserv:type=jdbc-resource,category=config,jndi-name=" + jdbc)) {
            String err = Util.getMessage("persistenceManagers.deleteError", new Object[]{jdbc, key});
            throw new FrameworkException(err);
        }
    }

    private void deleteTableRowUsingDestroy(Object key, String objectName, String methodName) {
        Object[] params = new Object[]{key};
        String[] types = new String[]{"java.lang.String"};
        ObjectName retObject = (ObjectName)MBeanUtil.invoke(objectName, methodName, params, types);
        MBeanUtil.invoke(retObject, "destroyConfigElement", null, null);
    }

    private Object getName(Object obj) {
        String name;
        if (obj instanceof String && (name = (String)obj).indexOf("category=monitor") >= 0) {
            return MBeanUtil.invoke(name, "getName", null, null);
        }
        return obj;
    }

    private CCActionTableDescriptor getTableDescriptor(HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        View tableView = (View)handlerCtx.getInputValue("tableView");
        if (tableView != null) {
            desc = ((DescriptorContainerView)tableView).getViewDescriptor();
        } else if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else if (view instanceof DescriptorContainerView) {
            desc = ((DescriptorContainerView)view).getViewDescriptor();
        }
        if (desc == null || !(desc instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("Unable to determine CCActionTableDescriptor.  This handler should be invoked from a CCActionTable.", desc, view);
        }
        return (CCActionTableDescriptor)desc;
    }

    public void resetXMLinModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableDescriptor ccDesc = this.getTableDescriptor(handlerCtx);
        ccDesc.resetXML();
    }

    public void loadTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableDescriptor ccDesc = this.getTableDescriptor(handlerCtx);
        CCActionTableModelInterface model = ccDesc.getModel();
        ((DefaultModel)model).clear();
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        Object[] keys = (Object[])handlerCtx.getInputValue("keys");
        if (keys == null) {
            return;
        }
        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        String[] modelNames = null;
        if (modelNamesList != null) {
            modelNames = modelNamesList.toArray(new String[modelNamesList.size()]);
        }
        if (keys instanceof String[] || modelNames == null) {
            for (int rowNo = 0; rowNo < keys.length; ++rowNo) {
                model.appendRow();
                model.setValue((String)displayNamesList.get(0), this.getName(keys[rowNo].toString()));
                model.setValue("objectName", (Object)keys[rowNo].toString());
            }
        } else if (keys instanceof ObjectName[]) {
            ObjectName[] objNames = (ObjectName[])keys;
            if (this.isMixed(modelNames)) {
                this.loadTable(objNames, modelNames, displayNamesList, model);
            } else {
                this.loadTableByGroup(objNames, modelNames, displayNamesList, model);
            }
        }
    }

    private boolean isMixed(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null || names[i].indexOf(64) != 0) continue;
            return true;
        }
        return false;
    }

    private void loadTableByGroup(ObjectName[] objNames, String[] modelNames, ArrayList displayNamesList, CCActionTableModelInterface model) {
        for (int rowNo = 0; rowNo < objNames.length; ++rowNo) {
            AttributeList attrList = MBeanUtil.getAttributes(objNames[rowNo].toString(), modelNames);
            model.appendRow();
            int colNo = 0;
            for (int i = 0; i < attrList.size(); ++i) {
                Attribute attr = (Attribute)attrList.get(i);
                while (colNo < modelNames.length && !attr.getName().equals(modelNames[colNo])) {
                    ++colNo;
                }
                if (colNo >= modelNames.length) continue;
                Object attrValue = attr.getValue();
                if (attrValue != null) {
                    attrValue = attrValue.toString();
                }
                model.setValue((String)displayNamesList.get(colNo), this.getName(attr.getValue()));
            }
            model.setValue("objectName", (Object)objNames[rowNo].toString());
            model.setValue("objectType", (Object)objNames[rowNo].getKeyProperty("type"));
        }
    }

    private void loadTable(ObjectName[] objNames, String[] modelNames, ArrayList displayNamesList, CCActionTableModelInterface model) {
        for (int rowNo = 0; rowNo < objNames.length; ++rowNo) {
            model.appendRow();
            for (int colNo = 0; colNo < modelNames.length; ++colNo) {
                model.setValue((String)displayNamesList.get(colNo), (Object)this.getValue(objNames[rowNo], modelNames[colNo]));
                model.setValue("objectName", (Object)objNames[rowNo].toString());
                model.setValue("objectType", (Object)objNames[rowNo].getKeyProperty("type"));
            }
        }
    }

    private String getValue(ObjectName objName, String attrName) {
        Object value = null;
        if (attrName.indexOf(64) == 0 && attrName.length() > 3) {
            String method = attrName.substring(2, attrName.length() - 1);
            try {
                value = MBeanUtil.invoke(objName, method, null, null);
            }
            catch (Exception ex) {
                if (method.equals("getRuntimeStatus")) {
                    return TargetHandlers.getStatusHtml(value);
                }
                value = ex.getMessage();
            }
        } else {
            value = MBeanUtil.getAttribute(objName, attrName);
        }
        String result = "";
        if (value != null) {
            result = value instanceof RuntimeStatus || value instanceof RuntimeStatusList ? TargetHandlers.getStatusHtml(value) : value.toString();
        }
        return result;
    }

    public void ensureModelRows(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor desc = null;
        if (!(handlerCtx.getEvent() instanceof BeforeCreateEvent)) {
            throw new FrameworkException("ensureModelRows can only be called in BeforeCreate event handler!", desc, handlerCtx.getView());
        }
        String dummyArrayName = "";
        for (desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor(); desc != null; desc = desc.getParent()) {
            if (!dummyArrayName.equals("")) {
                dummyArrayName = "." + dummyArrayName;
            }
            dummyArrayName = desc.getName() + dummyArrayName;
        }
        dummyArrayName = dummyArrayName + ".rowCounter";
        HttpServletRequest req = ctx.getRequest();
        Object[] arr = req.getParameterValues(dummyArrayName);
        if (arr == null) {
            return;
        }
        DefaultModel model = (DefaultModel)handlerCtx.getInputValue(MODEL);
        if (model == null) {
            throw new FrameworkException("Model cannot be null!", desc, handlerCtx.getView());
        }
        int rowsToAdd = arr.length;
        rowsToAdd -= model.getNumRows();
        for (int count = 0; count < rowsToAdd; ++count) {
            model.appendRow();
        }
    }

    public void handleTableMenuAction(RequestContext ctx, HandlerContext handlerCtx) {
        String action = (String)handlerCtx.getInputValue("action");
        ViewDescriptor desc = null;
        View tableView = (View)handlerCtx.getInputValue("tableView");
        if (tableView != null) {
            desc = ((DescriptorContainerView)tableView).getViewDescriptor();
        }
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        CCActionTableModelInterface model = ccDesc.getModel();
        try {
            model.beforeFirst();
            while (model.next()) {
                if (!Util.isLoggableFINER()) continue;
                Util.logFINER("isRowSelected = " + model.isRowSelected());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getTableFilterValue(RequestContext ctx, HandlerContext handlerCtx) {
        String filterValue = (String)handlerCtx.getInputValue("displayFieldValue");
        if (filterValue != null && filterValue.equals("allItemsOption")) {
            filterValue = null;
        }
        handlerCtx.setOutputValue("filterValue", (Object)filterValue);
    }

    public void loadTransactionIds(RequestContext ctx, HandlerContext handlerCtx) {
        View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else if (view instanceof DescriptorContainerView) {
            desc = ((DescriptorContainerView)view).getViewDescriptor();
        }
        if (desc == null || !(desc instanceof CCActionTableDescriptor)) {
            throw new FrameworkException("Unable to determine CCActionTableDescriptor.  This handler should be invoked from a CCActionTable.", desc, view);
        }
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)desc;
        CCActionTableModelInterface model = ccDesc.getModel();
        ArrayList displayName = (ArrayList)handlerCtx.getInputValue("displayNames");
        AttributeList keys = (AttributeList)handlerCtx.getInputValue("keys");
        if (keys == null) {
            return;
        }
        for (int rowNo = 0; rowNo < keys.size(); ++rowNo) {
            Object value = ((Attribute)keys.get(rowNo)).getValue();
            if (value == null || value.toString().length() == 0) continue;
            model.appendRow();
            model.setValue((String)displayName.get(0), value);
        }
    }

    public void setTransactionPageTitle(RequestContext ctx, HandlerContext handlerCtx) {
        Object obj = handlerCtx.getEvent().getSource();
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        AttributeList state = (AttributeList)handlerCtx.getInputValue("state");
        String status = Util.getMessage("common.unknown");
        if (state != null && state.get(0) != null) {
            String value = (String)((Attribute)state.get(0)).getValue();
            status = value.equals("False") ? Util.getMessage("UnFreeze") : Util.getMessage("Freeze");
        }
        String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
        String pageTitle = tag.getPageTitleText();
        String localizedString = Util.getMessage(bundle, pageTitle, new Object[]{status});
        tag.setPageTitleText(localizedString);
    }

    public void setTransactionDisplayFieldValues(RequestContext ctx, HandlerContext handlerCtx) {
        View childView = handlerCtx.getView();
        DescriptorContainerView view = (DescriptorContainerView)((ViewBase)childView).getParentViewBean();
        AttributeList state = (AttributeList)handlerCtx.getInputValue("state");
        String value = (String)((Attribute)state.get(0)).getValue();
        String status = value.equals("False") ? "Freeze" : "UnFreeze";
        DisplayField stateField = view.getDisplayField("Status");
        stateField.setValue((Object)value);
        CCButton button = (CCButton)childView;
        button.setDisplayLabel(status);
    }

    public void setTransactionState(RequestContext ctx, HandlerContext handlerCtx) {
        String objectName = (String)handlerCtx.getInputValue("objectName");
        View childView = handlerCtx.getView();
        DescriptorContainerView view = (DescriptorContainerView)((ViewBase)childView).getParentViewBean();
        String state = (String)view.getDisplayFieldValue("Status");
        String methodName = state.equals("False") ? "freeze" : "unfreeze";
        MBeanUtil.invoke(objectName, methodName, null, null);
    }

    private void deleteCluster(String clusterName) {
        boolean running;
        block9: {
            running = true;
            try {
                RuntimeStatusList status = (RuntimeStatusList)MBeanUtil.invoke("com.sun.appserv:type=clusters,category=config", "getRuntimeStatus", new Object[]{clusterName}, new String[]{"java.lang.String"});
                running = status.anyRunning();
            }
            catch (Exception ex) {
                if (!Util.isLoggableFINE()) break block9;
                Util.logFINE(ex);
            }
        }
        if (running) {
            try {
                MBeanUtil.invoke("com.sun.appserv:type=clusters,category=config", "stopCluster", new Object[]{clusterName}, new String[]{"java.lang.String"});
            }
            catch (Exception ex) {
                throw new FrameworkException((Throwable)ex);
            }
        }
        try {
            ObjectName[] objectNames = (ObjectName[])MBeanUtil.invoke("com.sun.appserv:type=servers,category=config", "listServerInstances", new Object[]{clusterName}, new String[]{"java.lang.String"});
            for (int i = 0; i < objectNames.length; ++i) {
                String instanceName = objectNames[i].getKeyProperty("name");
                String[] modules = (String[])MBeanUtil.invoke("com.sun.appserv:type=servers,category=config", "deleteServerInstance", new Object[]{instanceName}, new String[]{"java.lang.String"});
            }
            MBeanUtil.invoke("com.sun.appserv:type=clusters,category=config", "deleteCluster", new Object[]{clusterName}, new String[]{"java.lang.String"});
        }
        catch (Exception ex) {
            if (Util.isLoggableFINE()) {
                Util.logFINE(ex);
            }
            throw new FrameworkException((Throwable)ex);
        }
    }

    public void deleteClusterAndInstances(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model;
        ViewDescriptor tableDescriptor;
        block6: {
            View view = handlerCtx.getView();
            DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
            ViewDescriptor vd = descView.getViewDescriptor();
            String childName = (String)handlerCtx.getInputValue("tableChildName");
            if (childName == null) {
                throw new FrameworkException("deleteClusterAndInstances: childName not specified", vd, view);
            }
            tableDescriptor = vd.getChildDescriptor(childName);
            if (tableDescriptor == null) {
                throw new FrameworkException("deleteClusterAndInstances: tableDescriptor is null", vd, view);
            }
            if (!(tableDescriptor instanceof CCActionTableDescriptor)) {
                throw new FrameworkException("deleteClusterAndInstances: tableDescriptor is of wrong type", tableDescriptor, view);
            }
            model = ((CCActionTableDescriptor)tableDescriptor).getModel();
            model.setRowSelectionType("multiple");
            String objectName = null;
            try {
                model.beforeFirst();
                while (model.next()) {
                    if (!model.isRowSelected() || (objectName = (String)model.getValue("objectName")) == null) continue;
                    this.deleteCluster(new ObjectName(objectName).getKeyProperty("name"));
                    model.setRowSelected(false);
                }
            }
            catch (Exception ex) {
                if (!Util.isLoggableFINE()) break block6;
                Util.logFINE(ex);
            }
        }
        ContainerViewBase containerView = (ContainerViewBase)tableDescriptor.getView(ctx).getParent();
        containerView.removeChild(tableDescriptor.getName());
        ((DefaultModel)model).clear();
    }
}

