/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.web.ui.common.CCSystem;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LockhartEntityResolver
implements EntityResolver,
Serializable {
    private static final String COM_SUN_WEB_UI = "com_sun_web_ui";
    private static final String FILE_PROTOCOL = "file://";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String TAG_DIR = "tags";
    private static final String DTD_DIR = "dtd";
    private static final String DTD_SUFFIX = ".dtd";
    private static final String LOCAL_HOST = "localhost";
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static Object osync = new Object();
    private static String hostName = null;
    private static String xmlEncoding = "UTF-8";
    private String httpPort = null;
    private String httpPrefix = null;
    private String userDir = null;
    private String resourceContextName = null;
    private String filePrefix = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockhartEntityResolver() {
        Object object = osync;
        synchronized (object) {
            if (hostName == null) {
                try {
                    RequestContext reqContext = RequestManager.getRequestContext();
                    hostName = reqContext.getRequest().getServerName();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (hostName == null) {
                    try {
                        hostName = InetAddress.getLocalHost().getHostName();
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
                if (hostName == null) {
                    hostName = LOCAL_HOST;
                }
            }
        }
        this.httpPort = CCSystem.getUnsecurePort();
        this.httpPrefix = HTTP_PROTOCOL + hostName + ":" + this.httpPort;
        this.userDir = System.getProperty("user.dir");
        this.userDir = this.userDir.replace('\\', '/');
        this.resourceContextName = CCSystem.getResourceContextPath();
        if (this.resourceContextName.startsWith("/")) {
            this.resourceContextName = this.resourceContextName.substring(1);
        }
        String location = (String)MBeanUtil.getAttribute("com.sun.appserv:type=web-module,name=com_sun_web_ui,category=config", "location");
        this.filePrefix = "file:///" + RelativePathResolver.resolvePath((String)location);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        String path = this.getSystemId(systemId);
        if (path == null) {
            return null;
        }
        InputSource isrc = null;
        try {
            StringTokenizer st = new StringTokenizer(path, "/");
            int count = st.countTokens();
            if (count != 1 && count != 3) {
                return null;
            }
            String[] tokens = new String[count];
            for (int i = 0; i < count; ++i) {
                tokens[i] = st.nextToken();
            }
            if (count == 1) {
                if (tokens[0].endsWith(DTD_SUFFIX)) {
                    isrc = this.buildInputSource(this.resourceContextName, tokens[0]);
                }
            } else if (count == 3 && tokens[1].equals(DTD_DIR) && tokens[2].endsWith(DTD_SUFFIX)) {
                isrc = tokens[0].equals(COM_SUN_WEB_UI) ? this.buildInputSource(this.resourceContextName, tokens[2]) : (tokens[0].equals(TAG_DIR) ? this.buildInputSource(this.resourceContextName, tokens[2]) : this.buildInputSource(tokens[0], tokens[2]));
            }
        }
        catch (Exception e) {
            System.out.println("cannot convert DTD, using default behaviour: " + e.getMessage());
            isrc = null;
        }
        return isrc;
    }

    protected String getSystemId(String systemId) {
        int k;
        String path;
        if (systemId == null) {
            return null;
        }
        try {
            path = URLDecoder.decode(systemId, xmlEncoding);
        }
        catch (Exception ex) {
            path = systemId;
        }
        int j = path.indexOf(47);
        if (j > 0 && (k = path.indexOf(58)) >= 0 && k < j) {
            if (!path.startsWith(FILE_PROTOCOL)) {
                return null;
            }
            path = path.substring(FILE_PROTOCOL.length());
            if (this.userDir != null) {
                if (path.startsWith(this.userDir)) {
                    path = path.substring(this.userDir.length());
                } else if (path.startsWith("/" + this.userDir)) {
                    path = path.substring(this.userDir.length() + 1);
                }
            }
        }
        return path;
    }

    protected String getHostName() {
        return hostName;
    }

    protected String getPortNumber() {
        return this.httpPort;
    }

    private InputSource buildInputSource(String path, String file) {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(128);
        buffer.append(this.filePrefix);
        buffer.append("/dtd");
        buffer.append("/" + file);
        String url = buffer.toString();
        return new InputSource(url);
    }
}

