/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.HAWebEventPersistentManager;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;

public class HASyncContainerListener
implements ContainerListener {
    private static Logger _logger = null;
    private Manager _manager = null;

    public HASyncContainerListener(Manager manager) {
        this._manager = manager;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public void containerEvent(ContainerEvent event) {
        if (event.getType().equals("sessionSync")) {
            this.processSyncEvent(event);
        }
    }

    private void processSyncEvent(ContainerEvent event) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN CONTAINER_EVENT for sessionSync");
        }
        this.processSessionAttributeEvent(event);
    }

    private void processSessionAttributeEvent(ContainerEvent event) {
        Context context = (Context)event.getContainer();
        HttpSessionBindingEvent hsbe = (HttpSessionBindingEvent)event.getData();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASyncContainerListener: habe =" + hsbe);
        }
        String name = hsbe.getName();
        Object value = hsbe.getValue();
        HttpSession sess = hsbe.getSession();
        String sessId = null;
        if (sess != null) {
            sessId = sess.getId();
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("HASyncContainerListener: ATTRIBUTE_NAME = " + name + ": SESSION_ID = " + sessId);
        }
        if (this._manager != null) {
            HAWebEventPersistentManager pMgr = (HAWebEventPersistentManager)this._manager;
            Session session = this.findSession(sessId, pMgr);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("HASyncContainerListener: about to do valveSave: pMgr: " + (Object)((Object)pMgr) + "session: " + session);
            }
            pMgr.doValveSave(session);
        }
    }

    private Session findSession(String id, HAWebEventPersistentManager pMgr) {
        Session sess = null;
        try {
            sess = pMgr.findSession(id);
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sess;
    }
}

