/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.jdbc.DataSource;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.enterprise.ee.web.sessmgmt.HAErrorManager;
import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;

public class ConnectionUtil {
    private static javax.sql.DataSource _dataSource = null;
    private static Logger _logger = null;
    protected HAErrorManager haErr = null;
    protected String driverName = "com.sun.hadb.jdbc.Driver";
    protected String timeoutSecs = new Long(300L).toString();
    protected Object container = null;
    protected Object manager = null;
    protected Valve valve = null;
    protected Connection conn = null;
    protected String threadName = "ConnectionUtil";
    protected String user = null;
    protected String password = null;
    protected String connString = null;
    protected String dataSourceString = null;
    protected javax.sql.DataSource dataSource = null;

    public ConnectionUtil(Object cont) {
        this.container = cont;
        this.threadName = "ConnectionUtil";
        long timeout = new Long(this.timeoutSecs);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public ConnectionUtil(Container cont) {
        this.container = cont;
        this.threadName = "ConnectionUtil";
        long timeout = new Long(this.timeoutSecs);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    public ConnectionUtil(Container cont, Manager mgr) {
        this(cont);
        this.manager = mgr;
    }

    public ConnectionUtil(Container cont, Valve aValve) {
        this(cont);
        this.valve = aValve;
    }

    protected String getConnUser() {
        if (this.user == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.user = lookup.getConnectionUserFromConfig();
        }
        return this.user;
    }

    protected String getConnPassword() {
        if (this.password == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.password = lookup.getConnectionPasswordFromConfig();
        }
        return this.password;
    }

    protected String getConnString() {
        if (this.connString == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            this.connString = lookup.getConnectionURLFromConfig();
        }
        return this.connString;
    }

    protected String getDataSourceNameFromConfig() {
        if (this.dataSourceString == null) {
            ServerConfigLookup configLookup = new ServerConfigLookup();
            this.dataSourceString = configLookup.getHaStorePoolJndiNameFromConfig();
        }
        return this.dataSourceString;
    }

    protected javax.sql.DataSource getDataSourcePrevious() throws NamingException {
        javax.sql.DataSource ds;
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (_dataSource != null) {
            this.dataSource = _dataSource;
            return _dataSource;
        }
        Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("ERROR CREATING INITCTX+++++++++");
            }
            e.printStackTrace();
            throw new NamingException(e.getMessage());
        }
        String dsName = this.getDataSourceNameFromConfig();
        this.dataSource = ds = (javax.sql.DataSource)ctx.lookup(dsName);
        ConnectionUtil.setDataSource(ds);
        return ds;
    }

    public javax.sql.DataSource privateGetDataSource() throws NamingException {
        return this.getDataSource();
    }

    protected javax.sql.DataSource getDataSource() throws NamingException {
        javax.sql.DataSource dataSource;
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (_dataSource != null) {
            this.dataSource = _dataSource;
            return _dataSource;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                return null;
            }
        });
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("- Got initial context for pool successfully");
                _logger.finest("Getting datasource...");
            }
            String dsName = this.getDataSourceNameFromConfig();
            String systemDataSourceName = ResourceInstaller.getPMJndiName((String)dsName);
            javax.sql.DataSource ds = (javax.sql.DataSource)ctx.lookup(systemDataSourceName);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("- Got datasource for pool successfully");
            }
            this.dataSource = ds;
            ConnectionUtil.setDataSource(ds);
            dataSource = ds;
        }
        catch (Exception e) {
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("ERROR CREATING INITCTX+++++++++");
                }
                e.printStackTrace();
                throw new NamingException(e.getMessage());
            }
            catch (Throwable throwable) {
                AccessController.doPrivileged(new PrivilegedAction(originalClassLoader){
                    private final /* synthetic */ ClassLoader val$originalClassLoader;
                    {
                        this.val$originalClassLoader = val$originalClassLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$originalClassLoader);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        return dataSource;
    }

    protected javax.sql.DataSource getDataSourceLatestPrevious() throws NamingException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (_dataSource != null) {
            this.dataSource = _dataSource;
            return _dataSource;
        }
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                return null;
            }
        });
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (Exception e) {
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("ERROR CREATING INITCTX+++++++++");
                }
                e.printStackTrace();
                throw new NamingException(e.getMessage());
            }
            catch (Throwable throwable) {
                AccessController.doPrivileged(new PrivilegedAction(originalClassLoader){
                    private final /* synthetic */ ClassLoader val$originalClassLoader;
                    {
                        this.val$originalClassLoader = val$originalClassLoader;
                    }

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(this.val$originalClassLoader);
                        return null;
                    }
                });
                throw throwable;
            }
        }
        AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("- Got initial context for pool successfully");
            _logger.finest("Getting datasource...");
        }
        String dsName = this.getDataSourceNameFromConfig();
        String systemDataSourceName = ResourceInstaller.getPMJndiName((String)dsName);
        javax.sql.DataSource ds = (javax.sql.DataSource)ctx.lookup(systemDataSourceName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("- Got datasource for pool successfully");
        }
        this.dataSource = ds;
        ConnectionUtil.setDataSource(ds);
        return ds;
    }

    protected javax.sql.DataSource getDataSourceLastGood() throws NamingException {
        javax.sql.DataSource ds;
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (_dataSource != null) {
            this.dataSource = _dataSource;
            return _dataSource;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                return null;
            }
        });
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("ERROR CREATING INITCTX+++++++++");
            }
            e.printStackTrace();
            throw new NamingException(e.getMessage());
        }
        String dsName = this.getDataSourceNameFromConfig();
        String systemDataSourceName = ResourceInstaller.getPMJndiName((String)dsName);
        this.dataSource = ds = (javax.sql.DataSource)ctx.lookup(systemDataSourceName);
        ConnectionUtil.setDataSource(ds);
        return ds;
    }

    private static synchronized void setDataSource(javax.sql.DataSource ds) {
        _dataSource = ds;
    }

    protected Connection getConnectionFromPool() throws IOException {
        Connection conn = null;
        Object invmgr = null;
        Object ci = null;
        try {
            javax.sql.DataSource ds = this.getDataSource();
            conn = this.getConnectionRetry(ds);
        }
        catch (Exception ex) {
            IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
            throw ex1;
        }
        return conn;
    }

    protected Connection getConnectionFromPool(boolean autoCommit) throws IOException {
        Connection conn = null;
        Object invmgr = null;
        Object ci = null;
        try {
            javax.sql.DataSource ds = this.getDataSource();
            conn = this.getConnectionRetry(ds, autoCommit);
        }
        catch (Exception ex) {
            IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
            throw ex1;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection doGetConnectionPrevious(javax.sql.DataSource ds) throws SQLException {
        Connection resultConn = null;
        String threadName = Thread.currentThread().getName();
        String shortString = this.truncateString(threadName, 63);
        Thread.currentThread().setName(shortString);
        try {
            resultConn = ds.getConnection();
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
        return resultConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection doGetConnection(javax.sql.DataSource ds) throws SQLException {
        Connection resultConn = null;
        String threadName = Thread.currentThread().getName();
        String shortString = this.truncateString(threadName, 63);
        Thread.currentThread().setName(shortString);
        DataSource castDS = (DataSource)ds;
        try {
            resultConn = castDS.getNonTxConnection();
        }
        finally {
            Thread.currentThread().setName(threadName);
        }
        return resultConn;
    }

    private String truncateString(String inputStr, int newLength) {
        int strLength = inputStr.length();
        String result = inputStr;
        if (newLength < strLength && newLength > 0) {
            result = inputStr.substring(strLength - newLength, strLength);
        }
        return result;
    }

    private Connection getConnectionRetry(javax.sql.DataSource ds) throws IOException {
        Connection resultConn = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    resultConn = this.doGetConnection(ds);
                    resultConn.setAutoCommit(false);
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, null);
                    if (resultConn != null) {
                        try {
                            resultConn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("Got a retryable exception from ConnectionUtil: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from ConnectionUtil: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from ConnectionUtil").initCause(e);
            throw ex1;
        }
        if (resultConn == null) {
            _logger.warning("ConnectionUtil>>getConnectionRetry failed: returning null");
        }
        return resultConn;
    }

    private Connection getConnectionRetry(javax.sql.DataSource ds, boolean autoCommit) throws IOException {
        Connection resultConn = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    resultConn = this.doGetConnection(ds);
                    resultConn.setAutoCommit(autoCommit);
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, null);
                    if (resultConn != null) {
                        try {
                            resultConn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("Got a retryable exception from ConnectionUtil: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from ConnectionUtil: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from ConnectionUtil").initCause(e);
            throw ex1;
        }
        if (resultConn == null) {
            _logger.warning("ConnectionUtil>>getConnectionRetry failed: returning null");
        }
        return resultConn;
    }

    private Connection getConnectionRetryPrevious(javax.sql.DataSource ds) throws IOException {
        Connection resultConn = null;
        try {
            this.haErr.txStart();
            try {
                while (!this.haErr.isTxCompleted()) {
                    resultConn = ds.getConnection();
                    resultConn.setAutoCommit(false);
                    this.haErr.txEnd();
                }
            }
            catch (SQLException e) {
                this.haErr.checkError(e, null);
                if (resultConn != null) {
                    try {
                        resultConn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Got a retryable exception from ConnectionUtil: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from ConnectionUtil: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from ConnectionUtil").initCause(e);
            throw ex1;
        }
        if (resultConn == null) {
            _logger.warning("ConnectionUtil>>getConnectionRetry failed: returning null");
        }
        return resultConn;
    }

    protected Connection getConnectionFromPoolLastGood() throws IOException {
        Connection conn = null;
        InvocationManager invmgr = null;
        ComponentInvocation ci = null;
        try {
            invmgr = Switch.getSwitch().getInvocationManager();
            ci = new ComponentInvocation((Object)this, this.container);
            invmgr.preInvoke(ci);
            javax.sql.DataSource ds = this.getDataSource();
            conn = ds.getConnection();
            conn.setAutoCommit(false);
        }
        catch (Exception ex) {
            try {
                IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
                throw ex1;
            }
            catch (Throwable throwable) {
                invmgr.postInvoke(ci);
                throw throwable;
            }
        }
        invmgr.postInvoke(ci);
        return conn;
    }

    protected Connection getConnectionFromPoolPrevious() throws IOException {
        Connection conn = null;
        InvocationManager invmgr = null;
        ComponentInvocation ci = null;
        try {
            invmgr = Switch.getSwitch().getInvocationManager();
            ci = new ComponentInvocation((Object)this, this.container);
            invmgr.preInvoke(ci);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Getting initial context...");
            }
            InitialContext ctx = new InitialContext();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("- Got initial context for pool successfully");
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Getting datasource...");
            }
            String dsName = this.getDataSourceNameFromConfig();
            javax.sql.DataSource ds = (javax.sql.DataSource)ctx.lookup(dsName);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("- Got datasource for pool successfully");
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Getting connection...");
            }
            conn = ds.getConnection();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("GOT CONNECTION: class= " + conn.getClass().getName());
            }
            conn.setAutoCommit(false);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("- Got connection from pool successfully");
            }
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                throw new IOException("Unable to obtain connection from pool");
            }
            catch (Throwable throwable) {
                invmgr.postInvoke(ci);
                throw throwable;
            }
        }
        invmgr.postInvoke(ci);
        return conn;
    }

    public HADBConnectionGroup getConnectionsFromPool() throws IOException {
        Connection conn = this.getConnectionFromPool();
        if (conn == null) {
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed: returning null");
            return null;
        }
        Connection internalConn = this.getInternalConnection(conn);
        HADBConnectionGroup connections = new HADBConnectionGroup(internalConn, conn);
        return connections;
    }

    public HADBConnectionGroup getConnectionsFromPool(boolean autoCommit) throws IOException {
        Connection conn = this.getConnectionFromPool(autoCommit);
        if (conn == null) {
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed: returning null");
            return null;
        }
        Connection internalConn = this.getInternalConnection(conn);
        HADBConnectionGroup connections = new HADBConnectionGroup(internalConn, conn);
        return connections;
    }

    private Connection getInternalConnection(Connection connection) throws IOException {
        Connection internalConn = null;
        DataSource ds = null;
        try {
            ds = (DataSource)this.getDataSource();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            internalConn = ds.getConnection(connection);
        }
        catch (Exception ex) {
            IOException ex1 = (IOException)new IOException("Unable to obtain connection from pool").initCause(ex);
            throw ex1;
        }
        return internalConn;
    }

    public Connection getConnection() throws IOException {
        return this.getConnection(true);
    }

    public Connection getConnectionNew(boolean autoCommit) throws IOException {
        Connection internalConn = null;
        try {
            Connection externalConn = this.getConnectionFromPool();
            internalConn = this.getInternalConnection(externalConn);
            if (internalConn != null) {
                internalConn.setAutoCommit(autoCommit);
                this.putConnection(internalConn);
            }
        }
        catch (SQLException e) {
            _logger.log(Level.SEVERE, "connectionutil.unableToOpenConnection", e.getMessage());
            _logger.log(Level.SEVERE, "connectionutil.failedToPersist");
            IOException ex1 = (IOException)new IOException("Unable to open connection to HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return internalConn;
    }

    public Connection getConnection(boolean autoCommit) throws IOException {
        this.haErr.txStart();
        while (!this.haErr.isTxCompleted()) {
            IOException ex1;
            try {
                if (this.conn != null && !this.conn.isClosed() && this.conn.getAutoCommit()) {
                    this.conn.setAutoCommit(autoCommit);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("VALUE-OF-CONN-STRING= " + this.getConnString());
                    _logger.finest("cached conn= " + this.conn);
                }
            }
            catch (Exception e1) {
                this.conn = null;
            }
            if (this.conn != null) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("getConnection-near begin return conn from cache");
                }
                this.haErr.txEnd();
                break;
            }
            try {
                try {
                    Class.forName(this.driverName);
                }
                catch (ClassNotFoundException ex) {
                    ex1 = (IOException)new IOException("Unable to find JDBC driver class " + this.driverName + ": " + ex.getMessage()).initCause(ex);
                    throw ex1;
                }
                try {
                    Properties props = new Properties();
                    String theUser = this.getConnUser();
                    String thePassword = this.getConnPassword();
                    props.setProperty("user", this.user);
                    props.setProperty("password", this.password);
                    String threadName = Thread.currentThread().getName();
                    String shortString = this.truncateString(threadName, 63);
                    Thread.currentThread().setName(shortString);
                    this.conn = DriverManager.getConnection(this.getConnString(), props);
                    Thread.currentThread().setName(threadName);
                    this.conn.setAutoCommit(autoCommit);
                    this.conn.setTransactionIsolation(4);
                    this.haErr.txEnd();
                    if (!_logger.isLoggable(Level.FINEST)) continue;
                    _logger.finest("getConnection at middle - return created conn: " + this.conn);
                }
                catch (SQLException ex) {
                    this.haErr.checkError(ex, this.conn);
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Got a retryable exception from HA Store: " + ex.getMessage());
                    }
                    System.out.println("Got a retryable exception from HA Store: " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            catch (SQLException e) {
                _logger.log(Level.SEVERE, "connectionutil.unableToOpenConnection", e.getMessage());
                _logger.log(Level.SEVERE, "connectionutil.failedToPersist");
                ex1 = (IOException)new IOException("Unable to open connection to HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (HATimeoutException e) {
                IOException ex2 = (IOException)new IOException("Timed out attempting to open connection to HA Store").initCause(e);
                throw ex2;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("getConnection at end - return conn: " + this.conn);
        }
        if (this.conn != null) {
            this.putConnection(this.conn);
        }
        return this.conn;
    }

    public Connection getConnectionPreviousGood(boolean autoCommit) throws IOException {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                if (this.conn.getAutoCommit()) {
                    this.conn.setAutoCommit(autoCommit);
                }
                return this.conn;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("VALUE-OF-CONN-STRING= " + this.getConnString());
            }
            try {
                Class.forName(this.driverName);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Unable to find JDBC driver class " + this.driverName + ": " + ex.getMessage());
            }
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    Properties props = new Properties();
                    String theUser = this.getConnUser();
                    String thePassword = this.getConnPassword();
                    props.setProperty("user", this.user);
                    props.setProperty("password", this.password);
                    this.conn = DriverManager.getConnection(this.getConnString(), props);
                    this.conn.setAutoCommit(autoCommit);
                    this.haErr.txEnd();
                }
                catch (SQLException ex) {
                    this.haErr.checkError(ex, this.conn);
                }
            }
            this.putConnection(this.conn);
            return this.conn;
        }
        catch (SQLException e) {
            _logger.log(Level.SEVERE, "connectionutil.unableToOpenConnection", e.getMessage());
            _logger.log(Level.SEVERE, "connectionutil.failedToPersist");
            e.printStackTrace();
            throw new IOException("Unable to open connection to HA Store: " + e.getMessage());
        }
        catch (HATimeoutException e) {
            throw new IOException("Timed out attempting to open connection to HA Store");
        }
    }

    public Connection getConnectionPrevious(boolean autoCommit) throws IOException {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.setAutoCommit(autoCommit);
                return this.conn;
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("VALUE-OF-CONN-STRING= " + this.getConnString());
            }
            try {
                Class.forName(this.driverName);
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Unable to find JDBC driver class " + this.driverName + ": " + ex.getMessage());
            }
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    Properties props = new Properties();
                    String theUser = this.getConnUser();
                    String thePassword = this.getConnPassword();
                    props.setProperty("user", this.user);
                    props.setProperty("password", this.password);
                    this.conn = DriverManager.getConnection(this.getConnString(), props);
                    this.conn.setAutoCommit(autoCommit);
                    this.haErr.txEnd();
                }
                catch (SQLException ex) {
                    this.haErr.checkError(ex, this.conn);
                }
            }
            this.putConnection(this.conn);
            return this.conn;
        }
        catch (SQLException e) {
            _logger.log(Level.SEVERE, "connectionutil.unableToOpenConnection", e.getMessage());
            _logger.log(Level.SEVERE, "connectionutil.failedToPersist");
            e.printStackTrace();
            throw new IOException("Unable to open connection to HA Store: " + e.getMessage());
        }
        catch (HATimeoutException e) {
            throw new IOException("Timed out attempting to open connection to HA Store");
        }
    }

    protected void putConnection(Connection conn) {
        if (this.manager instanceof ShutdownCleanupCapable) {
            ((ShutdownCleanupCapable)this.manager).putConnection(conn);
        }
        if (this.valve instanceof ShutdownCleanupCapable) {
            ((ShutdownCleanupCapable)this.valve).putConnection(conn);
        }
    }

    public void clearCachedConnection() {
        this.conn = null;
    }
}

