/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.authenticator;

import com.sun.enterprise.ee.web.authenticator.HASingleSignOn;
import com.sun.enterprise.ee.web.authenticator.HASingleSignOnEntry;
import com.sun.enterprise.ee.web.authenticator.SSOStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.ConnectionUtil;
import com.sun.enterprise.ee.web.sessmgmt.FullHASession;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.enterprise.ee.web.sessmgmt.HAErrorManager;
import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.enterprise.ee.web.sessmgmt.ModifiedAttributeHASession;
import com.sun.enterprise.ee.web.sessmgmt.ModifiedHASession;
import com.sun.enterprise.ee.web.sessmgmt.StorePoolElement;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import java.io.IOException;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.catalina.Container;
import org.apache.catalina.Valve;
import org.apache.catalina.session.StandardSession;

public class SSOStore
implements StorePoolElement,
SSOStorePoolElement {
    private static final String BASIC_AUTH = "BASIC";
    private static final String FORM_AUTH = "FORM";
    private static final String DIGEST_AUTH = "DIGEST";
    private static final String CLIENT_CERT_AUTH = "CLIENT-CERT";
    protected Container container = null;
    protected HASingleSignOn sso = null;
    private boolean debug = false;
    protected final String singleSignOnTable = "singlesignon";
    String sessionHeaderTable = "sessionheader";
    String blobSessionTable = "blobsessions";
    private PreparedStatement preparedLoadSSOSql = null;
    private PreparedStatement preparedInsertSSOSql = null;
    private PreparedStatement preparedUpdateSSOSql = null;
    private PreparedStatement preparedExistsSql = null;
    private PreparedStatement preparedRemoveSSOSql = null;
    private PreparedStatement preparedRemoveInactiveSql = null;
    private PreparedStatement preparedUpdateSessionTableSql = null;
    protected long timeout = 300L;
    protected HAErrorManager haErr = new HAErrorManager(this.timeout, "ssoThread");
    protected String connString = null;
    protected Connection conn = null;
    protected String driverName = "com.sun.hadb.jdbc.Driver";
    protected ConnectionUtil connectionUtil = null;
    protected String user = null;
    protected String password = null;

    public void setContainer(Container container) {
        this.container = container;
        this.debug("   container:    " + container);
    }

    public void setSingleSignOn(HASingleSignOn haSSO) {
        this.sso = haSSO;
        this.debug("   sso:    " + (Object)((Object)this.sso));
    }

    protected ConnectionUtil getConnectionUtil() {
        if (this.connectionUtil == null) {
            this.connectionUtil = new ConnectionUtil(this.container, (Valve)this.sso);
        }
        return this.connectionUtil;
    }

    public String[] keys() throws IOException {
        String[] retValue = null;
        return retValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SingleSignOnEntry loadSSO(String ssoId) throws IOException {
        SingleSignOnEntry _ssoEntry;
        block9: {
            HADBConnectionGroup connGroup = this.getConnectionsFromPool();
            Connection internalConn = connGroup._internalConn;
            Connection conn = connGroup._externalConn;
            _ssoEntry = null;
            try {
                try {
                    _ssoEntry = this.loadSSO(ssoId, conn);
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    conn = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                Object var8_8 = null;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ex) {}
            conn.close();
        }
        this.debug("Loaded SSO " + ssoId);
        return _ssoEntry;
    }

    /*
     * Loose catch block
     */
    public synchronized SingleSignOnEntry loadSSO(String ssoId, Connection connection) throws IOException {
        String realmName;
        String userName;
        String authType;
        block25: {
            ResultSet rst;
            Connection conn;
            block23: {
                if (ssoId == null) {
                    this.debug("in load -- SSOStore, ssoId is null, returning null");
                    Thread.dumpStack();
                    return null;
                }
                long lastAccess = 0L;
                authType = null;
                userName = null;
                realmName = null;
                conn = connection;
                rst = null;
                String loadSSOSql = "SELECT ssoid, lastaccess, authType, userName FROM singlesignon WHERE ssoid = ?";
                this.preparedLoadSSOSql = conn.prepareStatement(loadSSOSql);
                this.preparedLoadSSOSql.setString(1, ssoId);
                rst = this.preparedLoadSSOSql.executeQuery();
                if (rst.next()) {
                    rst.getString("ssoid");
                    lastAccess = rst.getLong("lastaccess");
                    String authTypeAndRealmName = rst.getString("authType");
                    if (authTypeAndRealmName.startsWith(BASIC_AUTH)) {
                        authType = BASIC_AUTH;
                        realmName = authTypeAndRealmName.substring(BASIC_AUTH.length());
                    } else if (authTypeAndRealmName.startsWith(FORM_AUTH)) {
                        authType = FORM_AUTH;
                        realmName = authTypeAndRealmName.substring(FORM_AUTH.length());
                    } else if (authTypeAndRealmName.startsWith(DIGEST_AUTH)) {
                        authType = DIGEST_AUTH;
                        realmName = authTypeAndRealmName.substring(DIGEST_AUTH.length());
                    } else if (authTypeAndRealmName.startsWith(CLIENT_CERT_AUTH)) {
                        authType = CLIENT_CERT_AUTH;
                        realmName = authTypeAndRealmName.substring(CLIENT_CERT_AUTH.length());
                    }
                    userName = rst.getString("userName");
                    break block23;
                }
                SingleSignOnEntry authTypeAndRealmName = null;
                Object var14_13 = null;
                try {
                    if (this.preparedLoadSSOSql != null) {
                        this.preparedLoadSSOSql.close();
                        this.preparedLoadSSOSql = null;
                    }
                }
                catch (SQLException se) {
                    // empty catch block
                }
                return authTypeAndRealmName;
            }
            this.closeResultSet(rst);
            conn.commit();
            this.preparedLoadSSOSql.close();
            this.preparedLoadSSOSql = null;
            Object var14_14 = null;
            try {
                if (this.preparedLoadSSOSql != null) {
                    this.preparedLoadSSOSql.close();
                    this.preparedLoadSSOSql = null;
                }
                break block25;
            }
            catch (SQLException se) {}
            break block25;
            {
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    e.printStackTrace();
                    IOException ex1 = (IOException)new IOException("Error from SSOStore: " + e.getMessage()).initCause(e);
                    throw ex1;
                }
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                try {
                    if (this.preparedLoadSSOSql != null) {
                        this.preparedLoadSSOSql.close();
                        this.preparedLoadSSOSql = null;
                    }
                }
                catch (SQLException se) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Principal principal = null;
        return new HASingleSignOnEntry(principal, authType, userName, null, realmName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(String ssoId, SingleSignOnEntry ssoEntry) throws IOException {
        block9: {
            HADBConnectionGroup connGroup = this.getConnectionsFromPool();
            Connection internalConn = connGroup._internalConn;
            Connection conn = connGroup._externalConn;
            try {
                try {
                    this.save(ssoId, ssoEntry, internalConn);
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    conn = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                Object var8_8 = null;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ex) {}
            conn.close();
        }
        this.debug("Saved SSO " + ssoId + " into SSOStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save(String ssoId, SingleSignOnEntry ssoEntry, Connection connection) throws IOException {
        block13: {
            block12: {
                Connection conn = connection;
                String existsSql = "SELECT ssoid FROM singlesignon WHERE ssoid = ?";
                ResultSet rs = null;
                boolean found = false;
                this.preparedExistsSql = conn.prepareStatement(existsSql);
                this.preparedExistsSql.setString(1, ssoId);
                rs = this.executeStatement(this.preparedExistsSql, true);
                found = rs != null && rs.next();
                conn.commit();
                this.preparedExistsSql.close();
                this.preparedExistsSql = null;
                if (!found) {
                    this.insertSSO(ssoId, ssoEntry, conn);
                    break block12;
                }
                this.updateSSO(ssoId, ssoEntry, conn);
            }
            Object var10_8 = null;
            try {
                if (this.preparedExistsSql != null) {
                    this.preparedExistsSql.close();
                    this.preparedExistsSql = null;
                }
                break block13;
            }
            catch (SQLException se) {}
            break block13;
            {
                catch (SQLException sqe) {
                    sqe.printStackTrace();
                    Object var10_9 = null;
                    try {
                        if (this.preparedExistsSql != null) {
                            this.preparedExistsSql.close();
                            this.preparedExistsSql = null;
                        }
                        break block13;
                    }
                    catch (SQLException se) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                try {
                    if (this.preparedExistsSql != null) {
                        this.preparedExistsSql.close();
                        this.preparedExistsSql = null;
                    }
                }
                catch (SQLException se) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertSSO(String ssoId, SingleSignOnEntry ssoEntry, Connection conn) throws IOException {
        this.debug("in insertSSO --SSOStore");
        String insertSSOSql = "INSERT into singlesignon(ssoid, lastaccess, authType, userName) VALUES (?, ?, ?, ?)";
        this.debug("insertSSO sso id '" + ssoId + "' for user '" + ssoEntry.principal.getName() + "' with auth type '" + ssoEntry.authType + "' and realm name '" + ssoEntry.realmName + "'");
        try {
            try {
                this.preparedInsertSSOSql = conn.prepareStatement(insertSSOSql);
                this.preparedInsertSSOSql.setString(1, ssoId);
                this.preparedInsertSSOSql.setLong(2, ssoEntry.lastAccessTime);
                String authTypeAndRealmName = ssoEntry.authType + ssoEntry.realmName;
                this.preparedInsertSSOSql.setString(3, authTypeAndRealmName);
                this.preparedInsertSSOSql.setString(4, ssoEntry.principal.getName());
                this.executeStatement(this.preparedInsertSSOSql, false);
                conn.commit();
                this.preparedInsertSSOSql.close();
                this.preparedInsertSSOSql = null;
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                e.printStackTrace();
                IOException ex1 = (IOException)new IOException("Error from SSO Store insertSSO : " + e.getMessage()).initCause(e);
                throw ex1;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (this.preparedInsertSSOSql == null) throw throwable;
                this.preparedInsertSSOSql.close();
                this.preparedInsertSSOSql = null;
                throw throwable;
            }
            catch (SQLException se) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException se) {}
        if (this.preparedInsertSSOSql == null) return;
        this.preparedInsertSSOSql.close();
        this.preparedInsertSSOSql = null;
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateSSO(String ssoId, SingleSignOnEntry ssoEntry, Connection conn) throws IOException {
        this.debug("in updateSSO --SSOStore");
        String updateSSOSql = "UPDATE singlesignon SET lastaccess = ?, authType = ?, userName = ? WHERE ssoid = ?";
        this.debug("updateSSO sso id '" + ssoId + "' for user '" + ssoEntry.principal.getName() + "' with auth type '" + ssoEntry.authType + "' and realm name '" + ssoEntry.realmName + "'");
        try {
            try {
                this.preparedUpdateSSOSql = conn.prepareStatement(updateSSOSql);
                this.preparedUpdateSSOSql.setLong(1, ssoEntry.lastAccessTime);
                String authTypeAndRealmName = ssoEntry.authType + ssoEntry.realmName;
                this.preparedUpdateSSOSql.setString(2, authTypeAndRealmName);
                this.preparedUpdateSSOSql.setString(3, ssoEntry.principal.getName());
                this.preparedUpdateSSOSql.setString(4, ssoId);
                this.executeStatement(this.preparedUpdateSSOSql, false);
                conn.commit();
                this.preparedUpdateSSOSql.close();
                this.preparedUpdateSSOSql = null;
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                e.printStackTrace();
                IOException ex1 = (IOException)new IOException("Error from SSO Store insertSSO : " + e.getMessage()).initCause(e);
                throw ex1;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (this.preparedUpdateSSOSql == null) throw throwable;
                this.preparedUpdateSSOSql.close();
                this.preparedUpdateSSOSql = null;
                throw throwable;
            }
            catch (SQLException se) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException se) {}
        if (this.preparedUpdateSSOSql == null) return;
        this.preparedUpdateSSOSql.close();
        this.preparedUpdateSSOSql = null;
        return;
    }

    public void updateLastAccessTime(String ssoId, long lat) throws IOException {
        Connection conn = this.getConnection(false);
        this.updateLastAccessTime(ssoId, lat, conn);
    }

    public void updateLastAccessTime(String ssoId, long lat, Connection conn) throws IOException {
        this.debug("in updateLastAccessTime --SSOStore");
        String updateLatSql = "UPDATE singlesignon SET lastaccess = ? WHERE ssoid = ?";
        try {
            if (this.preparedUpdateSSOSql == null) {
                this.preparedUpdateSSOSql = conn.prepareStatement(updateLatSql);
            }
            this.preparedUpdateSSOSql.setLong(1, lat);
            this.debug("updateLastAccessTime sso id '" + ssoId + "' with  LastAccessTime " + lat + " ");
            this.preparedUpdateSSOSql.setString(2, ssoId);
            this.executeStatement(this.preparedUpdateSSOSql, false);
            conn.commit();
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException ee) {
                ee.printStackTrace();
            }
            e.printStackTrace();
            IOException ex1 = (IOException)new IOException("Error from SSO Store updateLastAccessTime : " + e.getMessage()).initCause(e);
            throw ex1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void associate(StandardSession session, String ssoId) throws IOException {
        block9: {
            HADBConnectionGroup connGroup = this.getConnectionsFromPool();
            Connection internalConn = connGroup._internalConn;
            Connection conn = connGroup._externalConn;
            try {
                try {
                    this.associate(session, ssoId, internalConn);
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    conn = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                Object var8_8 = null;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ex) {}
            conn.close();
        }
        this.debug("Associated SSO " + ssoId + " with session " + session.getId());
    }

    /*
     * Loose catch block
     */
    public void associate(StandardSession session, String ssoId, Connection connection) throws IOException {
        block16: {
            String updateSql = null;
            String sessionTable = null;
            if (session instanceof FullHASession || session instanceof ModifiedHASession) {
                sessionTable = this.blobSessionTable;
            } else if (session instanceof ModifiedAttributeHASession) {
                sessionTable = this.sessionHeaderTable;
            } else {
                return;
            }
            updateSql = "UPDATE " + sessionTable + " SET ssoid = ? WHERE id = ?";
            Connection conn = connection;
            this.preparedUpdateSessionTableSql = conn.prepareStatement(updateSql);
            this.preparedUpdateSessionTableSql.setString(1, ssoId);
            this.preparedUpdateSessionTableSql.setString(2, session.getId());
            this.executeStatement(this.preparedUpdateSessionTableSql, false);
            conn.commit();
            this.preparedUpdateSessionTableSql.close();
            this.preparedUpdateSessionTableSql = null;
            this.debug("Inside SSOStore.associate() : ....completed");
            Object var10_7 = null;
            if (this.preparedUpdateSessionTableSql == null) break block16;
            try {
                if (this.preparedUpdateSessionTableSql != null) {
                    this.preparedUpdateSessionTableSql.close();
                    this.preparedUpdateSessionTableSql = null;
                }
                break block16;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            break block16;
            {
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    e.printStackTrace();
                    IOException ex1 = (IOException)new IOException("Error from SSO Store associate(): " + e.getMessage()).initCause(e);
                    throw ex1;
                }
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                if (this.preparedUpdateSessionTableSql != null) {
                    try {
                        if (this.preparedUpdateSessionTableSql != null) {
                            this.preparedUpdateSessionTableSql.close();
                            this.preparedUpdateSessionTableSql = null;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(String ssoId) throws IOException {
        block9: {
            HADBConnectionGroup connGroup = this.getConnectionsFromPool();
            Connection internalConn = connGroup._internalConn;
            Connection conn = connGroup._externalConn;
            try {
                try {
                    this.remove(ssoId, internalConn);
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    conn = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                Object var7_7 = null;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ex) {}
            conn.close();
        }
        this.debug("Removed SSO " + ssoId + " from SSOStore ");
    }

    /*
     * Loose catch block
     */
    public void remove(String ssoId, Connection connection) throws IOException {
        block13: {
            this.debug("in remove -- SSOStore");
            if (ssoId == null) {
                this.debug("In remove -- SSOStore, got a null id");
                return;
            }
            Connection conn = connection;
            String removeSSOSql = "DELETE FROM singlesignon WHERE ssoid = ?";
            this.preparedRemoveSSOSql = conn.prepareStatement(removeSSOSql);
            this.preparedRemoveSSOSql.setString(1, ssoId);
            this.executeStatement(this.preparedRemoveSSOSql, false);
            this.preparedRemoveSSOSql.executeUpdate();
            conn.commit();
            this.preparedRemoveSSOSql.close();
            this.preparedRemoveSSOSql = null;
            Object var8_5 = null;
            if (this.preparedRemoveSSOSql == null) break block13;
            try {
                if (this.preparedRemoveSSOSql != null) {
                    this.preparedRemoveSSOSql.close();
                    this.preparedRemoveSSOSql = null;
                }
                break block13;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            break block13;
            {
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    IOException ex1 = (IOException)new IOException("Error from SSO Store remove(): " + e.getMessage()).initCause(e);
                    throw ex1;
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                if (this.preparedRemoveSSOSql != null) {
                    try {
                        if (this.preparedRemoveSSOSql != null) {
                            this.preparedRemoveSSOSql.close();
                            this.preparedRemoveSSOSql = null;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeInActiveSessions(String ssoId) throws IOException {
        block9: {
            HADBConnectionGroup connGroup = this.getConnectionsFromPool();
            Connection internalConn = connGroup._internalConn;
            Connection conn = connGroup._externalConn;
            try {
                try {
                    this.removeInActiveSessions(ssoId, internalConn);
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    conn = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                Object var7_7 = null;
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ex) {}
            conn.close();
        }
        this.debug("Removed inactive sessions for SSO " + ssoId);
    }

    /*
     * Loose catch block
     */
    public void removeInActiveSessions(String ssoId, Connection connection) throws IOException {
        block13: {
            this.debug("in removeInActiveSessions");
            if (ssoId == null) {
                this.debug("In removeInActiveSessions, got a null ssoId");
                return;
            }
            Connection conn = connection;
            String removeInactiveSql1 = "DELETE FROM " + this.blobSessionTable + " WHERE ssoid = ?";
            String removeInactiveSql2 = "DELETE FROM " + this.sessionHeaderTable + " WHERE ssoid = ?";
            this.preparedRemoveInactiveSql = conn.prepareStatement(removeInactiveSql1);
            this.preparedRemoveInactiveSql.setString(1, ssoId);
            this.executeStatement(this.preparedRemoveInactiveSql, false);
            conn.commit();
            this.preparedRemoveInactiveSql.close();
            this.preparedRemoveInactiveSql = null;
            Object var9_6 = null;
            if (this.preparedRemoveInactiveSql == null) break block13;
            try {
                if (this.preparedRemoveInactiveSql != null) {
                    this.preparedRemoveInactiveSql.close();
                    this.preparedRemoveInactiveSql = null;
                }
                break block13;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            break block13;
            {
                catch (SQLException e) {
                    try {
                        conn.rollback();
                    }
                    catch (SQLException ee) {
                        // empty catch block
                    }
                    IOException ex1 = (IOException)new IOException("Error from SSO Store removeInActiveSessions(): " + e.getMessage()).initCause(e);
                    throw ex1;
                }
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                if (this.preparedRemoveInactiveSql != null) {
                    try {
                        if (this.preparedRemoveInactiveSql != null) {
                            this.preparedRemoveInactiveSql.close();
                            this.preparedRemoveInactiveSql = null;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                throw throwable;
            }
        }
    }

    protected ResultSet executeStatement(PreparedStatement stmt, boolean isQuery) throws IOException {
        ResultSet rst = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (isQuery) {
                        rst = stmt.executeQuery();
                    } else {
                        stmt.executeUpdate();
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, this.conn);
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                    this.haErr.printRetryableMessage(e);
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from SSOStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from SSOStore " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return rst;
    }

    protected ResultSet executeStatementLastGood(PreparedStatement stmt, boolean isQuery) throws IOException {
        ResultSet rst = null;
        try {
            this.haErr.txStart();
            try {
                while (!this.haErr.isTxCompleted()) {
                    if (isQuery) {
                        rst = stmt.executeQuery();
                    } else {
                        stmt.executeUpdate();
                    }
                    this.haErr.txEnd();
                }
            }
            catch (SQLException e) {
                this.haErr.checkError(e, this.conn);
                this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                this.haErr.printRetryableMessage(e);
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from SSOStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from SSOStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return rst;
    }

    protected void closeResultSet(ResultSet rst) {
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Connection getConnection(boolean autoCommit) throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        this.conn = util.getConnection(autoCommit);
        return this.conn;
    }

    protected Connection getConnection() throws IOException {
        return this.getConnection(true);
    }

    public void debug(String s) {
        if (this.debug) {
            System.out.println("SSOStore: " + s);
        }
    }

    public void cleanup() {
        this.closeStatements();
        this.closeConnection();
    }

    protected void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void closeStatements() {
        PreparedStatement[] statements = new PreparedStatement[]{this.preparedLoadSSOSql, this.preparedInsertSSOSql, this.preparedUpdateSSOSql, this.preparedExistsSql, this.preparedRemoveSSOSql, this.preparedRemoveInactiveSql, this.preparedUpdateSessionTableSql};
        for (int i = 0; i < statements.length; ++i) {
            PreparedStatement nextStatement = statements[i];
            this.closeStatement(nextStatement);
        }
    }

    protected void closeStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected HADBConnectionGroup getConnectionsFromPool() throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        return util.getConnectionsFromPool();
    }
}

