/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapParseException;
import com.sun.activation.registries.MailcapTokenizer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MailcapFile {
    private Hashtable type_hash = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MailcapFile(String new_fname) throws IOException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: file " + new_fname);
        }
        FileReader reader = null;
        try {
            reader = new FileReader(new_fname);
            this.type_hash = this.createMailcapHash(new BufferedReader(reader));
            Object var4_3 = null;
            if (reader == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            reader.close();
            return;
        }
        catch (IOException ex) {}
    }

    public MailcapFile(InputStream is) throws IOException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: InputStream");
        }
        this.type_hash = this.createMailcapHash(new BufferedReader(new InputStreamReader(is, "iso-8859-1")));
    }

    public MailcapFile() {
        if (LogSupport.isLoggable()) {
            LogSupport.log("new MailcapFile: default");
        }
        this.type_hash = new Hashtable();
    }

    public Hashtable getMailcapList(String mime_type) {
        Hashtable search_result = null;
        Hashtable wildcard_result = null;
        search_result = (Hashtable)this.type_hash.get(mime_type);
        int separator = mime_type.indexOf(47);
        String type = mime_type.substring(0, separator + 1) + "*";
        wildcard_result = (Hashtable)this.type_hash.get(type);
        if (wildcard_result != null) {
            search_result = search_result != null ? this.mergeResults(search_result, wildcard_result) : wildcard_result;
        }
        return search_result;
    }

    private Hashtable mergeResults(Hashtable first, Hashtable second) {
        Enumeration verb_enum = second.keys();
        Hashtable clonedHash = (Hashtable)first.clone();
        while (verb_enum.hasMoreElements()) {
            String verb = (String)verb_enum.nextElement();
            Vector cmdVector = (Vector)clonedHash.get(verb);
            if (cmdVector == null) {
                clonedHash.put(verb, second.get(verb));
                continue;
            }
            Vector oldV = (Vector)second.get(verb);
            Enumeration v_enum = oldV.elements();
            cmdVector = (Vector)cmdVector.clone();
            clonedHash.put(verb, cmdVector);
            while (v_enum.hasMoreElements()) {
                cmdVector.addElement(v_enum.nextElement());
            }
        }
        return clonedHash;
    }

    public void appendToMailcap(String mail_cap) {
        if (LogSupport.isLoggable()) {
            LogSupport.log("appendToMailcap: " + mail_cap);
        }
        try {
            this.parse(new StringReader(mail_cap), this.type_hash);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Hashtable createMailcapHash(Reader reader) throws IOException {
        Hashtable new_hash = new Hashtable();
        this.parse(reader, new_hash);
        return new_hash;
    }

    private void parse(Reader reader, Hashtable hash) throws IOException {
        BufferedReader buf_reader = new BufferedReader(reader);
        String line = null;
        String continued = null;
        while ((line = buf_reader.readLine()) != null) {
            line = line.trim();
            try {
                if (line.charAt(0) == '#') continue;
                if (line.charAt(line.length() - 1) == '\\') {
                    if (continued != null) {
                        continued = continued + line.substring(0, line.length() - 1);
                        continue;
                    }
                    continued = line.substring(0, line.length() - 1);
                    continue;
                }
                if (continued != null) {
                    continued = continued + line;
                    try {
                        MailcapFile.parseLine(continued, hash);
                    }
                    catch (MailcapParseException e) {
                        // empty catch block
                    }
                    continued = null;
                    continue;
                }
                try {
                    MailcapFile.parseLine(line, hash);
                }
                catch (MailcapParseException e) {
                }
            }
            catch (StringIndexOutOfBoundsException e) {}
        }
    }

    protected static void parseLine(String mailcapEntry, Hashtable masterHash) throws MailcapParseException, IOException {
        Hashtable<String, Vector<String>> commands;
        MailcapTokenizer tokenizer = new MailcapTokenizer(mailcapEntry);
        tokenizer.setIsAutoquoting(false);
        String primaryType = "";
        String subType = "*";
        String soFar = "";
        if (LogSupport.isLoggable()) {
            LogSupport.log("parse: " + mailcapEntry);
        }
        int currentToken = tokenizer.nextToken();
        soFar = soFar.concat(tokenizer.getCurrentTokenValue());
        if (currentToken != 2) {
            MailcapFile.reportParseError(2, currentToken, tokenizer.getCurrentTokenValue());
        }
        primaryType = tokenizer.getCurrentTokenValue().toLowerCase();
        currentToken = tokenizer.nextToken();
        if (currentToken != 47 && currentToken != 59) {
            MailcapFile.reportParseError(47, 59, currentToken, tokenizer.getCurrentTokenValue());
        }
        soFar = soFar.concat(tokenizer.getCurrentTokenValue());
        if (currentToken == 47) {
            currentToken = tokenizer.nextToken();
            soFar = soFar.concat(tokenizer.getCurrentTokenValue());
            if (currentToken != 2) {
                MailcapFile.reportParseError(2, currentToken, tokenizer.getCurrentTokenValue());
            }
            subType = tokenizer.getCurrentTokenValue().toLowerCase();
            currentToken = tokenizer.nextToken();
            soFar = soFar.concat(tokenizer.getCurrentTokenValue());
        }
        if (LogSupport.isLoggable()) {
            LogSupport.log("  Type: " + primaryType + "/" + subType);
        }
        if ((commands = (Hashtable<String, Vector<String>>)masterHash.get(primaryType + "/" + subType)) == null) {
            commands = new Hashtable<String, Vector<String>>();
            masterHash.put(primaryType + "/" + subType, commands);
        }
        if (currentToken != 59) {
            MailcapFile.reportParseError(59, currentToken, tokenizer.getCurrentTokenValue());
        }
        tokenizer.setIsAutoquoting(true);
        currentToken = tokenizer.nextToken();
        tokenizer.setIsAutoquoting(false);
        soFar = soFar.concat(tokenizer.getCurrentTokenValue());
        if (currentToken != 2 && currentToken != 59) {
            MailcapFile.reportParseError(2, 59, currentToken, tokenizer.getCurrentTokenValue());
        }
        if (currentToken != 59) {
            currentToken = tokenizer.nextToken();
        }
        if (currentToken == 59) {
            do {
                if ((currentToken = tokenizer.nextToken()) != 2) {
                    MailcapFile.reportParseError(2, currentToken, tokenizer.getCurrentTokenValue());
                }
                String paramName = tokenizer.getCurrentTokenValue().toLowerCase();
                currentToken = tokenizer.nextToken();
                if (currentToken != 61 && currentToken != 59 && currentToken != 5) {
                    MailcapFile.reportParseError(61, 59, 5, currentToken, tokenizer.getCurrentTokenValue());
                }
                if (currentToken != 61) continue;
                tokenizer.setIsAutoquoting(true);
                currentToken = tokenizer.nextToken();
                tokenizer.setIsAutoquoting(false);
                if (currentToken != 2) {
                    MailcapFile.reportParseError(2, currentToken, tokenizer.getCurrentTokenValue());
                }
                String paramValue = tokenizer.getCurrentTokenValue();
                if (paramName.startsWith("x-java-")) {
                    Vector<String> classes;
                    String commandName = paramName.substring(7);
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("    Command: " + commandName + ", Class: " + paramValue);
                    }
                    if ((classes = (Vector<String>)commands.get(commandName)) == null) {
                        classes = new Vector<String>();
                        commands.put(commandName, classes);
                    }
                    classes.insertElementAt(paramValue, 0);
                }
                currentToken = tokenizer.nextToken();
            } while (currentToken == 59);
        } else if (currentToken != 5) {
            MailcapFile.reportParseError(5, 59, currentToken, tokenizer.getCurrentTokenValue());
        }
    }

    protected static void reportParseError(int expectedToken, int actualToken, String actualTokenValue) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + " token.");
    }

    protected static void reportParseError(int expectedToken, int otherExpectedToken, int actualToken, String actualTokenValue) throws MailcapParseException {
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + " or a " + MailcapTokenizer.nameForToken(otherExpectedToken) + " token.");
    }

    protected static void reportParseError(int expectedToken, int otherExpectedToken, int anotherExpectedToken, int actualToken, String actualTokenValue) throws MailcapParseException {
        if (LogSupport.isLoggable()) {
            LogSupport.log("PARSE ERROR: Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + ", a " + MailcapTokenizer.nameForToken(otherExpectedToken) + ", or a " + MailcapTokenizer.nameForToken(anotherExpectedToken) + " token.");
        }
        throw new MailcapParseException("Encountered a " + MailcapTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + MailcapTokenizer.nameForToken(expectedToken) + ", a " + MailcapTokenizer.nameForToken(otherExpectedToken) + ", or a " + MailcapTokenizer.nameForToken(anotherExpectedToken) + " token.");
    }
}

