/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wsi.scm.util;

import com.sun.wsi.scm.logging.LogEntry;
import com.sun.wsi.scm.util.WSIConstants;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.xml.rpc.server.ServletEndpointContext;

public class DBConnectionPool
implements WSIConstants {
    private final String CREATE_LOG = "CREATE TABLE log (DemoUserID VARCHAR(255), ServiceID VARCHAR(255), EventID VARCHAR(255), EventDescription VARCHAR(255), Timestamp TIMESTAMP)";
    private final String INSERT_LOG = "INSERT INTO log (DemoUserID, ServiceID, EventID, EventDescription, Timestamp) VALUES(?, ?, ?, ?, ?)";
    private final String QUERY_LOG = "SELECT DemoUserID, ServiceID, EventID, EventDescription, Timestamp from log where DemoUserID=?";
    private final String CREATE_CALLBACK = "CREATE TABLE callback (conversationID VARCHAR(255), warehouse_role VARCHAR(255), manufacturer_role VARCHAR(255))";
    private final String INSERT_CALLBACK = "INSERT INTO callback (conversationID, warehouse_role, manufacturer_role) VALUES(?, ?, ?)";
    private final String QUERY_CALLBACK = "SELECT warehouse_role, manufacturer_role from callback where conversationID=?";
    private static DBConnectionPool thePool = null;
    private PreparedStatement loggingInsertStatement = null;
    private PreparedStatement loggingQueryStatement = null;
    private PreparedStatement callbackInsertStatement = null;
    private PreparedStatement callbackQueryStatement = null;
    public static final int LOGGING = 0;
    public static final int CALLBACK = 1;
    private final String CALLBACK_TABLE = "Callback";
    private final String LOGGING_TABLE = "Logging";
    private Connection connection = null;
    private Logger logger = Logger.getLogger("com.sun.wsi.scm", "com.sun.wsi.scm.resources.resources_en");
    private static ServletContext servletContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DBConnectionPool(ServletContext servletContext) {
        super();
        statement = null;
        try {
            block22: {
                is = servletContext.getResourceAsStream("/conf/db.props");
                dbProps = new Properties();
                dbProps.load(is);
                dbDriver = dbProps.getProperty("db.driver");
                dbUrl = dbProps.getProperty("db.url");
                dbUsername = dbProps.getProperty("db.username");
                dbPassword = dbProps.getProperty("db.password");
                dbTableExistProp = dbProps.getProperty("db.table.exist");
                if (dbDriver != null && dbUrl != null && dbUsername != null && dbPassword != null && dbTableExistProp != null) break block22;
                this.logger.log(Level.SEVERE, "db.file.corrupted");
                var14_14 = null;
                ** GOTO lbl137
            }
            this.logger.log(Level.CONFIG, "db.driver", dbDriver);
            this.logger.log(Level.CONFIG, "db.url", dbUrl);
            this.logger.log(Level.CONFIG, "db.username", dbUsername);
            this.logger.log(Level.CONFIG, "db.password", dbPassword);
            this.logger.log(Level.CONFIG, "db.tableExist", dbTableExistProp);
            dbTableExist = Integer.parseInt(dbTableExistProp);
            Class.forName(dbDriver);
            this.connection = DriverManager.getConnection(dbUrl, dbUsername, dbPassword);
            dbMetadata = this.connection.getMetaData();
            this.logger.log(Level.INFO, "db.product.info", new String[]{dbMetadata.getDatabaseProductName(), dbMetadata.getDatabaseProductVersion()});
            this.logger.log(Level.INFO, "db.driver.info", new String[]{dbMetadata.getDriverName(), dbMetadata.getDriverVersion()});
            statement = this.connection.createStatement();
            try {
                statement.executeUpdate("CREATE TABLE log (DemoUserID VARCHAR(255), ServiceID VARCHAR(255), EventID VARCHAR(255), EventDescription VARCHAR(255), Timestamp TIMESTAMP)");
                this.logger.log(Level.INFO, "db.tableCreated", "Logging");
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == dbTableExist) {
                    this.logger.log(Level.WARNING, "db.tableExisted", "Logging");
                }
                ex.printStackTrace();
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            try {
                statement.executeUpdate("CREATE TABLE callback (conversationID VARCHAR(255), warehouse_role VARCHAR(255), manufacturer_role VARCHAR(255))");
                this.logger.log(Level.INFO, "db.tableCreated", "Callback");
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == dbTableExist) {
                    this.logger.log(Level.WARNING, "db.tableExisted", "Callback");
                }
                ex.printStackTrace();
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.loggingInsertStatement = this.connection.prepareStatement("INSERT INTO log (DemoUserID, ServiceID, EventID, EventDescription, Timestamp) VALUES(?, ?, ?, ?, ?)");
            this.loggingQueryStatement = this.connection.prepareStatement("SELECT DemoUserID, ServiceID, EventID, EventDescription, Timestamp from log where DemoUserID=?");
            this.callbackInsertStatement = this.connection.prepareStatement("INSERT INTO callback (conversationID, warehouse_role, manufacturer_role) VALUES(?, ?, ?)");
            this.callbackQueryStatement = this.connection.prepareStatement("SELECT warehouse_role, manufacturer_role from callback where conversationID=?");
            ** GOTO lbl145
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            var14_16 = null;
            try {
                if (statement == null) return;
                statement.close();
                return;
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return;
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            var14_17 = null;
            try {}
            catch (SQLException ex) {
                ex.printStackTrace();
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return;
            }
            if (statement == null) return;
            statement.close();
            return;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            var14_18 = null;
            try {}
            catch (SQLException ex) {
                ex.printStackTrace();
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return;
            }
            if (statement == null) return;
            statement.close();
            return;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            var14_19 = null;
            try {}
            catch (SQLException ex) {
                ex.printStackTrace();
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
                return;
            }
            if (statement == null) return;
            statement.close();
            return;
        }
        {
            catch (Throwable var13_32) {
                var14_20 = null;
                ** try [egrp 4[TRYBLOCK] [17 : 728->741)] { 
lbl130:
                // 1 sources

                if (statement == null) throw var13_32;
                statement.close();
                throw var13_32;
lbl133:
                // 1 sources

                catch (SQLException ex) {
                    ex.printStackTrace();
                    this.logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                throw var13_32;
            }
lbl137:
            // 1 sources

            ** try [egrp 4[TRYBLOCK] [17 : 728->741)] { 
lbl138:
            // 1 sources

            if (statement == null) return;
            statement.close();
            return;
lbl141:
            // 1 sources

            catch (SQLException ex) {
                ex.printStackTrace();
                this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            return;
lbl145:
            // 1 sources

            var14_15 = null;
            try {}
            catch (SQLException ex) {}
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
            return;
            if (statement == null) return;
            statement.close();
            return;
        }
    }

    public static DBConnectionPool getInstance(Object context) {
        if (thePool == null) {
            servletContext = ((ServletEndpointContext)context).getServletContext();
            thePool = new DBConnectionPool(servletContext);
        }
        return thePool;
    }

    public synchronized void insert(int table, Vector setters) {
        try {
            if (this.connection.isClosed()) {
                this.logger.log(Level.WARNING, "db.connectionAgain");
                thePool = new DBConnectionPool(servletContext);
            }
            int rowCount = 0;
            if (table == 0) {
                for (int i = 0; i < setters.size() - 1; ++i) {
                    this.loggingInsertStatement.setString(i + 1, (String)setters.get(i));
                }
                this.loggingInsertStatement.setTimestamp(5, (Timestamp)setters.get(4));
                rowCount = this.loggingInsertStatement.executeUpdate();
                this.logger.log(Level.FINEST, "db.rowUpdated", new String[]{String.valueOf(rowCount), "Logging"});
            } else if (table == 1) {
                for (int i = 0; i < setters.size(); ++i) {
                    this.callbackInsertStatement.setString(i + 1, (String)setters.get(i));
                }
                rowCount = this.callbackInsertStatement.executeUpdate();
                this.logger.log(Level.FINEST, "db.rowUpdated", new String[]{String.valueOf(rowCount), "Callback"});
            } else {
                this.logger.log(Level.SEVERE, "db.tableUnknown", String.valueOf(table));
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            this.logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized ArrayList query(int table, Vector setters) {
        ArrayList<Object> list;
        block19: {
            ResultSet rs;
            block18: {
                list = new ArrayList<Object>();
                rs = null;
                if (this.connection.isClosed()) {
                    this.logger.log(Level.WARNING, "db.connectionAgain");
                    thePool = new DBConnectionPool(servletContext);
                }
                if (table == 0) {
                    this.logger.log(Level.FINEST, "db.queryTable", "Logging");
                    for (int i = 0; i < setters.size(); ++i) {
                        this.loggingQueryStatement.setString(i + 1, (String)setters.get(i));
                    }
                    rs = this.loggingQueryStatement.executeQuery();
                    Calendar cal = Calendar.getInstance();
                    while (rs.next()) {
                        LogEntry logEntry = new LogEntry();
                        logEntry.setServiceID(rs.getString(2));
                        logEntry.setEventID(rs.getString(3));
                        logEntry.setEventDescription(rs.getString(4));
                        cal.setTimeInMillis(rs.getTimestamp(5).getTime());
                        logEntry.setTimestamp(cal);
                        list.add(logEntry);
                    }
                    break block18;
                }
                if (table == 1) {
                    this.logger.log(Level.FINEST, "db.queryTable", "Callback");
                    for (int i = 0; i < setters.size(); ++i) {
                        this.callbackQueryStatement.setString(i + 1, (String)setters.get(i));
                    }
                    rs = this.callbackQueryStatement.executeQuery();
                    while (rs.next()) {
                        list.add(rs.getString(1));
                        list.add(rs.getString(2));
                    }
                    break block18;
                }
                this.logger.log(Level.SEVERE, "db.tableUnknown", String.valueOf(table));
            }
            Object var8_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
                break block19;
            }
            catch (SQLException ex2) {
                ex2.printStackTrace();
                this.logger.log(Level.SEVERE, ex2.getMessage(), ex2);
            }
            break block19;
            {
                catch (SQLException ex) {
                    ex.printStackTrace();
                    this.logger.log(Level.SEVERE, ex.getMessage(), ex);
                    Object var8_11 = null;
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        break block19;
                    }
                    catch (SQLException ex2) {
                        ex2.printStackTrace();
                        this.logger.log(Level.SEVERE, ex2.getMessage(), ex2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException ex2) {
                    ex2.printStackTrace();
                    this.logger.log(Level.SEVERE, ex2.getMessage(), ex2);
                }
                throw throwable;
            }
        }
        return list;
    }
}

