/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wsi.scm.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;

public class AttachmentHelper {
    protected Hashtable attachments = null;
    protected Logger logger = null;

    public AttachmentHelper() {
    }

    public AttachmentHelper(Collection attachments) {
        this.setAttachments(attachments);
    }

    public AttachmentHelper(Collection attachments, Logger logger) {
        this(attachments);
        this.logger = logger;
    }

    public void setAttachments(Collection attachments) {
        this.attachments = new Hashtable();
        Iterator iter = attachments.iterator();
        while (iter.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)iter.next();
            this.attachments.put(attachmentPart.getContentId(), attachmentPart);
        }
    }

    public void set_logger(Logger logger) {
        this.logger = logger;
    }

    public DataHandler search(String contentId) throws SOAPException {
        DataHandler dataHandler = null;
        if (this.attachments != null && this.attachments.containsKey(contentId)) {
            AttachmentPart attachment = (AttachmentPart)this.attachments.get(contentId);
            dataHandler = new DataHandler(attachment.getContent(), attachment.getContentType());
            if (this.logger != null) {
                this.logger.log(Level.FINE, "catalog.client.registry.found", contentId);
            }
        } else if (this.logger != null) {
            this.logger.log(Level.WARNING, "catalog.client.registry.notfound", contentId);
        }
        return dataHandler;
    }

    Enumeration keys() {
        return this.attachments.keys();
    }
}

