/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.cli.commands.BaseNodeAgentCommand;
import com.sun.enterprise.ee.nodeagent.NodeAgent;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.net.NetUtils;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CreateNodeAgentCommand
extends BaseNodeAgentCommand {
    private static final String AGENT_USER = "agentuser";
    private static final String AGENT_PASSWD = "agentpassword";
    private static final String AGENT_PORT = "agentport";
    private static final String ADMIN_HOST = "adminhost";
    private static final String AGENT_PROPERTIES = "agentproperties";
    private static final StringManager _strMgr = StringManager.getManager((Class)CreateNodeAgentCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rendezvousWithDAS(AgentConfig config, Properties props) throws Exception {
        String rendezvous = props.getProperty("attemptRendezvous", "true");
        String localRendezvous = props.getProperty("attemptLocalRendezvous", "false");
        boolean bRendezvous = new Boolean(rendezvous);
        boolean bLocalRendezvous = new Boolean(localRendezvous);
        if (bRendezvous || bLocalRendezvous) {
            boolean bDidRendezvous = false;
            NodeAgent agent = new NodeAgent(config);
            Logger naLogger = agent.getLogger();
            Level naLevel = naLogger.getLevel();
            if (!CLILogger.isDebug()) {
                naLogger.setLevel(Level.OFF);
            } else {
                naLogger.setLevel(Level.FINEST);
            }
            try {
                IdentityManager.setUser((String)((String)config.get((Object)"agent.das.user")));
                IdentityManager.setPassword((String)((String)config.get((Object)"agent.das.password")));
                IdentityManager.setMasterPassword((String)((String)config.get((Object)"agent.masterpassword")));
                if (bRendezvous) {
                    try {
                        agent.rendezvousWithDAS();
                    }
                    catch (Exception ex) {
                        if (!(ex instanceof IOException)) {
                            throw ex;
                        }
                        bDidRendezvous = false;
                    }
                }
                if (!bDidRendezvous && bLocalRendezvous) {
                    agent.localRendezvousWithDAS();
                }
            }
            finally {
                naLogger.setLevel(naLevel);
            }
        }
    }

    protected int getAdminPort() throws CommandValidationException {
        String adminPortStr = this.getOption(AGENT_PORT);
        int adminPort = adminPortStr == null ? NetUtils.getFreePort() : this.convertPortStr(adminPortStr);
        if (!NetUtils.isPortFree((int)adminPort)) {
            throw new CommandValidationException(_strMgr.getString("AdminPortInUse", (Object)adminPortStr));
        }
        CLILogger.getInstance().printDebugMessage("agentPort =" + adminPort);
        return adminPort;
    }

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String agentDirValue = this.getOption("agentdir");
        if (agentDirValue != null && !this.isWindows() && this.isSpaceInPath(agentDirValue)) {
            throw new CommandException(this.getLocalizedString("SpaceNotAllowedInPath", new Object[]{"agentdir"}));
        }
        String agentName = null;
        try {
            agentName = this.operands.isEmpty() ? NetUtils.getHostName() : (String)this.operands.firstElement();
            CLILogger.getInstance().printDebugMessage("agentName = " + agentName);
            AgentConfig agentConfig = new AgentConfig(agentName, this.getAgentPath());
            AgentManager manager = this.getAgentManager(agentConfig);
            manager.validateNodeAgent(agentConfig, false);
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
        try {
            Properties agentProperties = this.getAgentProperties(this.getOption(AGENT_PROPERTIES));
            String adminUser = this.getUser();
            String adminPassword = this.getPassword();
            this.setOption("adminpassword", adminPassword);
            String masterPassword = this.getMasterPassword(false, true);
            String adminPort = String.valueOf(this.getPort());
            String adminHost = this.getHost();
            Boolean saveMasterPassword = this.getSaveMasterPassword(masterPassword);
            if (!this.getBooleanOption("secure")) {
                agentProperties.setProperty("isDASSecure", "false");
            }
            if (adminHost == null || adminPort == null || adminUser == null || adminPassword == null) {
                throw new CommandValidationException(_strMgr.getString("InvalidDASConfiguration"));
            }
            AgentConfig agentConfig = new AgentConfig(agentName, this.getAgentPath(), adminUser, adminPassword, new Integer(this.getAdminPort()), adminHost, adminPort, adminUser, adminPassword, masterPassword, saveMasterPassword, agentProperties);
            AgentManager manager = this.getAgentManager(agentConfig);
            manager.createNodeAgent();
            try {
                this.rendezvousWithDAS(agentConfig, agentProperties);
            }
            catch (Exception ex) {
                try {
                    manager.deleteNodeAgent();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw ex;
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
    }

    protected Properties getAgentProperties(String propertyValues) throws CommandException, CommandValidationException {
        Properties propertyList = new Properties();
        if (propertyValues == null) {
            return propertyList;
        }
        StringTokenizer st = new StringTokenizer(propertyValues, ":");
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            while (st.hasMoreTokens() && propertyString.endsWith(Character.toString('\\'))) {
                propertyString = propertyString.substring(0, propertyString.length() - 1);
                propertyString = propertyString.concat(":" + st.nextToken());
            }
            int index = propertyString.indexOf(Character.toString('='));
            if (index == -1) {
                throw new CommandValidationException(_strMgr.getString("InvalidPropertySyntax"));
            }
            String propertyName = propertyString.substring(0, index);
            String propertyValue = propertyString.substring(index + 1);
            propertyList.put(propertyName, propertyValue);
        }
        CLILogger.getInstance().printDebugMessage("agent properties = " + propertyList);
        return propertyList;
    }
}

