/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.cli.commands.GenericCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.ee.util.zip.Unzipper;
import com.sun.enterprise.util.i18n.StringManager;

public class ApplyRepositoryZipCommand
extends GenericCommand {
    private static final String ROOT_DIR = "rootdir";
    private static final String TARGET = "target";
    private static final StringManager _strMgr = StringManager.getManager((Class)ApplyRepositoryZipCommand.class);

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String rootDir = null;
        String target = null;
        String zip = null;
        try {
            rootDir = this.getOption(ROOT_DIR);
            target = this.getOption(TARGET);
            if (!this.operands.isEmpty()) {
                zip = (String)this.operands.firstElement();
            }
            if (rootDir == null || target == null || zip == null) {
                throw new CommandValidationException(_strMgr.getString("InvalaidApplyRepositoryCommandConfiguration"));
            }
            if (rootDir.indexOf(target) <= 0) {
                throw new CommandValidationException(_strMgr.getString("InvalaidRootDir", new Object[]{rootDir, target}));
            }
            Unzipper z = new Unzipper(rootDir);
            z.writeZipFile(zip);
            CLILogger.getInstance().printDetailMessage(_strMgr.getString("ApplyRepositoryZipCommandSuccessful", new Object[]{this.name, zip}));
        }
        catch (Exception e) {
            e.printStackTrace();
            CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            throw new CommandException(_strMgr.getString("ApplyRepositoryZipCommandFailed", new Object[]{this.name}), (Throwable)e);
        }
    }
}

