/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.LocalStringsManager;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class SunJspc
extends MatchingTask {
    private File destDir = null;
    private File srcDir;
    private String packageName;
    private String verboseLevel;
    private File uriRoot;
    private File uriBase;
    private Path classPath;
    private int compileListLength;
    private boolean failOnError = true;
    private File webAppBaseDir;
    private File sunoneHome;
    private File asinstalldir;
    private static final String[] CLASSPATH_ELEMENTS = new String[]{"lib/appserv-rt.jar", "lib/j2ee.jar", "lib/appserv-ext.jar"};
    LocalStringsManager lsm = new LocalStringsManager();

    public void setSunonehome(File sunoneHome) {
        String msg = this.lsm.getString("DeprecatedAttribute", new Object[]{"sunonehome", "asinstalldir"});
        this.log(msg, 1);
        this.asinstalldir = sunoneHome;
    }

    public void setAsinstalldir(File asinstalldir) {
        this.asinstalldir = asinstalldir;
    }

    protected File getAsinstalldir() throws ClassNotFoundException {
        if (this.asinstalldir == null) {
            String home = this.getProject().getProperty("asinstall.dir");
            if (home != null) {
                this.asinstalldir = new File(home);
            } else {
                home = this.getProject().getProperty("sunone.home");
                if (home != null) {
                    String msg = this.lsm.getString("DeprecatedProperty", new Object[]{"sunone.home", "asinstall.dir"});
                    this.log(msg, 1);
                    this.asinstalldir = new File(home);
                }
            }
        }
        if (this.asinstalldir != null) {
            this.verifyAsinstalldir(this.asinstalldir);
        }
        return this.asinstalldir;
    }

    private boolean verifyAsinstalldir(File home) throws ClassNotFoundException {
        if (home != null && home.isDirectory() && new File(home, "config").isDirectory()) {
            return true;
        }
        throw new ClassNotFoundException("ClassCouldNotBeFound");
    }

    public void setDestdir(File dest) {
        this.destDir = dest;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setSrcdir(File src) {
        this.srcDir = src;
    }

    public File getSrcdir() {
        return this.srcDir;
    }

    public void setPackage(String name) {
        this.packageName = name;
    }

    public String getPackage() {
        return this.packageName;
    }

    public void setVerbose(String level) {
        this.verboseLevel = level;
    }

    public String getVerbose() {
        return this.verboseLevel;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public void setUribase(File base) {
        this.uriBase = base;
    }

    public File getUribase() {
        if (this.uriBase != null) {
            return this.uriBase;
        }
        return this.uriRoot;
    }

    public void setUriroot(File root) {
        this.uriRoot = root;
    }

    public File getUriroot() {
        return this.uriRoot;
    }

    public void setClasspath(Path cp) {
        if (this.classPath == null) {
            this.classPath = cp;
        } else {
            this.classPath.append(cp);
        }
    }

    public Path createClasspath() {
        if (this.classPath == null) {
            this.classPath = new Path(this.project);
        }
        return this.classPath.createPath();
    }

    public void setClasspathref(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public void setWebapp(File baseDir) {
        this.webAppBaseDir = baseDir;
    }

    public File getWebapp() {
        return this.webAppBaseDir;
    }

    public void execute() throws BuildException {
        this.CheckForMutuallyExclusiveAttribute();
        if (this.webAppBaseDir == null) {
            if (this.srcDir == null) {
                throw new BuildException(this.lsm.getString("SourceDirectoryProviced"), this.location);
            }
            if (!this.srcDir.exists() || !this.srcDir.isDirectory()) {
                throw new BuildException(this.lsm.getString("SourceDirectoryDoesNotExist", new Object[]{this.srcDir.getAbsolutePath()}), this.location);
            }
        } else if (!this.webAppBaseDir.exists() || !this.webAppBaseDir.isDirectory()) {
            throw new BuildException(this.lsm.getString("WebAppDirectoryDoesNotExist", new Object[]{this.webAppBaseDir.getAbsolutePath()}), this.location);
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException(this.lsm.getString("DestinationDirectoryDoesNotExist", new Object[]{this.destDir}));
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException(this.lsm.getString("InvalidDestinationDirectory", new Object[]{this.destDir}));
            }
        } else {
            throw new BuildException(this.lsm.getString("DestinationDirectoryNoProvided"));
        }
        String[] args = this.getCommandString();
        if (this.srcDir != null) {
            this.log(this.lsm.getString("PreCompilation", new Object[]{String.valueOf(this.compileListLength), this.destDir.getAbsolutePath()}));
        }
        if (!this.doCompilation(args)) {
            throw new BuildException(this.lsm.getString("CompilationFailed"));
        }
    }

    private void CheckForMutuallyExclusiveAttribute() throws BuildException {
        if (this.webAppBaseDir != null && this.srcDir != null) {
            String msg = this.lsm.getString("MutuallyExclusivelyAttribute", new Object[]{"srcdir", "webapp"});
            throw new BuildException(msg, this.getLocation());
        }
    }

    protected boolean doCompilation(String[] args) {
        try {
            Java java = (Java)this.project.createTask("java");
            java.setClasspath(this.constructPath());
            java.setClassname("org.apache.jasper.JspC");
            for (int i = 0; i < args.length; ++i) {
                java.createArg().setValue(args[i]);
            }
            java.setFailonerror(this.failOnError);
            java.setFork(true);
            this.log("Executing Jasper Compiler");
            int returnCode = java.executeJava();
            if (returnCode == 1) {
                this.log(this.lsm.getString("SetVerbose"));
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.log(this.lsm.getString("ExceptionMessage", new Object[]{ex.toString()}));
            return false;
        }
    }

    protected String[] getCommandString() {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("-d");
        commandList.add(this.destDir.getAbsolutePath());
        if (this.packageName != null && this.packageName.length() > 0) {
            commandList.add("-p");
            commandList.add(this.packageName);
        }
        if (this.verboseLevel != null) {
            commandList.add("-v".concat(this.verboseLevel));
        }
        if (this.uriRoot != null && this.uriRoot.exists()) {
            commandList.add("-uriroot");
            commandList.add(this.uriRoot.getAbsolutePath());
        }
        if (this.uriBase != null && this.uriBase.exists()) {
            commandList.add("-uribase");
            commandList.add(this.uriBase.getAbsolutePath());
        } else if (this.uriRoot != null && this.uriRoot.exists()) {
            commandList.add("-uribase");
            commandList.add(this.uriRoot.getAbsolutePath());
        }
        commandList.add("-die1");
        if (this.webAppBaseDir != null) {
            commandList.add("-webapp");
            commandList.add(this.webAppBaseDir.getAbsolutePath());
        } else {
            DirectoryScanner ds = super.getDirectoryScanner(this.srcDir);
            String[] files = ds.getIncludedFiles();
            this.compileListLength = files.length;
            for (int i = 0; i < files.length; ++i) {
                File tempFile = new File(this.srcDir, files[i]);
                commandList.add(tempFile.getAbsolutePath());
            }
        }
        String[] args = commandList.toArray(new String[commandList.size()]);
        return args;
    }

    private Path constructPath() throws ClassNotFoundException {
        StringBuffer classPathBuffer = new StringBuffer();
        if (this.getAsinstalldir() != null) {
            for (int i = 0; i < CLASSPATH_ELEMENTS.length; ++i) {
                classPathBuffer.append(new File(this.getAsinstalldir(), CLASSPATH_ELEMENTS[i]).getPath());
                classPathBuffer.append(":");
            }
        }
        if (this.classPath != null) {
            classPathBuffer.append(this.classPath);
            classPathBuffer.append(":");
        }
        classPathBuffer.append(Path.systemClasspath);
        return new Path(this.getProject(), classPathBuffer.toString());
    }
}

