/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server;

import com.sun.appserv.server.LifecycleListener;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycleModule;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.server.ServerContext;
import com.sun.web.security.RealmAdapter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.catalina.Context;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;

public final class LifecycleModuleService
implements ServerLifecycle {
    private ArrayList listeners = new ArrayList();
    private Context invocationContext;

    public synchronized void onInitialization(ServerContext context) throws ServerLifecycleException {
        try {
            Applications apps = ServerBeansFactory.getApplicationsBean((ConfigContext)context.getConfigContext());
            if (apps == null) {
                return;
            }
            LifecycleModule[] lcms = apps.getLifecycleModule();
            if (lcms == null) {
                return;
            }
            HashSet<ServerLifecycleModule> listenerSet = new HashSet<ServerLifecycleModule>();
            for (int i = 0; i < lcms.length; ++i) {
                LifecycleModule next = lcms[i];
                if (!this.isEnabled(next, context.getConfigContext())) continue;
                int order = Integer.MAX_VALUE;
                String strOrder = next.getLoadOrder();
                if (strOrder != null) {
                    try {
                        order = Integer.parseInt(strOrder);
                    }
                    catch (NumberFormatException nfe) {
                        nfe.printStackTrace();
                    }
                }
                ServerLifecycleModule slcm = new ServerLifecycleModule(context, next.getName(), next.getClassName());
                slcm.setLoadOrder(order);
                slcm.setClasspath(next.getClasspath());
                slcm.setIsFatal(next.isIsFailureFatal());
                ElementProperty[] s = next.getElementProperty();
                if (s != null) {
                    for (int j = 0; j < s.length; ++j) {
                        ElementProperty next1 = s[j];
                        slcm.setProperty(next1.getName(), next1.getValue());
                    }
                }
                LifecycleListener listener = slcm.loadServerLifecycle();
                listenerSet.add(slcm);
            }
            this.sortModules(listenerSet);
        }
        catch (Exception ce1) {
            ce1.printStackTrace();
        }
        this.initialize(context);
    }

    private boolean isEnabled(LifecycleModule lcm, ConfigContext config) {
        try {
            if (lcm == null || config == null) {
                return false;
            }
            Server server = ServerBeansFactory.getServerBean((ConfigContext)config);
            ApplicationRef appRef = server.getApplicationRefByRef(lcm.getName());
            return lcm.isEnabled() && appRef != null && appRef.isEnabled();
        }
        catch (ConfigException e) {
            return false;
        }
    }

    private void resetClassLoader(final ClassLoader c) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread.currentThread().setContextClassLoader(c);
                return null;
            }
        });
    }

    private void sortModules(HashSet listenerSet) {
        Iterator iter = listenerSet.iterator();
        while (iter.hasNext()) {
            int i;
            ServerLifecycleModule next = (ServerLifecycleModule)iter.next();
            int order = next.getLoadOrder();
            for (i = 0; i < this.listeners.size() && ((ServerLifecycleModule)this.listeners.get(i)).getLoadOrder() <= order; ++i) {
            }
            this.listeners.add(i, next);
        }
    }

    private void initialize(ServerContext context) throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ServerLifecycleModule next = (ServerLifecycleModule)iter.next();
            next.onInitialization(context);
        }
        this.resetClassLoader(cl);
    }

    public void onStartup(ServerContext context) throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.invocationContext = new StandardContext();
        WebBundleDescriptor wbd = new WebBundleDescriptor();
        wbd.setApplication(new Application());
        this.invocationContext.setRealm((Realm)new RealmAdapter(wbd));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ServerLifecycleModule next = (ServerLifecycleModule)iter.next();
            next.onStartup(context, this.invocationContext);
        }
        this.resetClassLoader(cl);
    }

    public void onReady(ServerContext context) throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ServerLifecycleModule next = (ServerLifecycleModule)iter.next();
            next.onReady(context);
        }
        this.resetClassLoader(cl);
    }

    public void onShutdown() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ServerLifecycleModule next = (ServerLifecycleModule)iter.next();
            next.onShutdown();
        }
        this.resetClassLoader(cl);
    }

    public void onTermination() throws ServerLifecycleException {
        if (this.listeners.isEmpty()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ServerLifecycleModule next = (ServerLifecycleModule)iter.next();
            next.onTermination();
        }
        this.resetClassLoader(cl);
    }
}

