/*
 * Decompiled with CFR 0.152.
 */
package com.sun.httpservice.spi.monitor;

public class StatsCache {
    private long _lastUpdate = 0L;
    private long _cacheRefresh = 5000L;
    private boolean _cacheEnabled = true;
    private static StatsCache _cache = null;

    private StatsCache() {
    }

    public static synchronized StatsCache getStatsCache() {
        if (_cache == null) {
            _cache = new StatsCache();
        }
        return _cache;
    }

    public synchronized boolean needUpdateCache() {
        if (!this._cacheEnabled) {
            return true;
        }
        long currentTime = System.currentTimeMillis();
        return currentTime - this._lastUpdate >= this._cacheRefresh;
    }

    public synchronized boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public synchronized void enableCache(long cacheRefresh) {
        this._cacheRefresh = cacheRefresh;
        this._cacheEnabled = true;
    }

    public synchronized void enableCache() {
        this._cacheEnabled = true;
    }

    public synchronized void disableCache() {
        this._cacheEnabled = false;
    }

    public synchronized void setLastUpdate(long lastUpdate) {
        this._lastUpdate = lastUpdate;
    }
}

