/*
 * Decompiled with CFR 0.152.
 */
package com.sun.httpservice.spi.monitor;

import com.sun.httpservice.spi.HttpServiceLogger;
import com.sun.httpservice.spi.HttpServiceSPIException;
import com.sun.httpservice.spi.monitor.BaseMB;
import com.sun.httpservice.spi.monitor.ConnectionQueueMB;
import com.sun.httpservice.spi.monitor.DnsMB;
import com.sun.httpservice.spi.monitor.FileCacheMB;
import com.sun.httpservice.spi.monitor.HttpServiceMB;
import com.sun.httpservice.spi.monitor.KeepAliveMB;
import com.sun.httpservice.spi.monitor.MonitoringEventListener;
import com.sun.httpservice.spi.monitor.ProfileMB;
import com.sun.httpservice.spi.monitor.RequestMB;
import com.sun.httpservice.spi.monitor.StatsCache;
import com.sun.httpservice.spi.monitor.StatsUnmarshaller;
import com.sun.httpservice.spi.monitor.ThreadPoolMB;
import com.sun.httpservice.spi.monitor.VirtualServerMB;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class MBManager {
    private static MBManager manager = null;
    private HttpServiceMB httpServiceMB;
    private StatsUnmarshaller unmarshaller;
    private StatsCache cache = StatsCache.getStatsCache();
    private ArrayList monitoringListeners = null;

    private MBManager() {
    }

    public static synchronized MBManager getMBManager() {
        if (manager == null) {
            manager = new MBManager();
        }
        return manager;
    }

    protected synchronized void initMonitoring() {
        try {
            this.unmarshaller = StatsUnmarshaller.getInstance();
        }
        catch (HttpServiceSPIException ex) {
            HttpServiceLogger.log(3, "httpservice.monitor.exception.init.unmarshaller", ex);
            HttpServiceLogger.log(0, "httpservice.monitor.not.inited");
            return;
        }
        try {
            HttpServiceLogger.log(6, "httpservice.monitor.initializing");
            this.httpServiceMB = this.unmarshaller.getHttpServiceStats();
            this.cache.setLastUpdate(System.currentTimeMillis());
            this.registerBeans();
            HttpServiceLogger.log(6, "httpservice.monitor.initializing.done");
        }
        catch (HttpServiceSPIException ex) {
            HttpServiceLogger.log(3, "httpservice.monitor.exception.initialization", ex);
            HttpServiceLogger.log(0, "httpservice.monitor.not.inited");
        }
    }

    protected synchronized void updateStats(BaseMB bean) {
        if (!this.cache.isCacheEnabled()) {
            this.updateBeanStats(bean);
            return;
        }
        if (!this.cache.needUpdateCache()) {
            return;
        }
        try {
            this.unmarshaller.updateHttpServiceStatsTree(this.httpServiceMB);
            this.cache.setLastUpdate(System.currentTimeMillis());
        }
        catch (HttpServiceSPIException ex) {
            HttpServiceLogger.log(0, "httpservice.monitor.exception.update.cache", ex);
        }
    }

    private void updateBeanStats(BaseMB bean) {
        try {
            if (bean instanceof HttpServiceMB) {
                this.unmarshaller.updateHttpServiceStats((HttpServiceMB)bean);
            } else if (bean instanceof ConnectionQueueMB) {
                this.unmarshaller.updateConnectionQueueStats((ConnectionQueueMB)bean);
            } else if (bean instanceof DnsMB) {
                this.unmarshaller.updateDnsStats((DnsMB)bean);
            } else if (bean instanceof FileCacheMB) {
                this.unmarshaller.updateFileCacheStats((FileCacheMB)bean);
            } else if (bean instanceof KeepAliveMB) {
                this.unmarshaller.updateKeepAliveStats((KeepAliveMB)bean);
            } else if (bean instanceof ProfileMB) {
                this.unmarshaller.updateProfileStats((ProfileMB)bean);
            } else if (bean instanceof RequestMB) {
                this.unmarshaller.updateRequestStats((RequestMB)bean);
            } else if (bean instanceof ThreadPoolMB) {
                this.unmarshaller.updateThreadPoolStats((ThreadPoolMB)bean);
            } else if (bean instanceof VirtualServerMB) {
                this.unmarshaller.updateVirtualServerStats((VirtualServerMB)bean);
            }
        }
        catch (HttpServiceSPIException ex) {
            HttpServiceLogger.log(0, "httpservice.monitor.exception.update.bean", ex);
        }
    }

    protected synchronized void restartMonitoring() {
        HttpServiceLogger.log(6, "httpservice.monitor.restart");
        this.unregisterBeans();
        try {
            this.unmarshaller = StatsUnmarshaller.getInstance();
            this.cache = StatsCache.getStatsCache();
        }
        catch (HttpServiceSPIException ex) {
            HttpServiceLogger.log(3, "httpservice.monitor.exception.init.unmarshaller", ex);
            return;
        }
        try {
            this.httpServiceMB = this.unmarshaller.getHttpServiceStats();
            this.cache.setLastUpdate(System.currentTimeMillis());
            this.registerBeans();
            HttpServiceLogger.log(6, "httpservice.monitor.restart.done");
        }
        catch (HttpServiceSPIException ex) {
            HttpServiceLogger.log(3, "httpservice.monitor.exception.reconfig.beans", ex);
        }
    }

    protected synchronized void serviceStopped() {
        this.unregisterBeans();
    }

    private void registerBeans() {
        List listeners = this.getMonitoringListeners();
        if (listeners == null || listeners.size() < 1) {
            return;
        }
        Iterator listenerIt = listeners.iterator();
        MonitoringEventListener l = null;
        while (listenerIt.hasNext()) {
            l = (MonitoringEventListener)listenerIt.next();
            l.addedBeanEvent(this.httpServiceMB);
        }
    }

    private void unregisterBeans() {
        List listeners = this.getMonitoringListeners();
        if (listeners == null || listeners.size() < 1) {
            return;
        }
        Iterator listenerIt = listeners.iterator();
        MonitoringEventListener l = null;
        while (listenerIt.hasNext()) {
            l = (MonitoringEventListener)listenerIt.next();
            l.removedBeanEvent(this.httpServiceMB);
        }
    }

    private List getMonitoringListeners() {
        return this.monitoringListeners;
    }

    public synchronized void addMonitoringListener(MonitoringEventListener monitor) {
        if (this.monitoringListeners == null) {
            this.monitoringListeners = new ArrayList();
        }
        this.monitoringListeners.add(monitor);
        this.monitoringListeners.trimToSize();
    }

    public synchronized StatsCache getCache() {
        return this.cache;
    }
}

