/*
 * Decompiled with CFR 0.152.
 */
package com.sun.httpservice.spi;

import com.sun.httpservice.spi.LogListener;

public class HttpServiceLogger {
    private static LogListener[] logListeners;

    private HttpServiceLogger() {
    }

    public static void addLogListener(LogListener logListener) {
        if (logListeners == null) {
            logListeners = new LogListener[1];
            HttpServiceLogger.logListeners[0] = logListener;
        } else {
            LogListener[] temp = new LogListener[logListeners.length + 1];
            System.arraycopy(logListeners, 0, temp, 0, logListeners.length);
            temp[HttpServiceLogger.logListeners.length] = logListener;
            logListeners = temp;
        }
    }

    protected static LogListener[] getLogListeners() {
        return logListeners;
    }

    public static void log(int level, String msg) {
        LogListener[] listenerArray = HttpServiceLogger.getLogListeners();
        if (listenerArray == null) {
            System.out.println("WARNING: HttpService can't log messages");
            return;
        }
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].log(level, msg);
        }
    }

    public static void log(int level, String msg, Throwable t) {
        LogListener[] listenerArray = HttpServiceLogger.getLogListeners();
        if (listenerArray == null) {
            System.out.println("WARNING: HttpService can't log messages");
            return;
        }
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].log(level, msg, t);
        }
    }

    public static void log(int level, String msg, Object[] params) {
        LogListener[] listenerArray = HttpServiceLogger.getLogListeners();
        if (listenerArray == null) {
            System.out.println("WARNING: HttpService can't log messages");
            return;
        }
        for (int i = 0; i < listenerArray.length; ++i) {
            listenerArray[i].log(level, msg, params);
        }
    }
}

