/*
 * Decompiled with CFR 0.152.
 */
package com.sun.httpservice.spi;

import com.sun.httpservice.spi.HttpServiceEvent;
import com.sun.httpservice.spi.HttpServiceEventListener;
import com.sun.httpservice.spi.HttpServiceLogger;
import com.sun.httpservice.spi.HttpServiceSPIException;
import java.util.HashSet;

public class HttpServiceLogRotator
implements HttpServiceEventListener {
    public static final int STOPPED = 0;
    public static final int STARTED = 1;
    private int status = 0;
    public static final boolean ROTATION_BY_SIZE_ENABLED = false;
    private long p_rotator;
    private HashSet fileRegistry;
    private byte[] fileRegistryLock = new byte[0];
    private boolean enabled = false;
    private String suffix;
    private int rotationPolicy;
    private long timeInterval;
    private long maxSize;
    public static final int N_TRUE = 1;
    public static final int N_FALSE = 0;
    public static final int ROTATION_DISABLED = 0;
    public static final int ROTATION_BY_SIZE = 1;
    public static final int ROTATION_BY_INTERVAL = 2;

    private native long get_rotator();

    private native int init_rotator(long var1, int var3, int var4, long var5, String[] var7);

    private native int rotate_logs(long var1);

    private native int start(long var1);

    private native int stop(long var1);

    private native int rotate(long var1);

    private native int set_suffix(long var1, String var3);

    protected HttpServiceLogRotator() {
        this.p_rotator = this.get_rotator();
    }

    public int getRotationPolicy() {
        return this.rotationPolicy;
    }

    public void setRotationPolicy(int rotationPolicy) {
        if (rotationPolicy == 1) {
            throw new UnsupportedOperationException("accesslog.rotation.by.size.not.supportted");
        }
        this.rotationPolicy = rotationPolicy;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        this.set_suffix(this.p_rotator, suffix);
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(long maxSize) {
        throw new UnsupportedOperationException("accesslog.rotation.by.size.not.supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getRegisteredFiles() {
        String[] files = null;
        byte[] byArray = this.fileRegistryLock;
        synchronized (this.fileRegistryLock) {
            if (this.fileRegistry == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            files = this.fileRegistry.toArray(new String[0]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return files;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFile(String filename) {
        byte[] byArray = this.fileRegistryLock;
        synchronized (this.fileRegistryLock) {
            if (this.fileRegistry == null) {
                this.fileRegistry = new HashSet();
            }
            this.fileRegistry.add(filename);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFile(String filename) {
        byte[] byArray = this.fileRegistryLock;
        synchronized (this.fileRegistryLock) {
            if (this.fileRegistry == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.fileRegistry.remove(filename);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private void init() throws HttpServiceSPIException {
        String[] filenames;
        long policyParam = this.rotationPolicy == 2 ? this.timeInterval : this.maxSize;
        int returnCode = this.init_rotator(this.p_rotator, 1, this.rotationPolicy, policyParam, filenames = this.getRegisteredFiles());
        if (returnCode != 0) {
            throw new HttpServiceSPIException("couldnot.configure.native.rotator");
        }
    }

    public void stop() throws HttpServiceSPIException {
        if (this.status != 1) {
            throw new HttpServiceSPIException("log.rotation.not.runnning");
        }
        this.stop(this.p_rotator);
        this.status = 0;
    }

    public void start() throws HttpServiceSPIException {
        if (this.status != 0) {
            throw new HttpServiceSPIException("accesslog.rotation.already.runnning");
        }
        if (!this.isEnabled()) {
            throw new HttpServiceSPIException("accesslog.rotation.disabled");
        }
        this.init();
        this.start(this.p_rotator);
        this.status = 1;
    }

    public int getStatus() {
        return this.status;
    }

    public void httpServiceEvent(HttpServiceEvent evt) {
        int eventType = evt.getType();
        switch (eventType) {
            case 0: {
                break;
            }
            case 1: {
                try {
                    this.start();
                }
                catch (HttpServiceSPIException ex) {
                    HttpServiceLogger.log(0, "httpservice.rotator.could_not_start", ex);
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                try {
                    this.stop();
                }
                catch (HttpServiceSPIException ex) {
                    HttpServiceLogger.log(0, "httpservice.rotator.could_not_stop", ex);
                }
                break;
            }
        }
    }

    public void rotate() {
        this.rotate(this.p_rotator);
    }

    static {
        System.loadLibrary("httpservicespi");
    }
}

