/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.httpservice;

import com.sun.enterprise.web.connector.httpservice.HttpServiceConnector;
import com.sun.enterprise.web.connector.httpservice.HttpServiceRequest;
import com.sun.enterprise.web.connector.httpservice.HttpServiceResponse;
import com.sun.enterprise.web.connector.httpservice.HttpServiceResponseStream;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;

public final class HttpServiceProcessor
implements ActionHook {
    private HttpServiceConnector _connector = new HttpServiceConnector();
    private HttpServiceRequest _request = (HttpServiceRequest)this._connector.createRequest();
    private HttpServiceResponse _response = (HttpServiceResponse)this._connector.createResponse();
    private boolean _invokeFromWrapper = false;
    private static Logger _logger = null;
    private static boolean _debugLog;

    public HttpServiceProcessor() {
        this._request.setResponse((Response)this._response);
        this._response.setRequest((Request)this._request);
        this._response.getCoyoteResponse().setHook((ActionHook)this);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
            _debugLog = _logger.isLoggable(Level.FINE);
        }
    }

    public int process(StandardHost vs, String[] rqStrs, byte[][] mbRqStrs, int[] rqInts, StandardContext ctx, String ctxPath, StandardWrapper wrapper, String servletPath, String pathInfo) {
        int rval = -1;
        try {
            try {
                String certString;
                this._connector.setContainer((Container)vs);
                if (this._connector.isXpoweredBy()) {
                    this._response.addHeader("X-Powered-By", "Servlet/2.4");
                }
                this._request.setContext((Context)ctx);
                this._request.setContextPath(ctxPath);
                this._request.initialize(rqStrs, mbRqStrs, rqInts);
                int nativeStreamSize = this._request.getNativeStreamSize();
                this._connector.setInitialSize(nativeStreamSize);
                this._response.setBufferSize(nativeStreamSize);
                HttpServiceResponseStream output = new HttpServiceResponseStream(this._connector);
                this._response.setStream((OutputStream)((Object)output));
                if (_debugLog) {
                    _logger.fine("context = " + ctx);
                    _logger.fine("contextPath = " + ctxPath);
                    _logger.fine("wrapper = " + wrapper);
                    _logger.fine("servletPath = " + servletPath);
                    _logger.fine("pathInfo = " + pathInfo);
                }
                this._request.setAttributes();
                if (this.isClientCertificateNeeded(ctx, this._request) && (certString = this._connector.getCertificate()) != null) {
                    HttpServiceProcessor.attachRequestCertificate(certString, this._request);
                }
                if (wrapper != null) {
                    this._request.setWrapper((Wrapper)wrapper);
                    this._request.setServletPath(servletPath);
                    this._request.setPathInfo(pathInfo);
                    if (pathInfo != null) {
                        this._request.setRequestPath(servletPath + pathInfo);
                    } else {
                        this._request.setRequestPath(servletPath);
                    }
                }
                this.setClientCert(this._connector, this._request);
                if ("TRACE".equalsIgnoreCase(this._request.getMethod()) && !this._connector.getAllowTrace()) {
                    String[] methods;
                    String header = null;
                    if (wrapper != null && (methods = wrapper.getServletMethods()) != null) {
                        for (int i = 0; i < methods.length; ++i) {
                            if ("TRACE".equals(methods[i])) continue;
                            header = header == null ? methods[i] : header + ", " + methods[i];
                        }
                    }
                    this._response.setStatus(405);
                    this._response.addHeader("Allow", header);
                } else {
                    this._connector.getContainer().invoke((Request)this._request, (Response)this._response);
                }
                output.setNativeStreamFlushMode(false);
                this._response.finishResponse();
                if (!this._response.isCommitted()) {
                    this._response.getCoyoteResponse().action(ActionCode.ACTION_COMMIT, null);
                }
                this._request.finishRequest();
                rval = 0;
            }
            catch (Throwable ex) {
                _logger.log(Level.INFO, "httpservice.processor.exception", ex);
                throw new RuntimeException(ex);
            }
            Object var17_17 = null;
            this._request.recycle();
            this._response.recycle();
            this._connector.recycle();
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            this._request.recycle();
            this._response.recycle();
            this._connector.recycle();
            throw throwable;
        }
        return rval;
    }

    public HttpServiceConnector getConnector() {
        return this._connector;
    }

    private boolean isClientCertificateNeeded(StandardContext context, HttpServiceRequest request) {
        String authMethod;
        if (request.getAttribute("javax.servlet.request.X509Certificate") != null) {
            return false;
        }
        LoginConfig loginConfig = context.getLoginConfig();
        return loginConfig != null && "CLIENT-CERT".equalsIgnoreCase(authMethod = loginConfig.getAuthMethod());
    }

    private void setClientCert(HttpServiceConnector connector, HttpServiceRequest request) throws CertificateException {
        String clientCert;
        if (connector.getAuthPassthroughEnabled() && (clientCert = request.getHeader("Proxy-auth-cert")) != null) {
            clientCert = clientCert.replaceAll("% d% a", "\n");
            HttpServiceProcessor.attachRequestCertificate(clientCert, request);
        }
    }

    static void attachRequestCertificate(String clientCert, HttpServiceRequest request) throws CertificateException {
        clientCert = "-----BEGIN CERTIFICATE-----\n" + clientCert + "\n-----END CERTIFICATE-----";
        byte[] certBytes = new byte[clientCert.length()];
        clientCert.getBytes(0, clientCert.length(), certBytes, 0);
        ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate[] certs = new X509Certificate[]{(X509Certificate)cf.generateCertificate(bais)};
        request.setAttribute("javax.servlet.request.X509Certificate", certs);
    }

    public void action(ActionCode actionCode, Object param) {
        if (actionCode == ActionCode.ACTION_COMMIT) {
            try {
                this._response.sendHeaders();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else if (actionCode == ActionCode.ACTION_REQ_LOCAL_NAME_ATTRIBUTE) {
            org.apache.coyote.Request request = (org.apache.coyote.Request)param;
            String ipAddr = request.localAddr().toString();
            String localName = null;
            try {
                localName = InetAddress.getByName(ipAddr).getHostName();
            }
            catch (UnknownHostException ex) {
                _logger.fine("httpservice.processor.not_hostname_by_ip");
                localName = ipAddr;
            }
            request.localName().setString(localName);
        }
    }
}

