/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.httpservice;

import com.sun.enterprise.web.HttpServiceWebContainer;
import com.sun.enterprise.web.connector.coyote.PECoyoteConnector;
import com.sun.enterprise.web.connector.httpservice.HttpServiceRequest;
import com.sun.enterprise.web.connector.httpservice.HttpServiceResponse;
import com.sun.enterprise.web.util.ReaderInputStream;
import com.sun.enterprise.web.util.WriterOutputStream;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Connector;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.core.ApplicationHttpResponse;
import org.apache.catalina.core.ApplicationResponse;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;
import org.apache.coyote.tomcat5.CoyoteResponse;
import org.apache.coyote.tomcat5.CoyoteResponseFacade;

public final class HttpServiceConnector
extends PECoyoteConnector {
    protected static Logger logger = null;
    private long _jniConnector = 0L;
    private int _streamSize = 0;
    private static final String _info = "com.sun.enterprise.web.connector.httpservice.HttpServiceConnector/1.0";
    private int _redirectPort = -1;
    private static StringManager _sm = StringManager.getManager((String)"com.sun.enterprise.web.connector.httpservice");
    private boolean _isClosing = false;
    private String _charsetName = null;

    public HttpServiceConnector() {
        if (logger == null) {
            logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this._charsetName = System.getProperty("com.iplanet.ias.web.connector.nsapi.charset");
    }

    public void setRedirectPort(int redirectPort) {
        this._redirectPort = redirectPort;
    }

    public int getRedirectPort() {
        Integer redirectPort = (Integer)HttpServiceWebContainer.redirectPorts.get(String.valueOf(this.getPort()));
        this._redirectPort = redirectPort != null ? redirectPort : HttpServiceWebContainer.defaultRedirectPort;
        return this._redirectPort;
    }

    public void setJNIConnector(long jniConnector) {
        this._jniConnector = jniConnector;
    }

    public int getConnectionTimeout() {
        return 0;
    }

    public void setClosing() {
        this._isClosing = true;
    }

    public boolean isClosing() {
        return this._isClosing;
    }

    public Request createRequest() {
        HttpServiceRequest request = new HttpServiceRequest();
        request.setConnector((Connector)this);
        return request;
    }

    public Response createResponse() {
        HttpServiceResponse response = new HttpServiceResponse();
        response.setConnector((Connector)this);
        return response;
    }

    public void initialize() {
    }

    void setInitialSize(int size) {
        this._streamSize = size;
    }

    int resize(int newSize) {
        int prevSize = this._streamSize;
        if (newSize != this._streamSize) {
            this._streamSize = newSize;
            this.jniSetSize(this._jniConnector, newSize);
        }
        return prevSize;
    }

    void flush() {
        if (this.isClosing()) {
            this.jniFinishResponse(this._jniConnector);
        } else {
            this.jniFlushResponse(this._jniConnector);
        }
    }

    int readByte() {
        return this.jniReadByte(this._jniConnector);
    }

    int read(byte[] bytes, int offset, int len) {
        return this.jniRead(this._jniConnector, bytes, offset, len);
    }

    int readLine(byte[] bytes, int offset, int len) {
        return this.jniReadLine(this._jniConnector, bytes, offset, len);
    }

    boolean skip(int nbytes) {
        return this.jniSkip(this._jniConnector, nbytes);
    }

    void setAllResponseFields(int status, String message, String contentType, int contentLength, boolean isError, Object[] responseStrs, int numStrs, boolean isMBHeader) {
        this.jniSetAllResponseFields(this._jniConnector, status, message, contentType, contentLength, isError, responseStrs, numStrs, isMBHeader);
    }

    String getCertificate() {
        return this.jniGetCertificate(this._jniConnector);
    }

    void writeByte(byte b) throws IOException {
        if (!this.jniWriteByte(this._jniConnector, b)) {
            throw new IOException(_sm.getString("nsapiConnector.jniWriteByteError"));
        }
    }

    void write(byte[] bytes, int offset, int length) throws IOException {
        if (length > 0 && this.jniWrite(this._jniConnector, bytes, offset, length) != length) {
            throw new IOException(_sm.getString("nsapiConnector.jniWriteError"));
        }
    }

    protected void recycle() {
        this._isClosing = false;
    }

    public static void dispatch(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        HttpServiceConnector connector = HttpServiceConnector.getConnector((ServletRequest)req);
        if (HttpServiceConnector.isIncluded((ServletResponse)res)) {
            connector.include(req, res);
        } else {
            connector.forward(req, res);
        }
    }

    public static void dispatch(HttpServletRequest req, HttpServletResponse res, String allow) throws IOException, ServletException {
        HttpServiceConnector connector = HttpServiceConnector.getConnector((ServletRequest)req);
        if (HttpServiceConnector.isIncluded((ServletResponse)res)) {
            connector.include(req, res);
        } else {
            connector.forward(req, res, allow);
        }
    }

    public void include(HttpServletRequest hreq, HttpServletResponse hres) throws IOException, ServletException {
        OutputStream os = this.getOutputStream(hres);
        String uri = null;
        String query = null;
        uri = (String)hreq.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            query = (String)hreq.getAttribute("javax.servlet.include.query_string");
        } else {
            uri = hreq.getRequestURI();
            query = hreq.getQueryString();
        }
        int status_num = this.jniInclude(this._jniConnector, os, uri, query);
        if (status_num < 100 || status_num > 999) {
            throw new IOException(_sm.getString("nsapiConnector.nsapiError"));
        }
        hres.setStatus(status_num);
        if (status_num == 404) {
            String msg = MessageFormat.format(_sm.getString("nsapiConnector.httpStatus"), Integer.toString(status_num));
            throw new FileNotFoundException(msg);
        }
        if (status_num != 200) {
            String msg = MessageFormat.format(_sm.getString("nsapiConnector.httpStatus"), Integer.toString(status_num));
            throw new ServletException(msg);
        }
    }

    public void forward(HttpServletRequest hreq, HttpServletResponse hres) throws IOException, ServletException {
        this.forward(hreq, hres, null);
    }

    public void forward(HttpServletRequest hreq, HttpServletResponse hres, String allow) throws IOException, ServletException {
        InputStream is = this.getInputStream(hreq);
        OutputStream os = this.getOutputStream(hres);
        String uri = null;
        String query = null;
        uri = (String)hreq.getAttribute("javax.servlet.include.request_uri");
        if (uri != null) {
            query = (String)hreq.getAttribute("javax.servlet.include.query_string");
        } else {
            uri = hreq.getRequestURI();
            query = hreq.getQueryString();
        }
        int status_num = this.jniForward(this._jniConnector, is, os, uri, query, allow);
        if (status_num < 100 || status_num > 999) {
            throw new IOException(_sm.getString("nsapiConnector.nsapiError"));
        }
        if (status_num != 200) {
            hres.setStatus(status_num);
        }
    }

    protected static HttpServiceConnector getConnector(ServletRequest request) {
        HttpServiceRequest httpServiceRequest = null;
        ServletRequest current = request;
        while (current != null) {
            if (current instanceof CoyoteRequestFacade) {
                httpServiceRequest = (HttpServiceRequest)((CoyoteRequestFacade)current).getUnwrappedCoyoteRequest();
                break;
            }
            if (!(current instanceof ServletRequestWrapper)) break;
            current = ((ServletRequestWrapper)current).getRequest();
        }
        return (HttpServiceConnector)httpServiceRequest.getConnector();
    }

    protected static boolean isIncluded(ServletResponse res) {
        while (res != null) {
            if (res instanceof Response) {
                return ((Response)res).getIncluded();
            }
            if (res instanceof ApplicationResponse) {
                return ((ApplicationResponse)res).isIncluded();
            }
            if (res instanceof ApplicationHttpResponse) {
                return ((ApplicationHttpResponse)res).isIncluded();
            }
            if (res instanceof ServletResponseWrapper) {
                res = ((ServletResponseWrapper)res).getResponse();
                continue;
            }
            if (!(res instanceof CoyoteResponseFacade)) break;
            res = ((CoyoteResponseFacade)res).getUnwrappedCoyoteResponse();
        }
        return true;
    }

    protected OutputStream getOutputStream(HttpServletResponse hres) throws IOException {
        CoyoteResponse coyoteRes;
        Object os = null;
        if (hres instanceof CoyoteResponseFacade && (coyoteRes = ((CoyoteResponseFacade)hres).getUnwrappedCoyoteResponse()) != null) {
            os = coyoteRes.createOutputStream();
        }
        if (os == null) {
            try {
                os = hres.getOutputStream();
            }
            catch (IllegalStateException e) {
                String charsetName = this._charsetName;
                if (charsetName == null) {
                    charsetName = hres.getCharacterEncoding();
                }
                os = new WriterOutputStream((Writer)hres.getWriter(), charsetName);
            }
        }
        return os;
    }

    InputStream getInputStream(HttpServletRequest hreq) throws IOException {
        CoyoteRequest coyoteReq;
        Object is = null;
        if (hreq instanceof CoyoteRequestFacade && (coyoteReq = ((CoyoteRequestFacade)hreq).getUnwrappedCoyoteRequest()) != null) {
            is = coyoteReq.createInputStream();
        }
        if (is == null) {
            try {
                is = hreq.getInputStream();
            }
            catch (IllegalStateException e) {
                String charsetName = this._charsetName;
                if (charsetName == null) {
                    charsetName = hreq.getCharacterEncoding();
                }
                is = new ReaderInputStream((Reader)hreq.getReader(), charsetName);
            }
        }
        return is;
    }

    public X509Certificate[] getCertificates(Request request) {
        String clientCert = this.getCertificate();
        X509Certificate[] certs = null;
        if (clientCert != null) {
            clientCert = "-----BEGIN CERTIFICATE-----\n" + clientCert + "\n-----END CERTIFICATE-----";
            byte[] certBytes = new byte[clientCert.length()];
            clientCert.getBytes(0, clientCert.length(), certBytes, 0);
            ByteArrayInputStream bais = new ByteArrayInputStream(certBytes);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                certs = new X509Certificate[]{(X509Certificate)cf.generateCertificate(bais)};
            }
            catch (CertificateException ce) {
                // empty catch block
            }
        }
        return certs;
    }

    public void start() throws LifecycleException {
    }

    public void stop() throws LifecycleException {
    }

    public native void jniSetThreadLocalData(Object var1);

    private native void jniSetSize(long var1, int var3);

    private native void jniFlushResponse(long var1);

    private native void jniFinishResponse(long var1);

    private native int jniWrite(long var1, byte[] var3, int var4, int var5);

    private native boolean jniWriteByte(long var1, byte var3);

    private native int jniReadByte(long var1);

    private native int jniRead(long var1, byte[] var3, int var4, int var5);

    private native int jniReadLine(long var1, byte[] var3, int var4, int var5);

    private native boolean jniSkip(long var1, int var3);

    private native void jniSetAllResponseFields(long var1, int var3, String var4, String var5, int var6, boolean var7, Object[] var8, int var9, boolean var10);

    private native String jniGetCertificate(long var1);

    private native int jniInclude(long var1, OutputStream var3, String var4, String var5);

    private native int jniForward(long var1, InputStream var3, OutputStream var4, String var5, String var6, String var7);
}

