/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.ProxyHandler;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.http.HSAccessLogEvent;
import com.sun.enterprise.admin.event.http.HSAccessLogEventListenerImpl;
import com.sun.enterprise.admin.event.http.HSHttpAccessLogEvent;
import com.sun.enterprise.admin.event.http.HSHttpAccessLogEventListenerImpl;
import com.sun.enterprise.admin.event.http.HSHttpListenerEvent;
import com.sun.enterprise.admin.event.http.HSHttpListenerEventListenerImpl;
import com.sun.enterprise.admin.event.http.HSSslEvent;
import com.sun.enterprise.admin.event.http.HSSslEventListenerImpl;
import com.sun.enterprise.admin.event.http.HSVirtualServerEvent;
import com.sun.enterprise.admin.event.http.HSVirtualServerEventListenerImpl;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AccessLog;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpAccessLog;
import com.sun.enterprise.config.serverbeans.HttpFileCache;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.KeepAlive;
import com.sun.enterprise.config.serverbeans.RequestProcessing;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.httpservice.monitor.MonitoringEventListenerImpl;
import com.sun.enterprise.server.logging.HSStringProviderImpl;
import com.sun.enterprise.server.logging.LogMBean;
import com.sun.enterprise.server.logging.LogRotatorSPI;
import com.sun.enterprise.server.logging.LogRotatorSPIImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.logging.IASLevel;
import com.sun.enterprise.web.HttpServiceVirtualServer;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.PEWebContainer;
import com.sun.enterprise.web.ProxyHandlerImpl;
import com.sun.enterprise.web.SessionPurgeUtil;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.VirtualServerValve;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.connector.httpservice.HttpServiceConnector;
import com.sun.enterprise.web.connector.httpservice.HttpServiceProcessor;
import com.sun.enterprise.web.logger.HttpServiceLogListener;
import com.sun.httpservice.spi.FileCacheConfig;
import com.sun.httpservice.spi.HttpService;
import com.sun.httpservice.spi.HttpServiceConfig;
import com.sun.httpservice.spi.HttpServiceLogRotator;
import com.sun.httpservice.spi.HttpServiceLogger;
import com.sun.httpservice.spi.HttpServiceSPIException;
import com.sun.httpservice.spi.HttpServiceStringManager;
import com.sun.httpservice.spi.ListenSocketConfig;
import com.sun.httpservice.spi.MagnusConfig;
import com.sun.httpservice.spi.MagnusDirective;
import com.sun.httpservice.spi.SSLServerConfig;
import com.sun.httpservice.spi.VSDefaultTypeConfig;
import com.sun.httpservice.spi.VSForceTypeConfig;
import com.sun.httpservice.spi.VirtualServerConfig;
import com.sun.httpservice.spi.monitor.HttpServiceEventListenerImpl;
import com.sun.httpservice.spi.monitor.MBManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.coyote.tomcat5.CoyoteConnector;

public class HttpServiceWebContainer
extends PEWebContainer
implements MonitoringLevelListener {
    protected HttpService hs = null;
    HttpServiceConfig hsc = null;
    protected static int[] xpoweredListeners;
    private static Boolean authPassthroughEnabled;
    private static ProxyHandler proxyHandler;
    private static HashMap authPassthroughFlags;
    private static HashMap proxyHandlers;
    protected static Hashtable propertyHash;
    private static boolean isTraceEnabled;
    private boolean statsProfilingOn = true;
    private boolean dnsCacheOn = false;
    private boolean accessLoggingOn = true;
    private boolean monitoringCacheEnabled = true;
    private long monitoringCacheRefresh = 5000L;
    private static final boolean SKIP_NSS_INITIALIZE = true;
    private static final String DEFAULT_SERVER_STRING = "Sun-Java-System/Application-Server";
    public static HashMap redirectPorts;
    public static int defaultRedirectPort;
    private static Integer _redirectPort;
    private static final String DEFAULT_CERT_NICKNAME = "s1as";
    private static final String DEFAULT_SSL2_CIPHERS = "-rc4,-rc4export,-rc2,-rc2export,-desede3,-des";
    private static final String DEFAULT_SSL3_TLS_CIPHERS = "-rsa_rc4_128_sha,+rsa_rc4_128_md5,-rsa_rc4_56_sha,-rsa_rc4_40_md5,+rsa_3des_sha,+rsa_des_sha,-rsa_des_56_sha,-rsa_rc2_40_md5,-rsa_null_md5,-fortezza,-fortezza_rc4_128_sha,-fortezza_null,+fips_3des_sha,-fips_des_sha";
    private static final String DEFAULT_ACCESS_LOG_FORMAT = "%Ses->client.ip% - %Req->vars.auth-user% [%SYSDATE%] \"%Req->reqpb.clf-request%\" %Req->srvhdrs.clf-status% %Req->srvhdrs.content-length%";
    private static final String HTTPS = "https://";
    private static final String HTTP = "http://";

    private HttpServiceWebContainer(String id, ServerContext context) {
        super(id, context);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "httpservice.webcontainer.constructed");
        }
        Config config = null;
        try {
            config = ServerBeansFactory.getConfigBean((ConfigContext)this._configContext);
            this.domain = ServerBeansFactory.getDomainBean((ConfigContext)this._configContext);
        }
        catch (ConfigException e) {
            _logger.log(Level.SEVERE, "httpservice.getconfig.exception", e);
        }
        HttpServiceWebContainer.loadPropertyHash();
        com.sun.enterprise.config.serverbeans.HttpService httpService = config.getHttpService();
        ElementProperty ep = httpService.getElementPropertyByName("monitoringCacheEnabled");
        String enabledStr = null;
        if (ep != null) {
            enabledStr = ep.getValue();
        }
        if (enabledStr == null) {
            this.monitoringCacheEnabled = true;
        } else if (enabledStr.equals("no") || enabledStr.equals("off") || enabledStr.equals("0") || enabledStr.equals("false")) {
            this.monitoringCacheEnabled = false;
        } else if (enabledStr.equals("yes") || enabledStr.equals("on") || enabledStr.equals("1") || enabledStr.equals("true")) {
            this.monitoringCacheEnabled = true;
        } else {
            _logger.log(Level.WARNING, "httpservice.monitor.cache_enabled.invalid_value", enabledStr);
            _logger.log(Level.WARNING, "httpservice.monitor.cache_enabled.default");
            this.monitoringCacheEnabled = true;
        }
        ep = httpService.getElementPropertyByName("monitoringCacheRefreshInMillis");
        String cacheRefreshStr = null;
        if (ep != null) {
            cacheRefreshStr = ep.getValue();
        }
        if (cacheRefreshStr != null) {
            try {
                this.monitoringCacheRefresh = Long.parseLong(cacheRefreshStr);
                if (this.monitoringCacheRefresh <= 0L) {
                    _logger.log(Level.WARNING, "httpservice.monitor.invalid_cache_refresh", cacheRefreshStr);
                    _logger.log(Level.WARNING, "httpservice.monitor.disabling_cache");
                    this.monitoringCacheEnabled = false;
                }
            }
            catch (NumberFormatException ex) {
                this.monitoringCacheRefresh = 5000L;
                _logger.log(Level.WARNING, "httpservice.monitoring.invalid_cache_refresh", cacheRefreshStr);
            }
        }
        if ((ep = httpService.getElementPropertyByName("authPassthroughEnabled")) != null && ep.getValue() != null) {
            authPassthroughEnabled = new Boolean(ConfigBean.toBoolean((String)ep.getValue()));
        }
        if ((ep = httpService.getElementPropertyByName("proxyHandler")) != null && ep.getValue() != null) {
            HttpServiceWebContainer.setProxyHandler(ep.getValue());
        }
        this.createEngine();
        this.createHosts(httpService, false);
        this.configureHttpService(httpService, this.domain);
    }

    protected static void loadPropertyHash() {
        propertyHash = new Hashtable();
        propertyHash.put("keepAliveQueryMeanTime", "KeepAliveQueryMeanTime");
        propertyHash.put("keepAliveQueryMaxSleepTime", "KeepAliveQueryMaxSleepTime");
        propertyHash.put("keepAliveReservation", "KeepAliveReservation");
        propertyHash.put("stackSize", "StackSize");
        propertyHash.put("chunkedRequestBufferSize", "ChunkedRequestBufferSize");
        propertyHash.put("chunkedRequestTimeout", "ChunkedRequestTimeout");
        propertyHash.put("sslSessionTimeout", "SslSessionTimeout");
        propertyHash.put("sslClientAuthDataLimit", "SslClientAuthDataLimit");
        propertyHash.put("ssl3SessionTimeout", "Ssl3SessionTimeout");
        propertyHash.put("sslCacheEntries", "SslCacheEntries");
    }

    public void createNewHosts(Server server, com.sun.enterprise.config.serverbeans.HttpService httpService) throws LifecycleException {
        Engine[] engines = this._embedded.getEngines();
        String docroot = null;
        MimeMap mm = null;
        WebModuleConfig wmInfo = null;
        com.sun.enterprise.config.serverbeans.VirtualServer[] vsBeanArray = httpService.getVirtualServer();
        Container[] curVsArray = engines[0].findChildren();
        for (int cnt = 0; cnt < vsBeanArray.length; ++cnt) {
            List values;
            String cacheControl;
            String newVsId = vsBeanArray[cnt].getId();
            boolean found = false;
            for (int j = 0; curVsArray != null && j < curVsArray.length; ++j) {
                if (!newVsId.equals(curVsArray[j].getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "httpservice.config.creating_vs", newVsId);
            }
            if (vsBeanArray[cnt].getElementPropertyByName("docroot") != null) {
                docroot = vsBeanArray[cnt].getElementPropertyByName("docroot").getValue();
                boolean isValid = new File(docroot).exists();
                if (!isValid) {
                    if (vsBeanArray[cnt].getDefaultWebModule() == null) {
                        String msg = _rb.getString("pewebcontainer.virtual_server.invalid_docroot");
                        msg = MessageFormat.format(msg, newVsId, docroot);
                        throw new IllegalArgumentException(msg);
                    }
                    _logger.log(Level.WARNING, "httpservice.config.vs.invalid.docroot", new Object[]{newVsId, docroot});
                }
            } else if (vsBeanArray[cnt].getDefaultWebModule() == null) {
                String msg = _rb.getString("pewebcontainer.virtual_server.missing_docroot");
                msg = MessageFormat.format(msg, newVsId);
                throw new IllegalArgumentException(msg);
            }
            VirtualServer vs = this.createVS(newVsId, vsBeanArray[cnt], docroot, vsBeanArray[cnt].getLogFile(), mm);
            _logger.log(Level.INFO, "httpservice.config.vs_created", newVsId);
            ElementProperty cacheProp = vsBeanArray[cnt].getElementPropertyByName("setCacheControl");
            if (cacheProp != null && (cacheControl = cacheProp.getValue()) != null && (values = StringUtils.parseStringList((String)cacheControl, (String)",")) != null && !values.isEmpty()) {
                String[] cacheControls = new String[values.size()];
                vs.setCacheControls(values.toArray(cacheControls));
            }
            engines[0].addChild((Container)vs);
            this.configureHost(vs, httpService);
            wmInfo = vsBeanArray[cnt].getDefaultWebModule() != null ? this.createNewDefWmInfo(vsBeanArray[cnt].getDefaultWebModule(), server, vs) : vs.createSystemDefaultWebModuleIfNecessary();
            if (wmInfo != null) {
                this.loadStandaloneWebModule(vs, wmInfo);
            }
            vs.start();
        }
    }

    public void removeDeletedHosts(com.sun.enterprise.config.serverbeans.HttpService httpService) throws LifecycleException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "httpservice.removing_hosts_from_tomcat");
        }
        SessionPurgeUtil purgeUtil = new SessionPurgeUtil(this._embedded);
        Engine[] engines = this._embedded.getEngines();
        com.sun.enterprise.config.serverbeans.VirtualServer[] vsBeanArray = httpService.getVirtualServer();
        Container[] curVsArray = engines[0].findChildren();
        ArrayList<String> newVsList = new ArrayList<String>();
        for (int i = 0; i < vsBeanArray.length; ++i) {
            com.sun.enterprise.config.serverbeans.VirtualServer newVsBean = vsBeanArray[i];
            String vsId = newVsBean.getId();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "httpservice.config.cur_vs", vsId);
            }
            newVsList.add(vsId);
        }
        for (int cnt = 0; cnt < curVsArray.length; ++cnt) {
            VirtualServer curVs;
            String curVsList;
            if (!(curVsArray[cnt] instanceof VirtualServer) || newVsList.contains(curVsList = (curVs = (VirtualServer)curVsArray[cnt]).getID()) || curVsList.equals("__asadmin")) continue;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "httpservice.deleting.vs", curVsList);
            }
            String[] contextRoots = curVs.findDeployedApps();
            for (int j = 0; j < contextRoots.length; ++j) {
                Context ctx = (Context)curVs.findChild(contextRoots[j]);
                boolean hasBeenUndeployed = false;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("about to call SessionPurgeUtil for contextRoot: " + ctx);
                }
                if (ctx != null) {
                    purgeUtil.purgeSessionsForContext(ctx);
                }
                this.disableMonitoring((WebModule)ctx, curVs.getName());
                curVs.removeChild((Container)ctx);
                try {
                    ((StandardContext)ctx).destroy();
                }
                catch (Exception ex) {
                    String msg = _rb.getString("httpservice.context_destroy.exception");
                    msg = MessageFormat.format(msg, ctx);
                    _logger.log(Level.WARNING, msg, ex);
                }
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "httpservice.undeployed_context", new Object[]{ctx, curVsList});
                }
                hasBeenUndeployed = true;
                curVs.fireContainerEvent("remove", (Object)ctx);
                if (!hasBeenUndeployed) {
                    _logger.log(Level.SEVERE, "httpservice.undeploy.failed.forcontext", ctx);
                }
                engines[0].removeChild((Container)curVs);
            }
        }
    }

    public void updateHosts(com.sun.enterprise.config.serverbeans.VirtualServer vs, Server server) throws LifecycleException {
        WebModuleConfig newWmInfo;
        Engine[] engine = this._embedded.getEngines();
        Container[] curVsArray = engine[0].findChildren();
        VirtualServer curVs = null;
        VirtualServerValve vsValve = null;
        String defWmId = null;
        String newDefWmId = null;
        for (int i = 0; curVsArray != null && i < curVsArray.length; ++i) {
            if (!vs.getId().equals(curVsArray[i].getName())) continue;
            curVs = (VirtualServer)curVsArray[i];
            _logger.log(Level.INFO, "CurrentVS = " + curVs.getID());
            break;
        }
        String[] existAliases = curVs.getAliases();
        for (int i = 0; i < existAliases.length; ++i) {
            curVs.removeAlias(existAliases[i]);
        }
        List hosts = StringUtils.parseStringList((String)vs.getHosts(), (String)",");
        String newAlias = null;
        for (int i = 0; i < hosts.size(); ++i) {
            newAlias = hosts.get(i).toString();
            if (newAlias.equalsIgnoreCase("localhost.localdomain")) continue;
            curVs.addAlias(newAlias);
        }
        boolean addCurrentValve = false;
        vsValve = curVs.getValve();
        if (vsValve == null) {
            vsValve = new VirtualServerValve();
            curVs.setValve(vsValve);
        }
        if (vs.getState().equalsIgnoreCase("off") && !vsValve.isVsInOffList(curVs.getName())) {
            vsValve.addOffVirtualHost(curVs.getName());
            addCurrentValve = true;
        } else if (vs.getState().equalsIgnoreCase("disabled") && !vsValve.isVsInDisabledList(curVs.getName())) {
            vsValve.addDisabledVirtualHost(curVs.getName());
            addCurrentValve = true;
        } else if (vs.getState().equalsIgnoreCase("on") && vsValve.isVsInDisabledList(curVs.getName())) {
            vsValve.removeDisabledVirtualHost(curVs.getName());
        } else if (vs.getState().equalsIgnoreCase("on") && vsValve.isVsInOffList(curVs.getName())) {
            vsValve.removeOffVirtualHost(curVs.getName());
        }
        if (addCurrentValve) {
            curVs.addValve((Valve)vsValve);
        }
        defWmId = curVs.getBean().getDefaultWebModule();
        newDefWmId = vs.getDefaultWebModule();
        if (defWmId == null && newDefWmId == null) {
            return;
        }
        if (defWmId != null && !defWmId.equals(newDefWmId)) {
            WebModuleConfig wmInfo = curVs.getUserDefaultWebModuleConfig(server);
            Application app = wmInfo.getDescriptor().getApplication();
            this.unloadWebModule(wmInfo.getContextPath(), app.getRegistrationName(), curVs.getName(), null);
        }
        if (newDefWmId != null && !newDefWmId.equals(defWmId) && (newWmInfo = this.createNewDefWmInfo(newDefWmId, server, curVs)) != null) {
            this.loadStandaloneWebModule(curVs, newWmInfo);
        }
        curVs.setBean(vs);
    }

    protected WebModuleConfig createNewDefWmInfo(String wmId, Server server, VirtualServer curVs) {
        WebModuleConfig wmInfo = null;
        Applications appsBean = null;
        try {
            appsBean = ServerBeansFactory.getApplicationsBean((ConfigContext)server.getConfigContext());
        }
        catch (ConfigException e) {
            String msg = _rb.getString("vs.appsConfigError");
            Object[] params = new Object[]{this.getID()};
            msg = MessageFormat.format(msg, params);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (wmId != null) {
            com.sun.enterprise.config.serverbeans.WebModule wm;
            wmInfo = curVs.findWebModuleInJ2eeApp(appsBean, wmId);
            if (wmInfo == null) {
                wm = appsBean.getWebModuleByName(wmId);
                if (wm != null) {
                    if (curVs.isActive(wm, false)) {
                        com.sun.enterprise.config.serverbeans.WebModule wmCopy = new com.sun.enterprise.config.serverbeans.WebModule();
                        wmCopy.setName(wm.getName());
                        wmCopy.setLocation(wm.getLocation());
                        wmCopy.setEnabled(wm.isEnabled());
                        wmCopy.setContextRoot(wm.getContextRoot());
                        wmInfo = curVs.loadWebModuleConfig(wmCopy);
                        wmInfo.setVirtualServers(curVs.getID());
                        wmCopy.setName("__default-" + wmCopy.getName());
                        wmCopy.setContextRoot("");
                    } else {
                        Object[] params = new Object[]{wmId, curVs.getID()};
                        _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", params);
                        wm = null;
                    }
                }
            } else {
                wm = wmInfo.getBean();
                wmInfo.setVirtualServers(curVs.getID());
                wm.setName("__default-" + wm.getName());
                wm.setContextRoot("");
            }
            if (wmInfo == null) {
                Object[] params = new Object[]{wmId, curVs.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", params);
            }
        }
        return wmInfo;
    }

    protected void configureHost(VirtualServer vs, com.sun.enterprise.config.serverbeans.HttpService httpService) {
        com.sun.enterprise.config.serverbeans.VirtualServer vsBean = vs.getBean();
        List hosts = StringUtils.parseStringList((String)vsBean.getHosts(), (String)",");
        for (int i = 0; i < hosts.size(); ++i) {
            String alias = hosts.get(i).toString();
            if (alias.equalsIgnoreCase("localhost.localdomain")) continue;
            vs.addAlias(alias);
        }
    }

    private void configureConnector(CoyoteConnector connector, HttpListener httpListener, boolean isSecure, ElementProperty[] httpServiceProps) {
    }

    protected static void configureConnector(com.sun.enterprise.config.serverbeans.HttpService httpService) {
        HttpListener[] httpListeners = httpService.getHttpListener();
        redirectPorts.clear();
        proxyHandlers.clear();
        authPassthroughFlags.clear();
        if (httpListeners != null) {
            xpoweredListeners = new int[httpListeners.length];
            for (int i = 0; i < httpListeners.length; ++i) {
                ElementProperty lsEp;
                String redirectPort;
                int port = -1;
                try {
                    port = Integer.parseInt(httpListeners[i].getPort());
                }
                catch (NumberFormatException nfe) {
                    String msg = _rb.getString("pewebcontainer.http_listener.invalid_port");
                    msg = MessageFormat.format(msg, httpListeners[i].getPort(), httpListeners[i].getId());
                    throw new IllegalArgumentException(msg);
                }
                HttpServiceWebContainer.xpoweredListeners[i] = httpListeners[i].isXpoweredBy() ? port : -1;
                boolean isSecure = httpListeners[i].isSecurityEnabled();
                if (isSecure && defaultRedirectPort == -1) {
                    defaultRedirectPort = port;
                }
                if ((redirectPort = httpListeners[i].getRedirectPort()) != null && !redirectPort.equals("")) {
                    try {
                        _redirectPort = Integer.valueOf(redirectPort);
                    }
                    catch (NumberFormatException nfe) {
                        _logger.log(Level.WARNING, "pewebcontainer.invalid_redirect_port", new Object[]{redirectPort, httpListeners[i].getPort(), redirectPort});
                    }
                    redirectPorts.put(httpListeners[i].getPort(), _redirectPort);
                }
                if ((lsEp = httpListeners[i].getElementPropertyByName("authPassthroughEnabled")) != null && lsEp.getValue() != null) {
                    authPassthroughFlags.put(httpListeners[i].getPort(), new Boolean(lsEp.getValue()));
                } else {
                    authPassthroughFlags.put(httpListeners[i].getPort(), HttpServiceWebContainer.getAuthPassthroughEnabled());
                }
                lsEp = httpListeners[i].getElementPropertyByName("proxyHandler");
                if (lsEp != null && lsEp.getValue() != null) {
                    proxyHandlers.put(httpListeners[i].getPort(), HttpServiceWebContainer.getProxyHandlerInstance(lsEp.getValue()));
                    continue;
                }
                proxyHandlers.put(httpListeners[i].getPort(), HttpServiceWebContainer.getProxyHandler());
            }
        }
    }

    protected void loadWebModule(VirtualServer vs, WebModuleConfig wmInfo, String j2eeApplication) {
        super.loadWebModule(vs, wmInfo, j2eeApplication);
        String contextRoot = wmInfo.getContextPath();
        HttpServiceVirtualServer hsvs = (HttpServiceVirtualServer)vs;
        hsvs.handleCoreMappings((StandardContext)vs.findChild(contextRoot));
    }

    public static WebContainer createInstance(ServerContext context) {
        webContainer = new HttpServiceWebContainer(new String("0"), context);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "httpservice.create_new_instance");
        }
        return webContainer;
    }

    public void startInstance() throws ServerLifecycleException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "httpservice.start.instance");
        }
        try {
            HttpServiceWebContainer.registerReconfigListeners();
            super.start();
            this.initAndRunHttpService();
        }
        catch (LifecycleException le) {
            Throwable ex = le.getThrowable();
            if (ex == null) {
                ex = le;
            }
            String msg = _rb.getString("webcontainer.startError");
            throw new ServerLifecycleException(msg, ex);
        }
    }

    public void stopInstance() throws ServerLifecycleException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "httpservice.stop.instance");
        }
        try {
            this.stopHttpService();
            super.stop();
        }
        catch (LifecycleException le) {
            Throwable ex = le.getThrowable();
            if (ex == null) {
                ex = le;
            }
            String msg = _rb.getString("webcontainer.stopError");
            throw new ServerLifecycleException(msg, ex);
        }
    }

    public static HttpServiceWebContainer getHttpServiceWebContainer() {
        return (HttpServiceWebContainer)webContainer;
    }

    public static void registerReconfigListeners() {
        AdminEventListenerRegistry.addEventListener((String)HSHttpListenerEvent.eventType, (AdminEventListener)new HSHttpListenerEventListenerImpl());
        AdminEventListenerRegistry.addEventListener((String)HSSslEvent.eventType, (AdminEventListener)new HSSslEventListenerImpl());
        AdminEventListenerRegistry.addEventListener((String)HSVirtualServerEvent.eventType, (AdminEventListener)new HSVirtualServerEventListenerImpl());
        AdminEventListenerRegistry.addEventListener((String)HSAccessLogEvent.eventType, (AdminEventListener)new HSAccessLogEventListenerImpl());
        AdminEventListenerRegistry.addEventListener((String)HSHttpAccessLogEvent.eventType, (AdminEventListener)new HSHttpAccessLogEventListenerImpl());
    }

    public static StandardHost attachVS(long jniVS, String vsID) {
        Engine[] engines = webContainer.getEngines();
        for (int i = 0; i < engines.length; ++i) {
            HttpServiceVirtualServer vs = (HttpServiceVirtualServer)engines[i].findChild(vsID);
            if (vs == null) continue;
            vs.setJNIVirtualServer(jniVS);
            HttpServiceWebContainer.handleVSFunctions(vs);
            vs.handleCoreMappings();
            return vs;
        }
        return null;
    }

    private static void handleVSFunctions(HttpServiceVirtualServer vs) {
        ArrayList urlPattern = new ArrayList();
        ArrayList urlPrefix = new ArrayList();
        ArrayList fixedURLPattern = new ArrayList();
        ArrayList fixedURL = new ArrayList();
        ArrayList docURLPattern = new ArrayList();
        ArrayList docPath = new ArrayList();
        HttpServiceWebContainer.configureRedirect(vs.getBean(), urlPattern, urlPrefix, fixedURLPattern, fixedURL);
        HttpServiceWebContainer.configureAlternateDocRoot(vs.getBean(), docURLPattern, docPath);
        vs.setObjConfValues(urlPattern, urlPrefix, fixedURLPattern, fixedURL, docURLPattern, docPath);
    }

    public static HttpServiceProcessor createProcessor() {
        return new HttpServiceProcessor();
    }

    protected void initAndRunHttpService() {
        try {
            this.initHttpService();
            this.startHttpService();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void initHttpService() {
        try {
            _logger.log(Level.INFO, "httpservice.initializing");
            HttpServiceLogListener hsLogListener = new HttpServiceLogListener();
            HttpServiceLogger.addLogListener(hsLogListener);
            HSStringProviderImpl prov = new HSStringProviderImpl();
            HttpServiceStringManager.getInstance().setHSStringProvider(prov);
            this.hs = HttpService.getInstance();
            if (this.statsProfilingOn) {
                this.hs.addEventListener(new HttpServiceEventListenerImpl());
                MBManager mbManager = MBManager.getMBManager();
                mbManager.addMonitoringListener(new MonitoringEventListenerImpl(this.getServerContext()));
                if (this.monitoringCacheEnabled) {
                    mbManager.getCache().enableCache(this.monitoringCacheRefresh);
                } else {
                    mbManager.getCache().disableCache();
                }
            }
            this.hs.init(this.hsc);
            _logger.log(Level.INFO, "httpservice.initializing.done");
        }
        catch (HttpServiceSPIException hsspie) {
            _logger.log(Level.SEVERE, "httpservice.init.failed", hsspie);
            throw new RuntimeException(hsspie);
        }
    }

    protected void startHttpService() {
        try {
            _logger.log(Level.INFO, "httpservice.starting");
            this.hs.run();
            _logger.log(Level.INFO, "httpservice.starting.done");
        }
        catch (HttpServiceSPIException hsspie) {
            _logger.log(Level.SEVERE, "httpservice.start.failed", hsspie);
            throw new RuntimeException(hsspie);
        }
    }

    public void reconfigHttpService(com.sun.enterprise.config.serverbeans.HttpService httpService, Domain domain) throws HttpServiceSPIException {
        _logger.log(Level.INFO, "httpservice.reconfiguring");
        this.configureHttpService(httpService, domain);
        this.hs.reconfig(this.hsc);
        _logger.log(Level.INFO, "httpservice.reconfiguring.done");
    }

    protected void stopHttpService() {
        try {
            _logger.log(Level.INFO, "httpservice.stopping");
            this.hs.stop();
            _logger.log(Level.INFO, "httpservice.stopping.done");
        }
        catch (HttpServiceSPIException hsspie) {
            _logger.log(Level.WARNING, "httpservice.stopping.failed", hsspie);
        }
    }

    protected void configureHttpService(com.sun.enterprise.config.serverbeans.HttpService httpService, Domain domain) {
        int port = 8080;
        HttpListener[] listeners = httpService.getHttpListener();
        AccessLog accessLog = httpService.getAccessLog();
        com.sun.enterprise.config.serverbeans.VirtualServer[] vs = httpService.getVirtualServer();
        VirtualServerConfig vsc = null;
        ListenSocketConfig lsc = null;
        HttpServiceWebContainer.configureConnector(httpService);
        boolean hpSslEnabled = false;
        HttpProtocol hp = httpService.getHttpProtocol();
        if (hp != null) {
            hpSslEnabled = hp.isSslEnabled();
        }
        this.hsc = new HttpServiceConfig();
        for (int i = 0; i < listeners.length; ++i) {
            lsc = this.getListenSocketConfig(listeners[i], hpSslEnabled);
            this.hsc.addListeningSocket(lsc);
        }
        for (int j = 0; j < vs.length; ++j) {
            vsc = this.getVirtualServerConfig(vs[j], httpService);
            this.hsc.addVirtualServer(vsc);
        }
        this.hsc.setMagnusConfig(this.getMagnusConfig(httpService));
        this.hsc.setFileCacheConfig(this.getFileCacheConfig(httpService));
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        String instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        String fileSeparator = System.getProperty("file.separator");
        if (this.accessLoggingOn) {
            if (accessLog != null) {
                this.hsc.setAccessLogFormat(this.getTranslation(accessLog.getFormat()));
            } else {
                this.hsc.setAccessLogFormat(DEFAULT_ACCESS_LOG_FORMAT);
            }
            this.configureAccessLogRotation(accessLog);
        }
        this.hsc.setTempDir(instanceRoot + fileSeparator + "generated" + fileSeparator + "tmp");
        this.hsc.setInstallDirectory(installRoot);
        this.hsc.setCertificateDirectory(instanceRoot + fileSeparator + "config");
        this.hsc.setInstanceDirectory(instanceRoot);
        this.hsc.setResourceDir(installRoot + fileSeparator + "/lib");
        this.hsc.setSkipNSSInitialize(true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "httpservice.nss.skipping");
        }
        this.hsc.setDefaultLang("en");
        if (this._logLevel.equals(Level.FINEST)) {
            this.hsc.setLogLevel(8);
        } else if (this._logLevel.equals(Level.FINER)) {
            this.hsc.setLogLevel(7);
        } else if (this._logLevel.equals(Level.FINE)) {
            this.hsc.setLogLevel(6);
        } else if (this._logLevel.equals(Level.INFO)) {
            this.hsc.setLogLevel(5);
        } else if (this._logLevel.equals(IASLevel.FATAL)) {
            this.hsc.setLogLevel(4);
        } else if (this._logLevel.equals(IASLevel.ALERT)) {
            this.hsc.setLogLevel(2);
        } else if (this._logLevel.equals(Level.SEVERE)) {
            this.hsc.setLogLevel(3);
        } else {
            this.hsc.setLogLevel(0);
        }
        this.hsc.setServerName(System.getProperty("com.sun.aas.instanceName"));
    }

    protected String getTranslation(String accessLogFormat) {
        if (accessLogFormat == "") {
            return DEFAULT_ACCESS_LOG_FORMAT;
        }
        StringBuffer translatedFormat = new StringBuffer();
        int end_index = 0;
        int last_index = 0;
        int next_index = 0;
        int formatLength = accessLogFormat.length();
        while (end_index < formatLength) {
            next_index = accessLogFormat.indexOf(37, last_index);
            if (next_index > last_index) {
                translatedFormat.append(accessLogFormat.substring(last_index, next_index));
                last_index = next_index;
                continue;
            }
            if (next_index < 0) {
                translatedFormat.append(accessLogFormat.substring(last_index, accessLogFormat.length()));
                end_index = accessLogFormat.length();
                continue;
            }
            end_index = next_index + 1;
            if (accessLogFormat.charAt(end_index) == '%') {
                translatedFormat.append("%");
                last_index = end_index;
                continue;
            }
            if ((end_index = accessLogFormat.indexOf("%", ++next_index)) < 0) {
                translatedFormat.append(accessLogFormat.substring(next_index));
                _logger.log(Level.WARNING, "httpservice.access_log_format.missing_percentage");
                break;
            }
            translatedFormat.append(this.translate(accessLogFormat.substring(next_index, end_index)));
            last_index = end_index + 1;
        }
        if (translatedFormat != null) {
            return translatedFormat.toString();
        }
        return DEFAULT_ACCESS_LOG_FORMAT;
    }

    protected String translate(String token) {
        String translatedToken = "";
        if (token.equals("client.name")) {
            translatedToken = "%Ses->client.ip%";
        } else if (token.equals("client.dns")) {
            translatedToken = "%Ses->client.dns%";
        } else if (token.equals("datetime")) {
            translatedToken = "%SYSDATE%";
        } else if (token.equals("request")) {
            translatedToken = "%Req->reqpb.clf-request%";
        } else if (token.equals("status")) {
            translatedToken = "%Req->srvhdrs.clf-status%";
        } else if (token.equals("response.length")) {
            translatedToken = "%Req->srvhdrs.content-length%";
        } else if (token.equals("http-method")) {
            translatedToken = "%Req->reqpb.method%";
        } else if (token.equals("http-uri")) {
            translatedToken = "%Req->reqpb.uri%";
        } else if (token.equals("query-str")) {
            translatedToken = "%Req->reqpb.query%";
        } else if (token.equals("http-version")) {
            translatedToken = "%Req->reqpb.protocol%";
        } else if (token.equals("cookie.value")) {
            translatedToken = "%Req->vars.varname%";
        } else if (token.equals("vs.id")) {
            translatedToken = "%vsid%  ";
        } else if (token.equals("auth-user-name")) {
            translatedToken = "%Req->vars.auth-user%";
        } else if (token.startsWith("header.")) {
            translatedToken = "%Req->headers" + token.substring(token.indexOf(".")) + "%";
        }
        return translatedToken;
    }

    protected VirtualServerConfig getVirtualServerConfig(com.sun.enterprise.config.serverbeans.VirtualServer vs, com.sun.enterprise.config.serverbeans.HttpService httpService) {
        String logFile;
        String logDir;
        VirtualServerConfig vsConfig = new VirtualServerConfig(vs.getId());
        String docRoot = null;
        docRoot = vs.getDocroot();
        if (docRoot == null) {
            if (vs.getElementPropertyByName("docroot") != null) {
                docRoot = vs.getElementPropertyByName("docroot").getValue();
            }
            if (docRoot == null) {
                String defaultWebModule = vs.getDefaultWebModule();
                if (defaultWebModule != null) {
                    try {
                        Applications apps = ServerBeansFactory.getApplicationsBean((ConfigContext)this._configContext);
                        com.sun.enterprise.config.serverbeans.WebModule webModule = apps.getWebModuleByName(defaultWebModule);
                        docRoot = webModule.getLocation();
                    }
                    catch (ConfigException cex) {
                        _logger.log(Level.WARNING, "httpservice.default_web_module.no_location");
                        docRoot = "/";
                    }
                }
                if (docRoot == null) {
                    String msg = _rb.getString("pewebcontainer.virtual_server.missing_docroot");
                    msg = MessageFormat.format(msg, vs.getId());
                    throw new IllegalArgumentException(msg);
                }
            }
        }
        vsConfig.setDocRoot(docRoot);
        if (vs.getState() != null) {
            if (vs.getState().equalsIgnoreCase("on")) {
                vsConfig.setStateEnable(true);
            } else {
                vsConfig.setStateEnable(false);
            }
        }
        if (vs.getHosts() != null) {
            vsConfig.setUrlHosts(vs.getHosts());
        }
        if (vs.getHttpListeners() != null) {
            StringTokenizer lsTokens = new StringTokenizer(vs.getHttpListeners(), ",");
            while (lsTokens.hasMoreElements()) {
                vsConfig.addListenSockets(lsTokens.nextElement().toString().trim());
            }
        }
        if (httpService.getHttpProtocol() != null) {
            HttpProtocol hp = httpService.getHttpProtocol();
        }
        String domainLogRoot = this.domain.getLogRoot();
        String accessLogProp = null;
        if (vs.getElementPropertyByName("accesslog") != null) {
            accessLogProp = vs.getElementPropertyByName("accesslog").getValue();
        }
        boolean isAbsolutePath = false;
        if (accessLogProp != null) {
            isAbsolutePath = new File(accessLogProp).isAbsolute();
            if (!isAbsolutePath) {
                logDir = domainLogRoot + File.separator + accessLogProp;
                logFile = logDir + vs.getId() + "_" + "access_log";
            } else {
                logDir = accessLogProp;
                logFile = logDir + File.separator + vs.getId() + "_" + "access_log";
            }
        } else {
            String accessLog = null;
            HttpAccessLog httpAccessLog = vs.getHttpAccessLog();
            if (httpAccessLog != null) {
                accessLog = httpAccessLog.getLogDirectory();
            }
            if (accessLog != null) {
                isAbsolutePath = new File(accessLog).isAbsolute();
                if (isAbsolutePath) {
                    logDir = accessLog;
                    logFile = logDir + File.separator + vs.getId() + "_" + "access_log";
                } else {
                    logDir = domainLogRoot + File.separator + accessLog;
                    logFile = logDir + File.separator + vs.getId() + "_" + "access_log";
                }
            } else {
                logDir = domainLogRoot + File.separator + "access";
                logFile = logDir + File.separator + vs.getId() + "_" + "access_log";
            }
        }
        this.createAccessLogDirectory(logDir);
        vsConfig.setAccessLog(logFile);
        return vsConfig;
    }

    protected void createAccessLogDirectory(String logDir) {
        File accessLogDir = new File(logDir);
        accessLogDir.mkdirs();
    }

    protected VSDefaultTypeConfig getVSDefaultTypeConfig(String defaultType) {
        StringTokenizer strToken = new StringTokenizer(defaultType, ";");
        String[] defaultTypeArray = new String[4];
        int i = 0;
        while (strToken.hasMoreElements()) {
            defaultTypeArray[i] = (String)strToken.nextElement();
            ++i;
        }
        VSDefaultTypeConfig vsDefTypeConfig = new VSDefaultTypeConfig();
        if (defaultTypeArray[0] != null) {
            vsDefTypeConfig.setEncoding(defaultTypeArray[0]);
        }
        if (defaultTypeArray[1] != null) {
            vsDefTypeConfig.setLang(defaultTypeArray[1]);
        }
        if (defaultTypeArray[2] != null) {
            vsDefTypeConfig.setCharset(defaultTypeArray[2]);
        }
        return vsDefTypeConfig;
    }

    protected VSForceTypeConfig getVSForceTypeConfig(String forceType) {
        StringTokenizer strToken = new StringTokenizer(forceType, ";");
        String[] forceTypeArray = new String[4];
        int i = 0;
        while (strToken.hasMoreElements()) {
            forceTypeArray[i] = (String)strToken.nextElement();
            ++i;
        }
        VSForceTypeConfig vsForceTypeConfig = new VSForceTypeConfig();
        if (forceTypeArray[0] != null) {
            vsForceTypeConfig.setType(forceTypeArray[0]);
        }
        if (forceTypeArray[1] != null) {
            vsForceTypeConfig.setEncoding(forceTypeArray[1]);
        }
        if (forceTypeArray[2] != null) {
            vsForceTypeConfig.setLang(forceTypeArray[2]);
        }
        if (forceTypeArray[3] != null) {
            vsForceTypeConfig.setCharset(forceTypeArray[3]);
        }
        return vsForceTypeConfig;
    }

    static void debug_print(String title, Object[] values) {
        StringBuffer result = new StringBuffer(256);
        result.append("\n===============================================================================\n# " + title + "\n" + "-------------------------------------------------------------------------------\n");
        for (int i = 0; i < values.length; ++i) {
            result.append(values[i]);
            result.append("\n");
        }
        result.append("-------------------------------------------------------------------------------\n# " + title + "\n" + "===============================================================================\n");
        if (_logger == null) {
            System.err.print(result);
        } else {
            _logger.log(Level.FINE, result.toString());
        }
    }

    protected ListenSocketConfig getListenSocketConfig(HttpListener ls, boolean hpSslEnabled) {
        ListenSocketConfig lsConfig = new ListenSocketConfig(ls.getId());
        HttpServiceWebContainer.debug_print("ListenSocketConfig", new Object[]{"ServerName: " + ls.getServerName(), "DefaultVirtualServer: " + ls.getDefaultVirtualServer(), "Security Enabled: " + new Boolean(ls.isSecurityEnabled()), "Acceptor Threads: " + ls.getAcceptorThreads(), "Port: " + ls.getPort()});
        String serverName = ls.getServerName();
        boolean lsSecurityEnabled = ls.isSecurityEnabled();
        if (serverName == null || serverName.equals("")) {
            String hostName = System.getProperty("com.sun.aas.hostName");
            if (lsSecurityEnabled) {
                lsConfig.setServerName(HTTPS + hostName + ":" + ls.getPort());
            } else {
                lsConfig.setServerName(HTTP + hostName + ":" + ls.getPort());
            }
        } else {
            lsConfig.setServerName(serverName);
        }
        if (lsSecurityEnabled) {
            if (!hpSslEnabled) {
                _logger.log(Level.WARNING, "httpservice.security_enabled.ssl_disabled");
            } else {
                lsConfig.setSecure(ls.isSecurityEnabled());
            }
        }
        lsConfig.setIp(ls.getAddress());
        lsConfig.setDefaultVSId(ls.getDefaultVirtualServer());
        lsConfig.setBlocking(ls.isBlockingEnabled());
        if (ls.getAddress().equalsIgnoreCase("any") || ls.getAddress().equalsIgnoreCase("INADDR_ANY")) {
            String preferIPv6Addresses = System.getProperty("java.net.preferIPv6Addresses");
            if (preferIPv6Addresses != null && preferIPv6Addresses.equals("true")) {
                lsConfig.setFamily("inet6");
            } else {
                lsConfig.setFamily(ls.getFamily());
            }
        } else if (ls.getAddress().indexOf(58) < 0) {
            lsConfig.setFamily(ls.getFamily());
        } else {
            lsConfig.setFamily("inet6");
        }
        if (ls.getExternalPort() != null) {
            lsConfig.setExternalPort(Integer.parseInt(ls.getExternalPort()));
        }
        if (ls.getAcceptorThreads() != null) {
            int acceptors = Integer.parseInt(ls.getAcceptorThreads());
            if (acceptors == 0) {
                _logger.log(Level.WARNING, "httpservice.acceptor_threads.is_zero");
                acceptors = 1;
            } else if (acceptors > 10) {
                _logger.log(Level.WARNING, "httpservice.acceptor_threads.too_high", acceptors + "");
                acceptors = 10;
            } else if (acceptors < 0) {
                int setAcceptors = acceptors;
                _logger.log(Level.WARNING, "httpservice.acceptor_threads.negative", new Object[]{"" + setAcceptors, "" + (acceptors *= -1)});
            }
            lsConfig.setAcceptorThreads(acceptors);
        }
        lsConfig.setListenPort(Integer.parseInt(ls.getPort()));
        if (hpSslEnabled && lsSecurityEnabled) {
            SSLServerConfig sslConf = new SSLServerConfig();
            Ssl ssl = ls.getSsl();
            if (ssl != null) {
                if (ssl.getCertNickname() != null) {
                    sslConf.setServerNickname(ssl.getCertNickname());
                } else {
                    _logger.log(Level.WARNING, "httpservice.cert_nickname.not_set");
                    sslConf.setServerNickname(DEFAULT_CERT_NICKNAME);
                }
                sslConf.setSsl2(ssl.isSsl2Enabled());
                if (ssl.getSsl2Ciphers() != null) {
                    sslConf.setSsl2Ciphers(ssl.getSsl2Ciphers());
                } else {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "httpservice.ssl2_ciphers", DEFAULT_SSL2_CIPHERS);
                    }
                    sslConf.setSsl2Ciphers(DEFAULT_SSL2_CIPHERS);
                }
                sslConf.setSsl3(ssl.isSsl3Enabled());
                if (ssl.getSsl3TlsCiphers() != null) {
                    sslConf.setSsl3TlsCiphers(ssl.getSsl3TlsCiphers());
                } else {
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.log(Level.FINE, "httpservice.ssl3_ciphers", DEFAULT_SSL3_TLS_CIPHERS);
                    }
                    sslConf.setSsl3TlsCiphers(DEFAULT_SSL3_TLS_CIPHERS);
                }
                sslConf.setTls(ssl.isTlsEnabled());
                sslConf.setTlsRollback(ssl.isTlsRollbackEnabled());
                sslConf.setClientAuth(ssl.isClientAuthEnabled());
                lsConfig.setSSLServerConfig(sslConf);
            } else {
                sslConf.setServerNickname(DEFAULT_CERT_NICKNAME);
                sslConf.setSsl2(new Boolean(Ssl.getDefaultSsl2Enabled()));
                sslConf.setSsl2Ciphers(DEFAULT_SSL2_CIPHERS);
                sslConf.setSsl3(new Boolean(Ssl.getDefaultSsl3Enabled()));
                sslConf.setSsl3TlsCiphers(DEFAULT_SSL3_TLS_CIPHERS);
                sslConf.setTls(new Boolean(Ssl.getDefaultTlsEnabled()));
                sslConf.setTlsRollback(new Boolean(Ssl.getDefaultTlsRollbackEnabled()));
                sslConf.setClientAuth(new Boolean(Ssl.getDefaultClientAuthEnabled()));
                lsConfig.setSSLServerConfig(sslConf);
            }
        }
        return lsConfig;
    }

    protected MagnusConfig getMagnusConfig(com.sun.enterprise.config.serverbeans.HttpService httpService) {
        MagnusConfig magnusConf = new MagnusConfig();
        String serverString = System.getProperty("product.name", DEFAULT_SERVER_STRING);
        magnusConf.addMagnusDirective(new MagnusDirective("ServerString", serverString));
        if (httpService.getConnectionPool() != null) {
            ConnectionPool cp = httpService.getConnectionPool();
            magnusConf.setConnQueueSize(Integer.parseInt(cp.getQueueSizeInBytes()));
            magnusConf.setRcvBufSize(Integer.parseInt(cp.getReceiveBufferSizeInBytes()));
            magnusConf.setListenQ(Integer.parseInt(cp.getMaxPendingCount()));
            magnusConf.addMagnusDirective(new MagnusDirective("SndBufSize", cp.getSendBufferSizeInBytes()));
        }
        if (httpService.getHttpProtocol() != null) {
            ElementProperty dnsCacheProp;
            HttpProtocol hp = httpService.getHttpProtocol();
            magnusConf.setDnsEnable(hp.isDnsLookupEnabled());
            if (hp.isDnsLookupEnabled() && (dnsCacheProp = httpService.getElementPropertyByName("dnsCacheEnabled")) != null) {
                this.dnsCacheOn = ConfigBean.toBoolean((String)dnsCacheProp.getValue());
            }
            magnusConf.setSecurityEnable(hp.isSslEnabled());
            magnusConf.addMagnusDirective(new MagnusDirective("HttpVersion", hp.getVersion()));
        }
        if (httpService.getKeepAlive() != null) {
            KeepAlive ka = httpService.getKeepAlive();
            magnusConf.setMaxKeepaliveConnections(Integer.parseInt(ka.getMaxConnections()));
            magnusConf.addMagnusDirective(new MagnusDirective("KeepAliveThreads", ka.getThreadCount()));
            magnusConf.addMagnusDirective(new MagnusDirective("KeepAliveTimeout", ka.getTimeoutInSeconds()));
        }
        if (httpService.getRequestProcessing() != null) {
            RequestProcessing rp = httpService.getRequestProcessing();
            magnusConf.setRqThrottle(Integer.parseInt(rp.getThreadCount()));
            magnusConf.setRqThrottleMin(Integer.parseInt(rp.getInitialThreadCount()));
            magnusConf.setIoTimeout(Integer.parseInt(rp.getRequestTimeoutInSeconds()));
            magnusConf.addMagnusDirective(new MagnusDirective("ThreadIncrement", rp.getThreadIncrement()));
            magnusConf.addMagnusDirective(new MagnusDirective("HeaderBufferSize", rp.getHeaderBufferLengthInBytes()));
        }
        String pluginName = System.mapLibraryName("j2eeplugin");
        String libraryPath = System.getProperty("java.library.path");
        StringTokenizer pathTokenizer = new StringTokenizer(libraryPath, System.getProperty("path.separator"));
        String pluginPath = null;
        while (pathTokenizer.hasMoreTokens()) {
            String path = pathTokenizer.nextToken();
            File filePath = new File(path, pluginName);
            if (!filePath.exists()) continue;
            pluginPath = filePath.getPath();
            break;
        }
        if (pluginPath == null) {
            _logger.log(Level.SEVERE, "httpservice.plugin.notfound", pluginName);
            throw new RuntimeException(new FileNotFoundException(pluginName));
        }
        pluginPath = pluginPath.replace(System.getProperty("file.separator").charAt(0), '/');
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "httpservice.j2ee_native_connector", pluginPath);
        }
        magnusConf.addMagnusDirective(new MagnusDirective("Init", "fn=\"load-modules\" shlib=\"" + pluginPath + "\" shlib_flags=\"(global|now)\""));
        boolean setStackSize = false;
        ElementProperty[] epArray = httpService.getElementProperty();
        for (int i = 0; i < epArray.length; ++i) {
            _logger.log(Level.INFO, "httpservice.processing_property", new Object[]{epArray[i].getName(), epArray[i].getValue()});
            if (propertyHash.contains(epArray[i].getName())) {
                magnusConf.addMagnusDirective(new MagnusDirective((String)propertyHash.get(epArray[i].getName()), epArray[i].getValue()));
                if (!epArray[i].getName().equals("stackSize")) continue;
                setStackSize = true;
                continue;
            }
            if (epArray[i].getName().equalsIgnoreCase("statsProfilingEnabled")) {
                this.statsProfilingOn = ConfigBean.toBoolean((String)epArray[i].getValue());
                continue;
            }
            if (epArray[i].getName().equalsIgnoreCase("dnsCacheEnabled")) continue;
            if (epArray[i].getName().equalsIgnoreCase("accessLoggingEnabled")) {
                this.accessLoggingOn = ConfigBean.toBoolean((String)epArray[i].getValue());
                continue;
            }
            if (epArray[i].getName().equalsIgnoreCase("traceEnabled") || epArray[i].getName().equalsIgnoreCase("authPassthroughEnabled")) continue;
            magnusConf.addMagnusDirective(new MagnusDirective(epArray[i].getName(), epArray[i].getValue()));
        }
        if (this.dnsCacheOn) {
            magnusConf.addMagnusDirective(new MagnusDirective("init", "fn=dns-cache-init"));
        }
        if (this.statsProfilingOn) {
            magnusConf.addMagnusDirective(new MagnusDirective("init", "fn=perf-init disable=false"));
        }
        if (!setStackSize) {
            magnusConf.addMagnusDirective(new MagnusDirective("StackSize", "262144"));
        }
        return magnusConf;
    }

    protected FileCacheConfig getFileCacheConfig(com.sun.enterprise.config.serverbeans.HttpService httpService) {
        FileCacheConfig fileCacheConf = new FileCacheConfig();
        if (httpService.getHttpFileCache() != null) {
            HttpFileCache hfc = httpService.getHttpFileCache();
            fileCacheConf.setEnable(hfc.isGloballyEnabled());
            fileCacheConf.setCacheFileContentEnable(ConfigBean.toBoolean((String)hfc.getFileCachingEnabled()));
            fileCacheConf.setMaxAge(Integer.parseInt(hfc.getMaxAgeInSeconds()));
            fileCacheConf.setMediumFileSizeLimit(Integer.parseInt(hfc.getMediumFileSizeLimitInBytes()));
            fileCacheConf.setMediumFileSpace(Integer.parseInt(hfc.getMediumFileSpaceInBytes()));
            fileCacheConf.setSmallFileSizeLimit(Integer.parseInt(hfc.getSmallFileSizeLimitInBytes()));
            fileCacheConf.setSmallFileSpace(Integer.parseInt(hfc.getSmallFileSpaceInBytes()));
            fileCacheConf.setTransmitFile(hfc.isFileTransmissionEnabled());
            fileCacheConf.setMaxFiles(Integer.parseInt(hfc.getMaxFilesCount()));
            fileCacheConf.setHashInitSize(Integer.parseInt(hfc.getHashInitSize()));
        }
        return fileCacheConf;
    }

    public static int service(long nativeConnector, HttpServiceProcessor processor, StandardHost vs, String[] rqStrs, byte[][] mbRqStrs, int[] rqInts, StandardContext ctx, String ctxPath, StandardWrapper wrapper, String servletPath, String pathInfo) {
        try {
            boolean initThreadLocalData = false;
            if (processor == null) {
                processor = new HttpServiceProcessor();
                initThreadLocalData = true;
            }
            HttpServiceConnector connector = processor.getConnector();
            connector.setContainer((Container)vs);
            connector.setAllowTrace(isTraceEnabled);
            connector.setJNIConnector(nativeConnector);
            connector.setPort(rqInts[0]);
            String localPortString = String.valueOf(rqInts[6]);
            if (HttpServiceWebContainer.isXpoweredBy(rqInts[6])) {
                connector.setXpoweredBy(true);
            } else {
                connector.setXpoweredBy(false);
            }
            connector.setAuthPassthroughEnabled((Boolean)authPassthroughFlags.get(localPortString));
            connector.setProxyHandler((ProxyHandler)proxyHandlers.get(localPortString));
            if (initThreadLocalData) {
                connector.jniSetThreadLocalData(processor);
            }
            return processor.process(vs, rqStrs, mbRqStrs, rqInts, ctx, ctxPath, wrapper, servletPath, pathInfo);
        }
        catch (Throwable t) {
            _logger.log(Level.WARNING, "httpservice.unhandled_pipeline_exception", t);
            return -1;
        }
    }

    private static boolean isXpoweredBy(int port) {
        for (int i = 0; i < xpoweredListeners.length; ++i) {
            if (xpoweredListeners[i] != port) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void configureAccessLogRotation(AccessLog accessLog) {
        HttpService hs;
        HttpServiceLogRotator rotator;
        block17: {
            rotator = null;
            hs = HttpService.getInstance();
            rotator = hs.getLogRotator();
            LogRotatorSPIImpl rotatorSPIImpl = new LogRotatorSPIImpl(rotator);
            LogMBean.getInstance().setAccessLogRotator((LogRotatorSPI)rotatorSPIImpl);
            if (accessLog == null) {
                String suffix = "%YYYY;%MM;%DD;-%hh;h%mm;m%ss;s";
                rotator.setSuffix(suffix);
                String s_enabled = AccessLog.getDefaultRotationEnabled();
                boolean enabled = Boolean.valueOf(s_enabled);
                if (!enabled) {
                    return;
                }
                String rotationType = AccessLog.getDefaultRotationPolicy();
                if (rotationType.equals("time")) {
                    long time = Long.parseLong(AccessLog.getDefaultRotationIntervalInMinutes());
                    rotator.setRotationPolicy(2);
                    rotator.setTimeInterval(time *= 60L);
                    break block17;
                } else {
                    if (rotationType.equals("size")) {
                        _logger.log(Level.WARNING, "httpservice.accesslog_rotation.bysize.not.supported");
                        _logger.log(Level.WARNING, "httpservice.accesslog_rotaion.disabled");
                        return;
                    }
                    _logger.log(Level.WARNING, "httpservice.accesslog_rotation.type.unknown", rotationType);
                    _logger.log(Level.WARNING, "httpservice.accesslog_rotation.disabled");
                    return;
                }
            }
            String suffix = accessLog.getRotationSuffix();
            if (suffix == null) {
                suffix = accessLog.getDefaultRotationSuffix();
            }
            rotator.setSuffix(suffix);
            boolean enabled = false;
            String s_enabled = accessLog.getAttributeValue("rotation-enabled");
            if (s_enabled == null || s_enabled.length() == 0) {
                s_enabled = AccessLog.getDefaultRotationEnabled();
                enabled = Boolean.valueOf(s_enabled);
            } else {
                enabled = accessLog.isRotationEnabled();
            }
            if (!enabled) {
                return;
            }
            String rotationType = accessLog.getRotationPolicy();
            if (rotationType == null) {
                rotationType = accessLog.getDefaultRotationPolicy();
            }
            if (rotationType.equals("size")) {
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.bysize.not.supported");
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.disabled");
                return;
            }
            if (!rotationType.equals("time")) {
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.type.unknown", rotationType);
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.disabled");
                return;
            }
            String s_time = accessLog.getRotationIntervalInMinutes();
            if (s_time == null || s_time.length() < 1) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "httpservice.accesslog_rotation.interval.default.value");
                }
                s_time = accessLog.getDefaultRotationIntervalInMinutes();
            }
            long time = 0L;
            try {
                time = Long.parseLong(s_time);
            }
            catch (NumberFormatException nex) {
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.interval.invalid.value", s_time);
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.disabled");
                return;
            }
            if (time <= 0L) {
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.interval.invalid.value", s_time);
                _logger.log(Level.WARNING, "httpservice.accesslog_rotation.disabled");
                return;
            }
            rotator.setRotationPolicy(2);
            rotator.setTimeInterval(time *= 60L);
        }
        rotator.setEnabled(true);
        hs.addEventListener(rotator);
    }

    public static WebContainer getInstance() {
        return webContainer;
    }

    public int jniIsTraceEnable() {
        int traceEnabled = 0;
        Config config = null;
        try {
            config = ServerBeansFactory.getConfigBean((ConfigContext)this._configContext);
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, "httpservice.getconfig.exception", e);
            return -1;
        }
        com.sun.enterprise.config.serverbeans.HttpService httpService = config.getHttpService();
        ElementProperty traceProp = null;
        traceProp = httpService.getElementPropertyByName("traceEnabled");
        if (traceProp != null && ConfigBean.toBoolean((String)traceProp.getValue())) {
            traceEnabled = 1;
            isTraceEnabled = true;
        }
        return traceEnabled;
    }

    private static void configureRedirect(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, ArrayList urlPattern, ArrayList urlPrefix, ArrayList fixedURLPattern, ArrayList fixedURL) {
        if (vsBean == null) {
            return;
        }
        ElementProperty[] props = vsBean.getElementProperty();
        if (props == null) {
            return;
        }
        int urlPatternCount = 0;
        int fixedPatternCount = 0;
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            String propValue = props[i].getValue();
            if (propName == null || propValue == null) {
                String msg = _rb.getString("webcontainer.nullVirtualServerProperty");
                _logger.log(Level.WARNING, msg, "redirect");
                continue;
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String url_Prefix = null;
            Object escape = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    from = redirectParams[j].substring("from=".length());
                }
                if (redirectParams[j].startsWith("url=")) {
                    url = redirectParams[j].substring("url=".length());
                    fixedURLPattern.add(from);
                    fixedURL.add(url);
                    ++fixedPatternCount;
                }
                if (!redirectParams[j].startsWith("url-prefix=")) continue;
                url_Prefix = redirectParams[j].substring("url-prefix=".length());
                urlPattern.add(from);
                urlPrefix.add(url_Prefix);
                ++urlPatternCount;
            }
            if (from == null || from.length() == 0) {
                String msg = _rb.getString("webcontainer.redirectMissingFrom");
                _logger.log(Level.WARNING, msg, propValue);
            }
            if (!(url != null && url.length() != 0 || url_Prefix != null && url_Prefix.length() != 0)) {
                String msg = _rb.getString("webcontainer.redirectMissingUrlOrUrlPrefix");
                _logger.log(Level.WARNING, msg, propValue);
            }
            if (url == null || url.length() <= 0 || url_Prefix == null || url_Prefix.length() <= 0) continue;
            String msg = _rb.getString("webcontainer.redirectBothUrlAndUrlPrefix");
            _logger.log(Level.WARNING, msg, propValue);
        }
    }

    private static void configureAlternateDocRoot(com.sun.enterprise.config.serverbeans.VirtualServer vsBean, ArrayList docURLPattern, ArrayList docPath) {
        if (vsBean == null) {
            return;
        }
        ElementProperty[] props = vsBean.getElementProperty();
        if (props == null) {
            return;
        }
        int docPatternCount = 0;
        boolean dirPathCount = false;
        block0: for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            String propValue = props[i].getValue();
            if (propName == null || propValue == null || !propName.startsWith("alternatedocroot_")) continue;
            String from = null;
            String dirPath = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    from = redirectParams[j].substring("from=".length());
                }
                if (!redirectParams[j].startsWith("dir=")) continue;
                dirPath = redirectParams[j].substring("dir=".length());
                docURLPattern.add(from);
                docPath.add(dirPath);
                ++docPatternCount;
                continue block0;
            }
        }
    }

    private static void setProxyHandler(String className) {
        proxyHandler = HttpServiceWebContainer.getProxyHandlerInstance(className);
    }

    private static ProxyHandler getProxyHandler() {
        return proxyHandler;
    }

    private static Boolean getAuthPassthroughEnabled() {
        return authPassthroughEnabled;
    }

    private static ProxyHandler getProxyHandlerInstance(String className) {
        Object handler = null;
        try {
            Class<?> handlerClass = Class.forName(className);
            handler = handlerClass.newInstance();
        }
        catch (Exception e) {
            String msg = _rb.getString("pewebcontainer.proxyHandlerClassLoadError");
            msg = MessageFormat.format(msg, className);
            _logger.log(Level.SEVERE, msg, e);
        }
        if (handler != null) {
            if (!(handler instanceof ProxyHandler)) {
                _logger.log(Level.SEVERE, "pewebcontainer.proxyHandlerClassInvalid", className);
                return null;
            }
            return handler;
        }
        return null;
    }

    static {
        System.loadLibrary("j2eeplugin");
        authPassthroughEnabled = Boolean.FALSE;
        proxyHandler = new ProxyHandlerImpl();
        authPassthroughFlags = new HashMap();
        proxyHandlers = new HashMap();
        isTraceEnabled = false;
        redirectPorts = new HashMap();
        defaultRedirectPort = -1;
        _redirectPort = new Integer(0);
    }
}

