/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.monitor;

import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.types.Gauge;
import com.sun.enterprise.admin.monitor.types.MonitoredAttributeType;
import com.sun.enterprise.server.monitor.HttpServerMonitorMBean;
import com.sun.enterprise.server.monitor.beans.ProcessMonitorBean;
import com.sun.enterprise.server.monitor.beans.ServerMonitorBean;
import com.sun.enterprise.server.monitor.beans.StatsMonitorBean;
import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;

public class ProcessMonitorMBean
extends BaseMonitorMBean {
    private Map _attrNameTypeMap;
    private MBeanInfo _mBeanInfo;
    private HttpServerMonitorMBean _parent;
    private static Logger _logger = null;
    private static ResourceBundle _rb = null;

    public ProcessMonitorMBean(HttpServerMonitorMBean p) {
        this._parent = p;
        this._attrNameTypeMap = new HashMap(1);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
        try {
            this._attrNameTypeMap.put("<pid>", new Gauge(Class.forName("java.lang.StringBuffer")));
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "web.monitor.unexpected_error_in_constr_process_mbean", e);
        }
        this._mBeanInfo = ProcessMonitorMBean.createMBeanInfo((Map)this._attrNameTypeMap);
    }

    public MBeanInfo getMBeanInfo() {
        return this._mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return this._attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String attrName) {
        MonitoredAttributeType type = null;
        if (this._attrNameTypeMap != null && attrName != null) {
            type = (MonitoredAttributeType)this._attrNameTypeMap.get(attrName);
        }
        return type;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        String fourSpaces = "    ";
        StatsMonitorBean stats = this._parent.getServerStats();
        if (stats == null) {
            String str = _rb.getString("web.monitor.attribute_not_found");
            Object[] params = new Object[]{attribute};
            str = MessageFormat.format(str, params);
            throw new AttributeNotFoundException(str);
        }
        ServerMonitorBean server = stats.getServer(0);
        StringBuffer sb = new StringBuffer();
        ProcessMonitorBean[] ps = server.getProcess();
        for (int i = 0; i < ps.length; ++i) {
            if (!ps[i].getAttributeValue("pid").equals(attribute)) continue;
            sb.append("\nProcess pid: " + attribute);
            server.dumpAttributes("Process", i, sb, "\n");
            ps[i].dump(sb, "\n" + fourSpaces);
            return sb;
        }
        String str = _rb.getString("web.monitor.attribute_not_found");
        Object[] params = new Object[]{attribute};
        str = MessageFormat.format(str, params);
        throw new AttributeNotFoundException(str);
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            String msg = _rb.getString("web.monitor.attribute_cannot_be_null");
            throw new RuntimeOperationsException(new IllegalArgumentException(msg));
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "web.monitor.error_while_getting_monitor_attr", e);
            }
        }
        return resultList;
    }

    public String[] getAllAttributeNames() {
        StatsMonitorBean stats = this._parent.updateNewStats();
        if (stats == null) {
            return null;
        }
        ServerMonitorBean server = stats.getServer(0);
        ProcessMonitorBean[] ps = server.getProcess();
        String[] str = new String[ps.length];
        for (int i = 0; i < ps.length; ++i) {
            str[i] = ps[i].getAttributeValue("pid");
        }
        return str;
    }
}

