/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.monitor;

import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.types.Gauge;
import com.sun.enterprise.admin.monitor.types.MonitoredAttributeType;
import com.sun.enterprise.server.monitor.ProcessMonitorMBean;
import com.sun.enterprise.server.monitor.StatsDtdResolver;
import com.sun.enterprise.server.monitor.VirtualServerMonitorMBean;
import com.sun.enterprise.server.monitor.beans.ProcessMonitorBean;
import com.sun.enterprise.server.monitor.beans.ServerMonitorBean;
import com.sun.enterprise.server.monitor.beans.StatsMonitorBean;
import com.sun.enterprise.server.monitor.beans.VirtualServerMonitorBean;
import com.sun.logging.LogDomains;
import java.io.ByteArrayInputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanInfo;
import javax.management.RuntimeOperationsException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class HttpServerMonitorMBean
extends BaseMonitorMBean {
    private static Logger _logger = null;
    private static ResourceBundle _rb = null;
    private Map _attrNameTypeMap;
    private MBeanInfo _mBeanInfo;
    private StatsMonitorBean _serverStats;
    private BaseMonitorMBean _vs;
    private BaseMonitorMBean _process;

    public HttpServerMonitorMBean() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
        this._attrNameTypeMap = new HashMap(1);
        try {
            this._attrNameTypeMap.put("summary", new Gauge(Class.forName("java.lang.StringBuffer")));
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "web.monitor.exception", e);
        }
        this._mBeanInfo = HttpServerMonitorMBean.createMBeanInfo((Map)this._attrNameTypeMap);
    }

    public void createChildren() {
        this._vs = new VirtualServerMonitorMBean(this);
        try {
            this.addChild(MonitoredObjectType.VIRTUAL_SERVER.getTypeName(), MonitoredObjectType.VIRTUAL_SERVER, this._vs);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "web.monitor.exception", e);
        }
        this._process = new ProcessMonitorMBean(this);
        try {
            this.addChild(MonitoredObjectType.PROCESS.getTypeName(), MonitoredObjectType.PROCESS, this._process);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "web.monitor.exception", e);
        }
    }

    public MBeanInfo getMBeanInfo() {
        return this._mBeanInfo;
    }

    public Map getMonitoringMetaData() {
        return this._attrNameTypeMap;
    }

    public MonitoredAttributeType getAttributeType(String attrName) {
        MonitoredAttributeType type = null;
        if (this._attrNameTypeMap != null && attrName != null) {
            type = (MonitoredAttributeType)this._attrNameTypeMap.get(attrName);
        }
        return type;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException {
        if (attribute.equals("summary")) {
            this.updateNewStats();
            if (this._serverStats != null) {
                ServerMonitorBean server = this._serverStats.getServer(0);
                StringBuffer sb = new StringBuffer(200);
                this.dumpSummary(sb, server);
                return sb;
            }
        }
        String str = _rb.getString("web.monitor.attribute_not_found");
        Object[] params = new Object[]{attribute};
        str = MessageFormat.format(str, params);
        throw new AttributeNotFoundException(str);
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            String msg = _rb.getString("web.monitor.attribute_cannot_be_null");
            throw new RuntimeOperationsException(new IllegalArgumentException(msg));
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "web.monitor.error_while_getting_monitor_attr", e);
            }
        }
        return resultList;
    }

    public StatsMonitorBean getServerStats() {
        return this._serverStats;
    }

    public void dumpSummary(StringBuffer sb, ServerMonitorBean server) {
        String fourSpaces = "    ";
        sb.append("\nServer");
        this._serverStats.dumpAttributes("Server", 0, sb, "\n");
        sb.append("\n \n");
        boolean[] cqs = server.getConnectionQueue();
        sb.append(fourSpaces + "Number of Connection Queues = " + cqs.length);
        for (int i = 0; i < cqs.length; ++i) {
            sb.append("\n");
            sb.append(fourSpaces + "Connection Queue #" + (i + 1) + ":");
            server.dumpAttributes("ConnectionQueue", i, sb, "\n" + fourSpaces);
        }
        sb.append("\n \n");
        boolean[] tps = server.getThreadPool();
        sb.append(fourSpaces + "Number of Thread Pools = " + tps.length);
        for (int i = 0; i < tps.length; ++i) {
            sb.append("\n");
            sb.append(fourSpaces + "Thread Pool #" + (i + 1) + ":");
            server.dumpAttributes("ThreadPool", i, sb, "\n" + fourSpaces);
        }
        sb.append("\n \n");
        boolean[] profiles = server.getProfile();
        sb.append(fourSpaces + "Number of Profiles = " + profiles.length);
        for (int i = 0; i < profiles.length; ++i) {
            sb.append("\n");
            sb.append(fourSpaces + "Profile #" + (i + 1) + ":");
            server.dumpAttributes("Profile", i, sb, "\n" + fourSpaces);
        }
        sb.append("\n \n");
        VirtualServerMonitorBean[] vss = server.getVirtualServer();
        sb.append(fourSpaces + "Number of Virtual Servers = " + vss.length);
        for (int i = 0; i < vss.length; ++i) {
            sb.append("\n");
            sb.append(fourSpaces + "Virtual Server #" + (i + 1) + ":");
            server.dumpAttributes("VirtualServer", i, sb, "\n" + fourSpaces);
        }
        sb.append("\n \n");
        ProcessMonitorBean[] ps = server.getProcess();
        sb.append(fourSpaces + "Number of Processes = " + ps.length);
        for (int i = 0; i < ps.length; ++i) {
            sb.append("\n");
            sb.append(fourSpaces + "Process #" + (i + 1) + ":");
            server.dumpAttributes("Process", i, sb, "\n" + fourSpaces);
        }
        sb.append("\n ");
    }

    public StatsMonitorBean updateNewStats() {
        Object[] obj = this.jniGetHttpServerStats();
        byte[] barray = (byte[])obj[0];
        byte[] dtdArray = (byte[])obj[1];
        if (barray != null) {
            ByteArrayInputStream bi = new ByteArrayInputStream(barray);
            InputSource is = new InputSource(bi);
            is.setSystemId("iwsstats.xml");
            StatsDtdResolver dtdResolver = new StatsDtdResolver(dtdArray);
            this._serverStats = StatsMonitorBean.createGraph(is, false, (EntityResolver)dtdResolver);
        }
        return this._serverStats;
    }

    private native Object[] jniGetHttpServerStats();
}

