/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.logging;

import com.sun.enterprise.util.logging.IASLevel;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class ServerHandler
extends StreamHandler {
    private static final int LOG_WARN = 0;
    private static final int LOG_MISCONFIG = 1;
    private static final int LOG_SECURITY = 2;
    private static final int LOG_FAILURE = 3;
    private static final int LOG_CATASTROPHE = 4;
    private static final int LOG_INFORM = 5;
    private static final int LOG_VERBOSE = 6;
    private static Logger _logger;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise");
        }
        return _logger;
    }

    private static native void logToCore(int var0, String var1, String var2);

    public void publish(LogRecord record) {
        String msg = null;
        if (record != null) {
            try {
                msg = this.getFormatter().format(record);
                Level level = record.getLevel();
                this.preLogToCore(this.getNativeLevel(level.intValue()), level.getLocalizedName(), msg);
            }
            catch (Exception ex) {
                ServerHandler.getLogger().log(Level.WARNING, "could not publish", ex);
            }
        }
    }

    private final void preLogToCore(int intLevel, String logkey, String msg) throws Exception {
        int chunk = 3500;
        int msgLength = msg.length();
        if (msgLength <= 3500) {
            ServerHandler.logToCore(intLevel, logkey, msg);
            return;
        }
        for (int i = 0; i < msgLength; i += 3500) {
            String subMsg = msgLength > i + 3500 ? msg.substring(i, i + 3500) : msg.substring(i);
            ServerHandler.logToCore(intLevel, logkey, subMsg);
        }
    }

    private int getNativeLevel(int level) {
        if (Level.FINE.intValue() >= level) {
            return 6;
        }
        if (Level.WARNING.intValue() == level) {
            return 0;
        }
        if (Level.SEVERE.intValue() == level) {
            return 3;
        }
        if (Level.INFO.intValue() == level) {
            return 5;
        }
        if (Level.CONFIG.intValue() == level) {
            return 5;
        }
        if (IASLevel.ALERT.intValue() == level) {
            return 3;
        }
        if (IASLevel.FATAL.intValue() == level) {
            return 4;
        }
        ServerHandler.getLogger().log(Level.WARNING, "unexpected log level " + level);
        return 6;
    }

    static {
        System.loadLibrary("j2eeplugin");
        _logger = null;
    }
}

