/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.httpservice.monitor;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCRequestStats;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.httpservice.spi.monitor.RequestMB;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class PWCRequestStatsImpl
implements PWCRequestStats {
    static Logger _logger = null;
    private RequestMB _bean;
    private long _startTime;
    private GenericStatsImpl _gsImpl;
    private StringStatistic _method;
    private StringStatistic _uri;
    private MutableCountStatistic _countRequests;
    private MutableCountStatistic _countBytesReceived;
    private MutableCountStatistic _countBytesTransmitted;
    private MutableCountStatistic _rateBytesTransmitted;
    private MutableCountStatistic _maxByteTransmissionRate;
    private MutableCountStatistic _countOpenConnections;
    private MutableCountStatistic _maxOpenConnections;
    private MutableCountStatistic _count2xx;
    private MutableCountStatistic _count3xx;
    private MutableCountStatistic _count4xx;
    private MutableCountStatistic _count5xx;
    private MutableCountStatistic _countOther;
    private MutableCountStatistic _count200;
    private MutableCountStatistic _count302;
    private MutableCountStatistic _count304;
    private MutableCountStatistic _count400;
    private MutableCountStatistic _count401;
    private MutableCountStatistic _count403;
    private MutableCountStatistic _count404;
    private MutableCountStatistic _count503;

    public PWCRequestStatsImpl(RequestMB bean) {
        this._bean = bean;
        this.initializeStatistics();
        try {
            this._gsImpl = new GenericStatsImpl(this.getClass().getInterfaces()[0].getName(), (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.WARNING, "httpservice.monitor.stats.constructor.exception", cnfe);
        }
    }

    public StringStatistic getMethod() {
        String method = this._bean.getMethod();
        method = method == null ? " " : method;
        StringStatisticImpl ss = new StringStatisticImpl(method, "method", "String", "Last executed method", this._startTime, this._bean.getUpdateTime());
        return ss;
    }

    public StringStatistic getUri() {
        String uri = this._bean.getUri();
        uri = uri == null ? " " : uri;
        StringStatisticImpl ss = new StringStatisticImpl(uri, "uri", "String", "Last uri served", this._startTime, this._bean.getUpdateTime());
        return ss;
    }

    public CountStatistic getCountRequests() {
        long countRequests = this.getBean().getCountRequests();
        this._countRequests.setCount(countRequests);
        return (CountStatistic)this._countRequests.unmodifiableView();
    }

    public CountStatistic getCountBytesReceived() {
        long countBytesReceived = this.getBean().getCountBytesReceived();
        this._countBytesReceived.setCount(countBytesReceived);
        return (CountStatistic)this._countBytesReceived.unmodifiableView();
    }

    public CountStatistic getCountBytesTransmitted() {
        long countBytesTransmitted = this.getBean().getCountBytesTransmitted();
        this._countBytesTransmitted.setCount(countBytesTransmitted);
        return (CountStatistic)this._countBytesTransmitted.unmodifiableView();
    }

    public CountStatistic getRateBytesTransmitted() {
        long rateBytesTransmitted = (long)this.getBean().getRateBytesTransmitted();
        this._rateBytesTransmitted.setCount(rateBytesTransmitted);
        return (CountStatistic)this._rateBytesTransmitted.unmodifiableView();
    }

    public CountStatistic getMaxByteTransmissionRate() {
        long maxByteTransmissionRate = (long)this.getBean().getMaxByteTransmissionRate();
        this._maxByteTransmissionRate.setCount(maxByteTransmissionRate);
        return (CountStatistic)this._maxByteTransmissionRate.unmodifiableView();
    }

    public CountStatistic getCountOpenConnections() {
        long countOpenConnections = this.getBean().getCountOpenConnections();
        this._countOpenConnections.setCount(countOpenConnections);
        return (CountStatistic)this._countOpenConnections.unmodifiableView();
    }

    public CountStatistic getMaxOpenConnections() {
        long maxOpenConnections = this.getBean().getMaxOpenConnections();
        this._maxOpenConnections.setCount(maxOpenConnections);
        return (CountStatistic)this._maxOpenConnections.unmodifiableView();
    }

    public CountStatistic getCount2xx() {
        long count2xx = this.getBean().getCount2xx();
        this._count2xx.setCount(count2xx);
        return (CountStatistic)this._count2xx.unmodifiableView();
    }

    public CountStatistic getCount3xx() {
        long count3xx = this.getBean().getCount3xx();
        this._count3xx.setCount(count3xx);
        return (CountStatistic)this._count3xx.unmodifiableView();
    }

    public CountStatistic getCount4xx() {
        long count4xx = this.getBean().getCount4xx();
        this._count4xx.setCount(count4xx);
        return (CountStatistic)this._count4xx.unmodifiableView();
    }

    public CountStatistic getCount5xx() {
        long count5xx = this.getBean().getCount5xx();
        this._count5xx.setCount(count5xx);
        return (CountStatistic)this._count5xx.unmodifiableView();
    }

    public CountStatistic getCountOther() {
        long countOther = this.getBean().getCountOther();
        this._countOther.setCount(countOther);
        return (CountStatistic)this._countOther.unmodifiableView();
    }

    public CountStatistic getCount200() {
        long count200 = this.getBean().getCount200();
        this._count200.setCount(count200);
        return (CountStatistic)this._count200.unmodifiableView();
    }

    public CountStatistic getCount302() {
        long count302 = this.getBean().getCount302();
        this._count302.setCount(count302);
        return (CountStatistic)this._count302.unmodifiableView();
    }

    public CountStatistic getCount304() {
        long count304 = this.getBean().getCount304();
        this._count304.setCount(count304);
        return (CountStatistic)this._count304.unmodifiableView();
    }

    public CountStatistic getCount400() {
        long count400 = this.getBean().getCount400();
        this._count400.setCount(count400);
        return (CountStatistic)this._count400.unmodifiableView();
    }

    public CountStatistic getCount401() {
        long count401 = this.getBean().getCount401();
        this._count401.setCount(count401);
        return (CountStatistic)this._count401.unmodifiableView();
    }

    public CountStatistic getCount403() {
        long count403 = this.getBean().getCount403();
        this._count403.setCount(count403);
        return (CountStatistic)this._count403.unmodifiableView();
    }

    public CountStatistic getCount404() {
        long count404 = this.getBean().getCount404();
        this._count404.setCount(count404);
        return (CountStatistic)this._count404.unmodifiableView();
    }

    public CountStatistic getCount503() {
        long count503 = this.getBean().getCount503();
        this._count503.setCount(count503);
        return (CountStatistic)this._count503.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this._gsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this._gsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this._gsImpl.getStatisticNames();
    }

    private RequestMB getBean() {
        return this._bean;
    }

    private void initializeStatistics() {
        long time = System.currentTimeMillis();
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl(0L, "countRequests", "count", "Requests served", time, time);
        this._countRequests = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countBytesReceived", "bytes", "Bytes received, or 0 if not available", time, time);
        this._countBytesReceived = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countBytesTransmitted", "bytes", "Bytes transmitted, or 0 if not available", time, time);
        this._countBytesTransmitted = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "rateBytesTransmitted", "bytes/second", "Transmission rate over some server-defined interval, or 0 if not available", time, time);
        this._rateBytesTransmitted = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxByteTransmissionRate", "bytes/second", "Maximum transmission rate over some server-defined interval, or 0 if not available", time, time);
        this._maxByteTransmissionRate = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countOpenConnections", "count", "Open connections, or 0 if not available", time, time);
        this._countOpenConnections = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxOpenConnections", "count", "Maximum number of open connections, or 0 if not available", time, time);
        this._maxOpenConnections = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count2xx", "count", "Responses with code 2xx", time, time);
        this._count2xx = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count3xx", "count", "Responses with code 3xx", time, time);
        this._count3xx = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count4xx", "count", "Responses with code 4xx", time, time);
        this._count4xx = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count5xx", "count", "Responses with code 5xx", time, time);
        this._count5xx = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countOther", "count", "Responses with other codes", time, time);
        this._countOther = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count200", "count", "Responses with code 200", time, time);
        this._count200 = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count302", "count", "Responses with code 302", time, time);
        this._count302 = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count304", "count", "Responses with code 304", time, time);
        this._count304 = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count400", "count", "Responses with code 400", time, time);
        this._count400 = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count401", "count", "Responses with code 401", time, time);
        this._count401 = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count403", "count", "Responses with code 403", time, time);
        this._count403 = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count404", "count", "Responses with code 404", time, time);
        this._count404 = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "count503", "count", "Responses with code 503", time, time);
        this._count503 = new MutableCountStatisticImpl((CountStatistic)cs);
        this._startTime = time;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    }
}

