/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.httpservice.monitor;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCKeepAliveStats;
import com.sun.httpservice.spi.monitor.KeepAliveMB;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class PWCKeepAliveStatsImpl
implements PWCKeepAliveStats {
    static Logger _logger = null;
    private KeepAliveMB _bean;
    private long _startTime;
    private GenericStatsImpl _gsImpl;
    private MutableCountStatistic _countConnections;
    private MutableCountStatistic _maxConnections;
    private MutableCountStatistic _countHits;
    private MutableCountStatistic _countFlushes;
    private MutableCountStatistic _countRefusals;
    private MutableCountStatistic _countTimeouts;
    private MutableCountStatistic _secondsTimeout;

    public PWCKeepAliveStatsImpl(KeepAliveMB bean) {
        this._bean = bean;
        this.initializeStatistics();
        try {
            this._gsImpl = new GenericStatsImpl(this.getClass().getInterfaces()[0].getName(), (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.WARNING, "httpservice.monitor.stats.constructor.exception", cnfe);
        }
    }

    public CountStatistic getCountConnections() {
        long countConnections = this.getBean().getCountConnections();
        this._countConnections.setCount(countConnections);
        return (CountStatistic)this._countConnections.unmodifiableView();
    }

    public CountStatistic getMaxConnections() {
        long maxConnections = this.getBean().getMaxConnections();
        this._maxConnections.setCount(maxConnections);
        return (CountStatistic)this._maxConnections.unmodifiableView();
    }

    public CountStatistic getCountHits() {
        long countHits = this.getBean().getCountHits();
        this._countHits.setCount(countHits);
        return (CountStatistic)this._countHits.unmodifiableView();
    }

    public CountStatistic getCountFlushes() {
        long countFlushes = this.getBean().getCountFlushes();
        this._countFlushes.setCount(countFlushes);
        return (CountStatistic)this._countFlushes.unmodifiableView();
    }

    public CountStatistic getCountRefusals() {
        long countRefusals = this.getBean().getCountRefusals();
        this._countRefusals.setCount(countRefusals);
        return (CountStatistic)this._countRefusals.unmodifiableView();
    }

    public CountStatistic getCountTimeouts() {
        long countTimeouts = this.getBean().getCountTimeouts();
        this._countTimeouts.setCount(countTimeouts);
        return (CountStatistic)this._countTimeouts.unmodifiableView();
    }

    public CountStatistic getSecondsTimeouts() {
        long secondsTimeout = this.getBean().getSecondsTimeout();
        this._secondsTimeout.setCount(secondsTimeout);
        return (CountStatistic)this._secondsTimeout.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this._gsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this._gsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this._gsImpl.getStatisticNames();
    }

    private KeepAliveMB getBean() {
        return this._bean;
    }

    private void initializeStatistics() {
        long time = System.currentTimeMillis();
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl(0L, "countConnections", "count", "Connections in keep-alive mode", time, time);
        this._countConnections = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxConnections", "count", "Max connections allowed in keep-alive", time, time);
        this._maxConnections = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countHits", "count", "Number of times connections in keep-alive mode have made a subsequent valid request", time, time);
        this._countHits = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countFlushes", "count", "Keep-alive connections closed by server", time, time);
        this._countFlushes = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countRefusals", "count", "Connections not handed to keep-alive thread due to too many persistent connections", time, time);
        this._countRefusals = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countTimeouts", "count", "Connections terminated due to client connections timed out", time, time);
        this._countTimeouts = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "secondsTimeouts", "seconds", "Time before idle keep-alive connections are closed", time, time);
        this._secondsTimeout = new MutableCountStatisticImpl((CountStatistic)cs);
        this._startTime = time;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    }
}

