/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.httpservice.monitor;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.PWCDnsStats;
import com.sun.httpservice.spi.monitor.DnsMB;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class PWCDnsStatsImpl
implements PWCDnsStats {
    static Logger _logger = null;
    private DnsMB _bean;
    private long _startTime;
    private GenericStatsImpl _gsImpl;
    private MutableCountStatistic _flagCacheEnabled;
    private MutableCountStatistic _countCacheEntries;
    private MutableCountStatistic _maxCacheEntries;
    private MutableCountStatistic _countCacheHits;
    private MutableCountStatistic _countCacheMisses;
    private MutableCountStatistic _flagAsyncEnabled;
    private MutableCountStatistic _countAsyncNameLookups;
    private MutableCountStatistic _countAsyncAddrLookups;
    private MutableCountStatistic _countAsyncLookupsInProgress;

    public PWCDnsStatsImpl(DnsMB bean) {
        this._bean = bean;
        this.initializeStatistics();
        try {
            this._gsImpl = new GenericStatsImpl(this.getClass().getInterfaces()[0].getName(), (Object)this);
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.WARNING, "httpservice.monitor.stats.constructor.exception", cnfe);
        }
    }

    public CountStatistic getFlagCacheEnabled() {
        long flagCacheEnabled = this.getBean().getFlagCacheEnabled();
        this._flagCacheEnabled.setCount(flagCacheEnabled);
        return (CountStatistic)this._flagCacheEnabled.unmodifiableView();
    }

    public CountStatistic getCountCacheEntries() {
        long countCacheEntries = this.getBean().getCountCacheEntries();
        this._countCacheEntries.setCount(countCacheEntries);
        return (CountStatistic)this._countCacheEntries.unmodifiableView();
    }

    public CountStatistic getMaxCacheEntries() {
        long maxCacheEntries = this.getBean().getMaxCacheEntries();
        this._maxCacheEntries.setCount(maxCacheEntries);
        return (CountStatistic)this._maxCacheEntries.unmodifiableView();
    }

    public CountStatistic getCountCacheHits() {
        long countCacheHits = this.getBean().getCountCacheHits();
        this._countCacheHits.setCount(countCacheHits);
        return (CountStatistic)this._countCacheHits.unmodifiableView();
    }

    public CountStatistic getCountCacheMisses() {
        long countCacheMisses = this.getBean().getCountCacheMisses();
        this._countCacheMisses.setCount(countCacheMisses);
        return (CountStatistic)this._countCacheMisses.unmodifiableView();
    }

    public CountStatistic getFlagAsyncEnabled() {
        long flagAsyncEnabled = this.getBean().getFlagAsyncEnabled();
        this._flagAsyncEnabled.setCount(flagAsyncEnabled);
        return (CountStatistic)this._flagAsyncEnabled.unmodifiableView();
    }

    public CountStatistic getCountAsyncNameLookups() {
        long countAsyncNameLookups = this.getBean().getCountAsyncNameLookups();
        this._countAsyncNameLookups.setCount(countAsyncNameLookups);
        return (CountStatistic)this._countAsyncNameLookups.unmodifiableView();
    }

    public CountStatistic getCountAsyncAddrLookups() {
        long countAsyncAddrLookups = this.getBean().getCountAsyncAddrLookups();
        this._countAsyncAddrLookups.setCount(countAsyncAddrLookups);
        return (CountStatistic)this._countAsyncAddrLookups.unmodifiableView();
    }

    public CountStatistic getCountAsyncLookupsInProgress() {
        long countAsyncLookupsInProgress = this.getBean().getCountAsyncLookupsInProgress();
        this._countAsyncLookupsInProgress.setCount(countAsyncLookupsInProgress);
        return (CountStatistic)this._countAsyncLookupsInProgress.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this._gsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this._gsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this._gsImpl.getStatisticNames();
    }

    private DnsMB getBean() {
        return this._bean;
    }

    private void initializeStatistics() {
        long time = System.currentTimeMillis();
        CountStatisticImpl cs = null;
        cs = new CountStatisticImpl(0L, "flagCacheEnabled", "(0/1)", "Is DNS cache enabled?", time, time);
        this._flagCacheEnabled = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countCacheEntries", "count", "Number of cache entries", time, time);
        this._countCacheEntries = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "maxCacheEntries", "count", "Maximum possible cache entries", time, time);
        this._maxCacheEntries = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countCacheHits", "count", "DNS cache hits", time, time);
        this._countCacheHits = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countCacheMisses", "count", "DNS cache misses", time, time);
        this._countCacheMisses = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "flagAsyncEnabled", "(0/1)", "Is asynchronous lookup enabled?", time, time);
        this._flagAsyncEnabled = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countAsyncNameLookups", "count", "Number of asynchronous name lookups", time, time);
        this._countAsyncNameLookups = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countAsyncAddrLookups", "count", "Number of asynchronous address lookups", time, time);
        this._countAsyncAddrLookups = new MutableCountStatisticImpl((CountStatistic)cs);
        cs = new CountStatisticImpl(0L, "countAsyncLookupsInProgress", "count", "Number of asynchronous lookups in progress", time, time);
        this._countAsyncLookupsInProgress = new MutableCountStatisticImpl((CountStatistic)cs);
        this._startTime = time;
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    }
}

