/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.httpservice.monitor;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistrationException;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.PWCConnectionQueueStats;
import com.sun.enterprise.admin.monitor.stats.PWCDnsStats;
import com.sun.enterprise.admin.monitor.stats.PWCFileCacheStats;
import com.sun.enterprise.admin.monitor.stats.PWCHttpServiceStats;
import com.sun.enterprise.admin.monitor.stats.PWCKeepAliveStats;
import com.sun.enterprise.admin.monitor.stats.PWCRequestStats;
import com.sun.enterprise.admin.monitor.stats.PWCThreadPoolStats;
import com.sun.enterprise.admin.monitor.stats.PWCVirtualServerStats;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.httpservice.monitor.PWCConnectionQueueStatsImpl;
import com.sun.enterprise.server.httpservice.monitor.PWCDnsStatsImpl;
import com.sun.enterprise.server.httpservice.monitor.PWCFileCacheStatsImpl;
import com.sun.enterprise.server.httpservice.monitor.PWCHttpServiceStatsImpl;
import com.sun.enterprise.server.httpservice.monitor.PWCKeepAliveStatsImpl;
import com.sun.enterprise.server.httpservice.monitor.PWCRequestStatsImpl;
import com.sun.enterprise.server.httpservice.monitor.PWCThreadPoolStatsImpl;
import com.sun.enterprise.server.httpservice.monitor.PWCVirtualServerStatsImpl;
import com.sun.httpservice.spi.monitor.ConnectionQueueMB;
import com.sun.httpservice.spi.monitor.DnsMB;
import com.sun.httpservice.spi.monitor.FileCacheMB;
import com.sun.httpservice.spi.monitor.HttpServiceMB;
import com.sun.httpservice.spi.monitor.KeepAliveMB;
import com.sun.httpservice.spi.monitor.RequestMB;
import com.sun.httpservice.spi.monitor.ThreadPoolMB;
import com.sun.httpservice.spi.monitor.VirtualServerMB;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;

public final class HttpServiceMonitorManager
implements MonitoringLevelListener {
    private static HttpServiceMonitorManager manager = null;
    private ServerContext serverContext;
    private ArrayList vsList = null;
    private HttpServiceMB httpServiceBean;
    static Logger _logger = null;

    private HttpServiceMonitorManager(ServerContext context) {
        this.serverContext = context;
    }

    public static synchronized HttpServiceMonitorManager getManager(ServerContext context) {
        if (manager == null) {
            manager = new HttpServiceMonitorManager(context);
            context.getMonitoringRegistry().registerMonitoringLevelListener((MonitoringLevelListener)manager, MonitoredObjectType.HTTP_SERVICE);
        }
        return manager;
    }

    public synchronized void registerStats(HttpServiceMB hsBean) {
        _logger.log(Level.INFO, "httpservice.monitor.register.stats");
        this.httpServiceBean = hsBean;
        this.internalRegisterStats(hsBean);
        _logger.log(Level.INFO, "httpservice.monitor.register.stats.done");
    }

    public synchronized void unregisterStats(HttpServiceMB bean) {
        this.internalUnregisterStats();
    }

    public void changeLevel(MonitoringLevel oldLevel, MonitoringLevel newLevel, MonitoredObjectType monitoredObjectType) {
        if (monitoredObjectType != MonitoredObjectType.HTTP_SERVICE) {
            return;
        }
        if (newLevel == null) {
            return;
        }
        if (oldLevel != null && !this.hasLevelChanged(oldLevel, newLevel)) {
            return;
        }
        if (newLevel.equals((Object)MonitoringLevel.OFF)) {
            this.internalUnregisterStats();
        } else {
            this.internalRegisterStats(this.httpServiceBean);
        }
    }

    public void changeLevel(MonitoringLevel monitoringLevel, MonitoringLevel monitoringLevel1, Stats stats) {
    }

    public void setLevel(MonitoringLevel monitoringLevel) {
    }

    private boolean hasLevelChanged(MonitoringLevel oldLevel, MonitoringLevel newLevel) {
        if (oldLevel.equals((Object)newLevel)) {
            return false;
        }
        return oldLevel.equals((Object)MonitoringLevel.OFF) || newLevel.equals((Object)MonitoringLevel.OFF);
    }

    private void internalRegisterStats(HttpServiceMB hsBean) {
        this.vsList = new ArrayList();
        MonitoringRegistry registry = this.serverContext.getMonitoringRegistry();
        try {
            List vsBeanList;
            ThreadPoolMB tpBean;
            FileCacheMB fcBean;
            KeepAliveMB kaBean;
            DnsMB dnsBean;
            registry.registerPWCHttpServiceStats((PWCHttpServiceStats)new PWCHttpServiceStatsImpl(hsBean), (MonitoringLevelListener)this);
            ConnectionQueueMB cqBean = hsBean.getConnectionQueueBean();
            if (cqBean != null) {
                registry.registerPWCConnectionQueueStats((PWCConnectionQueueStats)new PWCConnectionQueueStatsImpl(cqBean), (MonitoringLevelListener)this);
            }
            if ((dnsBean = hsBean.getDnsBean()) != null) {
                registry.registerPWCDnsStats((PWCDnsStats)new PWCDnsStatsImpl(dnsBean), (MonitoringLevelListener)this);
            }
            if ((kaBean = hsBean.getKeepAliveBean()) != null) {
                registry.registerPWCKeepAliveStats((PWCKeepAliveStats)new PWCKeepAliveStatsImpl(kaBean), (MonitoringLevelListener)this);
            }
            if ((fcBean = hsBean.getFileCacheBean()) != null) {
                registry.registerPWCFileCacheStats((PWCFileCacheStats)new PWCFileCacheStatsImpl(fcBean), (MonitoringLevelListener)this);
            }
            if ((tpBean = hsBean.getThreadPoolBean()) != null) {
                registry.registerPWCThreadPoolStats((PWCThreadPoolStats)new PWCThreadPoolStatsImpl(tpBean), (MonitoringLevelListener)this);
            }
            if ((vsBeanList = hsBean.getVirtualServers()) != null) {
                Iterator it = vsBeanList.iterator();
                VirtualServerMB vsBean = null;
                Object pfBeanList = null;
                Object pfBean = null;
                RequestMB reqBean = null;
                String vsId = null;
                while (it.hasNext()) {
                    vsBean = (VirtualServerMB)it.next();
                    vsId = vsBean.getId();
                    registry.registerPWCVirtualServerStats((PWCVirtualServerStats)new PWCVirtualServerStatsImpl(vsBean), vsId, (MonitoringLevelListener)this);
                    reqBean = vsBean.getRequestBean();
                    if (reqBean != null) {
                        registry.registerPWCRequestStats((PWCRequestStats)new PWCRequestStatsImpl(reqBean), vsId, (MonitoringLevelListener)this);
                    }
                    this.vsList.add(vsId);
                }
            }
        }
        catch (MonitoringRegistrationException mrex) {
            _logger.log(Level.WARNING, "httpservice.monitor.register.exception", mrex);
        }
    }

    private void internalUnregisterStats() {
        MonitoringRegistry registry = this.serverContext.getMonitoringRegistry();
        try {
            registry.unregisterPWCHttpServiceStats();
            registry.unregisterPWCConnectionQueueStats();
            registry.unregisterPWCDnsStats();
            registry.unregisterPWCFileCacheStats();
            registry.unregisterPWCKeepAliveStats();
            registry.unregisterPWCThreadPoolStats();
            if (this.vsList != null && this.vsList.size() > 0) {
                Iterator it = this.vsList.iterator();
                String vsId = null;
                while (it.hasNext()) {
                    vsId = (String)it.next();
                    registry.unregisterPWCRequestStats(vsId);
                    registry.unregisterPWCVirtualServerStats(vsId);
                }
            }
            this.vsList = null;
        }
        catch (MonitoringRegistrationException mrex) {
            _logger.log(Level.WARNING, "httpservice.monitor.unregister.exception", mrex);
        }
    }

    static {
        _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    }
}

