/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.Switch;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.server.ApplicationLoader;
import com.sun.enterprise.web.HttpServiceWebContainer;
import com.sun.logging.LogDomains;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class HttpServiceApplicationLoader
extends ApplicationLoader {
    private AppsManager appsManager = null;
    private HttpServiceWebContainer webContainer = null;
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.core.classloading");

    public HttpServiceApplicationLoader(String appID, ClassLoader parentClassLoader, AppsManager appsManager) {
        super(appID, parentClassLoader, appsManager);
        _logger.log(Level.FINEST, "[HttpServiceApplicationLoader] " + appID);
        this.appsManager = appsManager;
        this.webContainer = HttpServiceWebContainer.getHttpServiceWebContainer();
    }

    boolean load(boolean jsr77) {
        J2eeApplication[] j2eeAppBeans;
        _logger.log(Level.FINEST, "[HttpServiceApplicationLoader] load " + jsr77);
        boolean deployed = super.load(jsr77);
        _logger.log(Level.FINEST, "deployed " + deployed);
        if (deployed && (j2eeAppBeans = this.appsManager.getAllApps()) != null) {
            for (int i = 0; i < j2eeAppBeans.length; ++i) {
                if (!j2eeAppBeans[i].getName().equals(this.id)) continue;
                _logger.log(Level.FINEST, "[HttpServiceApplicationLoader] loadJ2EEAppWebModule with " + j2eeAppBeans[i]);
                this.webContainer.loadJ2EEApplicationWebModules(j2eeAppBeans[i]);
            }
        }
        return deployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unload(boolean jsr77) {
        Set wbds = null;
        J2eeApplication[] j2eeAppBeans = this.appsManager.getAllApps();
        if (j2eeAppBeans != null) {
            for (int i = 0; i < j2eeAppBeans.length; ++i) {
                if (!j2eeAppBeans[i].getName().equals(this.id)) continue;
                String virtualServers = null;
                try {
                    virtualServers = this.appsManager.getVirtualServersByAppName(j2eeAppBeans[i].getName());
                }
                catch (ConfigException ce) {
                    _logger.log(Level.FINEST, "[HttpServiceApplicationLoader] unload " + this.id + ". error getting virtualServers", ce);
                }
                _logger.log(Level.FINEST, "[HttpServiceApplicationLoader] unload " + this.id);
                wbds = this.application.getWebBundleDescriptors();
                WebBundleDescriptor wbd = null;
                if (wbds == null) continue;
                Iterator itr = wbds.iterator();
                while (itr.hasNext()) {
                    NamingException nameEx2;
                    Object var10_10;
                    wbd = (WebBundleDescriptor)itr.next();
                    String appName = wbd.getApplication().getRegistrationName();
                    try {
                        this.webContainer.unloadWebModule(wbd.getContextRoot(), appName, virtualServers, wbd);
                        var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        try {
                            Switch.getSwitch().getNamingManager().unbindObjects((JndiNameEnvironment)wbd);
                        }
                        catch (NamingException nameEx2) {
                            _logger.log(Level.FINEST, "[HttpServiceApplicationLoader]  Exception during namingManager.unbindObject", nameEx2);
                        }
                        throw throwable;
                    }
                    try {
                        Switch.getSwitch().getNamingManager().unbindObjects((JndiNameEnvironment)wbd);
                    }
                    catch (NamingException nameEx2) {
                        _logger.log(Level.FINEST, "[HttpServiceApplicationLoader]  Exception during namingManager.unbindObject", nameEx2);
                    }
                }
            }
        }
        return super.unload(jsr77);
    }
}

