/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.store;

import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.store.FilePersistenceStore;
import com.sun.enterprise.ee.synchronization.store.PersistenceStore;
import com.sun.enterprise.ee.synchronization.store.StoreException;
import com.sun.enterprise.util.i18n.StringManagerBase;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SynchronizationMemento {
    private static Logger _logger;
    private static StringManagerBase _strMgr;
    PersistenceStore _store = new FilePersistenceStore();
    String _file = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SynchronizationMemento(SynchronizationResponse res) {
        SynchronizationRequest[] reply = res.getReply();
        if (!$assertionsDisabled && reply.length != 1) {
            throw new AssertionError();
        }
        this._file = reply[0].getFileName();
    }

    public void saveState() throws StoreException {
        File f = new File(this._file);
        _logger.log(Level.FINER, _strMgr.getString("synchronization.save_momento", (Object)this._file));
        if (f.exists()) {
            this._store.save(this._file);
        }
    }

    public void rollback() throws StoreException {
        _logger.log(Level.FINER, _strMgr.getString("synchronization.rollback_momento", (Object)this._file));
        this._store.restore(this._file);
    }

    public void commit() throws StoreException {
        this.commitWithCopy();
    }

    private void commitWithCopy() throws StoreException {
        String dst = (String)((FilePersistenceStore)this._store).getBackupFileName(this._file);
        _logger.log(Level.FINER, _strMgr.getString("synchronization.commit_momento", (Object)this._file));
        File dstFile = new File(dst);
        if (dstFile.exists()) {
            FileUtils.liquidate((File)dstFile);
        } else {
            _logger.log(Level.FINEST, _strMgr.getString("synchronization.no_backup_dir", (Object)dst));
        }
    }

    private void commitWithMove() throws StoreException {
        String dst = (String)((FilePersistenceStore)this._store).getBackupFileName(this._file);
        _logger.log(Level.FINER, _strMgr.getString("synchronization.commit_momento", (Object)this._file));
        File newFile = new File(this._file);
        File dstFile = new File(dst);
        if (dstFile.exists()) {
            if (newFile.isDirectory()) {
                this._store.merge(dst, this._file);
            } else if (dstFile.isDirectory() && !newFile.exists()) {
                _logger.log(Level.FINEST, _strMgr.getString("synchronization.no_sync_file", (Object)newFile.getName()));
                boolean ok = dstFile.renameTo(newFile);
                if (!ok) {
                    throw new StoreException();
                }
            } else if (dstFile.isFile() && !newFile.exists()) {
                _logger.log(Level.FINEST, _strMgr.getString("synchronization.no_sync_file", (Object)newFile.getName()));
                boolean ok = dstFile.renameTo(newFile);
                if (!ok) {
                    throw new StoreException();
                }
            } else if (dstFile.isFile() && newFile.exists()) {
                FileUtils.liquidate((File)dstFile);
            }
        } else {
            _logger.log(Level.FINEST, _strMgr.getString("synchronization.no_backup_dir", (Object)dst));
        }
    }

    static {
        $assertionsDisabled = !SynchronizationMemento.class.desiredAssertionStatus();
        _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
        _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    }
}

