/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.store;

import com.sun.enterprise.ee.synchronization.store.PersistenceStore;
import com.sun.enterprise.ee.synchronization.store.StoreException;
import com.sun.enterprise.ee.synchronization.util.io.Utils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePersistenceStore
implements PersistenceStore {
    private static final StringManager _localStrMgr;
    private static Logger _logger;
    private static StringManagerBase _logStrMgr;
    static final String DEF_SUFFIX = "_save";
    static final String BKUP_KEY = "com.sun.appserv.synchronization.backup";
    static final /* synthetic */ boolean $assertionsDisabled;

    public void save(Object obj) throws StoreException {
        if (this.isBkupON()) {
            this.saveWithCopy(obj);
        }
    }

    private boolean isBkupON() {
        return Boolean.getBoolean(BKUP_KEY);
    }

    private void saveWithCopy(Object obj) throws StoreException {
        if (!$assertionsDisabled && obj == null) {
            throw new AssertionError();
        }
        String origDir = (String)obj;
        String backupDir = (String)this.getBackupFileName(origDir);
        File fromDir = new File(origDir);
        File toDir = new File(backupDir);
        if (toDir.exists()) {
            _logger.log(Level.FINEST, _logStrMgr.getString("synchronization.remove_olddir", (Object)toDir.getName()));
            FileUtils.liquidate((File)toDir);
        }
        try {
            FileUtils.copy((File)fromDir, (File)toDir);
        }
        catch (IOException ioe) {
            String msg = _localStrMgr.getString("notSavedError", (Object)fromDir, (Object)toDir);
            throw new StoreException(msg, ioe);
        }
    }

    private void saveWithMove(Object obj) throws StoreException {
        if (!$assertionsDisabled && obj == null) {
            throw new AssertionError();
        }
        String origDir = (String)obj;
        String backupDir = (String)this.getBackupFileName(origDir);
        File fromDir = new File(origDir);
        File toDir = new File(backupDir);
        if (toDir.exists()) {
            _logger.log(Level.FINEST, _logStrMgr.getString("synchronization.remove_olddir", (Object)toDir.getName()));
            FileUtils.liquidate((File)toDir);
        }
        _logger.log(Level.FINER, _logStrMgr.getString("synchronization.rename_dir", (Object)fromDir.getName(), (Object)toDir.getName()));
        boolean ok = fromDir.renameTo(toDir);
        if (!ok) {
            String msg = _localStrMgr.getString("notSavedError", (Object)fromDir, (Object)toDir);
            throw new StoreException(msg);
        }
    }

    public void restore(Object obj) throws StoreException {
        if (!this.isBkupON()) {
            return;
        }
        if (!$assertionsDisabled && obj == null) {
            throw new AssertionError();
        }
        String origDir = (String)obj;
        String backupDir = (String)this.getBackupFileName(origDir);
        File fromDir = new File(backupDir);
        File toDir = new File(origDir);
        if (toDir.exists()) {
            _logger.log(Level.FINEST, _logStrMgr.getString("synchronization.remove_olddir", (Object)toDir.getName()));
            FileUtils.liquidate((File)toDir);
        }
        if (fromDir.exists()) {
            _logger.log(Level.FINER, _logStrMgr.getString("synchronization.rename_dir", (Object)fromDir.getName(), (Object)toDir.getName()));
            boolean ok = fromDir.renameTo(toDir);
            if (!ok) {
                String msg = _localStrMgr.getString("notSavedError", (Object)fromDir, (Object)toDir);
                throw new StoreException(msg);
            }
        }
    }

    public void merge(Object src, Object dst) throws StoreException {
        if (!this.isBkupON()) {
            return;
        }
        if (!$assertionsDisabled && src == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dst == null) {
            throw new AssertionError();
        }
        File srcFile = new File((String)src);
        File dstFile = new File((String)dst);
        try {
            _logger.log(Level.FINEST, _logStrMgr.getString("synchronization.merge_dirs", (Object)srcFile.getName(), (Object)dstFile.getName()));
            Utils.mergeTree(srcFile, dstFile);
        }
        catch (IOException ioe) {
            String msg = _localStrMgr.getString("notMergedError", src, dst);
            throw new StoreException(msg, ioe);
        }
    }

    public Object getBackupFileName(Object src) throws StoreException {
        if (!$assertionsDisabled && src == null) {
            throw new AssertionError();
        }
        try {
            File file = new File((String)src);
            File bkup = null;
            _logger.log(Level.FINER, _logStrMgr.getString("synchronization.get_backup", (Object)file.getName()));
            if (file.isDirectory()) {
                String dir = file.getAbsolutePath();
                if (dir.endsWith(File.separator)) {
                    dir = dir.substring(0, dir.length());
                }
                bkup = new File(dir + DEF_SUFFIX);
            } else {
                bkup = new File(file.getAbsolutePath() + DEF_SUFFIX);
            }
            return bkup.getAbsolutePath();
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("noBackupFileError", src);
            throw new StoreException(msg, e);
        }
    }

    static {
        $assertionsDisabled = !FilePersistenceStore.class.desiredAssertionStatus();
        _localStrMgr = StringManager.getManager((Class)FilePersistenceStore.class);
        _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
        _logStrMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    }
}

