/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.processor;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.TextProcess;
import java.io.File;

public class RequestContext {
    private ConfigContext _configCtx = null;
    private SynchronizationRequest[] _requests = null;
    private File _zipFile = null;
    private long _delta = 0L;
    private long _startTime = System.currentTimeMillis();
    private boolean _processInventory = true;
    private static String tmpName = System.getProperty("java.io.tmpdir") + File.separator + "APPSERV_REMOVED";

    public RequestContext(ConfigContext ctx, SynchronizationRequest[] reqs) {
        this._configCtx = ctx;
        if (reqs != null) {
            TextProcess.transformDASConfig(reqs);
        }
        this._requests = reqs;
    }

    public ConfigContext getConfigContext() {
        return this._configCtx;
    }

    public SynchronizationRequest[] getRequests() {
        return this._requests;
    }

    public long getTimeDelta() {
        return this._delta;
    }

    public void setTimeDelta(long delta) {
        this._delta = delta;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public void setStartTime(long startTime) {
        this._startTime = startTime;
    }

    public File getZipFile() {
        if (this._zipFile == null) {
            this._zipFile = this.getTempZipFile();
        }
        return this._zipFile;
    }

    public void setZipFile(File f) {
        this._zipFile = f;
    }

    private File getTempZipFile() {
        long ts = System.currentTimeMillis();
        File f = new File(tmpName, new Long(ts).toString() + ".zip");
        while (f.exists()) {
            f = new File(tmpName, new Long(++ts).toString() + ".zip");
        }
        f.getParentFile().mkdirs();
        return f;
    }

    public boolean isProcessInventory() {
        return this._processInventory;
    }

    public void setProcessInventory(boolean pi) {
        this._processInventory = pi;
    }
}

