/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.processor;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.synchronization.ServerDirector;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.TextProcess;
import com.sun.enterprise.ee.synchronization.inventory.InventoryMgr;
import com.sun.enterprise.ee.synchronization.processor.RequestContext;
import com.sun.enterprise.ee.util.zip.Zipper;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipOutputStream;

abstract class BaseProcessor {
    protected RequestContext _ctx = null;
    protected ZipOutputStream _out = null;
    protected CheckedOutputStream _cos = null;
    protected ByteArrayOutputStream _bos = null;
    protected FileOutputStream _fout = null;
    protected File _zipFile = null;
    protected SynchronizationResponse _response = null;
    protected static final boolean DEBUG = false;
    protected static final int BUFFER_SIZE = 16384;
    protected static final long MAX_BUFFER_SIZE = 0x4000000L;
    protected static final StringManager _localStrMgr;
    protected static Logger _logger;
    private static WeakHashMap _excludeCache;
    static final /* synthetic */ boolean $assertionsDisabled;

    BaseProcessor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isModified(SynchronizationRequest request) throws IOException {
        long modifiedTime;
        block13: {
            modifiedTime = 0L;
            if (request.getTimestampType() == 2) {
                return true;
            }
            if (request.getTimestampType() == 1) {
                modifiedTime = request.getFile().lastModified();
            } else {
                if (request.getTimestampType() == 3) {
                    return true;
                }
                if (request.getTimestampType() == 0) {
                    BufferedReader is = null;
                    try {
                        is = new BufferedReader(new FileReader(request.getTimestampFile()));
                        modifiedTime = Long.parseLong(is.readLine());
                        is.close();
                        is = null;
                        Object var6_4 = null;
                        if (is == null) break block13;
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (Exception ex) {}
                    is.close();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
        }
        if (!$assertionsDisabled && request.getTimestamp() > modifiedTime) {
            throw new AssertionError();
        }
        if (request.getTimestamp() >= modifiedTime) return false;
        request.setTimestamp(modifiedTime);
        return true;
    }

    synchronized void processInventory(SynchronizationRequest req) {
        try {
            if (req.isGCEnabled()) {
                String serverName = req.getServerName();
                File f = req.getFile();
                InventoryMgr mgr = new InventoryMgr(f);
                List crList = mgr.getInventory();
                if (crList != null) {
                    req.setInventory(crList);
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Error during inventory processing for " + req.getMetaFileName(), ex);
        }
    }

    void setExcludeList(SynchronizationRequest req, Zipper zipper) {
        try {
            String serverName = req.getServerName();
            ArrayList<String> list = (ArrayList<String>)_excludeCache.get(serverName);
            if (list == null) {
                Properties env = req.getEnvironmentProperties();
                ConfigContext ctx = this._ctx.getConfigContext();
                Domain domain = (Domain)ctx.getRootConfigBean();
                Server server = domain.getServers().getServerByName(serverName);
                if (server != null) {
                    ServerDirector director = new ServerDirector(ctx, serverName);
                    List excludes = director.constructExcludes();
                    list = new ArrayList<String>();
                    int size = excludes.size();
                    for (int i = 0; i < size; ++i) {
                        String path = (String)excludes.get(i);
                        String tPath = TextProcess.tokenizeConfig(path, serverName, env);
                        list.add(tPath);
                    }
                    _excludeCache.put(serverName, list);
                }
            }
            _logger.log(Level.FINE, "Excluded List " + list);
            zipper.addToExcludeList(list);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Excluded List can not be set", e);
        }
    }

    void processAlwaysInclude(SynchronizationRequest req, Zipper zipper) throws ConfigException {
        if (req.isClientRepositoryInfoSent()) {
            Set clientInfo = req.getClientRepositoryInfo();
            String clientName = req.getServerName();
            ConfigContext ctx = this._ctx.getConfigContext();
            if (ServerHelper.isAServer((ConfigContext)ctx, (String)clientName)) {
                ApplicationRef[] appRefs = ServerHelper.getApplicationReferences((ConfigContext)ctx, (String)clientName);
                for (int i = 0; i < appRefs.length; ++i) {
                    String appName = appRefs[i].getRef();
                    if (clientInfo.contains(appName)) continue;
                    zipper.addToAlwaysIncludeList(appName);
                }
            }
        }
    }

    abstract void initZipper(SynchronizationRequest var1, Zipper var2) throws IOException, ConfigException;

    void addFileToZip(File file, Zipper z, SynchronizationRequest req) throws IOException {
        if (file.isFile()) {
            z.setBaseDirectory(req.getTargetDirectory());
            z.addFileToZip(file, this._out);
        } else if (file.isDirectory()) {
            z.setBaseDirectory(req.getTargetDirectory());
            z.addDirectoryToZip(file, this._out);
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws IOException, ConfigException {
        Exception e22;
        block27: {
            SynchronizationRequest[] request = this._ctx.getRequests();
            SynchronizationRequest[] results = new SynchronizationRequest[request.length];
            File file = null;
            try {
                long startTime = System.currentTimeMillis() + this._ctx.getTimeDelta();
                long zipSize = 0L;
                for (int i = 0; i < request.length; ++i) {
                    Zipper z = new Zipper(null, 0L);
                    this.initZipper(request[i], z);
                    if (this._ctx.isProcessInventory()) {
                        this.processInventory(request[i]);
                    }
                    if (this.isModified(request[i]) || z.hasAlwaysInclude()) {
                        _logger.log(Level.FINE, "synchronization.req_mod_file_info", request[i].getFileName());
                        if (request[i].isExclude()) {
                            this.setExcludeList(request[i], z);
                        }
                        List ePattern = request[i].getExcludePatternList();
                        z.addToExcludePatternList(ePattern);
                        z.setShallowCopyEnabled(request[i].isShallowCopyEnabled());
                        List iPattern = request[i].getIncludePatternList();
                        z.addToIncludePatternList(iPattern);
                        if (request[i].getTimestampType() == 3) {
                            z.setLastModifiedTime(request[i].getTimestamp());
                        } else {
                            z.setLastModifiedTime(0L);
                        }
                        file = request[i].getFile();
                        this.addFileToZip(file, z, request[i]);
                        results[i] = request[i];
                        zipSize += z.getZipSize();
                        continue;
                    }
                    _logger.log(Level.FINE, "synchronization.req_not_mod_file_info", request[i].getFileName());
                    results[i] = request[i];
                }
                this.postProcess(zipSize, results);
                Object var13_10 = null;
                if (this._fout == null) break block27;
            }
            catch (Throwable throwable) {
                Exception e22;
                Object var13_11 = null;
                if (this._fout != null) {
                    try {
                        this._fout.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (this._bos != null) {
                    try {
                        this._bos.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (this._cos != null) {
                    try {
                        this._cos.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                if (this._out != null) {
                    try {
                        this._out.close();
                    }
                    catch (Exception e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                this._fout.close();
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        if (this._bos != null) {
            try {
                this._bos.close();
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        if (this._cos != null) {
            try {
                this._cos.close();
            }
            catch (Exception e22) {
                // empty catch block
            }
        }
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (Exception e22) {}
        }
    }

    abstract void postProcess(long var1, SynchronizationRequest[] var3) throws IOException;

    public SynchronizationResponse getResult() {
        return this._response;
    }

    static {
        $assertionsDisabled = !BaseProcessor.class.desiredAssertionStatus();
        _localStrMgr = StringManager.getManager((Class)BaseProcessor.class);
        _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
        _excludeCache = new WeakHashMap();
    }
}

