/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.audit;

import com.sun.enterprise.ee.admin.clientreg.MBeanServerConnectionInfo;
import com.sun.enterprise.ee.admin.proxy.MBeanServerProxy;
import com.sun.enterprise.ee.synchronization.Command;
import com.sun.enterprise.ee.synchronization.SynchronizationMBean;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.audit.AuditException;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.logging.Logger;
import javax.management.ObjectName;

class AuditGetCommand
implements Command {
    private MBeanServerConnectionInfo _connInfo = null;
    private SynchronizationRequest[] _requests = null;
    private SynchronizationResponse _result = null;
    private static final String NAME = "Audit-Get-Command";
    private static final String MBEAN_NAME = "com.sun.appserv:type=synchronization,category=config";
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static final StringManagerBase _logStrMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private static final StringManager _localStrMgr = StringManager.getManager((Class)AuditGetCommand.class);

    AuditGetCommand(SynchronizationRequest[] req, MBeanServerConnectionInfo connInfo) {
        this._requests = req;
        this._connInfo = connInfo;
        for (int i = 0; i < req.length; ++i) {
            req[i].setTimestampType(2);
        }
    }

    public void execute() throws AuditException {
        try {
            SynchronizationMBean proxy = (SynchronizationMBean)MBeanServerProxy.getMBeanServerProxy(SynchronizationMBean.class, new ObjectName(MBEAN_NAME), this._connInfo);
            this._result = proxy.audit(this._requests);
        }
        catch (Exception e) {
            String msg = _localStrMgr.getString("fileRetrieveError", (Object)this._requests[0].getMetaFileName());
            throw new AuditException(msg, e);
        }
    }

    public String getName() {
        return NAME;
    }

    public Object getResult() {
        return this._result;
    }
}

