/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextProcess {
    private static Logger _logger;
    private static final StringManagerBase _strMgr;
    static final String DEF_DELIM_TOKEN = "[$]";
    static final String DEF_START_TOKEN = "{";
    static final String DEF_END_TOKEN = "}";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String tokenizeConfig(String str, String instName, Properties env) {
        if (str == null) {
            return str;
        }
        String[] result = str.split(DEF_DELIM_TOKEN);
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            if (result[i].startsWith(DEF_START_TOKEN)) {
                int idx = result[i].indexOf(DEF_END_TOKEN);
                String key = result[i].substring(1, idx);
                String value = TextProcess.lookupConfigVar(key, instName, env);
                s.append(value);
                s.append(result[i].substring(idx + 1));
                continue;
            }
            s.append(result[i]);
        }
        return s.toString();
    }

    public static String lookupConfigVar(String s, String instName, Properties env) {
        if (s.equals("config.name")) {
            if (!$assertionsDisabled && instName == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && env == null) {
                throw new AssertionError();
            }
            String x = env.getProperty(s);
            if (x == null) {
                x = TextProcess.lookupConfigName(instName);
                if (!$assertionsDisabled && x == null) {
                    throw new AssertionError();
                }
                env.put("config.name", x);
            }
            return x;
        }
        String x = System.getProperty(s);
        if (x == null) {
            x = env.getProperty(s);
        }
        if (!$assertionsDisabled && x == null) {
            throw new AssertionError();
        }
        return x;
    }

    public static String lookupConfigName(String instName) {
        String configName = null;
        try {
            ConfigContext ctx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            Config config = ServerHelper.getConfigForServer((ConfigContext)ctx, (String)instName);
            if (config != null) {
                configName = config.getName();
            }
        }
        catch (Exception ce) {
            _logger.log(Level.FINE, _strMgr.getString("synchronization.config_not_found", (Object)instName));
        }
        if (!$assertionsDisabled && configName == null) {
            throw new AssertionError();
        }
        return configName;
    }

    public static void transformDASConfig(SynchronizationRequest[] requests) {
        for (int i = 0; i < requests.length; ++i) {
            String serverName = requests[i].getServerName();
            Properties env = requests[i].getEnvironmentProperties();
            String srcTs = requests[i].getTimestampFileName();
            requests[i].setTimestampFileName(TextProcess.tokenizeConfig(srcTs, serverName, env));
            String targetDir = requests[i].getTargetDirectory();
            requests[i].setTargetDirectory(TextProcess.tokenizeConfig(targetDir, serverName, env));
        }
    }

    static {
        $assertionsDisabled = !TextProcess.class.desiredAssertionStatus();
        _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
        _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    }
}

