/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.synchronization.TextProcess;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class SynchronizationRequest
implements Serializable {
    public static final int TIMESTAMP_FILE = 0;
    public static final int TIMESTAMP_MODIFICATION_TIME = 1;
    public static final int TIMESTAMP_NONE = 2;
    public static final int TIMESTAMP_MODIFIED_SINCE = 3;
    private static final transient StringManager _localStrMgr;
    private String _metaFileName;
    private String _targetDirectory;
    private long _timestamp;
    private int _timestampType;
    private String _timestampFileName;
    private String _baseDirectory;
    private String _serverName;
    private String _cacheTimestampFile;
    private Properties _env;
    private boolean _exclude = false;
    private boolean _gcEnabled = false;
    private List _inventory;
    private List _excludePatternList;
    private List _includePatternList;
    private boolean _shallowCopyEnabled = false;
    private Set _clientRepositoryInfo;
    private boolean _clientRepositoryInfoSent = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SynchronizationRequest(String name, long timestamp, int timestampType) {
        this(name, ".", timestamp, timestampType, null);
    }

    public SynchronizationRequest(String name, String targetDirectory, long timestamp, int timestampType, String timestampFileName) {
        this._metaFileName = name;
        this._targetDirectory = targetDirectory;
        this._timestamp = timestamp;
        this._timestampType = timestampType;
        this._env = new Properties();
        if (!$assertionsDisabled && this._timestampType != 0 && this._timestampType != 1 && this._timestampType != 2 && this._timestampType != 3) {
            throw new AssertionError();
        }
        if (this._timestampType != 0 && !$assertionsDisabled && timestampFileName != null) {
            throw new AssertionError();
        }
        this._timestampFileName = timestampFileName;
        this._inventory = new ArrayList();
        this._excludePatternList = new ArrayList();
        this._includePatternList = new ArrayList();
        this._clientRepositoryInfo = new HashSet();
    }

    public String getFileName() {
        String fn = TextProcess.tokenizeConfig(this._metaFileName, this._serverName, this._env);
        return this.processPath(fn);
    }

    private String processPath(String s) {
        if (s != null) {
            return FileUtils.makeForwardSlashes((String)s);
        }
        return s;
    }

    public String getMetaFileName() {
        return this._metaFileName;
    }

    void setMetaFileName(String file) {
        this._metaFileName = file;
    }

    public Properties getEnvironmentProperties() {
        return this._env;
    }

    void addEnvironmentProperty(String key, String value) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        this._env.put(key, value);
    }

    public boolean isExclude() {
        return this._exclude;
    }

    void setExclude(boolean b) {
        this._exclude = b;
    }

    public File getFile() {
        return new File(this.getFileName());
    }

    public String getTargetDirectory() {
        String targetDir = TextProcess.tokenizeConfig(this._targetDirectory, this._serverName, this._env);
        return this.processPath(targetDir);
    }

    void setTargetDirectory(String targetDir) {
        this._targetDirectory = targetDir;
    }

    public String getBaseDirectory() {
        String baseDir = TextProcess.tokenizeConfig(this._baseDirectory, this._serverName, this._env);
        return this.processPath(baseDir);
    }

    void setBaseDirectory(String baseDir) {
        this._baseDirectory = baseDir;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setTimestamp(long timestamp) {
        this._timestamp = timestamp;
    }

    public int getTimestampType() {
        return this._timestampType;
    }

    public void setTimestampType(int type) {
        this._timestampType = type;
    }

    public String getTimestampFileName() {
        String tsFile = TextProcess.tokenizeConfig(this._timestampFileName, this._serverName, this._env);
        return this.processPath(tsFile);
    }

    void setTimestampFileName(String fileName) {
        this._timestampFileName = fileName;
    }

    public File getTimestampFile() {
        String file = TextProcess.tokenizeConfig(this._timestampFileName, this._serverName, this._env);
        return new File(this.processPath(file));
    }

    public String getServerName() {
        return this._serverName;
    }

    void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public File getCacheTimestampFile() {
        String file = TextProcess.tokenizeConfig(this._cacheTimestampFile, this._serverName, this._env);
        return new File(this.processPath(file));
    }

    void setCacheTimestampFile(String tsfile) {
        this._cacheTimestampFile = tsfile;
    }

    public boolean isGCEnabled() {
        return this._gcEnabled;
    }

    void setGCEnabled(boolean gcEnabled) {
        if (gcEnabled) {
            // empty if block
        }
        this._gcEnabled = gcEnabled;
    }

    public List getInventory() {
        return this._inventory;
    }

    public void setInventory(List inventory) {
        this._inventory = inventory;
    }

    public List getExcludePatternList() {
        return this._excludePatternList;
    }

    void addToExcludePatternList(List pattern) {
        if (pattern != null) {
            this._excludePatternList.addAll(pattern);
        }
    }

    public List getIncludePatternList() {
        int length = this._includePatternList.size();
        for (int i = 0; i < length; ++i) {
            String p = TextProcess.tokenizeConfig((String)this._includePatternList.get(i), this._serverName, this._env);
            this._includePatternList.set(i, p);
        }
        return this._includePatternList;
    }

    void addToIncludePatternList(List pattern) {
        if (pattern != null) {
            this._includePatternList.addAll(pattern);
        }
    }

    public boolean isShallowCopyEnabled() {
        return this._shallowCopyEnabled;
    }

    void setShallowCopyEnabled(boolean tf) {
        this._shallowCopyEnabled = tf;
    }

    void addToClientRepositoryInfo(Set crInfo) {
        if (crInfo != null) {
            this._clientRepositoryInfo.addAll(crInfo);
            this._clientRepositoryInfoSent = true;
        }
    }

    public Set getClientRepositoryInfo() {
        return this._clientRepositoryInfo;
    }

    public boolean isClientRepositoryInfoSent() {
        return this._clientRepositoryInfoSent;
    }

    static {
        $assertionsDisabled = !SynchronizationRequest.class.desiredAssertionStatus();
        _localStrMgr = StringManager.getManager((Class)SynchronizationRequest.class);
    }
}

