/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.synchronization.SynchronizationConfig;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.SynchronizationMBean;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.SynchronizationResponse;
import com.sun.enterprise.ee.synchronization.processor.ByteProcessor;
import com.sun.enterprise.ee.synchronization.processor.ListProcessor;
import com.sun.enterprise.ee.synchronization.processor.RequestContext;
import com.sun.enterprise.ee.synchronization.processor.ZipProcessor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Synchronization
extends BaseConfigMBean
implements SynchronizationMBean {
    private static final String ZIP_FILE_SUFFIX = "-repository.zip";
    private static final String TEMP_FS_FILE_NM = ".synchronize";
    private static final StringManager _localStrMgr = StringManager.getManager((Class)Synchronization.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    private static long _delta = Synchronization.getTimeDelta();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static long getTimeDelta() {
        long dlt = 0L;
        try {
            block15: {
                FileWriter fw;
                block14: {
                    long currentVMTime = System.currentTimeMillis();
                    File f = new File(TEMP_FS_FILE_NM);
                    fw = null;
                    fw = new FileWriter(f);
                    fw.write(Long.toString(currentVMTime));
                    fw.flush();
                    fw.close();
                    fw = null;
                    long fsTime = f.lastModified();
                    if (fsTime >= currentVMTime) break block14;
                    dlt = fsTime - currentVMTime;
                }
                Object var9_7 = null;
                try {
                    if (fw != null) {
                        fw.close();
                    }
                    break block15;
                }
                catch (Exception ex) {}
                break block15;
                {
                    catch (Exception e) {
                        _logger.log(Level.FINE, "Unable to compute synchronization time delta", e);
                        Object var9_8 = null;
                        try {
                            if (fw != null) {
                                fw.close();
                            }
                            break block15;
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            if (dlt > 0L) {
                dlt = 0L;
            }
            _logger.log(Level.FINE, "Computed synchronization time delta: " + dlt);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dlt;
    }

    public SynchronizationResponse synchronize(SynchronizationRequest[] request) throws IOException, ConfigException {
        SynchronizationResponse response = null;
        try {
            ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            RequestContext rCtx = new RequestContext(configCtx, request);
            rCtx.setTimeDelta(_delta);
            ByteProcessor bProcessor = new ByteProcessor(rCtx);
            bProcessor.process();
            response = bProcessor.getResult();
        }
        catch (BufferOverflowException overflowEx) {
            _logger.log(Level.FINE, "Zipper reached max buffer size. Attempting a redirect.");
            ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            RequestContext rCtx = new RequestContext(configCtx, request);
            rCtx.setTimeDelta(_delta);
            ZipProcessor zProcessor = new ZipProcessor(rCtx);
            zProcessor.process();
            response = zProcessor.getResult();
        }
        return response;
    }

    public SynchronizationResponse ping(String serverName) throws IOException, ConfigException {
        long startTime = System.currentTimeMillis();
        SynchronizationResponse response = null;
        _logger.log(Level.INFO, "synchronization.synchronization_start_time", new Object[]{new Long(startTime).toString(), serverName});
        return response;
    }

    public SynchronizationResponse audit(SynchronizationRequest[] request) throws IOException, ConfigException {
        ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
        RequestContext rCtx = new RequestContext(configCtx, request);
        rCtx.setTimeDelta(_delta);
        ListProcessor lProcessor = new ListProcessor(rCtx);
        lProcessor.process();
        SynchronizationResponse response = lProcessor.getResult();
        return response;
    }

    public String createRepositoryZip(String target) throws SynchronizationException {
        File zip = new File("..", target + ZIP_FILE_SUFFIX);
        try {
            ConfigContext configCtx = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            SynchronizationRequest[] requests = this.getRequests(configCtx, target);
            RequestContext rCtx = new RequestContext(configCtx, requests);
            rCtx.setZipFile(zip);
            rCtx.setProcessInventory(false);
            ZipProcessor zProcessor = new ZipProcessor(rCtx);
            zProcessor.setDeleteZipOnExitFlag(false);
            zProcessor.process();
        }
        catch (Exception ex) {
            String msg = _localStrMgr.getString("createRepositoryZipFailed", (Object)target);
            throw new SynchronizationException(msg, ex);
        }
        return zip.getPath();
    }

    private SynchronizationRequest[] getRequests(ConfigContext ctx, String target) throws ConfigException {
        SynchronizationConfig sc = null;
        if (target != null && ServerHelper.isAServer((ConfigContext)ctx, (String)target)) {
            sc = new SynchronizationConfig("synchronization-meta-data.xml", target);
        } else if (target != null && NodeAgentHelper.isANodeAgent((ConfigContext)ctx, (String)target)) {
            sc = new SynchronizationConfig("na-startup-meta-data.xml", target);
        } else {
            String msg = _localStrMgr.getString("invalidTarget", (Object)target);
            throw new IllegalArgumentException(msg);
        }
        SynchronizationRequest[] reqs = sc.getSyncRequests();
        for (int i = 0; i < reqs.length; ++i) {
            reqs[i].setTimestamp(0L);
        }
        return reqs;
    }
}

